/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator.mybatis;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.co.headwaters.webappos.generator.GeneratorConstants;
import jp.co.headwaters.webappos.generator.mybatis.bean.TableInfo;
import jp.co.headwaters.webappos.generator.utils.DataBaseUtils;
import jp.co.headwaters.webappos.generator.utils.GeneratorUtils;
import jp.co.headwaters.webappos.generator.utils.MessageUtils;
import jp.co.headwaters.webappos.generator.utils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;
import org.mybatis.generator.config.ModelType;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.config.SqlMapGeneratorConfiguration;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.internal.DefaultShellCallback;

public class ExtraMyBatisGenerator {
    private static final Log _logger = LogFactory.getLog(ExtraMyBatisGenerator.class);
    private Configuration _config = null;

    public boolean generate(String dbPassword) {
        ArrayList warnings = new ArrayList();
        try {
            this._config = this.createMyBatisConfiguration(dbPassword);
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(this._config, (ShellCallback)new DefaultShellCallback(false), warnings);
            myBatisGenerator.generate(null);
        }
        catch (Exception e) {
            _logger.error((Object)MessageUtils.getString("err.100"), (Throwable)e);
            return false;
        }
        if (warnings.size() != 0) {
            for (String warning : warnings) {
                _logger.error((Object)warning);
            }
            return false;
        }
        return true;
    }

    public Configuration getConfiguration() {
        return this._config;
    }

    private Configuration createMyBatisConfiguration(String dbPassword) throws InvalidConfigurationException, SQLException {
        ArrayList errors = new ArrayList();
        Configuration config = new Configuration();
        String rootPackage = GeneratorUtils.getRootPackage();
        String contextName = GeneratorUtils.getContextName();
        PropertyUtils.putProperty("model.package", ExtraMyBatisGenerator.getModelPackage(rootPackage));
        PropertyUtils.putProperty("mapper.package", ExtraMyBatisGenerator.getMapperPackage(rootPackage));
        Context context = new Context(ModelType.FLAT);
        config.addContext(context);
        context.setId(contextName);
        context.setTargetRuntime("MyBatis3");
        context.addProperty("javaFileEncoding", "UTF-8");
        String[] stringArray = GeneratorConstants.MYBATIS_PLUGIN_CLASSES;
        int n = GeneratorConstants.MYBATIS_PLUGIN_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            String plugin = stringArray[n2];
            PluginConfiguration pluginConfiguration = new PluginConfiguration();
            pluginConfiguration.setConfigurationType(plugin);
            pluginConfiguration.validate(errors, contextName);
            context.addPluginConfiguration(pluginConfiguration);
            ++n2;
        }
        JDBCConnectionConfiguration jdbcConnectionConfiguration = new JDBCConnectionConfiguration();
        jdbcConnectionConfiguration.setDriverClass("org.postgresql.Driver");
        jdbcConnectionConfiguration.setConnectionURL(String.valueOf(PropertyUtils.getProperty("connection.url")) + contextName);
        jdbcConnectionConfiguration.setUserId(contextName);
        jdbcConnectionConfiguration.setPassword(dbPassword);
        jdbcConnectionConfiguration.validate(errors);
        context.setJdbcConnectionConfiguration(jdbcConnectionConfiguration);
        JavaModelGeneratorConfiguration javaModelGeneratorConfiguration = new JavaModelGeneratorConfiguration();
        javaModelGeneratorConfiguration.setTargetPackage(PropertyUtils.getProperty("model.package"));
        javaModelGeneratorConfiguration.setTargetProject(GeneratorUtils.getOutputSrcPath());
        javaModelGeneratorConfiguration.addProperty("rootClass", GeneratorConstants.MYBATIS_MODEL_ROOT_CLASS);
        javaModelGeneratorConfiguration.validate(errors, contextName);
        context.setJavaModelGeneratorConfiguration(javaModelGeneratorConfiguration);
        SqlMapGeneratorConfiguration sqlMapGeneratorConfiguration = new SqlMapGeneratorConfiguration();
        sqlMapGeneratorConfiguration.setTargetPackage(PropertyUtils.getProperty("mapper.package"));
        sqlMapGeneratorConfiguration.setTargetProject(GeneratorUtils.getOutputSrcPath());
        sqlMapGeneratorConfiguration.validate(errors, contextName);
        context.setSqlMapGeneratorConfiguration(sqlMapGeneratorConfiguration);
        List<TableInfo> tables = this.getTableInfo(jdbcConnectionConfiguration);
        int i = 0;
        while (i < tables.size()) {
            TableInfo tableInfo = tables.get(i);
            TableConfiguration tableConfiguration = new TableConfiguration(context);
            tableConfiguration.setTableName(tableInfo.getTableName());
            if (tableInfo.isView()) {
                tableConfiguration.setInsertStatementEnabled(false);
                tableConfiguration.setUpdateByPrimaryKeyStatementEnabled(false);
                tableConfiguration.setUpdateByExampleStatementEnabled(false);
                tableConfiguration.setDeleteByPrimaryKeyStatementEnabled(false);
                tableConfiguration.setDeleteByExampleStatementEnabled(false);
            }
            tableConfiguration.validate(errors, i);
            context.addTableConfiguration(tableConfiguration);
            ++i;
        }
        context.validate(errors);
        config.validate();
        if (errors.size() > 0) {
            throw new InvalidConfigurationException(errors);
        }
        return config;
    }

    private List<TableInfo> getTableInfo(JDBCConnectionConfiguration config) throws SQLException {
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        List<String> excludeTables = Arrays.asList(GeneratorConstants.MYBATIS_EXCLUDE_TABLE_NAMES);
        Connection connection = null;
        ResultSet result = null;
        try {
            connection = DataBaseUtils.getConnection(config);
            DatabaseMetaData meta = connection.getMetaData();
            String[] types = new String[]{"TABLE", "VIEW"};
            result = meta.getTables(null, null, "%", types);
            while (result.next()) {
                String tableName = result.getString("TABLE_NAME");
                if (excludeTables.contains(tableName.toLowerCase())) continue;
                tables.add(new TableInfo(tableName, result.getString("TABLE_TYPE").toUpperCase().equals("VIEW")));
            }
        }
        catch (Throwable throwable) {
            DataBaseUtils.closeResultSet(result);
            DataBaseUtils.closeConnection(connection);
            throw throwable;
        }
        DataBaseUtils.closeResultSet(result);
        DataBaseUtils.closeConnection(connection);
        return tables;
    }

    private static String getModelPackage(String rootPackage) {
        StringBuilder sb = new StringBuilder();
        sb.append(rootPackage);
        sb.append(".");
        sb.append("model");
        return sb.toString();
    }

    private static String getMapperPackage(String rootPackage) {
        StringBuilder sb = new StringBuilder();
        sb.append(rootPackage);
        sb.append(".");
        sb.append("mapper");
        return sb.toString();
    }
}

