/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator.mybatis.plugin;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.co.headwaters.webappos.controller.cache.WebAppOSCache;
import jp.co.headwaters.webappos.controller.cache.bean.ProcedureInfoBean;
import jp.co.headwaters.webappos.controller.enumation.DataTypeEnum;
import jp.co.headwaters.webappos.controller.enumation.PgLanguageEnum;
import jp.co.headwaters.webappos.generator.utils.DataBaseUtils;
import jp.co.headwaters.webappos.generator.utils.GeneratorUtils;
import jp.co.headwaters.webappos.generator.utils.MessageUtils;
import jp.co.headwaters.webappos.generator.utils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.config.Context;

public class AddProcedureMapperPlugin
extends PluginAdapter {
    private static final Log _logger = LogFactory.getLog(AddProcedureMapperPlugin.class);
    private static final String SELECT_PROC_INFO = "select  proname,  lanname,  prorettype::regtype as prorettype,  pronargs,  oidvectortypes(pg_proc.proargtypes) as proargtypes,  proargnames  from  pg_proc  inner join pg_user on pg_user.usesysid = pg_proc.proowner  inner join pg_language on pg_language.oid = pg_proc.prolang  where   pg_user.usename = current_user order by pg_proc.proname";
    private boolean _isError;

    public void setContext(Context context) {
        super.setContext(context);
        this._isError = !this.getProcedureInfo(context);
    }

    public boolean validate(List<String> warnings) {
        boolean valid = true;
        if (this._isError) {
            valid = false;
        }
        return valid;
    }

    public List<GeneratedXmlFile> contextGenerateAdditionalXmlFiles() {
        GeneratedXmlFile gxf = new GeneratedXmlFile(this.getDocument(), "ProcedureMapper.xml", PropertyUtils.getProperty("mapper.package"), GeneratorUtils.getOutputSrcPath(), false, this.context.getXmlFormatter());
        ArrayList<GeneratedXmlFile> answer = new ArrayList<GeneratedXmlFile>(1);
        answer.add(gxf);
        return answer;
    }

    private boolean getProcedureInfo(Context context) {
        LinkedHashMap<String, ProcedureInfoBean> procedureMap = new LinkedHashMap<String, ProcedureInfoBean>();
        WebAppOSCache.getInstance().setProcedureMap(procedureMap);
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        ProcedureInfoBean procedureInfo = null;
        String proname = null;
        short argnum = 0;
        LinkedHashMap<String, DataTypeEnum> args = null;
        try {
            try {
                connection = DataBaseUtils.getConnection(context.getJdbcConnectionConfiguration());
                stmt = connection.createStatement();
                rs = stmt.executeQuery(SELECT_PROC_INFO);
                while (rs.next()) {
                    if ("trigger".equalsIgnoreCase(rs.getString("prorettype").toLowerCase())) continue;
                    args = new LinkedHashMap<String, DataTypeEnum>();
                    ArrayList<String> outNames = new ArrayList<String>();
                    procedureInfo = new ProcedureInfoBean();
                    proname = rs.getString("proname");
                    procedureInfo.setName(proname.toLowerCase());
                    procedureInfo.setLang(PgLanguageEnum.getLanguage(rs.getString("lanname").toLowerCase()));
                    procedureInfo.setRetType(DataTypeEnum.getDataType(rs.getString("prorettype").toLowerCase()));
                    argnum = rs.getShort("pronargs");
                    procedureInfo.setArgNum(argnum);
                    procedureInfo.setArgs(args);
                    procedureInfo.setOutNames(outNames);
                    procedureMap.put(proname, procedureInfo);
                    String[] proargtypes = rs.getString("proargtypes").split(",");
                    if (rs.getArray("proargnames") == null) continue;
                    String[] proargnames = (String[])rs.getArray("proargnames").getArray();
                    int i = 0;
                    while (i < proargnames.length) {
                        if (i < argnum) {
                            args.put(proargnames[i].toLowerCase(), DataTypeEnum.getDataType(proargtypes[i].trim()));
                        } else {
                            outNames.add(proargnames[i].toLowerCase());
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                _logger.error((Object)MessageUtils.getString("err.102"), (Throwable)e);
                DataBaseUtils.closeResultSet(rs);
                DataBaseUtils.closeStatement(stmt);
                DataBaseUtils.closeConnection(connection);
                return false;
            }
        }
        catch (Throwable throwable) {
            DataBaseUtils.closeResultSet(rs);
            DataBaseUtils.closeStatement(stmt);
            DataBaseUtils.closeConnection(connection);
            throw throwable;
        }
        DataBaseUtils.closeResultSet(rs);
        DataBaseUtils.closeStatement(stmt);
        DataBaseUtils.closeConnection(connection);
        return true;
    }

    private Document getDocument() {
        Document document = new Document("-//mybatis.org//DTD Mapper 3.0//EN", "http://mybatis.org/dtd/mybatis-3-mapper.dtd");
        XmlElement root = new XmlElement("mapper");
        root.addAttribute(new Attribute("namespace", this.getNamespace()));
        document.setRootElement(root);
        Map<String, ProcedureInfoBean> procMap = WebAppOSCache.getInstance().getProcedureMap();
        for (ProcedureInfoBean procInfo : procMap.values()) {
            XmlElement select = new XmlElement("select");
            select.addAttribute(new Attribute("id", procInfo.getName()));
            if (procInfo.getArgNum() > 0) {
                select.addAttribute(new Attribute("parameterType", "map"));
            }
            if (!procInfo.getRetType().equals((Object)DataTypeEnum.DATA_TYPE_VOID)) {
                if (procInfo.getRetType().equals((Object)DataTypeEnum.DATA_TYPE_RECORD)) {
                    select.addAttribute(new Attribute("resultType", "map"));
                } else {
                    select.addAttribute(new Attribute("resultType", procInfo.getRetType().getClazz()));
                }
            } else {
                select.addAttribute(new Attribute("resultType", "map"));
            }
            select.addElement((Element)new TextElement(this.getStatement(procInfo)));
            root.addElement((Element)select);
        }
        return document;
    }

    private String getNamespace() {
        StringBuilder sb = new StringBuilder();
        sb.append(PropertyUtils.getProperty("mapper.package"));
        sb.append('.');
        sb.append("ProcedureMapper");
        return sb.toString();
    }

    private String getStatement(ProcedureInfoBean procInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilder param = new StringBuilder();
        sb.append("select * from ");
        sb.append(procInfo.getName());
        sb.append("(");
        if (procInfo.getArgNum() > 0) {
            for (Map.Entry<String, DataTypeEnum> arg : procInfo.getArgs().entrySet()) {
                if (param.length() > 0) {
                    param.append(",");
                }
                param.append("#{");
                param.append(arg.getKey());
                param.append(",");
                param.append("jdbcType=");
                param.append(arg.getValue().getJdbcType());
                param.append("}");
            }
        }
        sb.append((CharSequence)param);
        sb.append(")");
        return sb.toString();
    }
}

