/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator.mybatis.plugin;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jp.co.headwaters.webappos.controller.cache.WebAppOSCache;
import jp.co.headwaters.webappos.controller.cache.bean.RelationKeyBean;
import jp.co.headwaters.webappos.generator.GeneratorConstants;
import jp.co.headwaters.webappos.generator.mybatis.bean.JoinElementInfo;
import jp.co.headwaters.webappos.generator.utils.DataBaseUtils;
import jp.co.headwaters.webappos.generator.utils.MessageUtils;
import jp.co.headwaters.webappos.generator.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.CommentGeneratorConfiguration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public class AddRelationPlugin
extends PluginAdapter {
    private static final Log _logger = LogFactory.getLog(AddRelationPlugin.class);
    private Map<String, List<RelationKeyBean>> _exportedKeys = null;
    private Map<String, List<RelationKeyBean>> _importedKeys = null;
    private boolean _isError;
    private XmlElement _selectByExampleElement;

    public void setContext(Context context) {
        super.setContext(context);
        CommentGeneratorConfiguration commentConfig = new CommentGeneratorConfiguration();
        commentConfig.addProperty("suppressAllComments", Boolean.TRUE.toString());
        context.setCommentGeneratorConfiguration(commentConfig);
        this._isError = !this.getRelationInfo(context);
    }

    public void setProperties(Properties properties) {
        Properties conf = new Properties();
        try {
            conf.load(((Object)((Object)this)).getClass().getResourceAsStream("/generator.properties"));
        }
        catch (IOException e) {
            _logger.error((Object)MessageUtils.getString("err.100"), (Throwable)e);
        }
        super.setProperties(conf);
    }

    public boolean validate(List<String> warnings) {
        boolean valid = true;
        if (this.properties.size() == 0) {
            warnings.add(MessageUtils.getString("err.001"));
            valid = false;
        }
        if (this._isError) {
            valid = false;
        }
        return valid;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List<RelationKeyBean> importedKey;
        String tableName = introspectedTable.getTableConfiguration().getTableName();
        List<RelationKeyBean> exportedKey = this._exportedKeys.get(tableName);
        if (exportedKey != null) {
            for (RelationKeyBean relationKeys : exportedKey) {
                String property = JavaBeansUtil.getCamelCaseString((String)relationKeys.getFkTableName(), (boolean)false);
                FullyQualifiedJavaType javaType = AddRelationPlugin.getExportedJavaType(relationKeys.getFkTableName());
                topLevelClass.addField(AddRelationPlugin.getJavaBeansField(javaType, property));
                topLevelClass.addMethod(AddRelationPlugin.getJavaBeansGetter(javaType, property));
                topLevelClass.addMethod(AddRelationPlugin.getJavaBeansSetter(javaType, property));
                topLevelClass.addImportedType("java.util.List");
            }
        }
        if ((importedKey = this._importedKeys.get(tableName)) != null) {
            for (RelationKeyBean relationKeys : importedKey) {
                String property = JavaBeansUtil.getCamelCaseString((String)relationKeys.getPkTableName(), (boolean)false);
                FullyQualifiedJavaType javaType = AddRelationPlugin.getImportedJavaType(relationKeys.getPkTableName());
                topLevelClass.addField(AddRelationPlugin.getJavaBeansField(javaType, property));
                topLevelClass.addMethod(AddRelationPlugin.getJavaBeansGetter(javaType, property));
                topLevelClass.addMethod(AddRelationPlugin.getJavaBeansSetter(javaType, property));
            }
        }
        return true;
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapResultMapWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        String tableName = introspectedTable.getTableConfiguration().getTableName();
        StringBuilder newColumn = new StringBuilder();
        block0: for (Element e : element.getElements()) {
            XmlElement resultElement = (XmlElement)e;
            for (Attribute attribute : resultElement.getAttributes()) {
                if (!"column".equalsIgnoreCase(attribute.getName())) continue;
                newColumn.setLength(0);
                newColumn.append(tableName);
                newColumn.append("_");
                newColumn.append(attribute.getValue());
                resultElement.getAttributes().remove(attribute);
                resultElement.addAttribute(new Attribute("column", newColumn.toString()));
                continue block0;
            }
        }
        return true;
    }

    public boolean sqlMapBaseColumnListElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        String tableName = introspectedTable.getTableConfiguration().getTableName();
        StringBuilder orgColumns = new StringBuilder();
        StringBuilder newColumns = new StringBuilder();
        for (Element e : element.getElements()) {
            orgColumns.append(((TextElement)e).getContent());
        }
        element.getElements().removeAll(element.getElements());
        String[] columns = orgColumns.toString().split(",");
        int i = 0;
        while (i < columns.length) {
            newColumns.append(tableName);
            newColumns.append(".");
            newColumns.append(columns[i].trim());
            newColumns.append(" as ");
            newColumns.append(tableName);
            newColumns.append("_");
            newColumns.append(columns[i].trim());
            if (i != columns.length - 1) {
                newColumns.append(", ");
            }
            if (newColumns.length() > 80) {
                element.addElement((Element)new TextElement(newColumns.toString()));
                newColumns.setLength(0);
            }
            ++i;
        }
        if (newColumns.length() > 0) {
            element.addElement((Element)new TextElement(newColumns.toString()));
        }
        return true;
    }

    public boolean sqlMapCountByExampleElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        AddRelationPlugin.updateParameterTypeToGenericExample(element);
        return true;
    }

    public boolean sqlMapDeleteByExampleElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        AddRelationPlugin.updateParameterTypeToGenericExample(element);
        return true;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        List<RelationKeyBean> exportedKey;
        XmlElement answer = new XmlElement("resultMap");
        answer.addAttribute(new Attribute("id", "FullResultMap"));
        answer.addAttribute(new Attribute("extends", introspectedTable.getBaseResultMapId()));
        answer.addAttribute(new Attribute("type", introspectedTable.getBaseRecordType()));
        document.getRootElement().addElement((Element)answer);
        String tableName = introspectedTable.getTableConfiguration().getTableName();
        StringBuilder sb = new StringBuilder();
        String property = null;
        List<RelationKeyBean> importedKey = this._importedKeys.get(tableName);
        if (importedKey != null) {
            for (RelationKeyBean relationKeys : importedKey) {
                property = relationKeys.getPkTableName();
                sb.setLength(0);
                sb.append(AddRelationPlugin.getMapperName(introspectedTable, property));
                sb.append(".");
                sb.append("ResultMapRef");
                sb.append(JavaBeansUtil.getCamelCaseString((String)tableName, (boolean)true));
                XmlElement element = new XmlElement("association");
                element.addAttribute(new Attribute("property", JavaBeansUtil.getCamelCaseString((String)property, (boolean)false)));
                element.addAttribute(new Attribute("resultMap", sb.toString()));
                answer.addElement((Element)element);
            }
        }
        if ((exportedKey = this._exportedKeys.get(tableName)) != null) {
            ArrayList<XmlElement> resultMapElement = new ArrayList<XmlElement>();
            for (RelationKeyBean relationKeys : exportedKey) {
                property = relationKeys.getFkTableName();
                sb.setLength(0);
                sb.append(AddRelationPlugin.getMapperName(introspectedTable, property));
                sb.append(".");
                sb.append("BaseResultMap");
                XmlElement element = new XmlElement("collection");
                element.addAttribute(new Attribute("property", JavaBeansUtil.getCamelCaseString((String)property, (boolean)false)));
                element.addAttribute(new Attribute("resultMap", sb.toString()));
                answer.addElement((Element)element);
                resultMapElement.add(element);
            }
            for (XmlElement element : resultMapElement) {
                for (Attribute attribute : element.getAttributes()) {
                    if (!"property".equals(attribute.getName())) continue;
                    property = attribute.getValue();
                    sb.setLength(0);
                    sb.append("ResultMapRef");
                    sb.append(StringUtils.capitalize((String)property));
                    XmlElement resultElement = new XmlElement("resultMap");
                    resultElement.addAttribute(new Attribute("id", sb.toString()));
                    resultElement.addAttribute(new Attribute("extends", introspectedTable.getBaseResultMapId()));
                    resultElement.addAttribute(new Attribute("type", introspectedTable.getBaseRecordType()));
                    document.getRootElement().addElement((Element)resultElement);
                }
            }
        }
        List<JoinElementInfo> exportedJoinElementInfo = AddRelationPlugin.createJoinElementInfo(introspectedTable, exportedKey);
        List<JoinElementInfo> importedJoinElementInfo = AddRelationPlugin.createJoinElementInfo(introspectedTable, importedKey);
        if (introspectedTable.getRules().generateSelectByPrimaryKey()) {
            document.getRootElement().addElement((Element)this.getSelectAllByPrimaryKeyElement(introspectedTable, importedJoinElementInfo));
        }
        XmlElement selectAllElement = this.getSelectAllByExample(exportedJoinElementInfo, importedJoinElementInfo);
        document.getRootElement().addElement((Element)selectAllElement);
        document.getRootElement().addElement((Element)this.getCountAllByExample(selectAllElement, introspectedTable));
        return true;
    }

    public boolean sqlMapInsertElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapInsertSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        AddRelationPlugin.updateParameterTypeToMap(element);
        element.addAttribute(new Attribute("useGeneratedKeys", "true"));
        element.addAttribute(new Attribute("keyProperty", AddRelationPlugin.getKeyProperty()));
        XmlElement columnElement = (XmlElement)element.getElements().get(1);
        for (Element e : columnElement.getElements()) {
            Attribute orgAttribute = (Attribute)((XmlElement)e).getAttributes().get(0);
            StringBuilder sb = new StringBuilder();
            sb.append("record");
            sb.append(".");
            sb.append(orgAttribute.getValue());
            ((XmlElement)e).getAttributes().remove(0);
            ((XmlElement)e).getAttributes().add(0, new Attribute("test", sb.toString()));
        }
        XmlElement valueElement = (XmlElement)element.getElements().get(2);
        for (Element e : valueElement.getElements()) {
            Attribute orgAttribute = (Attribute)((XmlElement)e).getAttributes().get(0);
            StringBuilder newValue = new StringBuilder();
            newValue.append("record");
            newValue.append(".");
            newValue.append(orgAttribute.getValue());
            ((XmlElement)e).getAttributes().remove(0);
            ((XmlElement)e).getAttributes().add(0, new Attribute("test", newValue.toString()));
            Element orgElement = (Element)((XmlElement)e).getElements().get(0);
            StringBuilder newContent = new StringBuilder();
            newContent.append("#{");
            newContent.append("record");
            newContent.append(".");
            newContent.append(orgElement.getFormattedContent(0).substring(2));
            ((XmlElement)e).getElements().remove(0);
            ((XmlElement)e).getElements().add(0, new TextElement(newContent.toString()));
        }
        return true;
    }

    public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        AddRelationPlugin.updateParameterTypeToGenericExample(element);
        this._selectByExampleElement = element;
        return true;
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        AddRelationPlugin.updateParameterTypeToMap(element);
        XmlElement setElement = (XmlElement)element.getElements().get(1);
        for (Element e : setElement.getElements()) {
            Attribute orgAttribute = (Attribute)((XmlElement)e).getAttributes().get(0);
            StringBuilder newValue = new StringBuilder();
            newValue.append("record");
            newValue.append(".");
            newValue.append(orgAttribute.getValue());
            ((XmlElement)e).getAttributes().remove(0);
            ((XmlElement)e).getAttributes().add(0, new Attribute("test", newValue.toString()));
            Element orgElement = (Element)((XmlElement)e).getElements().get(0);
            String content = orgElement.getFormattedContent(0);
            StringBuilder newContent = new StringBuilder();
            newContent.append(content.substring(0, content.indexOf("{") - 1));
            newContent.append("#{");
            newContent.append("record");
            newContent.append(".");
            newContent.append(content.substring(content.indexOf("{") + 1));
            ((XmlElement)e).getElements().remove(0);
            ((XmlElement)e).getElements().add(0, new TextElement(newContent.toString()));
        }
        return true;
    }

    public boolean sqlMapUpdateByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        int i = element.getElements().size() - 1;
        while (i >= 1) {
            Element orgElement = (Element)element.getElements().get(i);
            if (orgElement instanceof TextElement) {
                element.getElements().remove(orgElement);
            }
            --i;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("set ");
        Iterator iter = introspectedTable.getNonBLOBColumns().iterator();
        while (iter.hasNext()) {
            IntrospectedColumn introspectedColumn = (IntrospectedColumn)iter.next();
            if (introspectedTable.getPrimaryKeyColumns().contains(introspectedColumn) || introspectedColumn.getActualColumnName().equalsIgnoreCase("created_date")) continue;
            sb.append(MyBatis3FormattingUtilities.getAliasedEscapedColumnName((IntrospectedColumn)introspectedColumn));
            sb.append(" = ");
            sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)"record."));
            if (iter.hasNext()) {
                sb.append(',');
            }
            element.addElement(element.getElements().size() - 1, (Element)new TextElement(sb.toString()));
            if (!iter.hasNext()) continue;
            sb.setLength(0);
            OutputUtilities.xmlIndent((StringBuilder)sb, (int)1);
        }
        return true;
    }

    private boolean getRelationInfo(Context context) {
        Connection connection = null;
        ResultSet exportResult = null;
        ResultSet importeResult = null;
        this._exportedKeys = new HashMap<String, List<RelationKeyBean>>();
        this._importedKeys = new HashMap<String, List<RelationKeyBean>>();
        try {
            try {
                connection = DataBaseUtils.getConnection(context.getJdbcConnectionConfiguration());
                DatabaseMetaData meta = connection.getMetaData();
                for (TableConfiguration tc : context.getTableConfigurations()) {
                    RelationKeyBean relationKeys;
                    exportResult = meta.getExportedKeys(tc.getCatalog(), tc.getSchema(), tc.getTableName());
                    while (exportResult.next()) {
                        if (exportResult.getString("pktable_name") == null) continue;
                        relationKeys = new RelationKeyBean();
                        String pkTableName = exportResult.getString("pktable_name");
                        relationKeys.setPkTableName(pkTableName);
                        relationKeys.setPkColumnName(exportResult.getString("pkcolumn_name"));
                        relationKeys.setFkTableName(exportResult.getString("fktable_name"));
                        relationKeys.setFkColumnName(exportResult.getString("fkcolumn_name"));
                        if (this._exportedKeys.get(pkTableName) == null) {
                            this._exportedKeys.put(pkTableName, new ArrayList());
                        }
                        this._exportedKeys.get(pkTableName).add(relationKeys);
                    }
                    importeResult = meta.getImportedKeys(tc.getCatalog(), tc.getSchema(), tc.getTableName());
                    while (importeResult.next()) {
                        if (importeResult.getString("fktable_name") == null) continue;
                        relationKeys = new RelationKeyBean();
                        String fkTableName = importeResult.getString("fktable_name");
                        relationKeys.setPkTableName(importeResult.getString("pktable_name"));
                        relationKeys.setPkColumnName(importeResult.getString("pkcolumn_name"));
                        relationKeys.setFkTableName(fkTableName);
                        relationKeys.setFkColumnName(importeResult.getString("fkcolumn_name"));
                        if (this._importedKeys.get(fkTableName) == null) {
                            this._importedKeys.put(fkTableName, new ArrayList());
                        }
                        this._importedKeys.get(fkTableName).add(relationKeys);
                    }
                }
            }
            catch (Exception e) {
                _logger.error((Object)MessageUtils.getString("err.100"), (Throwable)e);
                DataBaseUtils.closeResultSet(exportResult);
                DataBaseUtils.closeResultSet(importeResult);
                DataBaseUtils.closeConnection(connection);
                return false;
            }
        }
        finally {
            DataBaseUtils.closeResultSet(exportResult);
            DataBaseUtils.closeResultSet(importeResult);
            DataBaseUtils.closeConnection(connection);
        }
        WebAppOSCache.getInstance().setImportedKeys(this._importedKeys);
        return true;
    }

    private static FullyQualifiedJavaType getExportedJavaType(String fkTableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("List<");
        sb.append(PropertyUtils.getProperty("model.package"));
        sb.append(".");
        sb.append(JavaBeansUtil.getCamelCaseString((String)fkTableName, (boolean)true));
        sb.append(">");
        return new FullyQualifiedJavaType(sb.toString());
    }

    private static FullyQualifiedJavaType getImportedJavaType(String fkTableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(PropertyUtils.getProperty("model.package"));
        sb.append(".");
        sb.append(JavaBeansUtil.getCamelCaseString((String)fkTableName, (boolean)true));
        return new FullyQualifiedJavaType(sb.toString());
    }

    private static Field getJavaBeansField(FullyQualifiedJavaType type, String property) {
        Field field = new Field();
        field.setVisibility(JavaVisibility.PRIVATE);
        field.setType(type);
        field.setName(property);
        return field;
    }

    private static Method getJavaBeansGetter(FullyQualifiedJavaType type, String property) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(type);
        method.setName(JavaBeansUtil.getGetterMethodName((String)property, (FullyQualifiedJavaType)type));
        StringBuilder sb = new StringBuilder();
        sb.append("return ");
        sb.append(property);
        sb.append(";");
        method.addBodyLine(sb.toString());
        return method;
    }

    private static Method getJavaBeansSetter(FullyQualifiedJavaType type, String property) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName(JavaBeansUtil.getSetterMethodName((String)property));
        method.addParameter(new Parameter(type, property));
        StringBuilder sb = new StringBuilder();
        sb.append("this.");
        sb.append(property);
        sb.append(" = ");
        sb.append(property);
        sb.append(";");
        method.addBodyLine(sb.toString());
        return method;
    }

    private static void updateParameterTypeToGenericExample(XmlElement element) {
        for (Attribute orgAttribute : element.getAttributes()) {
            if (!"parameterType".equalsIgnoreCase(orgAttribute.getName())) continue;
            element.getAttributes().remove(orgAttribute);
            break;
        }
        element.addAttribute(new Attribute("parameterType", GeneratorConstants.MYBATIS_EXAMPLE_CLASS));
    }

    private static void updateParameterTypeToMap(XmlElement element) {
        for (Attribute orgAttribute : element.getAttributes()) {
            if (!"parameterType".equalsIgnoreCase(orgAttribute.getName())) continue;
            element.getAttributes().remove(orgAttribute);
            break;
        }
        element.addAttribute(new Attribute("parameterType", "map"));
    }

    private static List<JoinElementInfo> createJoinElementInfo(IntrospectedTable introspectedTable, List<RelationKeyBean> allRelationKeys) {
        ArrayList<JoinElementInfo> result = new ArrayList<JoinElementInfo>();
        ArrayList<String> joinTableNames = new ArrayList<String>();
        String joinTableName = null;
        String joinLeftColumn = null;
        String joinRightColumn = null;
        if (allRelationKeys == null) {
            return result;
        }
        String tableName = introspectedTable.getTableConfiguration().getTableName();
        joinTableNames.add(tableName);
        int i = 0;
        while (i < allRelationKeys.size()) {
            block5: {
                block3: {
                    RelationKeyBean relationKeys;
                    block4: {
                        block2: {
                            relationKeys = allRelationKeys.get(i);
                            if (!tableName.equals(relationKeys.getPkTableName())) break block2;
                            joinTableName = relationKeys.getFkTableName();
                            joinLeftColumn = String.valueOf(relationKeys.getFkTableName()) + "." + relationKeys.getFkColumnName();
                            joinRightColumn = String.valueOf(relationKeys.getPkTableName()) + "." + relationKeys.getPkColumnName();
                            break block3;
                        }
                        if (!joinTableNames.contains(relationKeys.getPkTableName())) break block4;
                        if (joinTableNames.contains(relationKeys.getFkTableName())) break block5;
                        joinTableName = relationKeys.getFkTableName();
                        joinLeftColumn = String.valueOf(relationKeys.getFkTableName()) + "." + relationKeys.getFkColumnName();
                        joinRightColumn = String.valueOf(relationKeys.getPkTableName()) + "." + relationKeys.getPkColumnName();
                        break block3;
                    }
                    joinTableName = relationKeys.getPkTableName();
                    joinLeftColumn = String.valueOf(joinTableName) + "." + relationKeys.getPkColumnName();
                    joinRightColumn = String.valueOf(relationKeys.getFkTableName()) + "." + relationKeys.getFkColumnName();
                }
                joinTableNames.add(joinTableName);
                JoinElementInfo joinElementInfo = new JoinElementInfo();
                StringBuilder sb = new StringBuilder();
                sb.append(AddRelationPlugin.getMapperName(introspectedTable, joinTableName));
                sb.append(".");
                sb.append("Base_Column_List");
                joinElementInfo.setIncludeRefId(sb.toString());
                joinElementInfo.setJoinTable(joinTableName);
                sb.setLength(0);
                sb.append(joinLeftColumn);
                sb.append(" = ");
                sb.append(joinRightColumn);
                joinElementInfo.setJoinColumn(sb.toString());
                result.add(joinElementInfo);
            }
            ++i;
        }
        return result;
    }

    private XmlElement getSelectAllByPrimaryKeyElement(IntrospectedTable introspectedTable, List<JoinElementInfo> importedJoinElementInfo) {
        StringBuilder sb = new StringBuilder();
        XmlElement answer = new XmlElement("select");
        answer.addAttribute(new Attribute("id", "selectAllByPrimaryKey"));
        answer.addAttribute(new Attribute("resultMap", "FullResultMap"));
        String parameterType = introspectedTable.getRules().generatePrimaryKeyClass() ? introspectedTable.getPrimaryKeyType() : (introspectedTable.getPrimaryKeyColumns().size() > 1 ? "map" : ((IntrospectedColumn)introspectedTable.getPrimaryKeyColumns().get(0)).getFullyQualifiedJavaType().toString());
        answer.addAttribute(new Attribute("parameterType", parameterType));
        answer.addElement((Element)new TextElement("select "));
        XmlElement baseColumn = new XmlElement("include");
        baseColumn.addAttribute(new Attribute("refid", introspectedTable.getBaseColumnListId()));
        answer.addElement((Element)baseColumn);
        for (JoinElementInfo joinElementInfo : importedJoinElementInfo) {
            XmlElement element = new XmlElement("include");
            element.addAttribute(new Attribute("refid", joinElementInfo.getIncludeRefId()));
            answer.addElement((Element)new TextElement(","));
            answer.addElement((Element)element);
        }
        String from = introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime();
        sb.setLength(0);
        sb.append("from ");
        sb.append(from);
        answer.addElement((Element)new TextElement(sb.toString()));
        for (JoinElementInfo joinElementInfo : importedJoinElementInfo) {
            sb.setLength(0);
            sb.append("left join ");
            sb.append(joinElementInfo.getJoinTable());
            sb.append(" on ");
            sb.append(joinElementInfo.getJoinColumn());
            TextElement element = new TextElement(sb.toString());
            answer.addElement((Element)element);
        }
        boolean and = false;
        for (IntrospectedColumn introspectedColumn : introspectedTable.getPrimaryKeyColumns()) {
            sb.setLength(0);
            if (and) {
                sb.append("  and ");
            } else {
                sb.append("where ");
                and = true;
            }
            sb.append(from);
            sb.append(".");
            sb.append(MyBatis3FormattingUtilities.getAliasedEscapedColumnName((IntrospectedColumn)introspectedColumn));
            sb.append(" = ");
            sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn));
            answer.addElement((Element)new TextElement(sb.toString()));
        }
        return answer;
    }

    private XmlElement getSelectAllByExample(List<JoinElementInfo> exportedJoinElementInfo, List<JoinElementInfo> importedJoinElementInfo) {
        XmlElement ifElement;
        XmlElement eachElement;
        JoinElementInfo joinElementInfo;
        XmlElement element;
        StringBuilder sb = new StringBuilder();
        XmlElement answer = new XmlElement(this._selectByExampleElement);
        int i = answer.getAttributes().size() - 1;
        while (i >= 0) {
            Attribute orgAttribute = (Attribute)answer.getAttributes().get(i);
            if ("id".equalsIgnoreCase(orgAttribute.getName())) {
                answer.getAttributes().remove(orgAttribute);
            }
            if ("resultMap".equalsIgnoreCase(orgAttribute.getName())) {
                answer.getAttributes().remove(orgAttribute);
            }
            --i;
        }
        answer.addAttribute(new Attribute("id", "selectAllByExample"));
        answer.addAttribute(new Attribute("resultMap", "FullResultMap"));
        i = importedJoinElementInfo.size() - 1;
        while (i >= 0) {
            sb.setLength(0);
            sb.append("left join ");
            sb.append(importedJoinElementInfo.get(i).getJoinTable());
            sb.append(" on ");
            sb.append(importedJoinElementInfo.get(i).getJoinColumn());
            element = new TextElement(sb.toString());
            answer.addElement(4, (Element)element);
            --i;
        }
        i = exportedJoinElementInfo.size() - 1;
        while (i >= 0) {
            joinElementInfo = exportedJoinElementInfo.get(i);
            eachElement = new XmlElement("foreach");
            eachElement.getAttributes().add(new Attribute("collection", "joinTables"));
            eachElement.getAttributes().add(new Attribute("item", "tableName"));
            ifElement = new XmlElement("if");
            ifElement.getAttributes().add(new Attribute("test", "tableName == '" + joinElementInfo.getJoinTable() + "'"));
            sb.setLength(0);
            sb.append("left join ");
            sb.append(joinElementInfo.getJoinTable());
            sb.append(" on ");
            sb.append(joinElementInfo.getJoinColumn());
            TextElement joinElement = new TextElement(sb.toString());
            ifElement.addElement((Element)joinElement);
            eachElement.addElement((Element)ifElement);
            answer.addElement(4, (Element)eachElement);
            --i;
        }
        i = importedJoinElementInfo.size() - 1;
        while (i >= 0) {
            element = new XmlElement("include");
            element.addAttribute(new Attribute("refid", importedJoinElementInfo.get(i).getIncludeRefId()));
            answer.addElement(3, (Element)element);
            answer.addElement(3, (Element)new TextElement(","));
            --i;
        }
        i = exportedJoinElementInfo.size() - 1;
        while (i >= 0) {
            joinElementInfo = exportedJoinElementInfo.get(i);
            eachElement = new XmlElement("foreach");
            eachElement.getAttributes().add(new Attribute("collection", "joinTables"));
            eachElement.getAttributes().add(new Attribute("item", "tableName"));
            ifElement = new XmlElement("if");
            ifElement.getAttributes().add(new Attribute("test", "tableName == '" + joinElementInfo.getJoinTable() + "'"));
            XmlElement includeElement = new XmlElement("include");
            includeElement.addAttribute(new Attribute("refid", joinElementInfo.getIncludeRefId()));
            ifElement.addElement((Element)new TextElement(","));
            ifElement.addElement((Element)includeElement);
            eachElement.addElement((Element)ifElement);
            answer.addElement(3, (Element)eachElement);
            --i;
        }
        return answer;
    }

    private XmlElement getCountAllByExample(XmlElement selectAllElement, IntrospectedTable introspectedTable) {
        StringBuilder sb = new StringBuilder();
        XmlElement answer = new XmlElement(selectAllElement);
        int i = answer.getAttributes().size() - 1;
        while (i >= 0) {
            Attribute orgAttribute = (Attribute)answer.getAttributes().get(i);
            if ("id".equalsIgnoreCase(orgAttribute.getName())) {
                answer.getAttributes().remove(orgAttribute);
            }
            if ("resultMap".equalsIgnoreCase(orgAttribute.getName())) {
                answer.getAttributes().remove(orgAttribute);
            }
            --i;
        }
        answer.addAttribute(new Attribute("id", "countAllByExample"));
        answer.addAttribute(new Attribute("resultType", Integer.class.getName()));
        boolean isFromStatement = true;
        int i2 = answer.getElements().size() - 1;
        while (i2 >= 0) {
            Element orgElement = (Element)answer.getElements().get(i2);
            if (orgElement instanceof TextElement) {
                if (",".equals(((TextElement)orgElement).getContent())) {
                    answer.getElements().remove(orgElement);
                }
                if (((TextElement)orgElement).getContent().startsWith("from")) {
                    isFromStatement = false;
                }
            } else {
                if (orgElement.getFormattedContent(0).startsWith("<if test=\"orderByClause")) {
                    answer.getElements().remove(orgElement);
                }
                if (!isFromStatement && !orgElement.getFormattedContent(0).startsWith("<if test=\"_parameter != null\" >")) {
                    answer.getElements().remove(orgElement);
                }
            }
            --i2;
        }
        answer.addElement(1, (Element)new TextElement(" count(*) from (select distinct "));
        sb.setLength(0);
        String tableName = introspectedTable.getFullyQualifiedTable().getIntrospectedTableName();
        if (!introspectedTable.getPrimaryKeyColumns().isEmpty()) {
            for (IntrospectedColumn primaryKeyColumn : introspectedTable.getPrimaryKeyColumns()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(tableName);
                sb.append('.');
                sb.append(primaryKeyColumn.getActualColumnName());
            }
        } else {
            sb.append("*");
        }
        answer.addElement(2, (Element)new TextElement(sb.toString()));
        answer.addElement((Element)new TextElement(") as x"));
        return answer;
    }

    private static String getMapperName(IntrospectedTable introspectedTable, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedTable.getMyBatis3XmlMapperPackage());
        sb.append(".");
        sb.append(JavaBeansUtil.getCamelCaseString((String)tableName, (boolean)true));
        sb.append("Mapper");
        return sb.toString();
    }

    private static String getKeyProperty() {
        StringBuilder sb = new StringBuilder();
        sb.append("record");
        sb.append('.');
        sb.append("id");
        return sb.toString();
    }
}

