/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator.mybatis.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.co.headwaters.webappos.generator.utils.GeneratorUtils;
import jp.co.headwaters.webappos.generator.utils.PropertyUtils;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JDBCConnectionConfiguration;

public class MapperConfigPlugin
extends PluginAdapter {
    private JDBCConnectionConfiguration _jdbcConnectionConfiguration;
    private List<String> _mapperFiles = new ArrayList<String>();

    public void setContext(Context context) {
        super.setContext(context);
        this._jdbcConnectionConfiguration = context.getJdbcConnectionConfiguration();
    }

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean sqlMapGenerated(GeneratedXmlFile sqlMap, IntrospectedTable introspectedTable) {
        this._mapperFiles.add(MapperConfigPlugin.getMapperName(sqlMap.getTargetPackage(), sqlMap.getFileName()));
        return true;
    }

    public List<GeneratedXmlFile> contextGenerateAdditionalXmlFiles() {
        this.addExtraMapperFiles();
        this.addSystemMapperFiles();
        GeneratedXmlFile gxf = new GeneratedXmlFile(this.getDocument(), "mybatis-config.xml", "properties", GeneratorUtils.getOutputPath(), false, this.context.getXmlFormatter());
        ArrayList<GeneratedXmlFile> answer = new ArrayList<GeneratedXmlFile>(1);
        answer.add(gxf);
        return answer;
    }

    private static String getMapperName(String targetPackage, String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append(targetPackage);
        sb.append('.');
        String temp = sb.toString();
        sb.setLength(0);
        sb.append(temp.replace('.', '/'));
        sb.append(fileName);
        return sb.toString();
    }

    private void addSystemMapperFiles() {
        this._mapperFiles.add(MapperConfigPlugin.getMapperName(PropertyUtils.getProperty("mapper.package"), "ProcedureMapper.xml"));
    }

    private void addExtraMapperFiles() {
        File mapperDir = new File(GeneratorUtils.getInputMapperPath());
        if (mapperDir.listFiles() != null) {
            File[] fileArray = mapperDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory()) {
                    this._mapperFiles.add(MapperConfigPlugin.getMapperName(PropertyUtils.getProperty("mapper.package"), file.getName()));
                }
                ++n2;
            }
        }
    }

    private Document getDocument() {
        Document document = new Document("-//mybatis.org//DTD Config 3.0//EN", "http://mybatis.org/dtd/mybatis-3-config.dtd");
        XmlElement root = new XmlElement("configuration");
        document.setRootElement(root);
        MapperConfigPlugin.addSettingsElement(root);
        this.addEnvironmentsElement(root);
        this.addMappersElement(root);
        return document;
    }

    private static void addSettingsElement(XmlElement root) {
        XmlElement settings = new XmlElement("settings");
        root.addElement((Element)settings);
        XmlElement setting = new XmlElement("setting");
        setting.addAttribute(new Attribute("name", "mapUnderscoreToCamelCase"));
        setting.addAttribute(new Attribute("value", "true"));
        settings.addElement((Element)setting);
    }

    private void addEnvironmentsElement(XmlElement root) {
        XmlElement environments = new XmlElement("environments");
        environments.addAttribute(new Attribute("default", "production"));
        root.addElement((Element)environments);
        XmlElement environment = new XmlElement("environment");
        environment.addAttribute(new Attribute("id", "production"));
        environments.addElement((Element)environment);
        XmlElement transactionManager = new XmlElement("transactionManager");
        transactionManager.addAttribute(new Attribute("type", "JDBC"));
        environment.addElement((Element)transactionManager);
        XmlElement dataSource = new XmlElement("dataSource");
        dataSource.addAttribute(new Attribute("type", "POOLED"));
        environment.addElement((Element)dataSource);
        XmlElement property = new XmlElement("property");
        property.addAttribute(new Attribute("name", "driver"));
        property.addAttribute(new Attribute("value", this._jdbcConnectionConfiguration.getDriverClass()));
        dataSource.addElement((Element)property);
        property = new XmlElement("property");
        property.addAttribute(new Attribute("name", "url"));
        property.addAttribute(new Attribute("value", this._jdbcConnectionConfiguration.getConnectionURL()));
        dataSource.addElement((Element)property);
        property = new XmlElement("property");
        property.addAttribute(new Attribute("name", "username"));
        property.addAttribute(new Attribute("value", this._jdbcConnectionConfiguration.getUserId()));
        dataSource.addElement((Element)property);
        property = new XmlElement("property");
        property.addAttribute(new Attribute("name", "password"));
        property.addAttribute(new Attribute("value", this._jdbcConnectionConfiguration.getPassword()));
        dataSource.addElement((Element)property);
    }

    private void addMappersElement(XmlElement root) {
        XmlElement mappers = new XmlElement("mappers");
        root.addElement((Element)mappers);
        for (String mapperFile : this._mapperFiles) {
            XmlElement mapper = new XmlElement("mapper");
            mapper.addAttribute(new Attribute("resource", mapperFile));
            mappers.addElement((Element)mapper);
        }
    }
}

