/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import jp.co.headwaters.webappos.generator.GeneratorConstants;
import org.apache.commons.lang3.StringUtils;

public class FileUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFile(File file, String content, String fileEncoding) throws IOException {
        String charsetName = fileEncoding;
        if (charsetName == null) {
            charsetName = null;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileOutputStream fos = new FileOutputStream(file, false);
            try {
                block19: {
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, charsetName);
                    try {
                        try (BufferedWriter bw = new BufferedWriter(osw);){
                            bw.write(content);
                        }
                        if (osw == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (osw == null) throw throwable;
                        osw.close();
                        throw throwable;
                    }
                    osw.close();
                }
                if (fos == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File file, String newFilePath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                block25: {
                    try (FileChannel ifc = fis.getChannel();){
                        File outFile = new File(newFilePath);
                        Throwable throwable2 = null;
                        Object var8_12 = null;
                        try {
                            FileOutputStream fos = new FileOutputStream(outFile);
                            try {
                                try (FileChannel ofc = fos.getChannel();){
                                    ifc.transferTo(0L, ifc.size(), ofc);
                                }
                                if (fos == null) break block25;
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                if (fos == null) throw throwable2;
                                fos.close();
                                throw throwable2;
                            }
                            fos.close();
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            }
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                            throw throwable2;
                        }
                    }
                }
                if (fis == null) return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            }
            if (throwable == throwable6) throw throwable;
            throwable.addSuppressed(throwable6);
            throw throwable;
        }
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                FileUtils.deleteFile(files[i]);
                ++i;
            }
            file.delete();
        }
    }

    public static String getFileExtension(String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return "";
        }
        int lastDotPos = filename.lastIndexOf(46);
        if (lastDotPos == -1) {
            return filename;
        }
        if (lastDotPos == 0) {
            return filename;
        }
        return filename.substring(lastDotPos + 1).toLowerCase();
    }

    public static String removeFileExtension(String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return filename;
        }
        int lastDotPos = filename.lastIndexOf(46);
        if (lastDotPos == -1) {
            return filename;
        }
        if (lastDotPos == 0) {
            return filename;
        }
        return filename.substring(0, lastDotPos);
    }

    public static String convertExtensionHtmlToJsp(String target) {
        String result = target;
        if (StringUtils.isEmpty((CharSequence)target)) {
            return result;
        }
        String[] stringArray = GeneratorConstants.INPUT_FILE_EXTENSION;
        int n = GeneratorConstants.INPUT_FILE_EXTENSION.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            result = result.replaceAll(String.valueOf(extension) + "$", ".jsp");
            ++n2;
        }
        return result;
    }

    public static FilenameFilter getTargetFileFilter() {
        return FileUtils.getFileExtensionFilter(GeneratorConstants.INPUT_FILE_EXTENSION);
    }

    public static FilenameFilter getFileExtensionFilter(String[] extensions) {
        final String[] _extensions = extensions;
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                boolean result = false;
                String[] stringArray = _extensions;
                int n = _extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if (name.endsWith(extension)) {
                        result = true;
                        break;
                    }
                    ++n2;
                }
                return result;
            }
        };
    }
}

