/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator.utils;

import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.generator.Main;
import jp.co.headwaters.webappos.generator.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class GeneratorUtils {
    public static String getContextName() {
        return Main.getContextName();
    }

    public static boolean getContextMode() {
        return Boolean.valueOf(PropertyUtils.getProperty("context.mode"));
    }

    public static String getRootPackage() {
        return PropertyUtils.getProperty("root.package");
    }

    public static String getInputPath() {
        StringBuilder sb = new StringBuilder(PropertyUtils.getProperty("generate.path"));
        if (!sb.toString().endsWith(ControllerUtils.getFileSparator())) {
            sb.append(ControllerUtils.getFileSparator());
        }
        if (StringUtils.isEmpty((CharSequence)System.getenv("GEN_PATH"))) {
            sb.append(GeneratorUtils.getContextName());
            sb.append(ControllerUtils.getFileSparator());
            sb.append("in");
            sb.append(ControllerUtils.getFileSparator());
        } else {
            sb.append("in");
            sb.append(ControllerUtils.getFileSparator());
        }
        return sb.toString();
    }

    public static String getInputHtmlPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getInputPath());
        sb.append("html");
        sb.append(ControllerUtils.getFileSparator());
        return sb.toString();
    }

    public static String getIputPropertyPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getInputPath());
        sb.append("properties");
        sb.append(ControllerUtils.getFileSparator());
        return sb.toString();
    }

    public static String getInputMapperPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getInputPath());
        sb.append("mapper");
        sb.append(ControllerUtils.getFileSparator());
        return sb.toString();
    }

    public static String getOutputPath() {
        StringBuilder sb = new StringBuilder(PropertyUtils.getProperty("generate.path"));
        if (!sb.toString().endsWith(ControllerUtils.getFileSparator())) {
            sb.append(ControllerUtils.getFileSparator());
        }
        if (StringUtils.isEmpty((CharSequence)System.getenv("GEN_PATH"))) {
            sb.append(GeneratorUtils.getContextName());
            sb.append(ControllerUtils.getFileSparator());
            sb.append("out");
            sb.append(ControllerUtils.getFileSparator());
        } else {
            sb.append("out");
            sb.append(ControllerUtils.getFileSparator());
        }
        return sb.toString();
    }

    public static String getOutputJspPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getOutputPath());
        sb.append("web");
        sb.append(ControllerUtils.getFileSparator());
        sb.append("jsp");
        sb.append(ControllerUtils.getFileSparator());
        return sb.toString();
    }

    public static String getOutputWebInfPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getOutputPath());
        sb.append("web");
        sb.append(ControllerUtils.getFileSparator());
        sb.append("WEB-INF");
        sb.append(ControllerUtils.getFileSparator());
        return sb.toString();
    }

    public static String getOutputSrcPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getOutputPath());
        sb.append("src");
        return sb.toString();
    }

    public static String getOutputPropertyPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getOutputPath());
        sb.append("properties");
        sb.append(ControllerUtils.getFileSparator());
        return sb.toString();
    }

    public static String getOutputDatPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getOutputPath());
        sb.append("dat");
        sb.append(ControllerUtils.getFileSparator());
        return sb.toString();
    }

    public static String getErrorPageLocation(String status, String separator) {
        StringBuilder sb = new StringBuilder();
        sb.append(separator);
        sb.append("jsp");
        sb.append(separator);
        sb.append("error");
        sb.append(separator);
        sb.append(status);
        sb.append(".jsp");
        return sb.toString();
    }

    public static String getLinesSparator() {
        String separator = System.getProperty("line.separator");
        if (separator == null) {
            separator = "\n";
        }
        return separator;
    }
}

