/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator.web;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.headwaters.webappos.controller.cache.SystemConstantCache;
import jp.co.headwaters.webappos.controller.cache.WebAppOSCache;
import jp.co.headwaters.webappos.controller.cache.bean.AbstractExecuteBean;
import jp.co.headwaters.webappos.controller.cache.bean.ActionBean;
import jp.co.headwaters.webappos.controller.cache.bean.BindInputBean;
import jp.co.headwaters.webappos.controller.cache.bean.BindOutputBean;
import jp.co.headwaters.webappos.controller.cache.bean.CaseBean;
import jp.co.headwaters.webappos.controller.cache.bean.ConditionBean;
import jp.co.headwaters.webappos.controller.cache.bean.ExecuteBean;
import jp.co.headwaters.webappos.controller.cache.bean.FunctionBean;
import jp.co.headwaters.webappos.controller.cache.bean.ImageBean;
import jp.co.headwaters.webappos.controller.cache.bean.LoadBean;
import jp.co.headwaters.webappos.controller.cache.bean.ProcedureInfoBean;
import jp.co.headwaters.webappos.controller.cache.bean.ResultBean;
import jp.co.headwaters.webappos.controller.cache.bean.SystemConstantBean;
import jp.co.headwaters.webappos.controller.cache.bean.UrlPatternBean;
import jp.co.headwaters.webappos.controller.enumation.ContentTypeEnum;
import jp.co.headwaters.webappos.controller.enumation.CrudEnum;
import jp.co.headwaters.webappos.controller.enumation.DataTypeEnum;
import jp.co.headwaters.webappos.controller.enumation.FunctionEnum;
import jp.co.headwaters.webappos.controller.enumation.StretchTypeEnum;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.controller.utils.RegexUtils;
import jp.co.headwaters.webappos.generator.GeneratorConstants;
import jp.co.headwaters.webappos.generator.utils.FileUtils;
import jp.co.headwaters.webappos.generator.utils.GeneratorUtils;
import jp.co.headwaters.webappos.generator.utils.MessageUtils;
import jp.co.headwaters.webappos.generator.web.WebAppOSDatGenerator;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.mybatis.generator.api.dom.OutputUtilities;

public class JspGenerator {
    private static final Log _logger = LogFactory.getLog(JspGenerator.class);
    private static String _webRootPath;
    private static String _htmlRootPath;
    private WebAppOSCache _webAppOSCache;
    private Map<String, IteratorInfo> _iteratorInfo;
    private boolean _isFullBuild;

    public JspGenerator(boolean isFullBuild) {
        this._isFullBuild = isFullBuild;
    }

    public boolean generate() {
        long lastBuildTime = -1L;
        if (!this._isFullBuild) {
            lastBuildTime = WebAppOSDatGenerator.getDatFile().lastModified();
        }
        ArrayList<String> warnings = new ArrayList<String>();
        this._webAppOSCache = WebAppOSCache.getInstance();
        if (lastBuildTime < 0L) {
            this.createActionCache(new File(GeneratorUtils.getInputHtmlPath()), null);
            this.createJspDirectory();
        } else {
            try {
                this._webAppOSCache.load(WebAppOSDatGenerator.getDatFile());
            }
            catch (IOException | ClassNotFoundException e) {
                _logger.error((Object)MessageUtils.getString("err.404"), (Throwable)e);
                return false;
            }
        }
        JspGenerator.setRootPath();
        for (ActionBean actionBean : this._webAppOSCache.getActionMap().values()) {
            File[] files;
            File[] fileArray = files = new File(JspGenerator.getTargetHtmlPath(actionBean)).listFiles(FileUtils.getTargetFileFilter());
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    if (lastBuildTime < file.lastModified()) {
                        _logger.debug((Object)file.getAbsoluteFile());
                        this.outputJspFile(actionBean, file, warnings);
                    }
                }
                catch (IOException e) {
                    _logger.error((Object)MessageUtils.getString("err.400", file.getAbsolutePath()), (Throwable)e);
                    return false;
                }
                ++n2;
            }
        }
        if (warnings.size() != 0) {
            for (String warning : warnings) {
                _logger.error((Object)warning);
            }
            return false;
        }
        return true;
    }

    private void createActionCache(File dir, String parent) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        String actionName = null;
        String actionPath = null;
        ActionBean indexAction = new ActionBean("", "");
        indexAction.setSubmitExecuteMap(new HashMap<String, ExecuteBean>());
        indexAction.setLoadExecuteMap(new HashMap<String, ExecuteBean>());
        this._webAppOSCache.getActionMap().put("", indexAction);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && !"sysapi".equalsIgnoreCase(file.getName())) {
                actionName = this.getActionName(parent, file.getName());
                actionPath = file.getAbsolutePath().replace(GeneratorUtils.getInputHtmlPath(), "");
                ActionBean action = new ActionBean(actionName, actionPath);
                action.setSubmitExecuteMap(new HashMap<String, ExecuteBean>());
                action.setLoadExecuteMap(new HashMap<String, ExecuteBean>());
                this._webAppOSCache.getActionMap().put(actionName, action);
                this.createActionCache(file, actionName);
            }
            ++n2;
        }
    }

    private String getActionName(String parent, String fileName) {
        StringBuilder sb = new StringBuilder();
        if (parent != null) {
            sb.append(parent);
            sb.append("-");
        }
        sb.append(fileName);
        return sb.toString();
    }

    private String getFormActionName(String attributeValue) {
        StringBuilder sb = new StringBuilder();
        if (attributeValue.indexOf(_htmlRootPath) > 0) {
            attributeValue = attributeValue.substring(attributeValue.indexOf(_htmlRootPath) + _htmlRootPath.length());
            String[] path = attributeValue.split("/");
            int i = 0;
            while (i < path.length - 1) {
                if (sb.length() > 0) {
                    sb.append("-");
                }
                sb.append(path[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    private void createJspDirectory() {
        StringBuilder sb = new StringBuilder();
        for (ActionBean actionBean : this._webAppOSCache.getActionMap().values()) {
            sb.setLength(0);
            sb.append(GeneratorUtils.getOutputJspPath());
            sb.append(actionBean.getHtmlPath());
            File file = new File(sb.toString());
            file.mkdirs();
        }
    }

    private static void setRootPath() {
        _htmlRootPath = JspGenerator.getHtmlRootPath();
        _webRootPath = JspGenerator.getWebRootPath();
    }

    private static String getHtmlRootPath() {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append("html");
        sb.append("/");
        return sb.toString();
    }

    private static String getWebRootPath() {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append("web");
        sb.append("/");
        return sb.toString();
    }

    private static String getTargetHtmlPath(ActionBean actionBean) {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getInputHtmlPath());
        sb.append(actionBean.getHtmlPath());
        return sb.toString();
    }

    private static String getOutputPath(ActionBean actionBean, String fileName) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)actionBean.getHtmlPath())) {
            sb.append(actionBean.getHtmlPath());
            sb.append(ControllerUtils.getFileSparator());
        }
        sb.append(FileUtils.convertExtensionHtmlToJsp(fileName));
        return sb.toString();
    }

    private void outputJspFile(ActionBean actionBean, File inputFile, List<String> warnings) throws IOException {
        String outputPath = JspGenerator.getOutputPath(actionBean, inputFile.getName());
        Document document = Jsoup.parse((File)inputFile, (String)"UTF-8");
        this._iteratorInfo = new HashMap<String, IteratorInfo>();
        ContentTypeEnum contentType = ContentTypeEnum.getContentType(FileUtils.getFileExtension(inputFile.getName()));
        if (contentType.equals((Object)ContentTypeEnum.HTML)) {
            JspGenerator.replacePath(document);
        }
        this.parseDataErasure(document);
        if (!"error".equalsIgnoreCase(actionBean.getName())) {
            this.parseDataLoad(actionBean, outputPath, document);
        }
        if (contentType.equals((Object)ContentTypeEnum.HTML)) {
            this.parseDataFunc(outputPath, document);
        }
        this.parseDataImage(actionBean, outputPath, document);
        JspGenerator.replaceHtmlPath(document.select("form[action]"), "action");
        this.parseDataBindOutput(actionBean, outputPath, document);
        if (contentType.equals((Object)ContentTypeEnum.HTML)) {
            this.parseDataBindInput(document);
        }
        this.parseDataIterator(document);
        this.parseDataCase(document);
        if (!"error".equalsIgnoreCase(actionBean.getName())) {
            this.parseDataUrl(document, actionBean.getName(), inputFile.getName());
        }
        this.checkUnParsedAttribute(document, inputFile.getAbsolutePath(), warnings);
        this.saveJspFile(document, outputPath, contentType);
    }

    private static void replacePath(Document document) {
        JspGenerator.replaceWebPath(document);
        JspGenerator.replaceHtmlPath(document.select("[href]"), "href");
    }

    private static void replaceWebPath(Document document) {
        StringBuilder sb = new StringBuilder();
        String attributeValue = null;
        String[] stringArray = GeneratorConstants.HTML_REPLACE_ATTR_KEY;
        int n = GeneratorConstants.HTML_REPLACE_ATTR_KEY.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeKey = stringArray[n2];
            for (Element element : document.getElementsByAttributeValueContaining(attributeKey, _webRootPath)) {
                sb.setLength(0);
                if (GeneratorUtils.getContextMode()) {
                    sb.append("/");
                    sb.append(GeneratorUtils.getContextName());
                }
                attributeValue = element.attr(attributeKey);
                attributeValue = attributeValue.replace("_dev", "");
                sb.append("/");
                sb.append(attributeValue.substring(attributeValue.indexOf(_webRootPath) + _webRootPath.length()));
                sb.append("?var=");
                sb.append(System.currentTimeMillis());
                element.attr(attributeKey, sb.toString());
            }
            ++n2;
        }
    }

    private static void replaceHtmlPath(Elements elements, String attributeName) {
        StringBuilder sb = new StringBuilder();
        String value = null;
        String resultName = null;
        for (Element element : elements) {
            sb.setLength(0);
            value = element.attr(attributeName);
            if (value.indexOf(_htmlRootPath) <= 0) continue;
            if (GeneratorUtils.getContextMode()) {
                sb.append("/");
                sb.append(GeneratorUtils.getContextName());
            }
            value = value.substring(value.indexOf(_htmlRootPath) + _htmlRootPath.length());
            String[] path = value.split("/");
            int i = 0;
            while (i < path.length) {
                if (i == path.length - 1) {
                    resultName = FileUtils.removeFileExtension(path[i]);
                    break;
                }
                sb.append("/");
                sb.append(path[i]);
                ++i;
            }
            sb.append("/");
            if (!"index".equalsIgnoreCase(resultName)) {
                sb.append(resultName);
                sb.append("/");
            }
            element.attr(attributeName, sb.toString());
        }
    }

    private void parseDataErasure(Document document) {
        Elements elements = document.getElementsByAttribute("data-erase");
        String type = null;
        for (Element element : elements) {
            type = element.attr("data-erase");
            if ("own".equalsIgnoreCase(type)) {
                elements.remove();
                continue;
            }
            if (!"child".equalsIgnoreCase(type)) continue;
            element.children().remove();
            element.removeAttr("data-erase");
        }
    }

    private void parseDataImage(ActionBean actionBean, String outputPath, Document document) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String params = null;
        ImageBean bean = null;
        Elements elements = document.getElementsByAttribute("data-image");
        for (Element element : elements) {
            params = element.attr("data-image");
            bean = (ImageBean)mapper.readValue(params, ImageBean.class);
            if (!this.updateAttributeForImage(actionBean, outputPath, bean, element)) {
                return;
            }
            element.removeAttr("data-image");
        }
    }

    private void parseDataLoad(ActionBean actionBean, String outputPath, Document document) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<AbstractExecuteBean> executeInfoList = null;
        String params = null;
        ExecuteBean executeInfo = new ExecuteBean();
        executeInfo.setResultInfo(JspGenerator.createResultForLoad(outputPath));
        executeInfo.setExecuteInfoList(new ArrayList<AbstractExecuteBean>());
        actionBean.getLoadExecuteMap().put(outputPath, executeInfo);
        Element element = document.select(JspGenerator.getQueryForLoad()).first();
        if (element != null) {
            params = element.attr("data-load");
            if (params.startsWith("[")) {
                executeInfoList = (List)mapper.readValue(params, (TypeReference)new TypeReference<List<LoadBean>>(){});
            } else {
                executeInfoList = new ArrayList<AbstractExecuteBean>();
                executeInfoList.add((AbstractExecuteBean)mapper.readValue(params, LoadBean.class));
            }
            executeInfo.getExecuteInfoList().addAll(executeInfoList);
            this.addIteratorResultNames(executeInfoList);
            element.removeAttr("data-load");
        }
    }

    private void parseDataFunc(String outputPath, Document document) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String actionName = null;
        String params = null;
        Elements elements = document.select(JspGenerator.getQueryForFunc());
        for (Element element : elements) {
            actionName = this.getFormActionName(element.attr("action"));
            ActionBean actionBean = WebAppOSCache.getInstance().getActionMap().get(actionName);
            ExecuteBean executeInfo = new ExecuteBean();
            executeInfo.setResultInfo(JspGenerator.createResultForSubmit(actionBean, element));
            executeInfo.setExecuteInfoList(new ArrayList<AbstractExecuteBean>());
            String formId = JspGenerator.addFormIdElement(outputPath, element);
            actionBean.getSubmitExecuteMap().put(formId, executeInfo);
            ArrayList<AbstractExecuteBean> executeInfoList = null;
            params = element.attr("data-func");
            if (params.startsWith("[")) {
                executeInfoList = (List)mapper.readValue(params, (TypeReference)new TypeReference<List<FunctionBean>>(){});
            } else {
                executeInfoList = new ArrayList<AbstractExecuteBean>();
                executeInfoList.add((AbstractExecuteBean)mapper.readValue(params, FunctionBean.class));
            }
            Elements condElements = element.select(JspGenerator.getQueryForCond());
            for (Element condElement : condElements) {
                params = condElement.attr("data-cond");
                ConditionBean condition = (ConditionBean)mapper.readValue(params, ConditionBean.class);
                this.updateAttributeForCondition(condition, condElement);
                condElement.removeAttr("data-cond");
                for (AbstractExecuteBean bean : executeInfoList) {
                    if (!bean.getResult().equalsIgnoreCase(condition.getResult())) continue;
                    FunctionBean function = (FunctionBean)bean;
                    if (function.getOperatorMap() == null) {
                        function.setOperatorMap(new HashMap<String, String>());
                    }
                    function.getOperatorMap().putAll(JspGenerator.createOperatorMap(condition));
                }
            }
            executeInfo.getExecuteInfoList().addAll(executeInfoList);
            this.addIteratorResultNames(executeInfoList);
            for (AbstractExecuteBean bean : executeInfoList) {
                FunctionBean function = (FunctionBean)bean;
                if (!function.isTokenValidation()) continue;
                JspGenerator.addTokenElement(element);
                break;
            }
            element.removeAttr("data-func");
        }
    }

    private void parseDataBindOutput(ActionBean actionBean, String outputPath, Document document) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String params = null;
        List binds = null;
        Elements elements = document.getElementsByAttribute("data-bind-out");
        for (Element element : elements) {
            params = element.attr("data-bind-out");
            if (params.startsWith("[")) {
                binds = (List)mapper.readValue(params, (TypeReference)new TypeReference<List<BindOutputBean>>(){});
            } else {
                binds = new ArrayList<BindOutputBean>();
                binds.add((BindOutputBean)mapper.readValue(params, BindOutputBean.class));
            }
            for (BindOutputBean bind : binds) {
                if (this.updateAttributeForBindOutput(actionBean, outputPath, bind, element)) continue;
                return;
            }
            element.removeAttr("data-bind-out");
        }
    }

    private void parseDataBindInput(Document document) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String params = null;
        boolean isUpdated = false;
        List binds = null;
        Elements elements = document.getElementsByAttribute("data-bind-in");
        for (Element element : elements) {
            params = element.attr("data-bind-in");
            if (params.startsWith("[")) {
                binds = (List)mapper.readValue(params, (TypeReference)new TypeReference<List<BindInputBean>>(){});
            } else {
                binds = new ArrayList<BindInputBean>();
                binds.add((BindInputBean)mapper.readValue(params, BindInputBean.class));
            }
            for (BindInputBean bind : binds) {
                isUpdated = this.updateAttributeForBindInput(bind, element);
                if (isUpdated) continue;
                return;
            }
            element.removeAttr("data-bind-in");
        }
    }

    private void parseDataIterator(Document document) {
        for (IteratorInfo iteratorInfo : this._iteratorInfo.values()) {
            Elements elements = document.select(JspGenerator.getQueryForIterator(iteratorInfo.getIteratorName()));
            for (Element element : elements) {
                JspGenerator.removeSiblingElement(element);
                JspGenerator.addIteratorElement(element, element.attr("data-iterator"), iteratorInfo);
                element.removeAttr("data-iterator");
            }
        }
    }

    private void parseDataCase(Document document) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String params = null;
        List cases = null;
        StringBuilder sb = new StringBuilder();
        String expression = null;
        Elements elements = document.getElementsByAttribute("data-case");
        for (Element element : elements) {
            params = element.attr("data-case");
            if (params.startsWith("[")) {
                cases = (List)mapper.readValue(params, (TypeReference)new TypeReference<List<CaseBean>>(){});
            } else {
                cases = new ArrayList<CaseBean>();
                cases.add((CaseBean)mapper.readValue(params, CaseBean.class));
            }
            for (CaseBean caseInfo : cases) {
                if (sb.length() > 0) {
                    if ("or".equalsIgnoreCase(caseInfo.getOperator())) {
                        sb.append(' ');
                        sb.append("or");
                        sb.append(' ');
                    } else {
                        sb.append(' ');
                        sb.append("and");
                        sb.append(' ');
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)(expression = this.getCaseExpression(caseInfo)))) {
                    sb.append(expression);
                    continue;
                }
                return;
            }
            sb.insert(0, "<s:if test=\"");
            sb.append("\">");
            sb.append("</s:if>");
            element.wrap(sb.toString());
            element.removeAttr("data-case");
            sb.setLength(0);
        }
    }

    private void parseDataUrl(Document document, String actionName, String fileName) throws JsonParseException, JsonMappingException, IOException {
        Element element;
        ObjectMapper mapper = new ObjectMapper();
        List patterns = null;
        String params = null;
        String defaultUrlPattern = null;
        UrlPatternBean urlPatternBean = null;
        String resultName = FileUtils.removeFileExtension(fileName);
        boolean isAuthRequire = false;
        defaultUrlPattern = this.getDefaultUrlPattern(actionName, resultName);
        Element authElement = document.select(JspGenerator.getQueryForAuth()).first();
        if (authElement != null) {
            isAuthRequire = true;
        }
        if ((element = document.select(JspGenerator.getQueryForUrl()).first()) != null) {
            params = element.attr("data-url");
            if (params.startsWith("[")) {
                patterns = (List)mapper.readValue(params, (TypeReference)new TypeReference<List<String>>(){});
            } else {
                patterns = new ArrayList<String>();
                patterns.add((String)mapper.readValue(params, String.class));
            }
            StringBuilder sb = new StringBuilder();
            String pattern = null;
            for (String attr : patterns) {
                if (attr.contains("{_ORIGINAL}")) {
                    pattern = attr.replace("{_ORIGINAL}", defaultUrlPattern);
                } else {
                    sb.setLength(0);
                    if (GeneratorUtils.getContextMode()) {
                        sb.append("/");
                        sb.append(GeneratorUtils.getContextName());
                    }
                    sb.append(attr);
                    pattern = sb.toString();
                }
                pattern = pattern.replace("{0}", "([^/]+)");
                urlPatternBean = new UrlPatternBean(RegexUtils.getUrlPatternRegex(pattern), actionName, resultName);
                urlPatternBean.setAuthRequire(isAuthRequire);
                if (this._webAppOSCache.getUrlPatternMap().containsKey(pattern)) {
                    if (!this._isFullBuild) continue;
                    _logger.warn((Object)MessageUtils.getString("err.403", pattern));
                    continue;
                }
                this._webAppOSCache.getUrlPatternMap().put(pattern, urlPatternBean);
            }
            element.removeAttr("data-url");
        } else {
            urlPatternBean = new UrlPatternBean(RegexUtils.getUrlPatternRegex(defaultUrlPattern), actionName, resultName);
            urlPatternBean.setAuthRequire(isAuthRequire);
            if (this._webAppOSCache.getUrlPatternMap().containsKey(defaultUrlPattern)) {
                if (this._isFullBuild) {
                    _logger.warn((Object)MessageUtils.getString("err.403", defaultUrlPattern));
                }
            } else {
                this._webAppOSCache.getUrlPatternMap().put(defaultUrlPattern, urlPatternBean);
            }
        }
    }

    private String getDefaultUrlPattern(String actionName, String resultName) {
        StringBuilder sb = new StringBuilder();
        if (GeneratorUtils.getContextMode()) {
            sb.append("/");
            sb.append(GeneratorUtils.getContextName());
        }
        sb.append("/");
        if (!StringUtils.isEmpty((CharSequence)actionName)) {
            sb.append(actionName);
            sb.append("/");
        }
        if (!"index".equalsIgnoreCase(resultName)) {
            sb.append(resultName);
            sb.append("/");
        }
        return sb.toString();
    }

    private void checkUnParsedAttribute(Document document, String inputFilePath, List<String> warnings) {
        Elements elements = document.select(JspGenerator.getQueryForUnParsedAttribute());
        String key = null;
        for (Element element : elements) {
            Attributes attributes = element.attributes();
            for (Attribute attribute : attributes) {
                key = attribute.getKey();
                Pattern pattern = Pattern.compile("data-(load|func|cond|bind-in|bind-out|iterator|case|erasure|url)$");
                Matcher matcher = pattern.matcher(key);
                if (!matcher.find()) continue;
                warnings.add(MessageUtils.getString("err.401", inputFilePath, key, attribute.getValue()));
            }
        }
    }

    private static String getQueryForLoad() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("data-load");
        sb.append("]");
        return sb.toString();
    }

    private static String getQueryForFunc() {
        StringBuilder sb = new StringBuilder();
        sb.append("form[");
        sb.append("data-func");
        sb.append("]");
        return sb.toString();
    }

    private static String getQueryForCond() {
        StringBuilder sb = new StringBuilder();
        sb.append("input[");
        sb.append("data-cond");
        sb.append("]");
        return sb.toString();
    }

    private static String getQueryForIterator(String resultName) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("data-iterator");
        sb.append("^=");
        sb.append(resultName);
        sb.append("]");
        return sb.toString();
    }

    private static String getQueryForUnParsedAttribute() {
        StringBuilder sb = new StringBuilder();
        sb.append("[^");
        sb.append("data-");
        sb.append("]");
        return sb.toString();
    }

    private static String getQueryForUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("data-url");
        sb.append("]");
        return sb.toString();
    }

    private static String getQueryForAuth() {
        StringBuilder sb = new StringBuilder();
        sb.append("head[");
        sb.append("data-auth");
        sb.append("]");
        return sb.toString();
    }

    private static ResultBean createResultForLoad(String outputPath) {
        StringBuilder sb = new StringBuilder();
        sb.append(ControllerUtils.getFileSparator());
        sb.append("jsp");
        sb.append(ControllerUtils.getFileSparator());
        sb.append(outputPath);
        ResultBean result = new ResultBean();
        String fileName = outputPath.substring(outputPath.indexOf(ControllerUtils.getFileSparator()) + 1);
        result.setName(fileName.replace(".jsp", ""));
        result.setValue(sb.toString());
        return result;
    }

    private static ResultBean createResultForSubmit(ActionBean actionBean, Element formElement) {
        ResultBean result = new ResultBean();
        StringBuilder sb = new StringBuilder();
        String value = formElement.attr("action");
        int beginIndex = value.indexOf(_htmlRootPath) + _htmlRootPath.length();
        value = value.substring(beginIndex);
        value = FileUtils.convertExtensionHtmlToJsp(value);
        value = value.replace("/", ControllerUtils.getFileSparator());
        sb.append(ControllerUtils.getFileSparator());
        sb.append("jsp");
        sb.append(ControllerUtils.getFileSparator());
        sb.append(value);
        result.setValue(sb.toString());
        sb.setLength(0);
        sb.append("result");
        sb.append(actionBean.getSubmitExecuteMap().size());
        result.setName(sb.toString());
        return result;
    }

    private static String addFormIdElement(String outputPath, Element formElement) {
        StringBuilder sb = new StringBuilder();
        sb.append(outputPath);
        sb.append(formElement.attr("id"));
        String formId = String.valueOf(sb.toString().hashCode());
        Element element = formElement.appendElement("input");
        element.attr("type", "hidden");
        element.attr("name", "_SYS_FORM_ID_");
        element.attr("value", formId);
        return formId;
    }

    private static void addTokenElement(Element formElement) {
        formElement.appendText("<s:token />");
    }

    private void updateAttributeForCondition(ConditionBean condition, Element element) {
        String[] column = condition.getColumnName().split("\\.");
        StringBuilder sb = new StringBuilder();
        sb.append(condition.getResult());
        sb.append("__");
        sb.append("COND");
        sb.append("__");
        sb.append(column[0]);
        sb.append("__");
        sb.append(column[1]);
        element.attr("name", sb.toString());
        sb.setLength(0);
        sb.append("<s:property value=\"");
        sb.append(this.getBindValue(null, element.attr("name"), condition.getValue(), null, false));
        sb.append("\"/>");
        element.attr("value", sb.toString());
    }

    private static Map<String, String> createOperatorMap(ConditionBean condition) {
        HashMap<String, String> operatorMap = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        sb.append(condition.getResult());
        sb.append('.');
        sb.append(condition.getColumnName());
        operatorMap.put(sb.toString(), condition.getOperator());
        return operatorMap;
    }

    private boolean updateAttributeForImage(ActionBean actionBean, String outputPath, ImageBean imageBean, Element element) throws JsonParseException, JsonMappingException, IOException {
        String target = imageBean.getTarget();
        if (imageBean.getArg() == null) {
            return false;
        }
        if (target == null) {
            target = "src";
        }
        StringBuilder key = new StringBuilder();
        String[] args = imageBean.getArg().split("\\.");
        if (args.length == 2) {
            key.append(args[0]);
            key.append("_");
            key.append(args[1]);
        } else {
            key.append(imageBean.getArg());
        }
        StringBuilder sb = new StringBuilder();
        if (GeneratorUtils.getContextMode()) {
            sb.append("/");
            sb.append(GeneratorUtils.getContextName());
        }
        sb.append("/sysapi/image/");
        sb.append("?");
        sb.append("path=");
        sb.append("<s:property value=\"");
        sb.append(this.getEncodeBindValue(imageBean.getResult(), key.toString()));
        sb.append("\"");
        sb.append("/>");
        if (imageBean.getWidth() != null) {
            sb.append("&dw=");
            sb.append(imageBean.getWidth());
        }
        if (imageBean.getHeight() != null) {
            sb.append("&dh=");
            sb.append(imageBean.getHeight());
        }
        if (imageBean.getStretchType() != null) {
            sb.append("&type=");
            StretchTypeEnum type = StretchTypeEnum.getStretchType(imageBean.getStretchType());
            sb.append(type.getKey());
        }
        List childs = null;
        if ("text".equalsIgnoreCase(target)) {
            childs = element.childNodes();
            if (childs != null) {
                int i = childs.size() - 1;
                while (i >= 0) {
                    Node child = (Node)childs.get(i);
                    if (child instanceof TextNode && !((TextNode)child).text().contains("s:property")) {
                        child.remove();
                    }
                    --i;
                }
            }
            element.appendChild((Node)new TextNode(sb.toString(), null));
        } else {
            element.attr(target, sb.toString());
        }
        return true;
    }

    private boolean updateAttributeForBindOutput(ActionBean actionBean, String outputPath, BindOutputBean bindBean, Element element) throws JsonParseException, JsonMappingException, IOException {
        int i;
        StringBuilder sb = new StringBuilder();
        String format = null;
        format = bindBean.getFormat();
        if (element.hasText() && element.text().contains("{0}")) {
            format = element.text();
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = "{0}";
        }
        if (!"text".equalsIgnoreCase(bindBean.getTarget())) {
            format = format.replace("\"", "''");
        }
        if (format.contains("{_ORIGINAL}")) {
            format = "text".equalsIgnoreCase(bindBean.getTarget()) ? format.replace("{_ORIGINAL}", element.text()) : format.replace("{_ORIGINAL}", element.attr(bindBean.getTarget()));
        } else if (("src".equalsIgnoreCase(bindBean.getTarget()) || "href".equalsIgnoreCase(bindBean.getTarget())) && !"{0}".equals(format)) {
            if (GeneratorUtils.getContextMode()) {
                sb.append("/");
                sb.append(GeneratorUtils.getContextName());
            }
            sb.append(format);
            format = sb.toString();
        }
        String value = null;
        if (bindBean.getArgs() != null && bindBean.getArgs().size() > 0) {
            Object[] args = new String[bindBean.getArgs().size()];
            i = 0;
            while (i < bindBean.getArgs().size()) {
                args[i] = StringUtils.isEmpty((CharSequence)bindBean.getArgs().get(i)) ? "<s:property />" : this.getBindPropertyForOutput(bindBean, bindBean.getArgs().get(i), null);
                ++i;
            }
            value = MessageFormat.format(format, args);
        } else if (bindBean.getArg() == null) {
            value = MessageFormat.format(format, "<s:property />");
        } else {
            if (StringUtils.isEmpty((CharSequence)bindBean.getArg())) {
                element.removeAttr(bindBean.getTarget());
                return true;
            }
            if (this.istPatternFormat(bindBean.getFormat())) {
                format = "{0}";
                if (element.hasText() && element.text().contains("{0}")) {
                    format = element.text();
                }
                value = MessageFormat.format(format, this.getBindPropertyForOutput(bindBean, bindBean.getArg(), bindBean.getFormat()));
            } else {
                value = MessageFormat.format(format, this.getBindPropertyForOutput(bindBean, bindBean.getArg(), null));
            }
        }
        List childs = null;
        if ("text".equalsIgnoreCase(bindBean.getTarget())) {
            childs = element.childNodes();
            if (childs != null) {
                i = childs.size() - 1;
                while (i >= 0) {
                    Node child = (Node)childs.get(i);
                    if (child instanceof TextNode && !((TextNode)child).text().contains("s:property")) {
                        child.remove();
                    }
                    --i;
                }
            }
            element.prependChild((Node)new TextNode(value, null));
        } else if ("inner".equalsIgnoreCase(bindBean.getTarget())) {
            element.html(value);
        } else if (bindBean.getTarget() != null) {
            if (!element.attr(bindBean.getTarget()).contains("s:property")) {
                element.removeAttr(bindBean.getTarget());
            }
            sb.setLength(0);
            sb.append(element.attr(bindBean.getTarget()));
            sb.append(value);
            element.attr(bindBean.getTarget(), sb.toString());
        }
        return true;
    }

    private boolean updateAttributeForBindInput(BindInputBean bind, Element element) throws JsonParseException, JsonMappingException, IOException {
        if (!element.tagName().equalsIgnoreCase("input") && !element.tagName().equalsIgnoreCase("textarea")) {
            return false;
        }
        String tagName = JspGenerator.getBindInputTagName(bind);
        if (tagName == null) {
            return false;
        }
        element.attr("name", tagName);
        String value = null;
        if (bind.getArg() != null) {
            value = this.getBindPropertyForInput(bind, tagName);
        }
        element.attr("value", String.valueOf(element.attr("value")) + value);
        return true;
    }

    private static String getBindInputTagName(BindInputBean bind) {
        StringBuilder sb = new StringBuilder();
        String[] args = bind.getArg().split("\\.");
        sb.append(bind.getResult());
        sb.append("__");
        sb.append("COL");
        sb.append("__");
        if (args.length >= 2) {
            sb.append(args[1]);
        } else {
            sb.append(bind.getArg());
        }
        return sb.toString();
    }

    private String getBindPropertyForOutput(BindOutputBean bind, String arg, String pattern) {
        StringBuilder sb = new StringBuilder();
        StringBuilder key = new StringBuilder();
        boolean isEscape = Boolean.valueOf(bind.getEscape());
        boolean isEraseTag = Boolean.valueOf(bind.getEraseTag());
        String[] args = arg.split("\\.");
        String type = args[0];
        if ("_PAGER".equalsIgnoreCase(type)) {
            key.append("_PAGER");
            key.append("__");
            key.append(bind.getResult());
            key.append('.');
            key.append(args[1]);
            sb.append("<s:property value=\"");
            sb.append(this.getBindValue(null, key.toString(), null, null, isEraseTag));
            sb.append("\"");
            sb.append("/>");
        } else if ("_status".equalsIgnoreCase(type)) {
            sb.append("<s:property value=\"");
            sb.append("#");
            sb.append("_status");
            sb.append('.');
            sb.append(args[1].toLowerCase());
            sb.append("\"");
            sb.append("/>");
        } else {
            if (bind.getMapKeyName() == null && ("_REQ".equalsIgnoreCase(type) || "_CONST".equalsIgnoreCase(type))) {
                key.append(type);
                key.append('.');
                key.append(args[1]);
                sb.append("<s:property value=\"");
                if (pattern != null) {
                    sb.append(this.getBindValueWithFomat(null, key.toString(), bind.getValue(), pattern, isEraseTag));
                } else {
                    sb.append(this.getBindValue(null, key.toString(), bind.getValue(), null, isEraseTag));
                }
                sb.append("\"");
                sb.append("/>");
                return sb.toString();
            }
            if (args.length == 2 && !"_SES".equalsIgnoreCase(type) && !"_REQ".equalsIgnoreCase(type)) {
                key.append(args[0]);
                key.append("_");
                key.append(args[1]);
            } else {
                key.append(arg);
            }
            sb.append("<s:property value=\"");
            if (pattern != null) {
                sb.append(this.getBindValueWithFomat(bind.getResult(), key.toString(), bind.getValue(), pattern, isEraseTag));
            } else {
                sb.append(this.getBindValue(bind.getResult(), key.toString(), bind.getValue(), bind.getMapKeyName(), isEraseTag));
            }
            sb.append("\"");
            if (!isEscape) {
                sb.append(" escape=\"false\" ");
            }
            sb.append("/>");
        }
        return sb.toString();
    }

    private String getBindPropertyForInput(BindInputBean bind, String tagName) {
        StringBuilder sb = new StringBuilder();
        StringBuilder key = new StringBuilder();
        String[] args = bind.getArg().split("\\.");
        String type = args[0];
        if ("_PAGER".equalsIgnoreCase(type)) {
            key.append("_PAGER");
            key.append("__");
            key.append(bind.getResult());
            key.append('.');
            key.append(args[1]);
            sb.append("<s:property value=\"");
            sb.append(this.getBindValue(null, key.toString(), null, null, false));
            sb.append("\"");
            sb.append("/>");
        } else {
            if ("_REQ".equalsIgnoreCase(type) || "_CONST".equalsIgnoreCase(type)) {
                key.append(type);
                key.append('.');
                key.append(args[1]);
            } else {
                key.append(tagName);
            }
            sb.append("<s:property value=\"");
            sb.append(this.getBindValue("COL", key.toString(), bind.getValue(), null, false));
            sb.append("\"");
            sb.append("/>");
        }
        return sb.toString();
    }

    private String getBindValue(String resultName, String key, String defaultKey, String mapKeyName, boolean isEraseTag) {
        String mapKey = "";
        if (!StringUtils.isEmpty((CharSequence)mapKeyName)) {
            mapKey = mapKeyName;
        }
        String getValueString = null;
        if (resultName != null && this._iteratorInfo.containsKey(resultName)) {
            getValueString = defaultKey == null ? MessageFormat.format("getValue(#_value,{0},{1})", "'" + key.toUpperCase() + "'", "'" + mapKey + "'") : MessageFormat.format("getValue(#_value,{0},{1},{2})", "'" + key.toUpperCase() + "'", "'" + defaultKey.toUpperCase() + "'", "'" + mapKey + "'");
        } else {
            StringBuilder sb = new StringBuilder();
            if (resultName == null) {
                sb.append(key.toUpperCase());
            } else {
                sb.append(resultName);
                sb.append('.');
                sb.append(key.toUpperCase());
            }
            getValueString = defaultKey == null ? MessageFormat.format("getValue({0},{1})", "'" + sb.toString() + "'", "'" + mapKey + "'") : MessageFormat.format("getValue({0},{1},{2})", "'" + sb.toString() + "'", "'" + defaultKey.toUpperCase() + "'", "'" + mapKey + "'");
        }
        StringBuilder result = null;
        if (isEraseTag) {
            result = new StringBuilder();
            result.append("eraseTag(");
            result.append(getValueString);
            result.append(")");
        } else {
            result = new StringBuilder(getValueString);
        }
        return result.toString();
    }

    private String getEncodeBindValue(String resultName, String key) {
        if (resultName != null && this._iteratorInfo.containsKey(resultName)) {
            return MessageFormat.format("getEncodeValue(#_value,{0})", "'" + key.toUpperCase() + "'");
        }
        StringBuilder sb = new StringBuilder();
        if (resultName == null) {
            sb.append(key.toUpperCase());
        } else {
            sb.append(resultName);
            sb.append('.');
            sb.append(key.toUpperCase());
        }
        return MessageFormat.format("getEncodeValue({0})", "'" + sb.toString() + "'");
    }

    private String getBindValueWithFomat(String resultName, String key, String defaultKey, String pattern, boolean isEraseTag) {
        String datePattarn = this.getDateFormatPattern(pattern);
        if (resultName != null && this._iteratorInfo.containsKey(resultName)) {
            if (datePattarn != null) {
                if (defaultKey == null) {
                    return MessageFormat.format("getValueWithDateFormat(#_value,{0},{1})", "'" + key.toUpperCase() + "'", "'" + datePattarn + "'");
                }
                return MessageFormat.format("getValueWithDateFormat(#_value,{0},{1},{2})", "'" + key.toUpperCase() + "'", "'" + defaultKey.toUpperCase() + "'", "'" + datePattarn + "'");
            }
            String numberPattarn = this.getNumberFormatPattern(pattern);
            if (numberPattarn != null) {
                if (defaultKey == null) {
                    return MessageFormat.format("getValueWithNumberFormat(#_value,{0},{1})", "'" + key.toUpperCase() + "'", "'" + numberPattarn + "'");
                }
                return MessageFormat.format("getValueWithNumberFormat(#_value,{0},{1},{2})", "'" + key.toUpperCase() + "'", "'" + numberPattarn + "'");
            }
        } else {
            StringBuilder sb = new StringBuilder();
            if (resultName == null) {
                sb.append(key.toUpperCase());
            } else {
                sb.append(resultName);
                sb.append('.');
                sb.append(key.toUpperCase());
            }
            if (datePattarn != null) {
                if (defaultKey == null) {
                    return MessageFormat.format("getValueWithDateFormat({0}, {1})", "'" + sb.toString() + "'", "'" + datePattarn + "'");
                }
                return MessageFormat.format("getValueWithDateFormat({0}, {1}, {2})", "'" + sb.toString() + "'", "'" + defaultKey.toUpperCase() + "'", "'" + datePattarn + "'");
            }
            String numberPattarn = this.getNumberFormatPattern(pattern);
            if (numberPattarn != null) {
                if (defaultKey == null) {
                    return MessageFormat.format("getValueWithNumberFormat({0}, {1})", "'" + sb.toString() + "'", "'" + numberPattarn + "'");
                }
                return MessageFormat.format("getValueWithNumberFormat({0}, {1}, {2})", "'" + sb.toString() + "'", "'" + numberPattarn + "'");
            }
        }
        return this.getBindValue(resultName, key, defaultKey, null, isEraseTag);
    }

    private boolean istPatternFormat(String format) {
        if (format == null) {
            return false;
        }
        return this.getDateFormatPattern(format) != null || this.getNumberFormatPattern(format) != null;
    }

    private String getDateFormatPattern(String format) {
        Pattern pattern = Pattern.compile("^DATE\\[(.+)\\]$");
        Matcher matcher = pattern.matcher(format);
        if (matcher.find()) {
            String target = matcher.group();
            return format.substring(target.indexOf("[") + 1, target.indexOf("]"));
        }
        return null;
    }

    private String getNumberFormatPattern(String format) {
        Pattern pattern = Pattern.compile("^NUMBER\\[(.+)\\]$");
        Matcher matcher = pattern.matcher(format);
        if (matcher.find()) {
            String target = matcher.group();
            return format.substring(target.indexOf("[") + 1, target.indexOf("]"));
        }
        return null;
    }

    private void addIteratorResultNames(List<AbstractExecuteBean> executeInfoList) {
        for (AbstractExecuteBean executeInfo : executeInfoList) {
            String method = executeInfo.getMethod();
            if (CrudEnum.SELECT_ALL_BY_EXAMPLE.getMethod().equalsIgnoreCase(method) || CrudEnum.SELECT_BY_EXAMPLE.getMethod().equalsIgnoreCase(method)) {
                if (this._iteratorInfo.containsKey(executeInfo.getResult())) continue;
                IteratorInfo iteratorInfo = new IteratorInfo(executeInfo.getTarget().split(",")[0].trim(), executeInfo.getResult());
                this._iteratorInfo.put(executeInfo.getResult(), iteratorInfo);
                continue;
            }
            if (!FunctionEnum.FUNCTION_PROCEDURE.getFunctionName().equalsIgnoreCase(executeInfo.getType())) continue;
            ProcedureInfoBean procedureInfo = WebAppOSCache.getInstance().getProcedureMap().get(executeInfo.getTarget().toLowerCase());
            if (!DataTypeEnum.DATA_TYPE_RECORD.getDataType().equalsIgnoreCase(procedureInfo.getRetType().getDataType()) || this._iteratorInfo.containsKey(executeInfo.getResult())) continue;
            IteratorInfo iteratorInfo = new IteratorInfo(executeInfo.getTarget(), executeInfo.getResult());
            this._iteratorInfo.put(executeInfo.getResult(), iteratorInfo);
        }
    }

    private static void addIteratorElement(Element element, String params, IteratorInfo iteratorInfo) {
        params = params.toUpperCase();
        String[] args = params.split("\\.");
        StringBuilder sb = new StringBuilder();
        sb.append("<s:iterator value=\"%{");
        if (args.length > 1 && args[1].equalsIgnoreCase("PAGE_NO_LIST")) {
            sb.append("resultMap");
            sb.append('.');
            sb.append("_PAGER");
            sb.append("__");
            sb.append(args[0]);
            sb.append('.');
            sb.append("PAGE_NO_LIST");
        } else {
            String subMapName = null;
            if (args.length > 2) {
                subMapName = ControllerUtils.getResultMapKey(args[args.length - 2], args[args.length - 1]);
            }
            if (subMapName == null) {
                sb.append("resultMap");
                sb.append('.');
                sb.append(iteratorInfo.getIteratorName());
                sb.append('.');
                sb.append(iteratorInfo.getTargetName());
            } else {
                sb.append(subMapName);
            }
        }
        sb.append("}\" ");
        sb.append("status=\"");
        sb.append("_status");
        sb.append("\" ");
        sb.append("var=\"");
        sb.append("_value");
        sb.append("\">");
        sb.append("</s:iterator>");
        element.wrap(sb.toString());
    }

    private String getCaseExpression(CaseBean caseInfo) {
        StringBuilder sb = new StringBuilder();
        if ("size".equalsIgnoreCase(caseInfo.getType())) {
            String[] column = caseInfo.getArgs().get(0).split("\\.");
            IteratorInfo iteratorInfo = this._iteratorInfo.get(column[0]);
            if (iteratorInfo == null) {
                return null;
            }
            if (column.length == 1) {
                sb.append("resultMap");
                sb.append('.');
                sb.append(iteratorInfo.getIteratorName());
            } else if (column.length == 2) {
                sb.append("resultMap");
                sb.append('.');
                sb.append(caseInfo.getArgs().get(0));
            } else {
                sb.append(ControllerUtils.getResultMapKey(column[column.length - 2], column[column.length - 1]));
            }
            sb.append(".size");
            sb.append(JspGenerator.getOperatorString(caseInfo.getArgs().get(1)));
            sb.append(caseInfo.getArgs().get(2));
        } else {
            StringBuilder key = new StringBuilder();
            String[] column = caseInfo.getArgs().get(0).split("\\.");
            String type = column[0];
            if (!caseInfo.getArgs().get(2).equalsIgnoreCase("null") || "_SES".equalsIgnoreCase(type)) {
                if ("_REQ".equalsIgnoreCase(type) || "_CONST".equalsIgnoreCase(type)) {
                    String keys = String.valueOf(type) + "." + column[1];
                    key.append(MessageFormat.format("getValue({0},{1})", "'" + keys.toUpperCase() + "'", "''"));
                } else if ("_SES".equalsIgnoreCase(type)) {
                    key.append(MessageFormat.format("getValue({0},{1})", "'" + caseInfo.getArgs().get(0).toUpperCase() + "'", "''"));
                } else if (column.length == 1) {
                    key.append(column[0]);
                } else if ("_PAGER".equalsIgnoreCase(column[1])) {
                    key.append("resultMap");
                    key.append('.');
                    key.append("_PAGER");
                    key.append("__");
                    key.append(column[0]);
                    key.append('.');
                    key.append(column[2]);
                } else {
                    IteratorInfo iteratorInfo = this._iteratorInfo.get(column[0].toUpperCase());
                    if (iteratorInfo == null) {
                        key.append("resultMap");
                        key.append('.');
                        key.append(type);
                        key.append('.');
                        key.append(column[column.length - 2]);
                        key.append("_");
                        key.append(column[column.length - 1]);
                    } else if ("_status".equalsIgnoreCase(column[column.length - 2])) {
                        key.append("#");
                        key.append(column[column.length - 2].toLowerCase());
                        key.append('.');
                        key.append(column[column.length - 1].toLowerCase());
                    } else if ("_value".equalsIgnoreCase(column[1])) {
                        key.append("#");
                        key.append("_value".toLowerCase());
                    } else {
                        key.append(column[column.length - 2]);
                        key.append("_");
                        key.append(column[column.length - 1]);
                    }
                }
                sb.append(key.toString());
                sb.append(JspGenerator.getOperatorString(caseInfo.getArgs().get(1)));
                String[] values = caseInfo.getArgs().get(2).split("\\.");
                if (values[0].toUpperCase().startsWith("_CONST")) {
                    SystemConstantBean systemConstant = null;
                    systemConstant = values.length == 2 ? SystemConstantCache.getSystemConstant(values[1]) : SystemConstantCache.getSystemConstant(values[1], values[2]);
                    sb.append(systemConstant.getValue());
                } else if (values[0].toUpperCase().startsWith("_REQ")) {
                    sb.append(MessageFormat.format("getValue({0},{1})", "'" + caseInfo.getArgs().get(2).toUpperCase() + "'", "''"));
                } else {
                    sb.append(caseInfo.getArgs().get(2).replace("\"", "'"));
                }
            } else {
                if (caseInfo.getArgs().get(1).equalsIgnoreCase("eq")) {
                    key.append("!");
                }
                if ("_REQ".equalsIgnoreCase(type)) {
                    key.append("resultMap");
                    key.append('.');
                    key.append(type);
                    key.append(".containsKey('");
                    key.append(column[1]);
                    key.append("')");
                } else {
                    IteratorInfo iteratorInfo = this._iteratorInfo.get(column[0].toUpperCase());
                    if (iteratorInfo == null) {
                        if (column.length >= 2) {
                            key.append("resultMap");
                            key.append('.');
                            key.append(type);
                            key.append(".containsKey('");
                            key.append(column[column.length - 2]);
                            key.append("_");
                            key.append(column[column.length - 1]);
                            key.append("')");
                        } else {
                            key.append("containsKey('");
                            key.append(type);
                            key.append("')");
                        }
                    } else {
                        key.append("containsKey('");
                        key.append(column[column.length - 2]);
                        key.append("_");
                        key.append(column[column.length - 1]);
                        key.append("')");
                    }
                }
                sb.append(key.toString());
            }
        }
        return sb.toString();
    }

    private static void removeSiblingElement(Element element) {
        Elements siblings = element.siblingElements();
        for (Element e : siblings) {
            if (e.tagName().equalsIgnoreCase("s:iterator") || !StringUtils.isEmpty((CharSequence)e.attr("data-iterator"))) continue;
            if (!e.hasAttr("data-keep")) {
                e.remove();
                continue;
            }
            e.removeAttr("data-keep");
        }
    }

    private static String getOperatorString(String operator) {
        String result = "=";
        if ("eq".equalsIgnoreCase(operator)) {
            result = " == ";
        } else if ("ne".equalsIgnoreCase(operator)) {
            result = " != ";
        } else if ("gt".equalsIgnoreCase(operator)) {
            result = " > ";
        } else if ("ge".equalsIgnoreCase(operator)) {
            result = " >= ";
        } else if ("lt".equalsIgnoreCase(operator)) {
            result = " < ";
        } else if ("le".equalsIgnoreCase(operator)) {
            result = " <= ";
        }
        return result;
    }

    private void saveJspFile(Document document, String outputPath, ContentTypeEnum contentType) throws IOException {
        File outputFile = JspGenerator.getOutputFile(outputPath);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.indentAmount(2);
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        FileUtils.writeFile(outputFile, JspGenerator.getContent(document, contentType), "UTF-8");
    }

    private static File getOutputFile(String outputRelativePath) {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getOutputJspPath());
        sb.append(outputRelativePath);
        return new File(sb.toString());
    }

    private static String getContent(Document document, ContentTypeEnum contentType) {
        StringBuilder sb = new StringBuilder();
        if (contentType.equals((Object)ContentTypeEnum.XML)) {
            sb.append("<?xml version=\"1.0\" encoding=\"");
            sb.append("UTF-8");
            sb.append("\" ?>");
            OutputUtilities.newLine((StringBuilder)sb);
        }
        sb.append("<%@ page contentType=\"text/");
        sb.append(contentType.getContentType());
        sb.append("; charset=");
        sb.append("UTF-8");
        sb.append("\" ");
        sb.append("pageEncoding=\"");
        sb.append("UTF-8");
        sb.append("\"%>");
        OutputUtilities.newLine((StringBuilder)sb);
        sb.append("<%@ taglib prefix=\"s\" uri=\"/struts-tags\"%>");
        OutputUtilities.newLine((StringBuilder)sb);
        if (contentType.equals((Object)ContentTypeEnum.XML)) {
            Element root = document.getElementsByTag("Container").parents().first();
            sb.append(StringEscapeUtils.unescapeXml((String)root.html()));
        } else {
            sb.append(StringEscapeUtils.unescapeXml((String)document.outerHtml()));
        }
        return sb.toString();
    }

    public class IteratorInfo {
        private String targetName;
        private String iteratorName;

        IteratorInfo(String targetName, String iteratorName) {
            this.targetName = targetName;
            this.iteratorName = iteratorName;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        public String getIteratorName() {
            return this.iteratorName;
        }

        public void setIteratorName(String iteratorName) {
            this.iteratorName = iteratorName;
        }
    }
}

