/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import jp.co.headwaters.webappos.controller.utils.ControllerUtils;
import jp.co.headwaters.webappos.generator.utils.GeneratorUtils;
import jp.co.headwaters.webappos.generator.utils.MessageUtils;
import jp.co.headwaters.webappos.generator.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyGenerator {
    private static final Log _logger = LogFactory.getLog(PropertyGenerator.class);

    public boolean generate() {
        try {
            Properties conf = new Properties();
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream inputStream = new FileInputStream(PropertyGenerator.getInputFile());){
                conf.load(inputStream);
                if (!StringUtils.isEmpty((CharSequence)System.getenv("context_mode"))) {
                    conf.setProperty("context.mode", System.getenv("context_mode"));
                    conf.setProperty("root.package", System.getenv("root_package"));
                }
                String contextName = GeneratorUtils.getContextName();
                conf.setProperty("context.name", contextName);
                conf.setProperty("webapps.path", this.getWebAppsPath(contextName));
                conf.store(new FileOutputStream(PropertyGenerator.getOutputFile()), this.getComments(contextName));
                PropertyUtils.putProperty("root.package", conf.getProperty("root.package"));
                PropertyUtils.putProperty("context.mode", conf.getProperty("context.mode"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            _logger.error((Object)MessageUtils.getString("err.300"), (Throwable)e);
            return false;
        }
        return true;
    }

    private String getWebAppsPath(String contextName) {
        StringBuilder sb = new StringBuilder();
        sb.append(PropertyUtils.getProperty("webapps.path"));
        if (!sb.toString().endsWith(ControllerUtils.getFileSparator())) {
            sb.append(ControllerUtils.getFileSparator());
        }
        sb.append(contextName);
        sb.append(ControllerUtils.getFileSparator());
        sb.append("webapps");
        sb.append(ControllerUtils.getFileSparator());
        return sb.toString();
    }

    private String getComments(String contextName) {
        StringBuilder sb = new StringBuilder();
        sb.append(" for ");
        sb.append(contextName);
        sb.append(" properties");
        return sb.toString();
    }

    private static File getInputFile() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getIputPropertyPath());
        sb.append("application.properties");
        return new File(sb.toString());
    }

    private static File getOutputFile() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getOutputPropertyPath());
        sb.append("application.properties");
        return new File(sb.toString());
    }
}

