/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator.web;

import java.io.File;
import jp.co.headwaters.webappos.controller.cache.WebAppOSCache;
import jp.co.headwaters.webappos.controller.cache.bean.ActionBean;
import jp.co.headwaters.webappos.controller.cache.bean.ExecuteBean;
import jp.co.headwaters.webappos.controller.cache.bean.ResultBean;
import jp.co.headwaters.webappos.generator.GeneratorConstants;
import jp.co.headwaters.webappos.generator.utils.FileUtils;
import jp.co.headwaters.webappos.generator.utils.GeneratorUtils;
import jp.co.headwaters.webappos.generator.utils.MessageUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class StrutsXmlGenerator {
    private static final Log _logger = LogFactory.getLog(StrutsXmlGenerator.class);

    public static boolean generate() {
        try {
            File outputFile = StrutsXmlGenerator.getOutputFile();
            FileUtils.writeFile(outputFile, StrutsXmlGenerator.getContent(), "UTF-8");
        }
        catch (Exception e) {
            _logger.error((Object)MessageUtils.getString("err.200"), (Throwable)e);
            return false;
        }
        return true;
    }

    private static File getOutputFile() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getOutputPropertyPath());
        sb.append("struts-webappos.xml");
        return new File(sb.toString());
    }

    public static String getContent() {
        Document document = new Document("-//Apache Software Foundation//DTD Struts Configuration 2.0//EN", "http://struts.apache.org/dtds/struts-2.0.dtd");
        XmlElement root = new XmlElement("struts");
        document.setRootElement(root);
        XmlElement packageElement = new XmlElement("package");
        packageElement.addAttribute(new Attribute("name", "WebAppOS"));
        packageElement.addAttribute(new Attribute("extends", "struts-default"));
        packageElement.addAttribute(new Attribute("namespace", "/"));
        root.addElement((Element)packageElement);
        StrutsXmlGenerator.addExceitonElement(packageElement);
        for (ActionBean actionBean : WebAppOSCache.getInstance().getActionMap().values()) {
            XmlElement resultElement;
            ResultBean resultInfo;
            if ("error".equalsIgnoreCase(actionBean.getName())) continue;
            XmlElement actionElement = new XmlElement("action");
            actionElement.addAttribute(new Attribute("name", actionBean.getName()));
            actionElement.addAttribute(new Attribute("class", GeneratorConstants.SYSTEM_GENERIC_ACTION_NAME));
            packageElement.addElement((Element)actionElement);
            if (actionBean.getSubmitExecuteMap() != null) {
                for (ExecuteBean execInfo : actionBean.getSubmitExecuteMap().values()) {
                    resultInfo = execInfo.getResultInfo();
                    resultElement = new XmlElement("result");
                    resultElement.addAttribute(new Attribute("name", resultInfo.getName()));
                    resultElement.addElement((Element)new TextElement(resultInfo.getValue()));
                    actionElement.addElement((Element)resultElement);
                }
            }
            if (actionBean.getLoadExecuteMap() == null) continue;
            for (ExecuteBean execInfo : actionBean.getLoadExecuteMap().values()) {
                resultInfo = execInfo.getResultInfo();
                resultElement = new XmlElement("result");
                resultElement.addAttribute(new Attribute("name", resultInfo.getName()));
                resultElement.addElement((Element)new TextElement(resultInfo.getValue()));
                actionElement.addElement((Element)resultElement);
            }
        }
        return document.getFormattedContent();
    }

    private static void addExceitonElement(XmlElement parent) {
        XmlElement results = new XmlElement("global-results");
        XmlElement result = new XmlElement("result");
        result.addAttribute(new Attribute("name", "notfound"));
        result.addAttribute(new Attribute("type", "httpheader"));
        XmlElement error = new XmlElement("param");
        error.addAttribute(new Attribute("name", "error"));
        error.addElement((Element)new TextElement("404"));
        result.addElement((Element)error);
        results.addElement((Element)result);
        result = new XmlElement("result");
        result.addAttribute(new Attribute("name", "invalidtoken"));
        result.addAttribute(new Attribute("type", "httpheader"));
        error = new XmlElement("param");
        error.addAttribute(new Attribute("name", "error"));
        error.addElement((Element)new TextElement("403"));
        result.addElement((Element)error);
        results.addElement((Element)result);
        result = new XmlElement("result");
        result.addAttribute(new Attribute("name", "execdenied"));
        result.addAttribute(new Attribute("type", "httpheader"));
        error = new XmlElement("param");
        error.addAttribute(new Attribute("name", "error"));
        error.addElement((Element)new TextElement("403"));
        result.addElement((Element)error);
        results.addElement((Element)result);
        result = new XmlElement("result");
        result.addAttribute(new Attribute("name", "conflict"));
        result.addAttribute(new Attribute("type", "httpheader"));
        error = new XmlElement("param");
        error.addAttribute(new Attribute("name", "error"));
        error.addElement((Element)new TextElement("409"));
        result.addElement((Element)error);
        results.addElement((Element)result);
        result = new XmlElement("result");
        result.addAttribute(new Attribute("name", "error"));
        result.addAttribute(new Attribute("type", "httpheader"));
        error = new XmlElement("param");
        error.addAttribute(new Attribute("name", "error"));
        error.addElement((Element)new TextElement("500"));
        result.addElement((Element)error);
        results.addElement((Element)result);
        parent.addElement((Element)results);
        XmlElement exceptionMappings = new XmlElement("global-exception-mappings");
        XmlElement exceptionMapping = new XmlElement("exception-mapping");
        exceptionMapping.addAttribute(new Attribute("result", "notfound"));
        exceptionMapping.addAttribute(new Attribute("exception", GeneratorConstants.NOT_FOUND_EXCEPTION_CLASS));
        exceptionMappings.addElement((Element)exceptionMapping);
        exceptionMapping = new XmlElement("exception-mapping");
        exceptionMapping.addAttribute(new Attribute("result", "invalidtoken"));
        exceptionMapping.addAttribute(new Attribute("exception", GeneratorConstants.INVALID_TOKEN_EXCEPTION_CLASS));
        exceptionMappings.addElement((Element)exceptionMapping);
        exceptionMapping = new XmlElement("exception-mapping");
        exceptionMapping.addAttribute(new Attribute("result", "conflict"));
        exceptionMapping.addAttribute(new Attribute("exception", GeneratorConstants.CONFLICT_EXCEPTION_CLASS));
        exceptionMappings.addElement((Element)exceptionMapping);
        exceptionMapping = new XmlElement("exception-mapping");
        exceptionMapping.addAttribute(new Attribute("result", "execdenied"));
        exceptionMapping.addAttribute(new Attribute("exception", GeneratorConstants.EXEC_DENIED_EXCEPTION_CLASS));
        exceptionMappings.addElement((Element)exceptionMapping);
        exceptionMapping = new XmlElement("exception-mapping");
        exceptionMapping.addAttribute(new Attribute("result", "error"));
        exceptionMapping.addAttribute(new Attribute("exception", Exception.class.getName()));
        exceptionMappings.addElement((Element)exceptionMapping);
        parent.addElement((Element)exceptionMappings);
    }
}

