/*
 * Decompiled with CFR 0.152.
 */
package jp.co.headwaters.webappos.generator.web;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.headwaters.webappos.generator.GeneratorConstants;
import jp.co.headwaters.webappos.generator.utils.FileUtils;
import jp.co.headwaters.webappos.generator.utils.GeneratorUtils;
import jp.co.headwaters.webappos.generator.utils.MessageUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class WebXmlGenerator {
    private static final Log _logger = LogFactory.getLog(WebXmlGenerator.class);

    public static boolean generate() {
        ArrayList<String> warnings = new ArrayList<String>();
        try {
            File outputFile = WebXmlGenerator.getOutputFile();
            String content = WebXmlGenerator.getContent(warnings);
            FileUtils.writeFile(outputFile, content, "UTF-8");
        }
        catch (Exception e) {
            _logger.error((Object)MessageUtils.getString("err.200"), (Throwable)e);
            return false;
        }
        if (warnings.size() != 0) {
            for (String warning : warnings) {
                _logger.error((Object)warning);
            }
            return false;
        }
        return true;
    }

    private static File getOutputFile() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getOutputWebInfPath());
        sb.append("web-webappos.xml");
        return new File(sb.toString());
    }

    public static String getContent(List<String> warnings) {
        StringBuilder sb = new StringBuilder();
        File[] htmlFiles = new File(WebXmlGenerator.getErrorPageDir()).listFiles(FileUtils.getTargetFileFilter());
        String fileName = null;
        if (htmlFiles == null) {
            return "";
        }
        List<String> requiredPageList = Arrays.asList(GeneratorConstants.REQUIRED_ERROR_PAGE_NAME);
        int requiredPageCount = 0;
        List<String> optionPageList = Arrays.asList(GeneratorConstants.OPTION_ERROR_PAGE_NAME);
        int optionPageCount = 0;
        File[] fileArray = htmlFiles;
        int n = htmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            fileName = WebXmlGenerator.getFileName(file.getName());
            if (WebXmlGenerator.isHttpStatusCode(fileName)) {
                if (requiredPageList.contains(fileName)) {
                    ++requiredPageCount;
                }
                if (optionPageList.contains(fileName)) {
                    ++optionPageCount;
                }
                XmlElement root = new XmlElement("error-page");
                XmlElement errorCode = new XmlElement("error-code");
                errorCode.addElement((Element)new TextElement(fileName));
                root.addElement((Element)errorCode);
                XmlElement location = new XmlElement("location");
                location.addElement((Element)new TextElement(GeneratorUtils.getErrorPageLocation(fileName, "/")));
                root.addElement((Element)location);
                OutputUtilities.newLine((StringBuilder)sb);
                sb.append(root.getFormattedContent(0));
            } else {
                _logger.warn((Object)MessageUtils.getString("warn.200", file.getName()));
            }
            ++n2;
        }
        if (optionPageCount != optionPageList.size()) {
            _logger.warn((Object)MessageUtils.getString("warn.201", StringUtils.join(optionPageList, (String)",")));
        }
        if (requiredPageCount != requiredPageList.size()) {
            warnings.add(MessageUtils.getString("err.201", StringUtils.join(requiredPageList, (String)",")));
        }
        return sb.toString();
    }

    private static String getErrorPageDir() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeneratorUtils.getInputHtmlPath());
        sb.append("error");
        return sb.toString();
    }

    private static String getFileName(String target) {
        if (target == null) {
            return null;
        }
        int point = target.lastIndexOf(".");
        if (point != -1) {
            return target.substring(0, point);
        }
        return target;
    }

    private static boolean isHttpStatusCode(String target) {
        Pattern pattern = Pattern.compile("^[4-5][0-9][0-9]$");
        Matcher matcher = pattern.matcher(target);
        return matcher.find();
    }
}

