<?php
require_once("./common.php");// 設定・共通ファイル読み込み
require_once 'Lite.php';//これがサーバーに入っている前提で

// エラー表示止め
ini_set('error_reporting', E_ALL | E_STRICT);
ini_set('display_errors', 'off');

// 最低価格と最高価格の設定
$minprice = "100";
$maxprice = "1000000";

// フォームに入力されたキーワードを取り出してURLエンコードする
$query = $_GET['word'];
$query4url = urlencode($query); // URLエンコード

// キャッシュ設定
$cacheId = $query4url;
$cache_lite = new Cache_Lite($cacheOptions);

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/html; charset=utf-8" />
<meta name="Copyright" content="&copy; 2009 横断検索 All Rights Reserved." />
<meta name="Keywords" content="<?php echo rawurldecode($query4url); ?>" />
<meta name="description" content="<?php echo rawurldecode($query4url); ?>の検索結果" />
<title><?php echo rawurldecode($query4url); ?>の検索結果</title>
<link rel="stylesheet" href="css/version4.css" type="text/css" />
<link rel="stylesheet" href="css/import.css" type="text/css" media="screen,print" />

</head>
<body>

<h2><?php echo rawurldecode($query4url); ?>の検索結果</h2>
<p>&nbsp;</p>

<!-- 検索結果表示ここから -->

<?php
	if ($cache = $cache_lite->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $cache_data = $cache;
    echo $cache_data;
}
else{// cache が無い場合 start

// ■各社リクエストURL組立■

// YAHOO!ショッピングリクエストURL組み立て
$ywsurl = "http://shopping.yahooapis.jp/ShoppingWebService/V1/itemSearch?appid=$appid&query=$query4url&sort=%2Bprice&hits=5&availability=1&price_from=$minprice&price_to=$maxprice&affiliate_from=2.0";
//$ywsurl = $ywsurl . "&affiliate_type=yid&affiliate_id=$token";
$ywsurl = $ywsurl . "&affiliate_type=vc&affiliate_id=http%3A%2F%2Fck.jp.ap.valuecommerce.com%2Fservlet%2Freferral%3Fsid%3D" . $sid . "%26pid%3D" . $pid . "%26vc_url%3D";

// 楽天リクエストURL組み立て
$rwsurl = "http://api.rakuten.co.jp/rws/1.13/rest?developerId=$rwsdevid&affiliateId=$rwsaffid&operation=ItemSearch&version=2009-02-03&keyword=$query4url&sort=%2BitemPrice&hits=5&availability=1&minPrice=$minprice&maxPrice=$maxprice";

// linkshareリクエストURL組み立て
$lsurl = "http://feed.linksynergy.com/productsearch?token=$lstoken&keyword=$query4url&max=5&sort=retailprice&sorttype=asc";
// &mid=3472,25051

// バリューコマースリクエストURL組み立て
$vcurl = "http://webservice.valuecommerce.ne.jp/productdb/search?token=$vctoken&keyword=$query4url&sort_by=price&sort_order=asc&price_max=$maxprice&price_min=$minprice&result_per_page=5&ec_code=02t5n,0png4,0zttq,05f47,0j3hc,08x8b,07s9u,08fsg,bdrxs,0ha4k,0jcf6,03p68,03gpr,0wz95,09muc,bdufh,077ap,02spk,090a7,078nc";

// アクセストレードリクエストURL組み立て
// http://interspace.typepad.jp/webservice/atws/index.html
$aturl = "http://xml.accesstrade.net/at/ws.html?ws_type=searchgoods&ws_ver=1&ws_id=$attoken&search=$query4url&price_max=$maxprice&price_min=$minprice&row=5&sort1=3";

// AmazonリクエストURL組み立て
$baseurl = 'http://ecs.amazonaws.jp/onca/xml';
$params = array();
$params['Service']        = 'AWSECommerceService';
$params['AWSAccessKeyId'] = $awssubid;
$params['Version']        = '2009-03-31';
$params['Operation']      = 'ItemSearch';
$params['SearchIndex']    = 'Blended';
$params['Keywords']       = $query4url;
$params['AssociateTag']   = $awsassid;
$params['Condition']   = 'New';
$params['ContentType']   = 'text/xml';
$params['ResponseGroup']   = 'Medium,Reviews,OfferSummary';
$params['Timestamp'] = gmdate('Y-m-d\TH:i:s\Z');

// パラメータの順序を昇順に並び替えます
ksort($params);
$canonical_string = '';
foreach ($params as $k => $v) {
    $canonical_string .= '&'.urlencode_rfc3986($k).'='.urlencode_rfc3986($v);
}
$canonical_string = substr($canonical_string, 1);

$parsed_url = parse_url($baseurl);
$string_to_sign = "GET\n{$parsed_url['host']}\n{$parsed_url['path']}\n{$canonical_string}";
$signature = base64_encode(hash_hmac('sha256', $string_to_sign, $awsseckey, true));
$awsurl = $baseurl.'?'.$canonical_string.'&Signature='.urlencode_rfc3986($signature);

// ヤフオクリクエストURL組み立て
$yacurl = "http://auctions.yahooapis.jp/AuctionWebService/V1/Search?appid=$appid&query=$query4url&aucminprice=$minprice&aucmaxprice=$maxprice&sort=cbids&order=a";


// ■並列通信用マルチハンドルを用意■
$mh = curl_multi_init();

//通信先ごとにCurl Handleを作り、それを $mh にaddしていく（Y!ショッピング）
$ch_ywsurl = curl_init($ywsurl);
curl_setopt($ch_ywsurl, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch_ywsurl, CURLOPT_TIMEOUT, 5);
curl_multi_add_handle($mh, $ch_ywsurl);

// 同様に（楽天市場）
$ch_rwsurl = curl_init($rwsurl);
curl_setopt($ch_rwsurl, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch_rwsurl, CURLOPT_TIMEOUT, 5);
curl_multi_add_handle($mh, $ch_rwsurl);

// 同様に （リンクシェア）
$ch_lsurl = curl_init($lsurl);
curl_setopt($ch_lsurl, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch_lsurl, CURLOPT_TIMEOUT, 5);
curl_multi_add_handle($mh, $ch_lsurl);

// 同様に （バリューコマース）
$ch_vcurl = curl_init($vcurl);
curl_setopt($ch_vcurl, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch_vcurl, CURLOPT_TIMEOUT, 5);
curl_multi_add_handle($mh, $ch_vcurl);

// 同様に （アクセストレード）
$ch_aturl = curl_init($aturl);
curl_setopt($ch_aturl, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch_aturl, CURLOPT_TIMEOUT, 5);
curl_multi_add_handle($mh, $ch_aturl);

// 同様に （Amazon.co.jp）
$ch_awsurl = curl_init($awsurl);
curl_setopt($ch_awsurl, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch_awsurl, CURLOPT_TIMEOUT, 5);
curl_multi_add_handle($mh, $ch_awsurl);

// 同様に （ヤフオク）
$ch_yacurl = curl_init($yacurl);
curl_setopt($ch_yacurl, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch_yacurl, CURLOPT_TIMEOUT, 5);
curl_multi_add_handle($mh, $ch_yacurl);

// せーので複数の通信を同時実行。whileで全て返ってくるのを待ちます  
do { curl_multi_exec($mh, $running); } while ( $running );

// 個々のXMLは、それぞれのCurl Handleを指定することで取得できる  
$xml_ywsurl  = curl_multi_getcontent($ch_ywsurl);
$xml_rwsurl = curl_multi_getcontent($ch_rwsurl);
$xml_lsurl = curl_multi_getcontent($ch_lsurl);
$xml_vcurl = curl_multi_getcontent($ch_vcurl);
$xml_aturl = curl_multi_getcontent($ch_aturl);
$xml_awsurl = curl_multi_getcontent($ch_awsurl);
$xml_yacurl = curl_multi_getcontent($ch_yacurl);


// 後始末  
curl_multi_remove_handle($mh, $ch_ywsurl);
curl_close($ch_ywsurl);

curl_multi_remove_handle($mh, $ch_rwsurl);
curl_close($ch_rwsurl);

curl_multi_remove_handle($mh, $ch_lsurl);
curl_close($ch_lsurl);

curl_multi_remove_handle($mh, $ch_vcurl);
curl_close($ch_vcurl);

curl_multi_remove_handle($mh, $ch_aturl);
curl_close($ch_aturl);

curl_multi_remove_handle($mh, $ch_awsurl);
curl_close($ch_awsurl);

curl_multi_remove_handle($mh, $ch_yacurl);
curl_close($ch_yacurl);

curl_multi_close($mh);
// ■並列通信ここまで■


// ■各社データを配列変数へ格納■
// ■YAHOO!ショッピングの処理■
$xml = simplexml_load_string ($xml_ywsurl);
if ($xml["totalResultsReturned"] != 0) {
	$hits = $xml->Result->Hit;
}
foreach ($hits as $hit) {
$itemname[] = h($hit->Name);
$linkurl[] = h($hit->Url);
if ($hit->Store->Id == "engei" or $hit->Store->Id == "dinos" or $hit->Store->Id == "fobcoop" or $hit->Store->Id == "ottojapan") {
	$imgurl[] = "c_img/linksakidegazo.gif";
} else {
	$imgurl[] = h($hit->Image->Medium);
}
$price[] = h($hit->Price);
$description[] = h($hit->Description);
$shopname[] = h($hit->Store->Name);
$souryou[] = h($hit->Shipping->Name);
$reviewnum[] = h($hit->Review->Count);
$reviewavr[] = h($hit->Review->Rate);
$reviewurl[] = h($hit->Review->Url);
$faviconurl[] = "http://shopping.yahoo.co.jp/";
}

// ■楽天市場の処理■
$rwsBuff = str_replace('header:Header', 'headerHeader', $xml_rwsurl);//置換
$rwsBuff = str_replace('itemSearch:ItemSearch', 'itemSearchItemSearch', $rwsBuff);//置換
$xml = simplexml_load_string ($rwsBuff);//置換されたXMLデータを処理
$hits = $xml->Body->itemSearchItemSearch->Items->Item;

foreach ($hits as $hit) {
$itemname[] = h($hit->itemName);
$linkurl[] = h($hit->affiliateUrl);
if (strlen($hit->mediumImageUrl)) {
	$imgurl[] = h($hit->mediumImageUrl);
} else {
	$imgurl[] = "c_img/noimage.gif";
}
$price[] = h($hit->itemPrice);
$description[] = h($hit->itemCaption);
$shopname[] = h($hit->shopName);
//送料フラグ 	postageFlag 	0：送料込
//1：送料別
if ($hit->postageFlag == 0) {
	$souryou[] = "送料無料";
} else {
	$souryou[] = "送料別";
}
$reviewnum[] = h($hit->reviewCount);
$reviewavr[] = h($hit->reviewAverage);
$reviewurl[] = "";
$faviconurl[] = "http://www.rakuten.co.jp/";
}

// ■リンクシェアの処理■
$xml = simplexml_load_string ($xml_lsurl);
$hits = $xml->item;

foreach ($hits as $hit) {
if (!is_numeric(mb_strpos($hit->merchantname,"携帯"))) {
$itemname[] = h($hit->productname);
$linkurl[] = h($hit->linkurl);
if (strlen($hit->imageurl)) {
	$imgurl[] = h($hit->imageurl);
} else {
	$imgurl[] = "c_img/noimage.gif";
}

$price[] = h($hit->price);
$description[] = h($hit->description->short);
$shopname[] = h($hit->merchantname);
$souryou[] = "";
$reviewnum[] = "";
$reviewavr[] = "";
$reviewurl[] = "";
if ($hit->merchantname == "イトーヨーカドー　ネット通販") {
	$faviconurl[] = "http://www.itoyokado.jp/";
} else {
	$faviconurl[] = h($hit->imageurl);
}

}
}

// ■バリューコマースの処理■
$vcBuff = str_replace('vc:', 'vc', $xml_vcurl);
$xml = simplexml_load_string ($vcBuff);
$hits = $xml->channel->item;

foreach ($hits as $hit) {
$itemname[] = h($hit->title);

$linkurl[] = h($hit->link);

// 画像URL取り出し
$img = array();
foreach($hit->vcimage as $vcimg) {
    $img[]=$vcimg["url"];
}

if (strlen($img[1])) {
	$imgurl[] = h($img[1]);
} else {
	if (strlen($img[2])) {
		$imgurl[] = h($img[2]);
	} else {
	$imgurl[] = "c_img/noimage.gif";
	}
}

$price[] = h($hit->vcprice);
$description[] = h($hit->description);

// ストア名とサブストア名が一緒ならサブストア名は使わない（ビッダーズとか）
if (h($hit->vcmerchantName) == h($hit->vcsubStoreName)) {
$shopname[] = h($hit->vcmerchantName);
} else {
$shopname[] = h($hit->vcmerchantName) . h($hit->vcsubStoreName);
}
$souryou[] = "";
$reviewnum[] = "";
$reviewavr[] = "";
$reviewurl[] = "";
$faviconurl[] = h($hit->guid);
}


// ■アクセストレードの処理■
$xml = simplexml_load_string ($xml_aturl);
$hits = $xml->Goods;

foreach ($hits as $hit) {
$itemname[] = h($hit->GoodsName);

$linkurl[] = h($hit->LinkCode);
$img = array();
// 画像情報取り出し


if (strlen($hit->ImageUrl)) {
	$imgurl[] = h($hit->ImageUrl);
} else {
	$imgurl[] = "c_img/noimage.gif";
}

$price[] = h($hit->Price);
$description[] = h($hit->Explanation);
$shopname[] = h($hit->ShopName);
$souryou[] = "";
$reviewnum[] = "";
$reviewavr[] = "";
$reviewurl[] = "";
$faviconurl[] = h($hit->ImageUrl);
}

// ■Amazon.co.jpの処理■
$xml = simplexml_load_string ($xml_awsurl);

$hits = $xml->Items->Item;

foreach ($hits as $hit) {
// amazonのみ値段の処理をここで追加
if ($hit->OfferSummary->LowestNewPrice->Amount > $minprice) {
$itemname[] = h($hit->ItemAttributes->Title);
$linkurl[] = h($hit->DetailPageURL);
$imgurl[] = h($hit->MediumImage->URL);
$price[] = h($hit->OfferSummary->LowestNewPrice->Amount);
$description[] = h($hit->EditorialReviews->EditorialReview->Content);
$shopname[] = "Amazon.co.jp";
$souryou[] = "";
$reviewnum[] = h($hit->CustomerReviews->TotalReviews);
$reviewavr[] = h($hit->CustomerReviews->AverageRating);
$reviewurl[] = "";
$faviconurl[] = "http://www.amazon.co.jp/";
}
}


// ■ヤフオクの処理■
$xml = simplexml_load_string ($xml_yacurl);
$hits = $xml->item;

$i=0;
foreach ($hits as $hit) {
$itemname[] = h($hit->title);

$linkurl[] = "http://ck.jp.ap.valuecommerce.com/servlet/referral?sid=$yaucsid&pid=$yaucpid&vc_url=" . urlencode(h($hit->url));
$img = array();
// 画像情報取り出し
if (strlen($hit->img)) {
	$imgurl[] = h($hit->img);
} else {
	$imgurl[] = "c_img/noimage.gif";
}
$pricebuff = h($hit->price);
$pricebuff = str_replace(' 円', '', $pricebuff);
$pricebuff = str_replace(',', '', $pricebuff);
$price[] = intval($pricebuff);
$description[] = "落札終了予定時間" . h($hit->endtime);
$shopname[] = "Yahoo!オークション　出品者（ストア）：" . h($hit->seller->id);
$souryou[] = "";
$reviewnum[] = "";
$reviewavr[] = "";
$reviewurl[] = "";
$faviconurl[] = "http://auctions.yahoo.co.jp/jp/";
$i=$i+1;
if ($i==5) {break;}
}

// 値段安い順番に並び替える（全部）
asort($price);

	ob_start(); // これ以降に出力する内容はバッファに書き出す
	$i=0;// カウンタとして$iを使用。$iを0にセット
	echo "<p>";
	foreach ($price as $key => $value) {
		echo "<h3>" . $itemname[$key] . "</h3>"."\n";
		echo '<div class="itempic" style="background: transparent url(' . $imgurl[$key] . ') no-repeat scroll center center; -moz-background-clip: -moz-initial; -moz-background-origin: -moz-initial; -moz-background-inline-policy: -moz-initial;"><a href="'.$linkurl[$key] . '" target="_blank"><img src="c_img/spacer.gif" class="line-height"/></a></div>'."\n";
		echo '税込価格：<span class="price">' . number_format($price[$key]) . '円</span>'."\n";
		if (strlen($souryou[$key])) {
			echo "（".$souryou[$key]."）"."\n";
			}
		echo '<br />'."\n";
		echo '<img src="http://favicon.hatena.ne.jp/?url=' . urlencode($faviconurl[$key]) . '" />';
		echo $shopname[$key] . '<br />'."\n";
		echo mb_substr ($description[$key],0,200,"utf-8") . '...<br />'."\n";
		if (strlen($reviewnum[$key])) {
			echo 'レビュー件数：' . $reviewnum[$key] . '件　レビュー平均点：' . $reviewavr[$key] . '点<br />'."\n";
		}
		echo '<a href="' . $linkurl[$key] . '" target="_blank">この商品の詳細をECサイトで確認する</a>'."\n";
		echo '<div class="pic">&nbsp;</div>'."\n";
		$i=$i+1;// カウンタの値をプラス1する
		if ($i==25) {break;}
		}
	// バッファに出力したものを文字列として得る
	$text = ob_get_contents();
	ob_end_flush;
	// キャッシュ保存
	$cache_lite->save($text,$cacheId);
	echo "</p>";


}// cache が無い場合 end

//キャッシュ時間取得
$chashjikan = date("Y/m/d H:i:s", $cache_lite->lastModified());
echo "最終更新時間：" . $chashjikan;

?>
	
<!-- 検索結果表示ここまで -->



<p>
<!-- Begin Yahoo! JAPAN Web Services Attribution Snippet -->
<a href="http://developer.yahoo.co.jp/about">
<img src="http://i.yimg.jp/images/yjdn/yjdn_attbtn2_105_17.gif" width="105" height="17" title="Webサービス by Yahoo! JAPAN" alt="Webサービス by Yahoo! JAPAN" border="0" style="margin:15px 15px 15px 15px"></a>
<!-- End Yahoo! JAPAN Web Services Attribution Snippet -->
<!-- Rakuten Web Services Attribution Snippet FROM HERE -->
<a href="http://webservice.rakuten.co.jp/" target="_blank"><img src="http://webservice.rakuten.co.jp/img/credit/200709/credit_4936.gif" border="0" alt="楽天ウェブサービスセンター" title="楽天ウェブサービスセンター" width="49" height="36"/></a>
<!-- Rakuten Web Services Attribution Snippet TO HERE -->
<br />
本サイトの表示内容はAmazon.co.jp、YAHOO!、楽天、バリューコマース、リンクシェア、アクセストレードの各種ウェブサービスを用いた情報となっています。在庫状況や価格はタイミングによって変更されることがありますので、リンク先で購入手続きを行う際に再度ご確認ください。
</p>
</body>
</html>
