/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.testcase;

import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionException;
import org.itscool.commons.pool.ObjectPool;
import org.itscool.commons.pool.ObjectPoolEventListener;
import org.itscool.weber.testcase.MockTransaction;

public class MockConnectionManager
implements ConnectionManager,
ObjectPoolEventListener {
    private static MockConnectionManager instance = null;
    private ObjectPool pool;
    private int timeout;
    private boolean initFlg = false;
    private int initSize = 0;
    private int maxSize = 1;
    private boolean mode = false;
    private boolean showSql = false;
    private String dbType = "hsql";

    public String toString() {
        return "Not Used Connection";
    }

    public static MockConnectionManager getInstance() {
        if (instance == null) {
            instance = new MockConnectionManager();
        }
        return instance;
    }

    public void init() {
        this.pool = new ObjectPool((ObjectPoolEventListener)this, this.initSize, this.maxSize);
        for (int i = 0; i < this.initSize; ++i) {
            this.pool.addNewElement((Object)this.newTransaction());
        }
    }

    private Transaction newTransaction() throws TransactionException {
        Object con = null;
        MockTransaction trn = null;
        trn = new MockTransaction();
        trn.setShowSql(this.showSql);
        return trn;
    }

    public boolean isInit() {
        return this.initFlg;
    }

    public Transaction getTransaction() {
        if (this.timeout != -1) {
            return (Transaction)this.pool.getElement(this.timeout);
        }
        return (Transaction)this.pool.getElement();
    }

    public void returnTransaction(Transaction trn) {
        if (trn == null) {
            trn = this.newTransaction();
        } else if (trn.isClosed()) {
            trn = this.newTransaction();
        }
        this.pool.returnElement((Object)trn);
    }

    public void destroy() {
        if (this.pool != null) {
            this.pool.release();
        }
        this.pool = null;
    }

    public Object doMissingElementEvent() {
        Transaction trn = this.newTransaction();
        return trn;
    }

    public void doReleaseElementEvent(Object obj) {
        Transaction trn = (Transaction)obj;
        try {
            trn.close();
        }
        catch (TransactionException e) {
            throw new TransactionException((Exception)((Object)e));
        }
    }

    public int getPoolSize() {
        if (this.pool != null) {
            return this.pool.getPoolSize();
        }
        return -1;
    }

    public int getInitSize() {
        return this.initSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMode(boolean mode) {
        this.mode = mode;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setInitSize(int initSize) {
        this.initSize = initSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public boolean isInitFlg() {
        return this.initFlg;
    }

    public boolean getMode() {
        return this.mode;
    }

    public boolean getShowSql() {
        return this.showSql;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbType() {
        return this.dbType;
    }
}

