/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;
import org.itscool.commons.dao.EntityInfoMapping;
import org.itscool.commons.dao.FieldMap;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.util.StringUtil;

public class Criteria {
    protected Class entity;
    protected static final String line = System.getProperty("line.separator");
    protected static final String tab = "    ";
    protected RecordMap gRecordMap;
    protected LinkedList whereList;
    protected LinkedList orderByList;
    protected LinkedList groupByList;
    protected HashMap fkRecordMaps;
    private HashMap oneToManyRecordMaps;
    private boolean oneToMany = false;
    protected String limit = null;

    public void setLimit(int startRow, int row) {
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        if (startRow > 0) {
            --startRow;
        }
        this.limit = dbType.equals("hsql") ? "LIMIT " + startRow + " " + row : "LIMIT " + startRow + ", " + row;
    }

    public String getLimit() {
        return this.limit;
    }

    public Criteria(Class entity) {
        this.entity = entity;
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        this.gRecordMap = mapping.getGRecordMap(entity);
        this.fkRecordMaps = mapping.getFkRecordMaps(entity);
        this.setOneToManyRecordMaps(mapping.getOneToManyRecordMaps(entity));
        if (this.getOneToManyRecordMaps().size() > 0) {
            this.setOneToMany(true);
        }
        this.orderByList = new LinkedList();
        this.groupByList = new LinkedList();
        this.whereList = new LinkedList();
    }

    public String getColumName(String propertyName) {
        String columName;
        int index = propertyName.indexOf(".");
        if (index > 0) {
            String fkObjectName = propertyName.substring(0, index);
            String fkPropertyName = propertyName.substring(index + 1, propertyName.length());
            columName = this.cnvFkColumName(fkObjectName, fkPropertyName);
        } else {
            columName = this.cnvColumName(propertyName);
        }
        if (columName == null) {
            columName = StringUtil.cnvUpperNameToUnderScoreName(propertyName);
        }
        return columName;
    }

    protected String cnvColumName(String propertyName) {
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        RecordMap recordMap = mapping.getGRecordMap(this.entity.getName());
        if (recordMap == null) {
            return null;
        }
        FieldMap fieldMap = recordMap.getFieldByPropertyName(propertyName);
        if (fieldMap == null) {
            return null;
        }
        String columWithTableName = fieldMap.getColumWithTableName();
        return columWithTableName;
    }

    protected String cnvFkColumName(String fkObjectName, String fkPropertyName) {
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        RecordMap fkRecordMap = mapping.getFkRecordMap(this.entity.getName(), fkObjectName);
        if (fkRecordMap == null) {
            return null;
        }
        FieldMap fkFieldMap = fkRecordMap.getFieldByPropertyName(fkPropertyName);
        if (fkFieldMap == null) {
            return null;
        }
        String fkColumName = fkFieldMap.getColumWithTableName();
        return fkColumName;
    }

    public RecordMap getRecord() {
        return this.gRecordMap;
    }

    protected String getColNames(RecordMap record) {
        StringBuffer sb = new StringBuffer(line);
        HashMap fields = record.getFields();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            String colWithTableName = item.getColumWithTableName();
            String colAsName = item.getColumAsName();
            sb.append(tab);
            sb.append(colWithTableName);
            sb.append(" as ");
            sb.append(colAsName);
            if (!it.hasNext()) continue;
            sb.append(",");
            sb.append(line);
        }
        return sb.toString();
    }

    protected String getColNamesByTable(HashMap records) {
        StringBuffer sb = new StringBuffer();
        Set keySet = records.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            RecordMap recordMap = (RecordMap)records.get(key);
            sb.append(this.getColNames(recordMap));
        }
        return sb.toString();
    }

    protected String getTableNames(HashMap records) {
        StringBuffer sb = new StringBuffer();
        Set keySet = records.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            RecordMap recordMap = (RecordMap)records.get(key);
            sb.append(recordMap.getTableName());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.gRecordMap.toString());
        sb.append(line);
        Set keySet = this.fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            RecordMap recordMap = (RecordMap)this.fkRecordMaps.get(key);
            sb.append("FK_KEY[").append(key).append("] ").append(recordMap.toString());
            sb.append(line);
        }
        return sb.toString();
    }

    public String toSelectString() {
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        StringBuffer sql = new StringBuffer("SELECT");
        if (dbType.equals("hsql") && this.limit != null) {
            sql.append(line + tab);
            sql.append(this.limit);
        }
        sql.append(this.getColNames(this.gRecordMap));
        sql.append(this.getFkSelectString());
        if (this.isOneToMany()) {
            sql.append(this.getOneToManySelectString());
        }
        sql.append(line);
        sql.append("FROM");
        sql.append(line + tab).append(this.gRecordMap.getTableName());
        sql.append(this.getFkTableString());
        if (this.isOneToMany()) {
            sql.append(this.getOneToManyTableString());
        }
        FieldMap deleteFg = this.gRecordMap.getFieldByFieldName("DELETE_FG");
        if (this.whereList.size() > 0 || this.fkRecordMaps.size() > 0 || deleteFg != null || this.getOneToManyRecordMaps().size() > 0 && this.isOneToMany()) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
        }
        sql.append(this.getWhereString());
        if (deleteFg != null) {
            if (this.whereList.size() > 0) {
                sql.append(line + tab);
                sql.append("AND ");
            }
            sql.append(deleteFg.getColumWithTableName());
            sql.append(" != 1 ");
        }
        sql.append(this.getFkWhereString());
        if (this.isOneToMany()) {
            sql.append(this.getOneToManyWhereString());
        }
        if (this.groupByList.size() > 0) {
            sql.append(line);
            sql.append("GROUP BY");
            sql.append(this.getGroupByString());
        }
        if (this.orderByList.size() > 0) {
            sql.append(line);
            sql.append("ORDER BY");
            sql.append(this.getOrderByString());
        }
        if (!dbType.equals("hsql") && this.limit != null) {
            sql.append(line + tab);
            sql.append(this.limit);
        }
        return sql.toString();
    }

    public String toCountString() {
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        StringBuffer sql = new StringBuffer("SELECT");
        sql.append(" COUNT(*) AS DATA_NUM");
        sql.append(line);
        sql.append("FROM");
        sql.append(line + tab).append(this.gRecordMap.getTableName());
        sql.append(this.getFkTableString());
        FieldMap deleteFg = this.gRecordMap.getFieldByFieldName("DELETE_FG");
        if (this.whereList.size() > 0 || this.fkRecordMaps.size() > 0 || deleteFg != null) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
        }
        sql.append(this.getWhereString());
        if (deleteFg != null) {
            if (this.whereList.size() > 0) {
                sql.append(line + tab);
                sql.append("AND ");
            }
            sql.append(deleteFg.getColumWithTableName());
            sql.append(" != 1 ");
        }
        sql.append(this.getFkWhereString());
        if (this.groupByList.size() > 0) {
            sql.append(line);
            sql.append("GROUP BY");
            sql.append(this.getGroupByString());
        }
        return sql.toString();
    }

    private String getFkSelectString() {
        StringBuffer sql = new StringBuffer();
        Set keySet = this.fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        if (it.hasNext()) {
            sql.append(",");
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            RecordMap fkRecordMap = (RecordMap)this.fkRecordMaps.get(key);
            sql.append(this.getColNames(fkRecordMap));
            if (!it.hasNext()) continue;
            sql.append(",");
        }
        return sql.toString();
    }

    private String getOneToManySelectString() {
        StringBuffer sql = new StringBuffer();
        Set keySet = this.getOneToManyRecordMaps().keySet();
        Iterator it = keySet.iterator();
        if (it.hasNext()) {
            sql.append(",");
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            RecordMap oneToManyRecordMap = (RecordMap)this.getOneToManyRecordMaps().get(key);
            sql.append(this.getColNames(oneToManyRecordMap));
            if (!it.hasNext()) continue;
            sql.append(",");
        }
        return sql.toString();
    }

    private String getFkTableString() {
        StringBuffer sql = new StringBuffer();
        Set keySet = this.fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        if (it.hasNext()) {
            sql.append(",");
            sql.append(line + tab);
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            RecordMap fkRecordMap = (RecordMap)this.fkRecordMaps.get(key);
            String fkTableName = fkRecordMap.getTableName();
            sql.append(fkTableName);
            if (!it.hasNext()) continue;
            sql.append(",");
            sql.append(line + tab);
        }
        return sql.toString();
    }

    private String getOneToManyTableString() {
        StringBuffer sql = new StringBuffer();
        Set keySet = this.getOneToManyRecordMaps().keySet();
        Iterator it = keySet.iterator();
        if (it.hasNext()) {
            sql.append(",");
            sql.append(line + tab);
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            RecordMap oneToManyRecordMap = (RecordMap)this.getOneToManyRecordMaps().get(key);
            String fkTableName = oneToManyRecordMap.getTableName();
            sql.append(fkTableName);
            if (!it.hasNext()) continue;
            sql.append(",");
            sql.append(line + tab);
        }
        return sql.toString();
    }

    private String getFkWhereString() {
        StringBuffer sql = new StringBuffer();
        Set keySet = this.fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        if (it.hasNext() && (this.whereList.size() > 0 || this.gRecordMap.getFieldByFieldName("DELETE_FG") != null)) {
            sql.append(line + tab);
            sql.append("AND ");
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            RecordMap fkRecordMap = (RecordMap)this.fkRecordMaps.get(key);
            Set fieldKeySet = fkRecordMap.getFields().keySet();
            Iterator fieldIt = fieldKeySet.iterator();
            while (fieldIt.hasNext()) {
                String fieldKey = (String)fieldIt.next();
                FieldMap fieldMap = fkRecordMap.getField(fieldKey);
                if (!fieldMap.isForignKey()) continue;
                String propertyName = fieldMap.getPropertyName();
                String columWithTableName = fieldMap.getColumWithTableName();
                String fkPropertyName = fieldMap.getFkPropertyName();
                sql.append(columWithTableName);
                sql.append(" = ");
                sql.append(this.getFkFieldName(fkPropertyName));
                if (!it.hasNext()) continue;
                sql.append(line + tab);
                sql.append("AND ");
            }
        }
        return sql.toString();
    }

    private String getOneToManyWhereString() {
        StringBuffer sql = new StringBuffer();
        Set keySet = this.getOneToManyRecordMaps().keySet();
        Iterator it = keySet.iterator();
        if (it.hasNext() && (this.whereList.size() > 0 || this.gRecordMap.getFieldByFieldName("DELETE_FG") != null)) {
            sql.append(line + tab);
            sql.append("AND ");
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            RecordMap oneToManyRecordMap = (RecordMap)this.getOneToManyRecordMaps().get(key);
            Set fieldKeySet = oneToManyRecordMap.getFields().keySet();
            Iterator fieldIt = fieldKeySet.iterator();
            while (fieldIt.hasNext()) {
                String fieldKey = (String)fieldIt.next();
                FieldMap fieldMap = oneToManyRecordMap.getField(fieldKey);
                if (!fieldMap.isForignKey()) continue;
                String propertyName = fieldMap.getPropertyName();
                String columWithTableName = fieldMap.getColumWithTableName();
                String oneToManyPropertyName = fieldMap.getFkPropertyName();
                sql.append(columWithTableName);
                sql.append(" = ");
                FieldMap current = this.gRecordMap.getFieldByPropertyName(oneToManyPropertyName);
                sql.append(current.getColumWithTableName());
                if (!it.hasNext()) continue;
                sql.append(line + tab);
                sql.append("AND ");
            }
        }
        return sql.toString();
    }

    private String getFkFieldName(String propertyName) {
        HashMap fields = this.gRecordMap.getFields();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        String fkFieldName = "";
        while (it.hasNext()) {
            String key = (String)it.next();
            FieldMap fieldMap = (FieldMap)fields.get(key);
            if (!fieldMap.getPropertyName().equals(propertyName)) continue;
            return fieldMap.getColumWithTableName();
        }
        return fkFieldName;
    }

    public String toDeleteString() {
        if (this.gRecordMap.getFieldByFieldName("DELETE_FG") != null) {
            return this.toLogicalDeleteString();
        }
        StringBuffer sql = new StringBuffer("DELETE FROM ");
        sql.append(" ").append(this.gRecordMap.getTableName()).append(" ");
        if (this.whereList.size() > 0) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
            sql.append(this.getWhereString());
        }
        return sql.toString();
    }

    public String toLogicalDeleteString() {
        StringBuffer sql = new StringBuffer("UPDATE ");
        FieldMap deleteFg = this.gRecordMap.getFieldByFieldName("DELETE_FG");
        FieldMap deleteDt = this.gRecordMap.getFieldByFieldName("DELETE_DT");
        sql.append(line);
        sql.append(" ").append(this.gRecordMap.getTableName()).append(" ");
        sql.append(" SET ");
        sql.append(line + tab);
        sql.append(deleteFg.getColumWithTableName());
        sql.append("=1");
        if (deleteDt != null) {
            sql.append(", ");
            sql.append(deleteDt.getColumWithTableName());
            sql.append("=");
            sql.append(deleteDt.cnvSqlValue(new Date()));
        }
        if (this.whereList.size() > 0) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
            sql.append(this.getWhereString());
        }
        return sql.toString();
    }

    public String toInsertString(Object bean) {
        StringBuffer sql = new StringBuffer("INSERT INTO");
        HashMap fields = this.gRecordMap.getFields();
        sql.append(" ").append(this.gRecordMap.getTableName());
        sql.append("(");
        sql.append(Criteria.toItemNames(fields));
        sql.append(") VALUES(");
        sql.append(Criteria.toItemValues(fields, bean));
        sql.append(")");
        return sql.toString();
    }

    public String toUpdateString(Object bean) {
        StringBuffer sql = new StringBuffer("UPDATE");
        HashMap fields = this.gRecordMap.getFields();
        Object version = null;
        try {
            version = this.getLockVersion(bean);
        }
        catch (Exception e) {
            // empty catch block
        }
        sql.append(" ").append(this.gRecordMap.getTableName()).append(line);
        sql.append("SET ").append(line + tab);
        sql.append(Criteria.toUpdateNames(fields, bean));
        if (this.whereList.size() > 0) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
            sql.append(this.getWhereString());
        }
        if (version != null) {
            if (this.whereList.size() == 0) {
                sql.append(line);
                sql.append("WHERE").append(line + tab);
            } else {
                sql.append(line + tab).append("AND ");
            }
            try {
                int versionNum = Integer.parseInt(version.toString());
                if (versionNum == 0) {
                    sql.append("(");
                    sql.append("LOCK_VERSION").append(" = ").append(version);
                    sql.append(" OR ").append("LOCK_VERSION").append(" is null");
                    sql.append(")");
                } else {
                    sql.append("LOCK_VERSION").append(" = ").append(version);
                }
            }
            catch (Exception e) {
                sql.append("LOCK_VERSION").append(" = ").append(version);
            }
        }
        return sql.toString();
    }

    public Object getLockVersion(Object bean) throws BeanUtilRuntimeException {
        FieldMap rockVersionField = this.gRecordMap.getFieldByFieldName("LOCK_VERSION");
        if (rockVersionField == null) {
            return null;
        }
        Object version = BeanUtil.getProperty(bean, rockVersionField.getPropertyName());
        return version;
    }

    protected static String toUpdateNames(HashMap fields, Object bean) {
        StringBuffer sb = new StringBuffer();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        boolean nextFlg = false;
        while (it.hasNext()) {
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            if (item.isPrimaryKey()) continue;
            if (nextFlg) {
                sb.append(",");
                sb.append(line + tab);
            }
            String propertyName = item.getPropertyName();
            Object value = BeanUtil.getProperty(bean, propertyName);
            sb.append(item.getColumName());
            sb.append("=");
            if (item.getColumName().equals("LOCK_VERSION")) {
                value = String.valueOf(Integer.parseInt(value.toString()) + 1);
                sb.append(value);
            } else if (item.getColumName().equals("UPDATE_DT")) {
                Date updateDt = new Date();
                value = item.cnvSqlValue(updateDt);
                sb.append(value);
            } else {
                sb.append(item.cnvSqlValue(value));
            }
            if (nextFlg) continue;
            nextFlg = true;
        }
        return sb.toString();
    }

    public String toSelectLockVersionString() {
        EntityInfoMapping mapping = EntityInfoMapping.getInstance();
        String dbType = mapping.getDbType();
        StringBuffer sql = new StringBuffer("SELECT");
        FieldMap lckField = this.gRecordMap.getFieldByFieldName("LOCK_VERSION");
        if (lckField == null) {
            return null;
        }
        sql.append(line + tab);
        sql.append(this.gRecordMap.getTableName()).append(".");
        sql.append(lckField.getColumName());
        sql.append(" AS ").append(lckField.getColumName());
        sql.append(line);
        sql.append("FROM");
        sql.append(line + tab).append(this.gRecordMap.getTableName());
        sql.append(this.getFkTableString());
        if (this.whereList.size() > 0 || this.fkRecordMaps.size() > 0) {
            sql.append(line);
            sql.append("WHERE").append(line + tab);
        }
        sql.append(this.getWhereString());
        sql.append(this.getFkWhereString());
        if (this.groupByList.size() > 0) {
            sql.append(line);
            sql.append("GROUP BY");
            sql.append(this.getGroupByString());
        }
        if (this.orderByList.size() > 0) {
            sql.append(line);
            sql.append("ORDER BY");
            sql.append(this.getOrderByString());
        }
        return sql.toString();
    }

    protected static String toItemNames(HashMap fields) {
        StringBuffer sb = new StringBuffer();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            sb.append(item.getColumName().toUpperCase());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected static String toItemValues(HashMap fields, Object bean) {
        StringBuffer sb = new StringBuffer();
        Set keySet = fields.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            FieldMap item = (FieldMap)fields.get(key);
            String propertyName = item.getPropertyName();
            Object value = BeanUtil.getProperty(bean, propertyName);
            if (item.getColumName().equals("LOCK_VERSION")) {
                value = String.valueOf(1);
                BeanUtil.setProperty(bean, propertyName, value);
                sb.append(value);
            } else if (item.getColumName().equals("UPDATE_DT")) {
                Date updateDt = new Date();
                value = item.cnvSqlValue(updateDt);
                BeanUtil.setProperty(bean, propertyName, updateDt);
                sb.append(value);
            } else if (item.getColumName().equals("DELETE_DT")) {
                sb.append("null");
            } else {
                sb.append(item.cnvSqlValue(value));
            }
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String getWhereString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.whereList.iterator();
        while (it.hasNext()) {
            String sql = (String)it.next();
            sb.append(sql);
        }
        return sb.toString();
    }

    public String getOrderByString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.orderByList.iterator();
        while (it.hasNext()) {
            String sql = (String)it.next();
            sb.append(sql.toUpperCase());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String getGroupByString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.groupByList.iterator();
        while (it.hasNext()) {
            String sql = (String)it.next();
            sb.append(sql.toUpperCase());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public Criteria or() {
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append("OR ");
        this.whereList.add(sb.toString());
        return this;
    }

    public Criteria and() {
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append("AND ");
        this.whereList.add(sb.toString());
        return this;
    }

    public Criteria orderby(String propertyName) {
        return this.orderby(propertyName, true);
    }

    public Criteria orderby(String propertyName, boolean sort) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        String sortStr = "";
        sortStr = sort ? "ASC" : "DESC";
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append(fieldName);
        sb.append(" ").append(sortStr);
        this.orderByList.add(sb.toString());
        return this;
    }

    public Criteria groupby(String propertyName) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        String sortStr = "";
        StringBuffer sb = new StringBuffer();
        sb.append(line);
        sb.append(tab);
        sb.append(fieldName);
        sb.append(" ").append(sortStr);
        this.groupByList.add(sb.toString());
        return this;
    }

    public FieldMap getFkField(String propertyName) {
        String fieldName = this.getColumName(propertyName);
        if (fieldName == null) {
            fieldName = propertyName;
        }
        Set keySet = this.fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            RecordMap fkRecordMap = (RecordMap)this.fkRecordMaps.get(key);
            FieldMap fieldMap = fkRecordMap.getField(fieldName);
            if (fieldMap == null) continue;
            return fieldMap;
        }
        return null;
    }

    public Criteria isnull(String propertyName) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(fieldName).append(" IS NULL");
        this.whereList.add(sb.toString());
        return this;
    }

    public Criteria isnotnull(String propertyName) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(fieldName).append(" IS NOT NULL");
        this.whereList.add(sb.toString());
        return this;
    }

    public Criteria between(String propertyName, Object value1, Object value2) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(fieldName);
        sb.append(" BETWEEN ");
        sb.append(fieldMap.cnvSqlValue(value1));
        sb.append(" AND ");
        sb.append(fieldMap.cnvSqlValue(value2));
        this.whereList.add(sb.toString());
        return this;
    }

    public Criteria between(String propertyName, int value1, int value2) {
        return this.between(propertyName, String.valueOf(value1), String.valueOf(value2));
    }

    public Criteria between(String propertyName, short value1, short value2) {
        return this.between(propertyName, String.valueOf(value1), String.valueOf(value2));
    }

    public Criteria between(String propertyName, double value1, double value2) {
        return this.between(propertyName, String.valueOf(value1), String.valueOf(value2));
    }

    public Criteria between(String propertyName, long value1, long value2) {
        return this.between(propertyName, String.valueOf(value1), String.valueOf(value2));
    }

    public Criteria between(String propertyName, float value1, float value2) {
        return this.between(propertyName, String.valueOf(value1), String.valueOf(value2));
    }

    public Criteria like(String propertyName, Object value) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(fieldName).append(" ");
        sb.append("LIKE ");
        sb.append(fieldMap.cnvSqlValue(value));
        this.whereList.add(sb.toString());
        return this;
    }

    public void like(String fieldName, int value) {
        this.like(fieldName, String.valueOf(value));
    }

    public Criteria like(String fieldName, short value) {
        return this.like(fieldName, String.valueOf(value));
    }

    public Criteria like(String fieldName, double value) {
        return this.like(fieldName, String.valueOf(value));
    }

    public Criteria like(String fieldName, long value) {
        return this.like(fieldName, String.valueOf(value));
    }

    public Criteria like(String fieldName, float value) {
        return this.like(fieldName, String.valueOf(value));
    }

    public Criteria eq(String propertyName, Object value) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        if (fieldMap == null) {
            fieldMap = this.getFkField(propertyName);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(propertyName).append(" = ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" = ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
        return this;
    }

    public Criteria eq(String propertyName, int value) {
        return this.eq(propertyName, String.valueOf(value));
    }

    public Criteria eq(String propertyName, short value) {
        return this.eq(propertyName, String.valueOf(value));
    }

    public Criteria eq(String propertyName, double value) {
        return this.eq(propertyName, String.valueOf(value));
    }

    public Criteria eq(String propertyName, long value) {
        return this.eq(propertyName, String.valueOf(value));
    }

    public Criteria eq(String propertyName, float value) {
        return this.eq(propertyName, String.valueOf(value));
    }

    public Criteria neq(String propertyName, Object value) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(fieldName).append(" != ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" != ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
        return this;
    }

    public Criteria neq(String propertyName, short value) {
        return this.neq(propertyName, String.valueOf(value));
    }

    public Criteria neq(String propertyName, int value) {
        return this.neq(propertyName, String.valueOf(value));
    }

    public Criteria neq(String propertyName, long value) {
        return this.neq(propertyName, String.valueOf(value));
    }

    public Criteria neq(String propertyName, double value) {
        return this.neq(propertyName, String.valueOf(value));
    }

    public Criteria neq(String propertyName, float value) {
        return this.neq(propertyName, String.valueOf(value));
    }

    public Criteria neq(String propertyName, Date value) {
        return this.neq(propertyName, String.valueOf(value));
    }

    public Criteria morebig(String propertyName, Object value) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(fieldName).append(" > ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" > ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
        return this;
    }

    public Criteria morebig(String propertyName, short value) {
        return this.morebig(propertyName, String.valueOf(value));
    }

    public Criteria morebig(String propertyName, int value) {
        return this.morebig(propertyName, String.valueOf(value));
    }

    public Criteria morebig(String propertyName, long value) {
        return this.morebig(propertyName, String.valueOf(value));
    }

    public Criteria morebig(String propertyName, double value) {
        return this.morebig(propertyName, String.valueOf(value));
    }

    public Criteria morebig(String propertyName, float value) {
        return this.morebig(propertyName, String.valueOf(value));
    }

    public Criteria morebig(String propertyName, Date value) {
        return this.morebig(propertyName, String.valueOf(value));
    }

    public Criteria moresmall(String propertyName, Object value) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(fieldName).append(" < ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" < ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
        return this;
    }

    public Criteria moresmall(String propertyName, short value) {
        return this.moresmall(propertyName, String.valueOf(value));
    }

    public Criteria moresmall(String propertyName, int value) {
        return this.moresmall(propertyName, String.valueOf(value));
    }

    public Criteria moresmall(String propertyName, long value) {
        return this.moresmall(propertyName, String.valueOf(value));
    }

    public Criteria moresmall(String propertyName, double value) {
        return this.moresmall(propertyName, String.valueOf(value));
    }

    public Criteria moresmall(String propertyName, float value) {
        return this.moresmall(propertyName, String.valueOf(value));
    }

    public Criteria moresmall(String propertyName, Date value) {
        return this.moresmall(propertyName, String.valueOf(value));
    }

    public Criteria overbig(String propertyName, Object value) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(fieldName).append(" >= ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" >= ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
        return this;
    }

    public Criteria overbig(String propertyName, short value) {
        return this.overbig(propertyName, String.valueOf(value));
    }

    public Criteria overbig(String propertyName, int value) {
        return this.overbig(propertyName, String.valueOf(value));
    }

    public Criteria overbig(String propertyName, long value) {
        return this.overbig(propertyName, String.valueOf(value));
    }

    public Criteria overbig(String propertyName, double value) {
        return this.overbig(propertyName, String.valueOf(value));
    }

    public Criteria overbig(String propertyName, float value) {
        return this.overbig(propertyName, String.valueOf(value));
    }

    public Criteria overbig(String propertyName, Date value) {
        return this.overbig(propertyName, String.valueOf(value));
    }

    public Criteria oversmall(String propertyName, Object value) {
        FieldMap fieldMap = null;
        String fieldName = this.getColumName(propertyName);
        if (fieldName != null) {
            fieldMap = this.gRecordMap.getField(fieldName);
        }
        StringBuffer sb = new StringBuffer();
        if (fieldMap == null) {
            sb.append(fieldName).append(" <= ");
            sb.append(value);
        } else {
            sb.append(fieldMap.getColumWithTableName()).append(" <= ");
            sb.append(fieldMap.cnvSqlValue(value));
        }
        this.whereList.add(sb.toString());
        return this;
    }

    public Criteria oversmall(String propertyName, short value) {
        return this.oversmall(propertyName, String.valueOf(value));
    }

    public Criteria oversmall(String propertyName, int value) {
        return this.oversmall(propertyName, String.valueOf(value));
    }

    public Criteria oversmall(String propertyName, long value) {
        return this.oversmall(propertyName, String.valueOf(value));
    }

    public Criteria oversmall(String propertyName, double value) {
        return this.oversmall(propertyName, String.valueOf(value));
    }

    public Criteria oversmall(String propertyName, float value) {
        return this.oversmall(propertyName, String.valueOf(value));
    }

    public Criteria oversmall(String propertyName, Date value) {
        return this.oversmall(propertyName, String.valueOf(value));
    }

    public HashMap getFkRecordMaps() {
        return this.fkRecordMaps;
    }

    public void setFkRecordMaps(HashMap fkRecordMaps) {
        this.fkRecordMaps = fkRecordMaps;
    }

    public boolean isOneToMany() {
        return this.oneToMany;
    }

    public void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    public HashMap getOneToManyRecordMaps() {
        return this.oneToManyRecordMaps;
    }

    public void setOneToManyRecordMaps(HashMap oneToManyRecordMaps) {
        this.oneToManyRecordMaps = oneToManyRecordMaps;
    }
}

