/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.itscool.commons.util.DateElement;
import org.itscool.commons.util.DateFormatUtil;

public class MonthTable {
    private HashMap days = new HashMap();
    private int year;
    private int month;
    private int maxday;

    public Date toMonth() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, this.year);
        cal.set(2, this.month - 1);
        Date date = cal.getTime();
        return date;
    }

    public MonthTable() {
        Calendar cal = Calendar.getInstance();
        this.year = cal.get(1);
        this.month = cal.get(2) + 1;
        this.init(this.year, this.month);
    }

    public MonthTable(Calendar cal) {
        this.year = cal.get(1);
        this.month = cal.get(2) + 1;
        this.init(this.year, this.month);
    }

    public MonthTable(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.year = cal.get(1);
        this.month = cal.get(2) + 1;
        this.init(this.year, this.month);
    }

    public MonthTable(int year, int month) {
        this.init(year, month);
    }

    public void init(int year, int month) {
        int i;
        Calendar cal = Calendar.getInstance();
        if (year > 0) {
            cal.clear();
            cal.set(1, year);
            cal.set(2, month - 1);
            this.year = year;
            this.month = month;
        } else {
            this.year = cal.get(1);
            this.month = cal.get(2) + 1;
        }
        this.maxday = DateFormatUtil.getMaxDay(cal);
        cal.set(5, 1);
        int yobi = cal.get(7);
        if (yobi != 1) {
            cal.set(7, 1);
            for (i = 1; i < yobi; ++i) {
                this.addDay(new DateElement(cal, false));
                cal.add(5, 1);
            }
        }
        for (i = 0; i < this.maxday; ++i) {
            this.addDay(new DateElement(cal, false));
            cal.add(5, 1);
        }
        this.initHoliday(this.getYear(), this.getMonth());
        cal.add(5, -1);
        yobi = cal.get(7);
        if (yobi != 7) {
            for (i = yobi; i <= 7; ++i) {
                this.addDay(new DateElement(cal, false));
                cal.add(5, 1);
            }
        }
    }

    public void initHoliday(int year, int month) {
        DateElement day;
        switch (month) {
            case 1: {
                this.addDay(new DateElement(year, 1, 1, true));
                DateElement holiday2 = MonthTable.getHoliday(year, 1, 2, 2);
                this.addDay(holiday2);
                break;
            }
            case 3: {
                DateElement holiday3 = MonthTable.getHolidayEx(year, 3, 20.69115);
                this.addDay(holiday3);
                break;
            }
            case 4: {
                this.addDay(new DateElement(year, 4, 29, true));
                break;
            }
            case 5: {
                this.addDay(new DateElement(year, 5, 3, true));
                this.addDay(new DateElement(year, 5, 4, true));
                this.addDay(new DateElement(year, 5, 5, true));
                break;
            }
            case 7: {
                DateElement holiday7 = MonthTable.getHoliday(year, 7, 3, 2);
                this.addDay(holiday7);
                break;
            }
            case 9: {
                DateElement holiday9 = MonthTable.getHoliday(year, 9, 3, 2);
                this.addDay(holiday9);
                DateElement holiday9_2 = MonthTable.getHolidayEx(year, 9, 23.09);
                this.addDay(holiday9_2);
                break;
            }
            case 10: {
                DateElement holiday10 = MonthTable.getHoliday(year, 10, 2, 2);
                this.addDay(holiday10);
                break;
            }
            case 11: {
                this.addDay(new DateElement(year, 11, 3, true));
                this.addDay(new DateElement(year, 11, 23, true));
                break;
            }
            case 12: {
                this.addDay(new DateElement(year, 12, 23, true));
            }
        }
        for (int i = 0; i < 31 && (day = this.getDay(year, month, i + 1)) != null; ++i) {
            if (!day.isHoliday() || day.getYobi() != 1) continue;
            DateElement monday = this.getDay(year, month, i + 2);
            if (monday == null) break;
            monday.setHoliday(true);
        }
    }

    public static DateElement getHoliday(int year, int month, int weekOfMonth, int youbi) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(7, youbi);
        ((Calendar)cal).add(4, weekOfMonth - 1);
        int tmpYear = cal.get(1);
        int tmpMonth = cal.get(2) + 1;
        int tmpDay = cal.get(5);
        return new DateElement(tmpYear, tmpMonth, tmpDay, true);
    }

    public static DateElement getHolidayEx(int year, int month, double throwDay) {
        double moveQt = (double)(year - 2000) * 0.2421904;
        int resetQt = (year - 2000) / 4;
        int day = (int)(throwDay + moveQt - (double)resetQt);
        return new DateElement(year, month, day, true);
    }

    public void addDay(DateElement day) {
        StringBuffer key = new StringBuffer();
        key.append(day.getYear());
        key.append(day.getMonth());
        key.append(day.getDay());
        this.days.put(key.toString(), day);
    }

    public DateElement getDay(int year, int month, int day) {
        StringBuffer key = new StringBuffer();
        key.append(year);
        key.append(month);
        key.append(day);
        DateElement date = (DateElement)this.days.get(key.toString());
        return date;
    }

    public DateElement getDay(Calendar cal) {
        int tmpYear = cal.get(1);
        int tmpMonth = cal.get(2) + 1;
        int tmpDay = cal.get(5);
        DateElement date = this.getDay(tmpYear, tmpMonth, tmpDay);
        return date;
    }

    public HashMap getDays() {
        return this.days;
    }

    public int getMaxday() {
        return this.maxday;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }
}

