package test.org.itscool.commons.bean;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import junit.framework.TestCase;

import org.itscool.commons.bean.BeanFactory;

public class BeanFactoryTest extends TestCase{
    
    public BeanFactoryTest() throws Exception{
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        URL weberUrl = parent.getResource("test/org/itscool/commons/bean/di-config-framework.xml");
        BeanFactory factory = BeanFactory.getInstance();
        
        factory.create(weberUrl.getPath());
        
    }
    
    public void testCreateInstance(){
        BeanFactory factory = BeanFactory.getInstance();
        SampleBean2 bean = (SampleBean2) factory.createInstance("sample2");
        System.out.println(bean.getName());
        System.out.println(bean.getChild().getName());
        assertEquals("parent", bean.getName());
        assertEquals("child", bean.getChild().getName());
        
    }
    
    public void testCreateInstance2(){
        BeanFactory factory = BeanFactory.getInstance();
        
        SampleBean3 bean3 = (SampleBean3) factory.createInstance("sample3");
        HashMap map2 = bean3.getMap2();
        Set set = map2.keySet();
        Iterator it = set.iterator();
        while(it.hasNext()){
            Object key = it.next();
            SampleChildBean2 child2 = (SampleChildBean2)map2.get(key);
            System.out.println(child2.getName());
        }
        
        HashMap map1 = bean3.getMap1();
        Set set1 = map1.keySet();
        Iterator it1 = set1.iterator();
        while(it1.hasNext()){
            Object key = it1.next();
            String child1 = (String)map1.get(key);
            System.out.println(child1);
        }
        
    }
    
    public void testSingleton(){
        BeanFactory factory = BeanFactory.getInstance();
        Sample4Singleton singleton = (Sample4Singleton)factory.createInstance("sample4");
        assertEquals("singleton", singleton.getName());
        
        Sample4Singleton singleton2 = (Sample4Singleton)factory.createInstance("sample4");
        assertEquals("singleton", singleton2.getName());
        
    }
    
}
