/*
 * TestJdbcConnectionManager.java
 *
 * Created on 2007/03/13, 22:21
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package test.org.itscool.commons.connection;

import junit.framework.TestCase;
import org.itscool.commons.connection.JdbcConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.pool.ObjectPoolRuntimeException;

/**
 *
 * @author KANO
 */
public class TestJdbcConnectionManager extends TestCase{
    
    public void testInit(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        try{
            mgr.setInitSize(1);
            mgr.setDrvname("org.hsqldb.jdbcDriver");
            mgr.setUrl("jdbc:hsqldb:hsql://localhost");
            mgr.setUser("sa");
            mgr.setPwd("");
            mgr.init();
            mgr.destroy();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testInit2(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        try{
            mgr.setInitSize(1);
            mgr.setDrvname("org.hsqldb.jdbcDriver");
            mgr.setUrl("jdbc:hsqldb:hsql://localhost");
            mgr.setUser("sa");
            mgr.setPwd(null);
            mgr.init();
            mgr.destroy();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testInitFail(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        try{
            mgr.setInitSize(1);
            mgr.setDrvname(null);
            mgr.init();
            fail("JdbcConnectionManager is initialized complete.");
        }catch(Exception e){
            System.out.println(e.getMessage());
        }
    }
    
    public void testInitFail2(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        try{
            mgr.setInitSize(1);
            mgr.setDrvname("org.hsqldb.jdbcDriver");
            mgr.setUrl(null);
            mgr.setUser("sa");
            mgr.setPwd("");
            mgr.init();
            fail("JdbcConnectionManager is initialized complete.");
        }catch(Exception e){
            System.out.println(e.getMessage());
        }
    }
    
    public void testPoolSize(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        try{
            mgr.setInitSize(1);
            mgr.setMaxSize(3);
            mgr.setDrvname("org.hsqldb.jdbcDriver");
            mgr.setUrl("jdbc:hsqldb:hsql://localhost");
            mgr.setUser("sa");
            mgr.setPwd("");
            mgr.init();
            
            assertEquals("init size test", 1, mgr.getPoolSize());
            Transaction trn = mgr.getTransaction();
            assertEquals("now pool size", 1, mgr.getPoolSize());
            Transaction trn2 = mgr.getTransaction();
            assertEquals("now pool size", 2, mgr.getPoolSize());
            Transaction trn3 = mgr.getTransaction();
            assertEquals("now pool size", 3, mgr.getPoolSize());
            mgr.returnTransaction(trn);
            mgr.returnTransaction(trn2);
            mgr.returnTransaction(trn3);
            mgr.destroy();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testPoolFull(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        try{
            mgr.setInitSize(1);
            mgr.setMaxSize(3);
            mgr.setDrvname("org.hsqldb.jdbcDriver");
            mgr.setUrl("jdbc:hsqldb:hsql://localhost");
            mgr.setUser("sa");
            mgr.setPwd("");
            mgr.init();
            
            assertEquals("init size test", 1, mgr.getPoolSize());
            Transaction trn = mgr.getTransaction();
            assertEquals("now pool size", 1, mgr.getPoolSize());
            Transaction trn2 = mgr.getTransaction();
            assertEquals("now pool size", 2, mgr.getPoolSize());
            Transaction trn3 = mgr.getTransaction();
            assertEquals("now pool size", 3, mgr.getPoolSize());
            try{
                Transaction trn4 = mgr.getTransaction();
                fail("getTransaction completed");
            }catch(ObjectPoolRuntimeException opre){
                
            }
            mgr.returnTransaction(trn);
            mgr.returnTransaction(trn2);
            mgr.returnTransaction(trn3);
            mgr.destroy();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testDestroy(){
        JdbcConnectionManager mgr = JdbcConnectionManager.getInstance();
        try{
            mgr.setInitSize(1);
            mgr.setDrvname("org.hsqldb.jdbcDriver");
            mgr.setUrl("jdbc:hsqldb:hsql://localhost");
            mgr.setUser("sa");
            mgr.setPwd("");
            mgr.init();
            mgr.destroy();
            assertEquals("destroy pool size", -1, mgr.getPoolSize());
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
}
