/*
 * SampleEntitInfo.java
 *
 * Created on 2007/04/13, 19:49
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package test.org.itscool.commons.dao.recordmap;

import java.util.HashMap;
import junit.framework.TestCase;
import org.itscool.commons.dao.FieldMap;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFkFactory;
import org.itscool.weber.user.Role;
import org.itscool.weber.user.User;

/**
 * NX[OQƃe[uԃ}bsONX̃eXg
 * @author KANO
 */
public class RecordMapFkFactoryTest extends TestCase{
    /**
     * iNXɉi`iCOLUM_)ꍇ
     */
    public void testCreate1() {
        HashMap fkMap = RecordMapFkFactory.createFkRecordMaps(SampleChild.class);
        assertEquals("parent num", 1, fkMap.size());
        
        //OQƏvpeBŎ擾
        RecordMap recordMap = (RecordMap)fkMap.get("parent");
        //System.out.println(recordMap.toString());
        
        //OQƃNX[e[u}bsO
        assertEquals("TABLE_NAME", "SAMPLE_ENTITY", recordMap.getTableName());
        assertEquals("CLASS_NAME", SampleEntity.class.getName(), recordMap.getClassName());
        assertEquals("CLASS_ONLY_NAME", "SampleEntity", recordMap.getClassOnlyName());
        
        //vpeB[J}bsO
        FieldMap fieldMap = recordMap.getFieldByFieldName("NAME");
        if( fieldMap == null ){
            fail("NAME IS NULL");
        }
        assertEquals("NAME", fieldMap.getColumName());
        assertEquals("SAMPLE_ENTITY_NAME", fieldMap.getColumAsName());
        assertEquals("name", fieldMap.getPropertyName());
    }
    
    /**
     * iNXɉi`iCOLUM_)ꍇ
     */
    public void testCreate2(){
        HashMap fkMap = RecordMapFkFactory.createFkRecordMaps(User.class);
        assertEquals("parent num", 1, fkMap.size());
        
        //OQƏvpeBŎ擾
        RecordMap recordMap = (RecordMap)fkMap.get("role");
        
        //NX[e[u}bsO
        assertEquals("TABLE_NAME", "ROLE", recordMap.getTableName());
        assertEquals("CLASS_NAME", Role.class.getName(), recordMap.getClassName());
        assertEquals("CLASS_ONLY_NAME", "Role", recordMap.getClassOnlyName());
        
        //vpeB[J}bsO
        FieldMap fieldMap = recordMap.getFieldByFieldName("NAME");
        if( fieldMap == null ){
            fail("NAME IS NULL");
        }
        assertEquals("NAME", fieldMap.getColumName());
        assertEquals("ROLE_NAME", fieldMap.getColumAsName());
        assertEquals("name", fieldMap.getPropertyName());
        
       FieldMap roleIdMap = recordMap.getFieldByFieldName("ID");
        if( roleIdMap == null ){
            fail("ID IS NULL");
        }
        assertEquals("ID", roleIdMap.getColumName());
        assertEquals("ROLE_ID", roleIdMap.getColumAsName());
        assertEquals("id", roleIdMap.getPropertyName());
//        System.out.println(recordMap.toString());
    }
    
    /**
     * OQƃL[̐ݒmF
     */
    public void testFk1() {
        HashMap fkMap = RecordMapFkFactory.createFkRecordMaps(User.class);
        RecordMap recordMap = (RecordMap)fkMap.get("role");
        if( recordMap == null) fail("RecordMap is NULL");
        FieldMap fieldMap = recordMap.getFieldByFieldName("ID");
        if( fieldMap == null ) fail("ID IS NULL");
        assertEquals("forign-key", true, fieldMap.isForignKey());
    }
}
