package test.org.itscool.commons.document;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

import org.itscool.commons.document.BeanToXmlDocument;
import org.itscool.commons.document.DomParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanToXmlDocumentTest extends TestCase{
    
    /**
     * PJavaBeansXMLϊB
     * ftHgϊP
     */
    public void test1(){
        try{
            SampleBean1 bean = new SampleBean1();
            bean.setId(1);
            bean.setName("aaa");
            BeanToXmlDocument beanToXml = new BeanToXmlDocument("root");
            
            //IuWFNgo^
            beanToXml.addElement(bean);
            
            String message = beanToXml.parseText("UTF-8");
            System.out.println(message+"\n");
            //DocumentBeanParser.parseBean();
            
            //
            DomParser parser = new DomParser(beanToXml.getDocument());
            Node beanNode = parser.getFirstElementsByTagNames("root.SampleBean1");
            String beanNodeName = beanNode.getNodeName();
            assertEquals("bean tag name", "SampleBean1", beanNodeName);
            String idValue = parser.getFirstTextElementByTagNames(beanNode.getChildNodes(), "id");
            String nameValue = parser.getFirstTextElementByTagNames(beanNode.getChildNodes(), "name");
            
            assertEquals("id", "1", idValue);
            assertEquals("name", "aaa", nameValue);
            
        }catch(Exception e){
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
    /**
     * has-a֌W̃IuWFNgXMLɕϊ
     * ftHgϊQ
     */
    public void test2(){
        try{
            SampleBean1 bean = new SampleBean1();
            bean.setId(1);
            bean.setName("ǂP");
            
            SampleParent1 parent = new SampleParent1();
            parent.setName("ƂȂP");
            parent.setBean(bean);
            
            BeanToXmlDocument beanToXml = new BeanToXmlDocument("root");
            beanToXml.addElement(parent);
            
            
            //
            String message = beanToXml.parseText("UTF-8");
            System.out.println(message+"\n");
            
            DomParser parser = new DomParser(beanToXml.getDocument());
            
            Node parentNode = parser.getFirstElementsByTagNames("root.SampleParent1");
            this.assertNotNull("SampleParentBean's Node", parentNode);
            
            String parentName = parser.getFirstTextElementByTagNames(parentNode.getChildNodes(), "name");
            Node childNode = parser.getFirstElementsByTagNames(parentNode.getChildNodes(), "bean");
            String childId = parser.getFirstTextElementByTagNames(childNode.getChildNodes(), "id");
            String childName = parser.getFirstTextElementByTagNames(childNode.getChildNodes(), "name");
            
            assertEquals("SampleParent1 name", parentName, "ƂȂP");
            assertNotNull("SampleBean1's Node", childNode);
            assertEquals("SampleBean1 id", childId, "1");
            assertEquals("SampleBean1 name", childName, "ǂP");
            
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    /**
     * ftHgϊR
     */
    public void test3(){
        try{
            SampleBean1 bean = new SampleBean1();
            bean.setName(null);
            BeanToXmlDocument beanToXml = new BeanToXmlDocument("root");
            beanToXml.addElement(bean);
            System.out.println(beanToXml.parseText("UTF-8")+"\n");
            //DocumentBeanParser.parseBean();
        }catch(Exception e){
            fail(e.getMessage());
        }
    }
    
    public void testParseList(){
        SampleBean1 child = new SampleBean1();
        child.setId(1);
        child.setName("child1");
        
        SampleBean1 child2 = new SampleBean1();
        child2.setId(2);
        child2.setName("child2");
        
        List childs = new ArrayList();
        childs.add(child);
        childs.add(child2);
        try{
            BeanToXmlDocument beanToXml = new BeanToXmlDocument("root");
            
            //}bsO`
            beanToXml.replaceClassToTagName(SampleBean1.class.getName(), "sample_bean");
            
            //IuWFNgǉ
            beanToXml.addElement(childs);
            
            Document document = beanToXml.getDocument();
            
            String text = beanToXml.parseTextIndent("utf-8");
            System.out.println("---- test2 start ----");
            System.out.println(text);
            System.out.println("---- test2 end ----");
            
            DomParser parser = new DomParser(document);
            
            NodeList beanNodes = parser.getElementsByTagNames("root.list.sample_bean" );
            for(int i=0; i<beanNodes.getLength(); i++){
                Node beanNode = beanNodes.item(i);
                System.out.println(beanNode.getNodeName());
                Node idNode = parser.getFirstElementsByTagNames(beanNode.getChildNodes(), "id");
                Node nameNode = parser.getFirstElementsByTagNames(beanNode.getChildNodes(), "name");
                
                System.out.println("id="+idNode.getChildNodes().item(0).getNodeValue());
                System.out.println("name="+nameNode.getChildNodes().item(0).getNodeValue());
            }
        }catch(Exception e){
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
}
