package test.org.itscool.commons.pool;

import junit.framework.TestCase;

import org.itscool.commons.pool.ObjectPool;
import org.itscool.commons.pool.ObjectPoolEventListener;
import org.itscool.commons.pool.ObjectPoolRuntimeException;

public class ObjectPool2Test extends TestCase implements ObjectPoolEventListener{
	ObjectPool pool = null;
	int id = 0;
	
	public ObjectPool2Test(){
		/* v[̏TCY=1 őTCY=2̃v[쐬 */
		pool = new ObjectPool(this, 1, 2);
		/* IuWFNgv[ɃZbg */
		pool.addNewElement(String.valueOf(++id));
	}
	
	/**
	 * v[IuWFNg擾
	 */
	public void testGetElement(){
		Object elem = pool.getElement();
		assertNotNull(elem);
		assertEquals(elem.toString(), "1");
		pool.returnElement(elem);
	}
	
	/**
	 * v[IuWFNgAŎ擾
	 * ڂdoMissingElementEvent()CxgŐVK
	 * 쐬ꂽ̂擾鎖
	 */
	public void testGetElement2(){
		Object elem = pool.getElement();
		assertNotNull(elem);
		assertEquals(elem.toString(), "1");
		Object elem2 = pool.getElement();
		assertNotNull(elem2);
		assertEquals(elem2.toString(), "2");
		pool.returnElement(elem);
		pool.returnElement(elem2);
	}
	
	/**
	 * v[IuWFNgOAŎ擾
	 * v[̍ől͂QȂ̂3ڂgetElement
	 * ObjectPoolRuntimeException鎖
	 */
	public void testGetElement3(){
		try{
			pool.getElement();
			pool.getElement();
			Object elem = pool.getElement();
			fail("??? "+ elem.toString());
		}catch(ObjectPoolRuntimeException e){
			//OK!
		}
	}
	
	public void doReleaseElementEvent(Object obj){
		
	}
	
	public Object doMissingElementEvent(){
		String str = String.valueOf(++id);
		return str;
	}
}