package org.itscool.commons.bean;


import java.io.IOException;
import org.itscool.commons.collection.KeyLinkedList;

import org.itscool.commons.document.XmlConfigReader;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Bean`t@C(di-config.xml)͂NXł<br/>
 * Bean`t@C͈ȉ̏ō쐬Ă<br/>
 *
 * Bean`t@C̋Lq<hr>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS" ?&gt;
 * &lt;di-config&gt;
 *     &lt;bean-mappings&gt;
 *         &lt;bean id="sample" type="SampleBeanImpl"&gt;
 *             &lt;property name="id" value="1"/&gt;
 *             &lt;property name="name" value="ios taro"/&gt;
 *             &lt;property name="age" value="32"/&gt;
 *             &lt;property name="child" ref="child"/&gt;
 *         &lt;/bean&gt;
 *         &lt;bean&gt;
 *             &lt;bean id="child" type="SampleChild"&gt;
 *             &lt;property name="name" value="ios Jr"/&gt;
 *         &lt;/bean&gt;
 *         &lt;bean id="params" type="SampleParams" singleton="true"&gt;
 *         &lt;property name="infos" collection="map"&gt;
 *             &lt;bean id="encoding" type="java.lang.String" value="Shift_JIS"/&gt;
 *             &lt;bean id="weber-config" value="weber-config.xml"/&gt;
 *             &lt;bean id="stylist-config" value="stylist-config.xml"/&gt;
 *             &lt;bean id="message-config" value="message-config.xml"/&gt;
 *         &lt;/property&gt;
 *         &lt;/bean&gt;
 *     &lt;/bean-mappings&gt;
 * &lt;/di-config&gt;
 * </pre>
 *
 * <p>
 * ^O̐<hr><br/>
 * &lt;di-config&gt; FK{ڂłiBean`t@C1`)<br/>
 * &lt;bean-mappings&gt;FK{ڂłiBean`t@C1`j<br/>
 * &lt;bean&gt;JavaBeans`܂<br/>
 * &lt;bean&gt;^O͍XɈȉ̑w肵܂<br/>
 * @idFJavaBeans̘_<BR>
 * @nameFJavaBeanś̕ipbP[W܂߂NXj<br/>
 * @singletonFVOgNX̏ꍇtruew肵Ă<br/>
 * </p>
 * <p>
 * &lt;property&gt;FJavaBeans̃vpeB`܂<br/>
 * &lt;property&gt;^O͍XɈȉ̑w肵܂<br/>
 * @nameF̖OiJavaBeansł͂̑ɑΉANZbT\bhKvłj<br/>
 * @valueFvpeB̏l<br/>
 * @refFvaluȇrefw肷邱Ƃł܂B<br/>
 * @ref́ABean`t@Cɒ`ꂽʂJavaBeans_̂Ŏw肷邱Ƃł܂B<br/>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1 VK쐬
 * @version 1.10A 2006/01/17 zێΉ
 */
public class BeanConfigReader extends XmlConfigReader{
    /**
     * &lt;bean-mappings&gt;vf͂܂<br>
     * ͌ʂhashMapɃZbg܂<br>
     * @param hashMap XML̉͌
     */
    protected void doCreate(KeyLinkedList hashMap) throws IOException{
        
        /* [g^O擾 */
        Element root = document.getDocumentElement();
        if( root == null ){
            String err = "Can not root element at di-config.xml(" +
                getClass().getName()+")";
            throw new IOException(err);
        }
        
        /* action-mappings ̎擾*/
        NodeList mappingsList = root.getElementsByTagName("bean-mappings");
        if( mappingsList == null ){
            String err = "Can not element at <bean-maggpins>(" +
                getClass().getName()+")";
            throw new IOException(err);
        }
        
        Node mappings = mappingsList.item(0);
        if( mappings != null ){
            createMappings(mappings, hashMap);
        }
    }
    
    /**
     * &lt;bean-mappings&gt;vf͂܂
     * @param mappings &lt;bean-mappings&gt;vf
     * @param hashMap ͌&lt;bean&gt;ǉm[hXg
     * @throws Exception
     */
    protected void createMappings(Node mappings, KeyLinkedList hashMap)
    throws IOException{
        NodeList mappingsChilds = mappings.getChildNodes();
        
        for( int i = 0; i < mappingsChilds.getLength(); i++) {
            Node beanInfoNode = mappingsChilds.item(i);
            if( beanInfoNode.getNodeName().equals("bean")){
                createBeanInfo(beanInfoNode, hashMap);
            }
        }
    }
    
    /**
     * &lt;beanInfoNode-mappings&gt;vf̑Ǝqvf͂܂
     * @param beanInfoNode &lt;beanInfoNode&gt;vf
     * @param hashMap ͌&lt;beanInfoNode&gt;ǉm[hXg
     * @throws Exception
     */
    protected void createBeanInfo(Node beanInfoNode, KeyLinkedList hashMap)
    throws IOException{
        NamedNodeMap attributes = beanInfoNode.getAttributes();
        Node id = attributes.getNamedItem("id");
        Node type = attributes.getNamedItem("type");
        Node singleton = attributes.getNamedItem("singleton");
        Node value = attributes.getNamedItem("value");
        Node collection = attributes.getNamedItem("collection");
        
        if( id == null || id.getNodeName().length() == 0){
            throw new IOException("bean tag's id is null");
        }
        String typeStr;
        if( type == null || type.getNodeName().length() == 0){
            typeStr="java.lang.String";
        }else{
            typeStr = type.getNodeValue();
        }
        
        BeanInfoMapping beanMapping =
            new BeanInfoMapping(id.getNodeValue(), typeStr);
        if( value != null && value.getNodeName().length() > 0 ){
            String valueStr = value.getNodeValue();
            beanMapping.setValue(valueStr);
        }
        if( singleton != null && singleton.getNodeName().length() > 0){
            boolean ret = new Boolean(singleton.getNodeValue()).booleanValue();
            beanMapping.setSingleton(ret);
        }
        NodeList childs = beanInfoNode.getChildNodes();
        for( int i=0; i<childs.getLength(); i++){
            Node child = childs.item(i);
            if( child.getNodeName().equals("property")){
                createProerty(child, beanMapping);
            }
        }
        
        hashMap.put( beanMapping.getId(), (Object)beanMapping );
        
    }
    
    /**
     * &lt;bean&gt;vf̎qvfi&lt;property&gt;j͂܂
     * @param propertyNode &lt;forward&gt;vf
     * @param beanMapping ͌&lt;forward&gt;ǉ
     *              ActionMappingCX^X
     * @throws Exception
     */
    protected void createProerty(Node propertyNode, BeanInfoMapping beanMapping)
    throws IOException{
        NamedNodeMap attributes = propertyNode.getAttributes();
        Node name = attributes.getNamedItem("name");
        Node value = attributes.getNamedItem("value");
        Node ref = attributes.getNamedItem("ref");
        
        Node collection = attributes.getNamedItem("collection");
        
        if( name == null || name.getNodeName().length() == 0){
            throw new IOException("property tag's name is null.");
        }
        
        BeanPropertyInfo property = new BeanPropertyInfo();
        property.setName(name.getNodeValue());
        if(value != null){
            property.setValue(value.getNodeValue());
        }else if(ref != null){
            property.setRef(ref.getNodeValue());
        }else if( collection != null ){
            //zvf쐬
            property.setCollection(collection.getNodeValue());
            createMappings(propertyNode, property.getAttrList());
        }
        
        beanMapping.addProperty(name.getNodeValue(), property);
    }
    
}
