package org.itscool.commons.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.connection.Record;
import org.itscool.commons.connection.Records;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionException;
import org.itscool.commons.connection.TransactionUtil;

/**
 * <p>{f[^ANZXNXł</p>
 * ̃NX̓f[^x[XPOJONXԂ}bsO邽߂̃C^[tF[X
 * 񋟂܂<br/>
 * </p>
 * <p>
 * insert(), update(), delete(), select()\bhSQLINSERTAUPDATE
 * DELETEASELECTs܂B<br/>
 * ̈ɂ͂CriteriaCX^Xw肷Kv܂B<br/>
 * CriteriaNX́Af[^x[X̃e[uƂPOJONXԂ̃}bsO
 * ܂܂Ă܂B<br/>
 * ڍׂ́Aorg.itscool.common.dao.Criteria̐QƂ<br/>
 * </p>
 * <p>
 * O/R}bsO@\𗘗pɂ́ÃNXpf[^ANZXNX
 * 쐬Ă<br/>
 * </p>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class BaseDao {
    /**
     * gUNVCX^X
     */
    protected Transaction transaction;
    
    public BaseDao(){
        transaction = TransactionUtil.getTransaction();
        if(transaction == null){
            throw new RuntimeException(BaseDao.class.getName() + " transaction is null.");
        }
    }
    
    public int getCount(String tableName){
        String sql = "SELECT COUNT(*) AS DATA_NUM FROM " + tableName;
        Transaction trn = TransactionUtil.getTransaction();
        Records records = trn.select(sql);
        Record record = (Record)records.get(0);
        int dataNum = record.getInt("DATA_NUM");
        
        return dataNum;
    }
    
    public int getCount(Criteria crt){
        Transaction trn = TransactionUtil.getTransaction();
        Records records = trn.select(crt.toCountString());
        Record record = (Record)records.get(0);
        int dataNum = record.getInt("DATA_NUM");
        
        return dataNum;
    }
    
    /**
     * DaoTransactionCX^X܂
     * @param trn TransactionCX^X
     */
    public void setTransaction(Transaction trn){
        this.transaction = trn;
    }
    
    /**
     * TransactionCX^X擾܂<BR>
     * SQL𒼐ڎsꍇ́ATransactionCX^X񋟂
     * \bhgp܂
     * @return TransactionCX^XԂ܂
     */
    public Transaction getTransaction() {
        return transaction;
    }
    
    /**
     * INSERTs܂
     * @param crt CriteriaCX^X
     * @param bean INSERTsBeanCX^X
     * @throws TransactionException
     */
    public int insert(Criteria crt, Object bean)
    throws TransactionException{
        String sql = crt.toInsertString(bean);
        return transaction.execute(sql);
    }
    
    /**
     * UPDATEs܂
     * @param crt CriteriaCX^X
     * @throws TransactionException
     */
    public int update(Criteria crt, Object bean)
    throws TransactionException{
        String sql = crt.toUpdateString(bean);
        
        //XVɎsR҃[U̍XVɊ̂`FbN
        int recNum = transaction.execute(sql);
        if( recNum > 0 ){
            return recNum;
        }
        String lckSql = crt.toSelectLockVersionString();
        if(lckSql==null){
            return recNum;
        }
        Record lckRec = transaction.selectOne(lckSql);
        if( lckRec == null ){
            return recNum;
        }
        int dbVersion = lckRec.getInt(FieldMap.FLD_LOCK_VERSION);
        Object obj = crt.getLockVersion(bean);
        if( obj instanceof Integer ){
            int beanVersion = Integer.parseInt(obj.toString());
            if( dbVersion != beanVersion ){
                String msg = "already update from other user.bean-version="
                    + beanVersion + " db-version=" + dbVersion;
                throw new LockVersionException(msg);
            }
        }else{
            return recNum;
        }
        return recNum;
    }
    
    /**
     * DELETEs܂
     * @param crt CriteriaCX^X
     * @throws TransactionException
     */
    public int delete(Criteria crt)
    throws TransactionException{
        String sql = crt.toDeleteString();
        return transaction.execute(sql);
    }
    
    /**
     * SELECTsAsʂBeanCX^X̔zŕԂ܂
     * @param crt CriteriaCX^X
     * @return SELECT̎sʂBeanCX^X̔zŕԂ܂
     * @throws TransactionException
     */
    public List select(Criteria crt) throws TransactionException{
        ArrayList result = new ArrayList();
        ArrayList list = null;
        
        //SQLs
        //sʂRecordNX̔zŎ擾܂
        list = transaction.select(crt.toSelectString());
        
        //CriteriaCX^XɃZbgꂽRecordMapCX^X擾܂
        RecordMap recordMap = crt.getRecord();
        //select\bhŎ擾RecordCX^XCrieteriaCX^X
        //ŃZbgĂRecordMapCX^XJavaBeansCX^X
        //܂
        for(int i=0; i<list.size(); i++){
            Record record = (Record)list.get(i);
            Object obj = createCurrentObject(crt, recordMap, record);
            
            HashMap oneToManyRecordMaps = crt.getOneToManyRecordMaps();
            Set mKeySet = oneToManyRecordMaps.keySet();
            Iterator mIt = mKeySet.iterator();
            int childCount=0;
            while(mIt.hasNext()){
                ArrayList childs = new ArrayList();
                String propertyName = (String)mIt.next();
                RecordMap oneToManyRecordMap = (RecordMap)oneToManyRecordMaps.get(propertyName);
                
                for( childCount=i;childCount<list.size(); childCount++){
                    Record child = (Record)list.get(childCount);
                    Object oneToManyObj = createObject(oneToManyRecordMap, child);
                    childs.add(oneToManyObj);
                    
                    Object chkObj = createObject(recordMap, child);
                    if( !RecordMap.isEquals(obj, chkObj, recordMap)){
                        if( childCount > 1 ){
                            childCount --;
                        }
                        break;
                    }
                }
                BeanUtil.setProperty(obj, propertyName, childs);
            }
            if( crt.isOneToMany() ){
                i = childCount;
            }
            
            result.add(obj);
        }
        
        return result;
    }

    private Object createCurrentObject(Criteria crt, RecordMap recordMap, Record record) 
    throws TransactionException {
        
        Object obj = createObject(recordMap, record);
        //OQƏ̎擾
        HashMap fkRecordMaps = crt.getFkRecordMaps();
        Set keySet = fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        //OQƏ񂪒`Ăꍇ́AOQƏɕRtlR[h
        //擾AOQƃIuWFNg쐬
        while(it.hasNext()){
            String propertyName = (String)it.next();
            //OQƗpRecordMapCX^X擾
            RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(propertyName);
            Object fkObj = createObject(fkRecordMap, record);
            //OQƃIuWFNgʃIuWFNgɃZbg
            BeanUtil.setProperty(obj, propertyName, fkObj);
        }
        return obj;
    }
    
    /**
     * Transaction.select\bhŎ擾RecordCX^XCriteriaCX^X
     * ŃZbgĂRecordMapCX^XJavaBeansCX^X𐶐܂
     * @param recordMap RecordMapCX^X
     * @param record RecordCX^X
     * @return ꂽJavaBeansCX^XԂ܂
     * @throws TransactionException
     */
    private Object createObject(RecordMap recordMap, Record record)
    throws TransactionException{
        Object obj = BeanUtil.createInstance(recordMap.getClassName());
        //RecordMap newRecord = new RecordMap(recordMap.getClassName(), recordMap.getTableName());
        Set keySet = recordMap.getFields().keySet();
        Iterator it = keySet.iterator();
        while( it.hasNext() ){
            Object key = it.next();
            FieldMap field = (FieldMap)recordMap.getFields().get(key);
            Object value = record.get(field.getColumAsName());
            
            try{
                //BeanUtil.setProperty(obj,field.getPropertyName(),value);
                field.setPropertyValue(obj, value);
            }catch(Exception e){
                System.out.print(obj.getClass().getName() + ":");
                System.out.print(field.getPropertyName());
                System.out.println( ":" + value);
                e.printStackTrace();
            }
        }
        return obj;
    }
    /**
     * USERe[uVid擾܂
     * @return VKo^pidԂ܂
     */
    public int getNewId(String tableName, String pkCulomName){
        int id = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select MAX(");
        sql.append(tableName).append(".").append(pkCulomName);
        sql.append(") AS NEW_ID FROM ").append(tableName);
        
        Records result = transaction.select(sql.toString());
        if(result.size() > 0){
            Record record = (Record)result.getRecord(0);
            id = record.getInt("NEW_ID");
            id ++;
        }
        return id;
    }
    
    public int getNewId(String tableName){
        int id = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select COUNT(*) AS NEW_ID FROM " + tableName);
        
        Records result = transaction.select(sql.toString());
        if(result.size() > 0){
            Record record = (Record)result.getRecord(0);
            id = record.getInt("NEW_ID");
            id ++;
        }
        return id;
    }
    
    /**
     * AUTONUMBERe[ugUSERe[uVid
     * 擾܂
     * @return VKo^pidԂ܂
     */
    public int getNewIdFromAutoNumber(String tableName){
        int id = 0;
        AutoNumberDao dao = new AutoNumberDao();
        try{
            id = dao.getNext(tableName);
        }catch(Exception e){
            id = getNewId(tableName);
        }
        return id;
    }
}
