package org.itscool.commons.document;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * JavaBeansIuWFNgwlkhLgɓWJ邽߂̃NXł
 * @version 1.00A 2006/08/23 VK쐬
 * @author kano
 *
 */
public class BeanToXmlDocument extends XmlDocument{
    
    /**
     * [gurootNamevŎw肵VDocumentCX^X
     * 쐬܂
     * @param rootName ̃hLg̃[gvf̖O
     * @throws Exception
     */
    public BeanToXmlDocument(String rootName) throws Exception{
        super(rootName);
    }
    
    /**
     * w肳ꂽDocumentCX^Xg܂
     * @param document DocumentCX^X
     * @throws Exception
     */
    public BeanToXmlDocument(Document document) throws Exception{
        super(document);
    }
    
    /**
     * w肳ꂽIuWFNghLgɒǉ܂
     * @param bean hLgɒǉIuWFNg
     * @param elementName IuWFNg̗vfiNULLw肵ꍇ
     * NXZbg܂j
     * @throws Exception
     */
    public void addElement(Object bean, String elementName) throws Exception{
        Class clazz = bean.getClass();
        DocumentBean pBean = DocumentBeanParser.parseBean(bean, clazz, this);
        if( elementName != null ){
            pBean.setName(elementName);
        }
        addElement(pBean);
    }
    
    /**
     * w肳ꂽIuWFNghLgɒǉ܂<BR>
     * vf̓IuWFNg̃NXZbg܂
     * @param bean hLgɒǉIuWFNg
     * @throws Exception
     */
    public void addElement(Object bean) throws Exception{
        Class clazz = bean.getClass();
        DocumentBean pBean = DocumentBeanParser.parseBean(bean, clazz, this);
        addElement(pBean);
    }
    
    /**
     * Objectzɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param objects hLgɒǉObjectz
     * @param elementName IuWFNg̗vf
     * @throws Exception
     */
    public void addElement(Object[] objects, String elementName) throws Exception{
        DocumentBean pParentBean = new DocumentBean();
        pParentBean.setName(elementName);
        for( int i=0; i<objects.length; i++){
            Object bean = objects[i];
            if( bean == null ) continue;
            Class clazz = bean.getClass();
            DocumentBean pBean = DocumentBeanParser.parseBean(bean, clazz, this);
            pParentBean.add(pBean);
        }
        addElement(pParentBean);
    }
    
    /**
     * Objectzɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param objects hLgɒǉObjectz
     * @throws Exception
     */
    public void addElement(Object[] objects) throws Exception{
        addElement(objects, "array");
    }
    
    /**
     * ListCX^Xɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param list hLgɒǉListCX^X
     * @param elementName IuWFNg̗vf
     * @throws Exception
     */
    public void addElement(List list, String elementName) throws Exception{
        DocumentBean pParentBean = new DocumentBean();
        pParentBean.setName(elementName);
        for( int i=0; i<list.size(); i++){
            Object bean = list.get(i);
            if( bean == null ) continue;
            Class clazz = bean.getClass();
            DocumentBean pBean = DocumentBeanParser.parseBean(bean, clazz, this);
            pParentBean.add(pBean);
        }
        addElement(pParentBean);
    }
    
    /**
     * ListCX^Xɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param list hLgɒǉListCX^X
     * @throws Exception
     */
    public void addElement(List list) throws Exception{
        addElement(list, "list");
    }
    
    /**
     * MapCX^Xɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param map hLgɒǉMapCX^X
     * @param elementName IuWFNg̗vf
     * @throws Exception
     */
    public void addElement(Map map, String elementName) throws Exception{
        DocumentBean pParentBean = new DocumentBean();
        pParentBean.setName(elementName);
        Set set = map.keySet();
        Iterator it = set.iterator();
        while( it.hasNext()){
            Object key = it.next();
            Object bean = map.get(key);
            if( bean == null ) continue;
            Class clazz = bean.getClass();
            DocumentBean pBean = DocumentBeanParser.parseBean(bean, clazz, this);
            pParentBean.add(pBean);
        }
        addElement(pParentBean);
    }
    
    /**
     * MapCX^Xɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param map hLgɒǉMapCX^X
     * @throws Exception
     */
    public void addElement(Map map) throws Exception{
        addElement(map, "map");
    }
    
    /**
     * JavaBeansWJIuWFNghLgɒǉ܂
     * @param pBean hLgɒǉParseBeanCX^X
     * @throws Exception
     */
    protected void addElement(DocumentBean pBean) throws Exception{
        Element root = document.getDocumentElement();
        Element beanElement = document.createElement(pBean.getName());
        int size = pBean.size();
        for(int i=0; i<size; i++){
            DocumentBean child = (DocumentBean)pBean.get(i);
            
            String name = child.getName();
            String value = (String)child.getValue();
            
            Element element = document.createElement(name);
            if( value != null){
                element.appendChild(document.createTextNode(value));
            }
            addChild(child, element);
            beanElement.appendChild(element);
        }
        root.appendChild(beanElement);
    }
    
    /**
     * ElementCX^XɎqDocumentBeanCX^Xǉ܂
     * @param pBean qDocumentBeanCX^X
     * @param element eElementCX^X
     * @throws Exception
     */
    protected void addChild(DocumentBean pBean, Element element) throws Exception{
//        Set set = pBean.keySet();
//        Iterator it = set.iterator();
//        while(it.hasNext()){
        int size = pBean.size();
        for(int i=0; i<size; i++){
            DocumentBean child = (DocumentBean)pBean.get(i);
            String name = child.getName();
            String value = (String)child.getValue();
//            if(object instanceof DocumentBean){
                Element childElement = document.createElement(name);
                if( value != null ){
                    childElement.appendChild(document.createTextNode(value));
                }
                if(child.size() > 0){
                    addChild(child, childElement);
                }
                element.appendChild(childElement);
//            }else{
//                String value = object.toString();
//                Element childElement = document.createElement(name);
//                childElement.appendChild(document.createTextNode(value));
//                element.appendChild(childElement);
//            }
        }
        
    }
}



