package org.itscool.commons.logging;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * ONX̒ۃX[p[NXł
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public abstract class AbstractLog {
    
    /** O F g[Xp */
    public static final String TRACE = "trace";
    /** Oʁ@F@fobOp */
    public static final String DEBUG = "debug";
    /** O F CtH[Vp */
    public static final String INFO = "info";
    /** O F xp */
    public static final String WARN = "warn";
    /** O F G[Oo */
    public static final String ERROR = "error";
    /** O F G[Oo */
    public static final String FATAL = "fatal";
    /** Oo̓[hFR\[ */
    public static final String DISP_MODE = "disp";
    /** Oo̓[hFt@C */
    public static final String FILE_MODE = "file";
    /** Oo̓[hFR\[/t@C */
    public static final String ALLOUT_MODE = "all";
    
    protected boolean init;
    /**
     * t@C̍őTCYiKByte)
     */
    protected int maxSize;  //KByte
    
    /**
     * t@C܂߂pX
     */
    protected String logPath;
    
    /**
     * Ȍo̓x
     */
    protected String level = WARN;
    protected int levelInt = 2;
    
    /**
     * Ȍo̓[h
     */
    protected String mode = DISP_MODE;
    
    /**
     * GR[fBO
     */
    protected String encode;
    
    /**
     * Oo͑ΏۃNX`̈ꗗ
     */
    protected List traces = null;
    protected List debugs = null;
    protected List infos = null;
    protected List warns = null;
    protected List errors = null;
    protected List fatals = null;
    
    /**
     * Oo͑ΏۃNX`̈ꗗZbg܂
     * @param infos Oo͑ΏۃNẌꗗ
     */
    public void setInfos(List infos){
        this.infos = infos;
    }
    
    /**
     * Oo͑ΏۃNX`̈ꗗ擾܂
     * @return Oo͑ΏۃNẌꗗԂ܂
     */
    public List getInfos(){
        return infos;
    }
    
    
    /**
     * w肳ꂽNXOo͑Ώۂɍv邩肵܂
     * @param clazzName ΏۃNX
     * @return p^[Ƀ}b`ꍇtrueԂ܂
     */
    public boolean isOutputClass(String clazzName, String levelNow){
        boolean ret = false;
        if( levelNow.equals(AbstractLog.TRACE) && isOutputClass(traces, clazzName) ){
            return true;
        }
        else if( levelNow.equals(AbstractLog.DEBUG) && isOutputClass(debugs, clazzName) ){
            return true;
        }
        else if( levelNow.equals(AbstractLog.INFO) && isOutputClass(infos, clazzName) ){
            return true;
        }
        else if( levelNow.equals(AbstractLog.WARN) && isOutputClass(warns, clazzName) ){
            return true;
        }
        else if( levelNow.equals(AbstractLog.FATAL) && isOutputClass(errors, clazzName) ){
            return true;
        } else {
            return true;
        }
    }
    
    protected boolean isOutputClass(List levels, String clazzName){
        boolean ret = false;
        
        //`o^́AȌo̓xɈˑ
        if(levels == null){
            return true;
        }
        int size = levels.size();
        
        //Oo͑ΏۃNX
        for(int i=0; i<size; i++ ){
            String pattern = (String)levels.get(i);
            if(clazzName.indexOf(pattern) == 0 ){
                return true;
            }
        }
        
        return ret;
    }
    
    /**
     * Ox擾܂
     * @return level
     */
    public String getLevel() {
        return level;
    }
    /**
     * OpX擾܂
     * @return logPath
     */
    public String getLogPath() {
        return logPath;
    }
    /**
     * OMAXTCY擾܂
     * @return maxSize
     */
    public int getMaxSize() {
        return maxSize;
    }
    /**
     * Ȍo̓[h擾܂
     * @return mode
     */
    public String getMode() {
        return mode;
    }
    
    public abstract void trace(String msg);
    
    public abstract void debug(String msg);
    
    public abstract void info(String msg);
    
    public abstract void warn(String msg);
    
    public abstract void error(String msg);
    
    public abstract void fatal(String msg);
    
    public abstract void trace(Exception msg);
    
    public abstract void debug(Exception msg);
    
    public abstract void info(Exception msg);
    
    public abstract void warn(Exception msg);
    
    public abstract void error(Exception msg);
    
    public abstract void fatal(Exception msg);
    
    public abstract void trace(Error msg);
    
    public abstract void debug(Error msg);
    
    public abstract void info(Error msg);
    
    public abstract void warn(Error msg);
    
    public abstract void error(Error msg);
    
    public abstract void fatal(Error msg);
    
    protected abstract void out(String logMsg, String levelNow, int classLevel);
    protected abstract void out(Exception logMsg, String levelNow);
    protected abstract void out(Error logMsg, String levelNow);
    
    /**
     * Ox̎擾
     * @param levelNow Ox
     * @return Ox̖̂𕶎ŕԂ܂B
     */
    public static String getLogKind( String levelNow){
        if( levelNow.equals(TRACE)){
            return "DEBUG";
        }else if( levelNow.equals(INFO)){
            return "INFO ";
        }else if( levelNow.equals(WARN)){
            return "WORN ";
        }else if( levelNow.equals(ERROR)){
            return "ERROR";
        }else if( levelNow.equals(FATAL)){
            return "SYSTEM";
        }else{
            return "DEBUG";
        }
    }
    
    /**
     * Oo̓[h̎擾
     * @param mode Oo̓[h
     * @return Oo̓[ĥ̖𕶎ŕԂ܂B
     */
    public static String getLogMode( String mode){
        if( mode.equals(DISP_MODE)){
            return "DISP ONLY";
        }else if( mode.equals(FILE_MODE)){
            return "FILE ONLY";
        }else{
            return "DISP & FILE ";
        }
    }
    
    /**
     * ݎ̎擾
     *
     * @return yyyy/mm/dd/ hh:mimi:ss:msmsmsms `̎
     */
    protected static String getNowDate(){
        //~bPʂŕ\B
        Calendar date = Calendar.getInstance();
        int year =date.get(Calendar.YEAR);
        int month = date.get(Calendar.MONTH) + 1;
        int day = date.get(Calendar.DATE);
        int hour = date.get(Calendar.HOUR_OF_DAY);
        int minute = date.get(Calendar.MINUTE);
        int second = date.get(Calendar.SECOND);
        String monthPadding="";
        String dayPadding = "";
        String hourPadding = "";
        String minutePadding = "";
        String secondPadding = "";
        if( month < 10 ){
            monthPadding = "0";
        }
        if( day < 10 ){
            dayPadding = "0";
        }
        if( hour < 10 ){
            hourPadding = "0";
        }
        if( minute < 10 ){
            minutePadding = "0";
        }
        if( second < 10 ){
            secondPadding ="0";
        }
        //String mSecond = String.valueOf(date.get(Calendar.MILLISECOND ));
        StringBuffer ret = new StringBuffer();
        ret.append(year).append("/");
        ret.append(monthPadding).append(month).append("/");
        ret.append(dayPadding).append(day).append(" ");
        ret.append(hourPadding).append(hour).append(":");
        ret.append(minutePadding).append(minute).append(":");
        ret.append(secondPadding).append(second );
        
        return ret.toString();
    }
    
    /**
     * ݎ̎擾
     *
     * @return yyyymmddHHMMSS `̎
     */
    protected static String getNowDateYYYYMMDDHHMMSS(){
        //~bPʂŕ\B
        Calendar date = Calendar.getInstance() ;
        String year = String.valueOf(date.get(Calendar.YEAR));
        String month = String.valueOf(date.get(Calendar.MONTH));
        String day = String.valueOf(date.get(Calendar.DATE));
        String hour = String.valueOf(date.get(Calendar.HOUR));
        String minute = String.valueOf(date.get(Calendar.MINUTE));
        String second = String.valueOf(date.get(Calendar.SECOND ));
        return ( year + month + day + hour + minute + second );
    }
    
    /**
     * ݓ̎擾
     *
     * @return yyyymmdd `̎
     */
    protected static String getNowDateYYYYMMDD(){
        //~bPʂŕ\B
        Calendar date = Calendar.getInstance() ;
        String year = String.valueOf(date.get(Calendar.YEAR));
        String month = String.valueOf(date.get(Calendar.MONTH));
        String day = String.valueOf(date.get(Calendar.DATE));
        
        return ( year + month + day );
    }
    
    /**
     * Ot@C̃TCY`FbN Ot@C̑傫ȏ
     * ł΃obNAbvt@CɒǉB
     * obNAbvt@C̑傫ȏł΁AobNAbv
     * 쐬B
     */
    protected synchronized void sizeCheck(){
        File file = new File( logPath  );
        
        if( file.canRead() ){
            //maxSize𒴂ꍇ̓obNAbvt@CɎcB
            if( file.length() >= ( maxSize * 1024 ) ){
                file.renameTo( new File( logPath + "." + getNowDateYYYYMMDDHHMMSS() ));
            }
        }
        file = null;
    }
    /**
     * @return GR[hԂ܂
     */
    public String getEncode() {
        return encode;
    }
    public void setEncode(String encode) {
        this.encode = encode;
    }
    public void setLevel(String level) {
        this.level = level;
        levelInt = getLevelNum(level);
    }
    protected int getLevelNum(String level) {
        this.level = level;
        if( level.equals(TRACE)){
            return 0;
        }else if( level.equals(DEBUG)){
            return 1;
        }else if( level.equals(INFO)){
            return 2;
        }else if( level.equals(WARN)){
            return 3;
        }else if( level.equals(ERROR)){
            return 4;
        }else if( level.equals(FATAL)){
            return 5;
        }else{
            return 1;
        }
    }
    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
    public void setMode(String mode) {
        this.mode = mode;
    }
    public boolean isInit() {
        return init;
    }
    public void setInit(boolean init) {
        this.init = init;
    }

    public List getTraces() {
        return traces;
    }

    public void setTraces(List debugs) {
        this.traces = debugs;
    }

    public List getWarns() {
        return warns;
    }

    public void setWarns(List warns) {
        this.warns = warns;
    }

    public List getErrors() {
        return errors;
    }

    public void setErrors(List errors) {
        this.errors = errors;
    }

    public List getFatals() {
        return fatals;
    }

    public void setFatals(List fatals) {
        this.fatals = fatals;
    }

    public List getDebugs() {
        return debugs;
    }

    public void setDebugs(List debugs) {
        this.debugs = debugs;
    }
    
}
