package org.itscool.commons.request;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/**
 * FilterT[ubgɈn_~[HttpServletResponseCX^Xł
 * @author KANO
 */
public class CustomPageResponseWrapper extends HttpServletResponseWrapper{
    private ByteArrayOutputStream byteStream;
    private ServletOutputStream servStream;
    private PrintWriter prWriter;
    private String localContentType = null;
    
//add 2006/11/28 kano start
    /**
     * ContentTypeZbg܂
     * @param contentType Reg^Cv
     */
    public void setContentType(String contentType){
    	super.setContentType(contentType);
    	this.localContentType = contentType;
//    	System.out.println("CustomPageResponseWrapper" + getContentType());
    }
    
    /**
     * ContentType擾܂
     * @return Reg^Cv
     */
    public String getContentType(){
    	return localContentType;
    }
    
//add 2006/11/28 kano end
    
    public CustomPageResponseWrapper(HttpServletResponse res ) throws IOException{
        super(res);
        
        byteStream = new ByteArrayOutputStream();
        servStream = new MyJspOutputStream(byteStream);
        prWriter = new PrintWriter(byteStream);
    }
    
    //UOutputStreamԂ悤ɂĂ
    public ServletOutputStream getOutputStream() throws IOException{
        return servStream;
    }
    
    //UOutputWriterԂ悤ɂĂ
    public PrintWriter getWriter() throws IOException{
        return prWriter;
    }
    
    public void flushBuffer() throws IOException{
    }
    /**
     * @return ByteStreamCX^XԂ܂
     */
    public ByteArrayOutputStream getByteStream() {
        return byteStream;
    }

}

//{ServletOutputStream̕ςɃobt@ɗߍł܂
//UServletOutputStream
class MyJspOutputStream extends ServletOutputStream{
    private ByteArrayOutputStream byteStream;
    
    public MyJspOutputStream(ByteArrayOutputStream byteStream){
        this.byteStream = byteStream;
    }
    
    public void close() throws IOException{
        byteStream.close();
    }
    
    public void flush() throws IOException{
        byteStream.flush();
    }
    
    public void write(byte[] b) throws IOException{
        byteStream.write(b);
    }
    
    public void write(byte[] b, int offset, int len) throws IOException{
        byteStream.write(b, offset, len);
    }
    
    public void write(int b) throws IOException{
        byteStream.write(b);
    }
    /**
     * @return
     */
    public ByteArrayOutputStream getByteStream() {
        return byteStream;
    }

    /**
     * @param stream
     */
    public void setByteStream(ByteArrayOutputStream stream) {
        byteStream = stream;
    }

}
