package org.itscool.commons.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * tR|[lgp[eBeBNXł
 */
public class DateFormatUtil {
    private static final int[] DAY_OF_KIND = { 4, 6, 9, 11 };
    
    public static Date createDate(int year, int month, int day){
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.MONTH, month-1);
        cal.set(Calendar.DAY_OF_MONTH, day);
        Date date = cal.getTime();
        return date;
    }
    
    public static Date createMonth(int year, int month){
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.MONTH, month-1);
        Date date = cal.getTime();
        return date;
    }
    
    /**
     * ̓擾܂
     * @param cal CalendarCX^X
     * @return ̓
     */
    public static int getMaxDay(Calendar cal){
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        
        if(month==2){
            if( (year%4==0 && year%100!=0) || (year%400==0) ){
                return 29;
            }else{
                return 28;
            }
        }
        
        for(int i=0; i<DAY_OF_KIND.length; i++){
            if( DAY_OF_KIND[i] == month){
                return 30;
            }
        }
        return 31;
    }
    
    /**
     * 挎̍ŏIT̓jCalendarCX^XŎ擾
     * @param year N
     * @param month 
     * @return CalendarCX^XԂ܂
     */
    public static Calendar getLastMonthWeek(int year, int month ){
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.MONTH, month-1);
        cal.set(Calendar.DAY_OF_MONTH, 1);
        int firstYobi = cal.get(Calendar.DAY_OF_WEEK);
        cal.add(Calendar.DAY_OF_MONTH, -( firstYobi-1 ));
        return cal;
    }
    
    /**
     * ݓyy/mm/dd`Ŏ擾܂
     *
     * @return ݓyy/mm/ddŕԂ܂
     */
    public static String encodeYYMMDDString(){
        Calendar cal = Calendar.getInstance();
        return encodeYYMMDDString(cal);
    }
    
    
    /**
     * wyy/mm/dd`Ŏ擾܂
     * @param cal CalendarCX^X
     * @return wyy/mm/ddŕԂ܂
     */
    public static String encodeYYMMDDString(Calendar cal){
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH)+1;
        int day = cal.get(Calendar.DAY_OF_MONTH);
        
        String yearStr = String.valueOf(year).substring(2, 4);
        String monthStr = NumberFormatUtil.convZeroPadding(month, 2);
        String dayStr = NumberFormatUtil.convZeroPadding(day, 2);
        
        String ret = yearStr + "/" + monthStr + "/" + dayStr;
        
        return ret;
    }
    
    /**
     * wyy/mm/dd`Ŏ擾܂
     * @param date DateCX^X
     * @return wyy/mm/ddŕԂ܂
     */
    public static String encodeYYMMDDString(Date date){
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH)+1;
        int day = cal.get(Calendar.DAY_OF_MONTH);
        
        String yearStr = String.valueOf(year).substring(2, 4);
        String monthStr = NumberFormatUtil.convZeroPadding(month, 2);
        String dayStr = NumberFormatUtil.convZeroPadding(day, 2);
        
        String ret = yearStr + "/" + monthStr + "/" + dayStr;
        
        return ret;
    }
    
    /**
     * ݓyyyy/mm/dd`Ŏ擾܂
     *
     * @return ݓyyyy/mm/ddŕԂ܂
     */
    public static String encodeYYYYMMDDString(){
        Calendar cal = Calendar.getInstance();
        return encodeYYYYMMDDString(cal);
    }
    
    /**
     * wyyyy/mm/dd`Ŏ擾܂
     * @param cal CalendarCX^X
     * @return wyyyy/mm/ddŕԂ܂
     */
    public static String encodeYYYYMMDDString(Calendar cal){
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH)+1;
        int day = cal.get(Calendar.DAY_OF_MONTH);
        
        String yearStr = String.valueOf(year);
        String monthStr = NumberFormatUtil.convZeroPadding(month, 2);
        String dayStr = NumberFormatUtil.convZeroPadding(day, 2);
        
        String ret = yearStr + "/" + monthStr + "/" + dayStr;
        
        return ret;
    }
    
    /**
     * yyyy/MM/dd`̕CalendarCX^Xɕϊ܂
     * @param yyyymmdd yyyy/MM/dd`̓t
     * @return CalendarCX^X
     */
    public static Calendar decodeYYYYMMDDString(String yyyymmdd){
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        try{
            StringTokenizer dataSt = new StringTokenizer(yyyymmdd, "/");
            dataSt.hasMoreTokens();
            int year = Integer.parseInt(dataSt.nextToken());
            dataSt.hasMoreTokens();
            int month = Integer.parseInt(dataSt.nextToken());
            dataSt.hasMoreTokens();
            int day = Integer.parseInt(dataSt.nextToken());
            cal.set(Calendar.YEAR, year);
            cal.set(Calendar.MONTH, month - 1 );
            cal.set(Calendar.DAY_OF_MONTH, day);
            return cal;
        }catch(Exception e){
            return null;
        }
    }
    
    /**
     * w肳ꂽCalendarCX^Xɕϊ\肷
     * @param str 蕶iyyyy/mm/dd`j
     * @return 蕶񂪐lϊ\ȏꍇtrueԂ܂
     */
    public static boolean isCalendar(String str){
        Calendar cal = decodeYYYYMMDDString(str);
        if( cal != null ){
            return true;
        }else{
            return false;
        }
    }
    
    /**
     * ܂܂ȓt^񂩂DateCX^Xɕϊ郁\bh
     * @param str t
     * @return DateCX^XԂ܂
     */
    public static Date parse(String str){
        if( str == null || str.length() == 0 ){
            return null;
        }
        str = str.trim();
        String format = searchDateFormat(str);
        if( format == null || str == null || str.length() == 0 ){
            return null;
        }
        Date date = new Date();
        SimpleDateFormat sdf1 = new SimpleDateFormat(format);
        try{
            date = sdf1.parse(str);
            
        }catch(Exception e){
            return null;
        }
        return date;
    }
    
    /**
     * Ɏw肳ꂽdata񂪓t̊eɃ}b`邩
     * `FbN܂B
     * t̏Ƀ}b`ꍇ͂̏Ԃ܂B
     * }b`ȂꍇitƂđÓŖꍇ)nullԂ܂
     * @param data t\
     * @return ̓t\
     */
    public static String searchDateFormat(String data){
        String koubun;
        Pattern pattern;
        Matcher matcher;
        
        if( data == null ){
            return null;
        }
        
        //t yyyy/mm/dd`̌
        koubun= "\\d{4,4}/\\d{1,2}/\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "yyyy/MM/dd";
        }
        
        koubun = "\\d{2,2}/\\d{1,2}/\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "yy/MM/dd";
        }
        
        //t yyyy-mm-dd`̌
        koubun = "\\d{4,4}-\\d{1,2}-\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "yyyy-MM-dd";
        }
        
        koubun = "\\d{2,2}-\\d{1,2}-\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "yy-MM-dd";
        }
        
        //t yyyy/mm/dd hh:mm:ss`̌
        koubun= "\\d{4,4}/\\d{1,2}/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "yyyy/MM/dd HH:mm:ss";
        }
        
        koubun = "\\d{2,2}/\\d{1,2}/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "yy/MM/dd HH:mm:ss";
        }
        
        //t yyyy-mm-dd hh:mm:ss`̌
        koubun = "\\d{4,4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "yyyy-MM-dd HH:mm:ss";
        }
        
        koubun = "\\d{2,2}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "yy-MM-dd HH:mm:ss";
        }
        
        //hh:mm:sš
        koubun= "\\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "HH:mm:ss";
        }
        
        //hh:mm̌
        koubun= "\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "HH:mm";
        }
        
        //t mm/dd/yyyy`̌(SQL`)
        koubun= "\\d{1,2}/\\d{1,2}/\\d{4,4}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "MM/dd/yyyy";
        }
        
        koubun= "\\d{1,2}/\\d{1,2}/\\d{4,4} \\d{1,2}:\\d{1,2}:\\d{1,2}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "MM/dd/yyyy HH:mm:ss";
        }
        
        //YYYYMMDD`
        koubun= "\\d{8,8}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "yyyyMMdd";
        }
        
        //YYMMDD`
        koubun= "\\d{6,6}";
        pattern = Pattern.compile(koubun);
        matcher = pattern.matcher(data);
        if(matcher.matches()){
            return "yyMMdd";
        }
        
        return null;
    }
    
    public static void main(String[] argv){
//        System.out.println(searchDateFormat("2004/05/01"));
//        System.out.println(searchDateFormat("04/05/01"));
//        System.out.println(searchDateFormat("04/5/1"));
        
        System.out.println(parse("2004/05/01"));
        System.out.println(parse("04/05/01"));
        System.out.println(parse("04/5/1"));
        System.out.println(parse("2004-05-01"));
        System.out.println(parse("04-05-01"));
        System.out.println(parse("04-5-1"));
        
        System.out.println(parse("2004/05/01 23:59:30"));
        System.out.println(parse("04/05/01 23:59:30"));
        System.out.println(parse("04/5/1 23:59:30"));
        
        System.out.println(parse("2004-05-01 23:59:30"));
        System.out.println(parse("04-05-01 23:59:30"));
        System.out.println(parse("04-5-1 23:59:30"));
        
        System.out.println(parse("01:01:01"));
        System.out.println(parse("1:1:1"));
        
        System.out.println(parse("05/01/2004"));
        System.out.println(parse("05/01/2004 23:59:30"));
        System.out.println(parse("20040501"));
        System.out.println(parse("040501"));
        
        System.out.println("0501-->"+parse("0501"));
        System.out.println("05/01-->"+parse("05/01"));
        System.out.println("05-01-->"+parse("05-01"));
        
    }
}
