/*
 * FileUtil.java
 *
 * Created on 2007/02/09, 12:38
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.itscool.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * t@C֌W̃[eBeBNXł
 *
 * @author kano
 */
public class FileUtil {
    /**
     * Pt@C̃Rs[s܂
     * @param from Rs[t@C̃pX
     * @param to Rs[t@C̃pX
     * @throws t@CRs[ɎsꍇFileUtilExceptionX[܂
     */
    public static void copy(String from, String to ){
        try{
            File file = new File(from);
            if(file.isDirectory()) return;
            
            int data;
            // t@C̓Xg[擾
            InputStream fr = new BufferedInputStream(new FileInputStream(from));
            //@t@Co̓Xg[擾
            OutputStream fw = new BufferedOutputStream( new FileOutputStream(to));
            while((data=fr.read())!=-1){
                fw.write(data);
            }
            fw.close();
            
            //t@C̍XVtRs[ɕ
            File fromFile = new File(from);
            File toFile = new File(to);
            toFile.setLastModified(fromFile.lastModified());
            
        }catch(IOException ex){
            throw new FileUtilException(ex.getMessage());
        }
    }
    
    /**
     * fBNgPʂ̃t@C̃Rs[s܂
     * @param fromDir Rs[̃fBNg
     * @param toDir Rs[̃fBNg
     * @return fBNgPʂ̃Rs[ɐꍇtrueԂ܂
     */
    public static boolean copyAll(String fromDir, String toDir){
        boolean ret = true;
        File file = new File(toDir);
        if(!file.isDirectory()){
            file.mkdirs();
        }
        String[] list = getFileList(fromDir);
        for(int i=0; i<list.length; i++){
            try{
                copy(fromDir+"/" + list[i], toDir+"/"+list[i]);
            }catch(Exception e){
                System.out.println(e.getMessage());
                ret = false;
            }
        }
        return ret;
    }
    
    /**
     * w肵fBNgzɑ݂t@CXg擾܂
     * @param path pX
     * @return t@CXg̈ꗗԂ܂B
     * t@C݂ȂA邢͎w肳ꂽpXfBNg
     * ꍇ́ATCYO̔zԂ܂
     */
    public static String[] getFileList(String path){
        String[] list = new String[0];
        File file = new File(path);
        if( !file.isDirectory()){
            return list;
        }
        return file.list();
    }
    
    /**
     * w肳ꂽt@C폜܂
     * @param fileName t@C
     * @throws t@C̍폜ɎsꍇFileUtilExceptionX[܂
     */
    public static void delete(String fileName ){
        try{
            File file = new File(fileName);
            if(file.isDirectory()) return;
            
            if( !file.delete() ){
                throw new FileUtilException("delete failed [" + fileName + "]");
            }
        }catch(Exception ex){
            throw new FileUtilException(ex.getMessage());
        }
    }
    
    /**
     * w肳ꂽfBNgz̃t@CSč폜܂
     * @param dir pX
     * @return SẴt@C폜ɐꍇtrueԂ܂
     * @throws w肳ꂽpXfBNgŖꍇFileUtilExceptionX[܂
     */
    public static boolean deleteAll(String dir){
        boolean ret = true;
        File file = new File(dir);
        if(!file.isDirectory()){
            throw new FileUtilException("directory not found [" + dir + "]");
        }
        String[] list = getFileList(dir);
        for(int i=0; i<list.length; i++){
            try{
                delete(dir+"/" + list[i]);
            }catch(Exception e){
                System.out.println(e.getMessage());
                ret = false;
            }
        }
        return ret;
    }
    
    /**
     * w肳ꂽpX̍ŏIXV擾܂<br/>
     * w肳ꂽpXt@CŖꍇ0Ԃ܂
     * @param path t@CpX
     * @return long ŏIXV
     */
    public static long getLastModified(String path) {
        File file = new File(path);
        if( file.isFile()){
            long lastModified = file.lastModified();
            return lastModified;
        }else{
            return 0;
        }
    }
    
    public static boolean isFile(String path){
        if( path == null || path.length() == 0){
            return false;
        }
        File file = new File(path);
        if( file != null && file.isFile()){
            return true;
        }else{
            return false;
        }
    }
}
