/*
 * FrontServletListener.java
 *
 * Created on 2007/05/11, 16:29
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.itscool.weber.controller;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.weber.user.User;


//(1)HttpSessionListenerC^tF[XXi[NX
//   錾܂B
public class FrontServletListener implements HttpSessionListener,
        HttpSessionAttributeListener{
    protected AbstractLog log;
    
    //(2)ZbV쐬ꂽƂɌĂяo
    //   sessionCreated\bhŃZbVZ鏈ƁA
    //   ZꂽZbVOɋLڂ鏈s܂B
    public void sessionCreated(HttpSessionEvent hse) {
        HttpSession session = hse.getSession();
        String id = session.getId();
        log.trace("Session created id="+id);
    }
    
    //(3)ZbVjꂽƂɌĂяo
    //   sessionDestroyed\bhŃZbV
    //   Z鏈s܂B
    public void sessionDestroyed(HttpSessionEvent hse) {
        HttpSession session = hse.getSession();
        String id = session.getId();
        log.trace("Session destroyed id="+id);
    }
    
    public void attributeAdded(HttpSessionBindingEvent event){
        HttpSession session=event.getSession();
        String id = session.getId();
        if(event.getValue() instanceof User){
            log.trace("login one user id="+id);
        }
    }
    
    public void attributeReplaced(HttpSessionBindingEvent event){
        HttpSession session=event.getSession();
        String id = session.getId();
        if(event.getValue() instanceof User){
            log.trace("login one user id="+id);
        }
    }
    
    public void attributeRemoved(HttpSessionBindingEvent event){
        HttpSession session=event.getSession();
        String id = session.getId();
        if(event.getValue() instanceof User){
            log.trace("logout one user id="+id);
        }
    }
    
    /** Creates a new instance of FrontServletListener */
    public FrontServletListener() {
        BeanFactory factory = BeanFactory.getInstance();
        if( !factory.isInit() ){
            try{
                factory.createForUrl("di-config.xml");
            }catch(Exception ex){
                ex.printStackTrace();
                throw new RuntimeException(ex.getMessage());
            }
        }
        
        try{
            if( factory.isDefined("Log") ){
                log = (AbstractLog)factory.getInstance("Log");
                if(!log.isInit()){
                    log = (AbstractLog)factory.createInstance("Log");
                }
            }else{
                log = SimpleLog.getInstance();
            }
        }catch(Exception ioe){
            throw new RuntimeException(ioe.getMessage());
        }
        log.trace("started");
    }
    
}
