package org.itscool.weber.testcase;

import java.sql.Connection;

import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionException;
import org.itscool.commons.dao.EntityInfoMapping;
import org.itscool.commons.pool.ObjectPool;
import org.itscool.commons.pool.ObjectPoolEventListener;

/**
 * bNpRlNVv[ǗNXł<BR>
 * <BR>
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class MockConnectionManager implements ConnectionManager, ObjectPoolEventListener{
    private static MockConnectionManager instance = null;
    private ObjectPool pool;				//IuWFNgv[
    private int timeout;                  // Connection擾̃^CAEg
    private boolean initFlg = false;     //tO
    private int initSize = 0;				//v[̏TCY
    private int maxSize = 1;				//v[MAXTCY
    private boolean mode = false;        // AutoCommit[h
    private boolean showSql = false;		//SQL\tO
    private String dbType = EntityInfoMapping.DB_HSQL;
    
    public String toString(){
        return "Not Used Connection";
    }
    
    /**
     * BConnectionManagerCX^X擾܂
     * @return BConnectionMangerCX^XԂ܂
     */
    public static MockConnectionManager getInstance(){
        if( instance == null){
            instance = new MockConnectionManager();
        }
        return instance;
    }
    
    public void init(){
        pool = new ObjectPool(this, initSize, maxSize);
        for( int i=0; i<initSize; i++ ){
            pool.addNewElement( (Object)newTransaction() );
        }
    }
    
    /**
     * VKRlNV̍쐬
     * @return ConnectionCX^Xv[擾܂
     * @throws TransactionException
     */
    private Transaction newTransaction() throws TransactionException{
        Connection con = null;
        MockTransaction trn = null;
        trn = new MockTransaction();
        trn.setShowSql(showSql);
        
        return trn;
    }
    
    /**
     * ConnectionManagerCX^XĂ邩肵܂
     * @return ς݂̏ꍇtrueԂ܂
     */
    public boolean isInit(){
        return initFlg;
    }
    
    /**
     * TransactionCX^Xv[擾܂
     * v[TransactionCX^XȂꍇnullԂ܂
     * @return TransactionCX^XԂ܂
     */
    public Transaction getTransaction(){
        if( timeout != -1 ){
            return (Transaction)pool.getElement(timeout);
        }else{
            return (Transaction)pool.getElement();
            
        }
    }
    
    /**
     * svɂȂTransactionCX^Xv[ɕԂ܂
     * @param trn svɂȂTransactionCX^X
     */
    public void returnTransaction(Transaction trn){
        if(trn == null ){
            trn = newTransaction();
        }else if(trn.isClosed()){
            trn = newTransaction();
        }
        pool.returnElement(trn);
    }
    
    /**
     * RlNVv[JAI܂B
     */
    public void destroy(){
        if(pool != null ){
            pool.release();
        }
        pool = null;
    }
    
    /**
     * org.itscool.commons.pool.PoolNXvf̒ǉv
     * 邽߂ɌĂ΂Cxgł<br>
     * VConnectionCX^X𐶐APoolNXɕԂ܂<br>
     * org.itscool.commons.pool.PoolNXȊO炱̃\bh
     * Ă΂Ȃł
     */
    public Object doMissingElementEvent(){
        Transaction trn = newTransaction();
        return trn;
    }
    
    /**
     * org.itscool.commons.pool.PoolNXĂ΂
     * Cxgł<br>
     * w肳ꂽConnectionvf̃N[Y{܂<br>
     * org.itscool.commons.pool.PoolNXȊO炱̃\bh
     * Ă΂Ȃł
     * @param obj w肳ꂽvf
     */
    public void doReleaseElementEvent(Object obj){
        Transaction trn = (Transaction) obj;
        try {
            trn.close();
        }catch (TransactionException e) {
            throw new TransactionException(e);
        }
    }
    
    /**
     * ݂̃v[TCYԂ܂
     * @return ݂̃v[TCYԂ܂
     */
    public int getPoolSize(){
        if( pool != null ){
            return pool.getPoolSize();
        }else{
            return -1;
        }
    }
    
    /**
     * v[̏TCYԂ܂
     * @return v[̏TCYԂ܂
     */
    public int getInitSize(){
        return initSize;
    }
    
    /**
     * v[̊g\ȍőTCYԂ܂
     * @return g\ȃv[TCYԂ܂
     */
    public int getMaxSize(){
        return maxSize;
    }
    
    /**
     * AutoCommit[hZbg܂
     * @param mode AutoCommit[h
     */
    public void setMode(boolean mode) {
        this.mode = mode;
    }
    
    /**
     * SQL\[hZbg܂
     * @param showSql SQL\[h
     */
    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }
    
    /**
     * RlNV^CAEgZbg܂
     * @param timeout RlNV^CAEg
     */
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
    
    /**
     * RlNVv[̏TCYZbg܂
     * @param initSize RlNVv[̏TCY
     */
    public void setInitSize(int initSize) {
        this.initSize = initSize;
    }
    
    /**
     * RlNVv[̍őTCYZbg܂
     * @param maxSize
     */
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
    
    /**
     * ConnectionMangerCX^X̏󋵂擾܂
     * @return ς݂̏ꍇtrueԂ܂
     */
    public boolean isInitFlg() {
        return initFlg;
    }
    
    /**
     * AutoCommitMode擾܂
     * @return AutoCommitModeLɂȂĂꍇtureԂ܂
     */
    public boolean getMode() {
        return mode;
    }
    
    /**
     * SQL\[h擾܂
     * @return SQL\̏ꍇtrueԂ܂
     */
    public boolean getShowSql() {
        return showSql;
    }
    
    /**
     * RlNV^CAEg擾܂
     * @return RlNV^CAEgmsecŎ擾܂
     */
    public int getTimeout() {
        return timeout;
    }
    
    /**
     * f[^x[X^CvZbg܂
     * @param dbType f[^x[X^Cv
     */
    public void setDbType(String dbType){
        this.dbType = dbType;
    }
    /**
     * f[^x[X^Cv擾܂
     * @return String f[^x[X^Cv
     */
    public String getDbType(){
        return dbType;
    }
}

