/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.web.filter;

import java.util.HashMap;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.webframe.test.AbstractEasyMockTestCase;
import jp.sourceforge.webframe.web.filter.LocaleFilter;
import org.easymock.EasyMock;

public class LocaleFilterTest
extends AbstractEasyMockTestCase {
    private String langParameter = "lang";
    private String[] acceptableLanguages = new String[]{"en", "ja"};
    private String defaultLanguage = "en";
    private String defaultContentType = "text/html;charset=UTF-8";
    private HttpServletRequest requestMock = null;
    private HttpServletResponse responseMock = null;
    private HttpSession sessionMock = null;
    private FilterChain filterChainMock = null;
    private LocaleFilter localeFilter = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected void setUp() throws Exception {
        super.setUp();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.servlet.http.HttpServletRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.requestMock = (HttpServletRequest)this.mocksControl.createMock((Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("javax.servlet.http.HttpServletResponse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.responseMock = (HttpServletResponse)this.mocksControl.createMock((Class)clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("javax.servlet.FilterChain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.filterChainMock = (FilterChain)this.mocksControl.createMock((Class)clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("javax.servlet.http.HttpSession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.sessionMock = (HttpSession)this.mocksControl.createMock((Class)clazz4);
        this.localeFilter = new LocaleFilter();
        this.localeFilter.setLangParameter(this.langParameter);
        this.localeFilter.setAcceptableLanguages(this.acceptableLanguages);
        this.localeFilter.setDefaultLanguage(this.defaultLanguage);
        this.localeFilter.setDefaultContentType(this.defaultContentType);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInit() {
    }

    public void testDoFilter() throws Exception {
        this.mocksControl.reset();
        EasyMock.expect((Object)this.requestMock.getSession()).andReturn((Object)this.sessionMock);
        HashMap<String, String> parameterMapMock = new HashMap<String, String>();
        parameterMapMock.put(this.langParameter, "ja");
        EasyMock.expect((Object)this.requestMock.getParameterMap()).andReturn(parameterMapMock);
        EasyMock.expect((Object)this.requestMock.getParameter(this.langParameter)).andReturn((Object)"ja");
        this.sessionMock.setAttribute(this.langParameter, (Object)"ja");
        this.responseMock.setLocale(new Locale("ja"));
        this.responseMock.setContentType(this.defaultContentType);
        this.sessionMock.setAttribute("org.apache.struts.action.LOCALE", (Object)new Locale("ja"));
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        this.mocksControl.replay();
        this.localeFilter.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        this.mocksControl.verify();
        this.mocksControl.reset();
        EasyMock.expect((Object)this.requestMock.getSession()).andReturn((Object)this.sessionMock);
        parameterMapMock = new HashMap();
        parameterMapMock.put(this.langParameter, "unknown");
        EasyMock.expect((Object)this.requestMock.getParameterMap()).andReturn(parameterMapMock);
        EasyMock.expect((Object)this.requestMock.getParameter(this.langParameter)).andReturn((Object)"unknown");
        this.sessionMock.setAttribute(this.langParameter, (Object)this.defaultLanguage);
        this.responseMock.setLocale(new Locale(this.defaultLanguage));
        this.responseMock.setContentType(this.defaultContentType);
        this.sessionMock.setAttribute("org.apache.struts.action.LOCALE", (Object)new Locale(this.defaultLanguage));
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        this.mocksControl.replay();
        this.localeFilter.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        this.mocksControl.verify();
        this.mocksControl.reset();
        EasyMock.expect((Object)this.requestMock.getSession()).andReturn((Object)this.sessionMock);
        parameterMapMock.clear();
        EasyMock.expect((Object)this.requestMock.getParameterMap()).andReturn(parameterMapMock);
        EasyMock.expect((Object)this.sessionMock.getAttribute(this.langParameter)).andReturn((Object)"ja").times(2);
        this.responseMock.setLocale(new Locale("ja"));
        this.responseMock.setContentType(this.defaultContentType);
        this.sessionMock.setAttribute("org.apache.struts.action.LOCALE", (Object)new Locale("ja"));
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        this.mocksControl.replay();
        this.localeFilter.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        this.mocksControl.verify();
        this.mocksControl.reset();
        EasyMock.expect((Object)this.requestMock.getSession()).andReturn((Object)this.sessionMock);
        parameterMapMock.clear();
        EasyMock.expect((Object)this.requestMock.getParameterMap()).andReturn(parameterMapMock);
        EasyMock.expect((Object)this.sessionMock.getAttribute(this.langParameter)).andReturn(null);
        Locale localeMock = new Locale("ja", "JP");
        EasyMock.expect((Object)this.requestMock.getLocale()).andReturn((Object)localeMock);
        this.responseMock.setLocale(new Locale("ja"));
        this.responseMock.setContentType(this.defaultContentType);
        this.sessionMock.setAttribute("org.apache.struts.action.LOCALE", (Object)new Locale("ja"));
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        this.mocksControl.replay();
        this.localeFilter.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        this.mocksControl.verify();
        this.mocksControl.reset();
        EasyMock.expect((Object)this.requestMock.getSession()).andReturn((Object)this.sessionMock);
        parameterMapMock.clear();
        EasyMock.expect((Object)this.requestMock.getParameterMap()).andReturn(parameterMapMock);
        EasyMock.expect((Object)this.sessionMock.getAttribute(this.langParameter)).andReturn(null);
        localeMock = new Locale("eo", "JP");
        EasyMock.expect((Object)this.requestMock.getLocale()).andReturn((Object)localeMock);
        this.responseMock.setLocale(new Locale(this.defaultLanguage));
        this.responseMock.setContentType(this.defaultContentType);
        this.sessionMock.setAttribute("org.apache.struts.action.LOCALE", (Object)new Locale(this.defaultLanguage));
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        this.mocksControl.replay();
        this.localeFilter.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        this.mocksControl.verify();
        this.mocksControl.reset();
        EasyMock.expect((Object)this.requestMock.getSession()).andReturn((Object)this.sessionMock);
        parameterMapMock.clear();
        EasyMock.expect((Object)this.requestMock.getParameterMap()).andReturn(parameterMapMock);
        EasyMock.expect((Object)this.sessionMock.getAttribute(this.langParameter)).andReturn(null);
        localeMock = null;
        EasyMock.expect((Object)this.requestMock.getLocale()).andReturn((Object)localeMock);
        this.responseMock.setLocale(new Locale(this.defaultLanguage));
        this.responseMock.setContentType(this.defaultContentType);
        this.sessionMock.setAttribute("org.apache.struts.action.LOCALE", (Object)new Locale(this.defaultLanguage));
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        this.mocksControl.replay();
        this.localeFilter.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        this.mocksControl.verify();
    }

    public void testDestroy() {
    }
}

