/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

/**
 * SearchableMetaData
 *
 * @author Yomei Komiya
 * @since 0.9.0
 *
 * @deprecated Use jp.sourceforge.metasearch.compass.entity.SearchableMetaData
 *		of <a href="http://metasearch.sourceforge.jp/">MetaSearch project</a>
 * @version $Id: SearchableMetaData.java 6 2007-06-27 13:49:06Z whitestar $
 */
public interface SearchableMetaData {

	/**
	 * @return Search Provider Name
	 */
	public String getProvider();

	/**
	 * @param provider Search Provider Name
	 */
	public void setProvider(String provider);

	/**
	 * @return Search Provider URL
	 */
	public String getProviderUrl();

	/**
	 * @param providerUrl Search Provider URL
	 */
	public void setProviderUrl(String providerUrl);

	/**
	 * @return Compass Resource Alias
	 */
	public String getResourceAlias();
	
	/**
	 * @param resourceAlias Compass Resource Alias
	 */
	public void setResourceAlias(String resourceAlias);

	/**
	 * @return Document Resource Context
	 * (URL Context, prefix, program id and so on.)
	 */
	public String getResourceContext();
	
	/**
	 * @param resourceContext Document Resource Context String
	 */
	public void setResourceContext(String resourceContext);
	
	/**
	 * @return Document Global Identifier
	 */
	public String getIdentifier();
	
	/**
	 * @param identifier Document Global identifier
	 */
	public void setIdentifier(String identifier);
	
	/**
	 * @return Document Type
	 */
	public String getType();
	
	/**
	 * @param type Document Type
	 */
	public void setType(String type);
	
	/**
	 * @return Rights string
	 */
	public String getRights();

	/**
	 * @param rights
	 */
	public void setRights(String rights);

	/**
	 * @return Content Size
	 */
	public long getSize();
	
	/**
	 * @param size Content Size
	 */
	public void setSize(long size);
	
	/**
	 * @return Compass Score
	 */
	public float getScore();
	
	/**
	 * @param score Compass Score
	 */
	public void setScore(float score);
	
	/**
	 * @return matched text fragment
	 */
	public String getFragment();
	
	/**
	 * @param fragment matched text fragment
	 */
	public void setFragment(String fragment);
	
}
