/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.io;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections.map.TypedMap;
import org.apache.commons.lang.StringUtils;

/**
 * DefaultCsvLineParser
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id: DefaultCsvLineParser.java 6 2007-06-27 13:49:06Z whitestar $
 */
public class DefaultCsvLineParser implements LineParser {
	
	/**
	 * Column delimiter
	 */
	private String delim;
	
	/**
	 * Column name list
	 */
	private String[] itemNames;
	

	public DefaultCsvLineParser() {
		super();
	}
	

	/**
	 * @param delim
	 * @param itemNames
	 */
	public DefaultCsvLineParser(String delim, String[] itemNames) {
		super();
		
		this.delim = delim;
		this.itemNames = itemNames;
	}


	/*
	 * @see jp.sourceforge.webframe.io.LineParser#parse(java.lang.String)
	 */
	public Map parse(String line)
		throws LineMalformedException {

		String[] parsedItems
			= StringUtils.splitPreserveAllTokens(line, this.delim);
		if (parsedItems.length == this.itemNames.length) {
			Map map = TypedMap.decorate(
					new HashMap(), String.class, String.class);
			
			for (int i = 0; i < this.itemNames.length; i++) {
				map.put(this.itemNames[i], parsedItems[i]);
			}
			
			return map;
		}
		else {
			throw new LineMalformedException(
					"Expected format: <"
					+ StringUtils.join(this.itemNames, this.delim)
					+ ">(" + this.itemNames.length
					+") but was: <" + line + ">(" + parsedItems.length + ")");
		}
	}


	public String getDelim() {
		return delim;
	}


	public void setDelim(String delim) {
		this.delim = delim;
	}


	public String[] getItemNames() {
		return itemNames;
	}


	public void setItemNames(String[] itemNames) {
		this.itemNames = itemNames;
	}
	
}
