/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.test;

import java.util.Collection;
import java.util.Iterator;

import org.easymock.EasyMock;

/**
 * EasyMockUtils
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id: EasyMockUtils.java 6 2007-06-27 13:49:06Z whitestar $
 */
public class EasyMockUtils {
	

	private EasyMockUtils() {
	}

	
	/**
	 * Reset all mocks
	 * 
	 * @param mocks mock objects collection
	 */
	static public void reset(Collection mocks) {
		if (mocks != null) {
			for (Iterator ite = mocks.iterator(); ite.hasNext(); ) {
				EasyMock.reset(ite.next());
			}
		}
	}


	/**
	 * Replay all mocks
	 * 
	 * @param mocks mock objects collection
	 */
	static public void replay(Collection mocks) {
		if (mocks != null) {
			for (Iterator ite = mocks.iterator(); ite.hasNext(); ) {
				EasyMock.replay(ite.next());
			}
		}
	}

	
	/**
	 * Verify all mocks
	 * 
	 * @param mocks mock objects collection
	 */
	static public void verify(Collection mocks) {
		if (mocks != null) {
			for (Iterator ite = mocks.iterator(); ite.hasNext(); ) {
				EasyMock.verify(ite.next());
			}
		}
	}
}
