/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.velocity.tools.struts;

import org.apache.velocity.tools.struts.StrutsLinkTool;

/**
 * ExtendedStrutsLinkTool
 *
 * @author Yomei Komiya
 * @since 0.9.2 
 *
 * @version $Id: ExtendedStrutsLinkTool.java 6 2007-06-27 13:49:06Z whitestar $
 */
public class ExtendedStrutsLinkTool extends StrutsLinkTool {
	
	/**
	 * Returns a copy of the link with the given module name and action name
	 * converted into a server-relative URI reference.
	 * 
	 * @param module module key (e.g. "/admin")
	 * @param action action name
	 * @return a new instance of StrutsLinkTool
	 */
	public StrutsLinkTool setAction(String module, String action) {
		return (StrutsLinkTool)copyWith(
				ExtendedStrutsUtils.getActionMappingURL(
						application, request, module, action));
	}
	
}
