/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import junit.framework.TestCase;

/**
 * PukiWikiBeanTest
 *
 * @author Yomei Komiya
 *
 * $Id: PukiWikiBeanTest.java 8 2007-06-27 13:50:16Z whitestar $
 */
public class PukiWikiBeanTest extends TestCase {
	
	private String pageNameEncodingCharset = "EUC-JP";
	
	private PukiWikiBean pukiWikiBean;
	

	protected void setUp() throws Exception {
		super.setUp();
		
		this.pukiWikiBean = new PukiWikiBeanMock();
	}

	
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	
	/*
	 * 'jp.sourceforge.webframe.compass.entity.PukiWikiBean.loadFile(File, String, int)' test method
	 */
	public void testLoadFile() {

	}

	
	/*
	 * 'jp.sourceforge.webframe.compass.entity.PukiWikiBean.buildIdentifier()' test method
	 */
	public void testBuildIdentifier() {
		String resourceContext = "http://localhost/wiki/home/index.php?";
		String title = "ヘルプ";
		this.pukiWikiBean.setResourceContext(resourceContext);
		this.pukiWikiBean.setTitle(title);
		this.pukiWikiBean.setPageNameEncodingCharset(
				this.pageNameEncodingCharset);
		this.pukiWikiBean.buildIdentifier();
		
		assertEquals(
				resourceContext + "%A5%D8%A5%EB%A5%D7",
				this.pukiWikiBean.getIdentifier());
	}

}
