/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import junit.framework.TestCase;

/**
 * TracRevisionBeanTest
 *
 * @author Yomei Komiya
 *
 * @version $Id: TracRevisionBeanTest.java 8 2007-06-27 13:50:16Z whitestar $
 */
public class TracRevisionBeanTest extends TestCase {
	
	private TracRevisionBean tracRevisionBean = null;

	
	protected void setUp() throws Exception {
		super.setUp();
		
		this.tracRevisionBean = new TracRevisionBeanMock();
	}

	
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	
	/*
	 * 'jp.sourceforge.webframe.compass.entity.TracRevisionBean.buildIdentifier()' test method
	 */
	public void testBuildIdentifier() {
		String resourceContext = "http://localhost/trac/home/changeset/";
		String localIdentifier = "128";
		this.tracRevisionBean.setResourceContext(resourceContext);
		this.tracRevisionBean.setLocalIdentifier(localIdentifier);
		this.tracRevisionBean.buildIdentifier();
		
		assertEquals(
				resourceContext + localIdentifier,
				this.tracRevisionBean.getIdentifier());

	}

}
