/*
 * Decompiled with CFR 0.152.
 */
package wbeer.core;

import java.util.Enumeration;
import java.util.Vector;
import wbeer.core.Feature;
import wbeer.core.Lexicon;
import wbeer.core.Parser;

public class Word
extends Vector {
    public static int branch_len = 12;
    public static final int max_xpos = 320;
    private static boolean[] mark = new boolean[320];
    public Lexicon lex;
    public String name;
    public int chainid;
    public Word parent;
    public Word left;
    public Word right;
    public Word headside;
    public Word noheadside;
    public Word assoc;

    public Word(String string) {
        this.clear(string);
    }

    public int NLP(String string) {
        Parser parser = new Parser();
        parser.setLexicon(this.lex);
        Word word = parser.doParse(string, this);
        if (word == null) {
            System.err.println(parser.msg);
            System.err.println(parser.sub);
            return -1;
        }
        return word.wbMain(null);
    }

    public void add(Feature feature) {
        this.addElement(feature.clone());
    }

    public void clear(String string) {
        this.removeAllElements();
        this.name = string;
        this.lex = this.lex;
        this.parent = null;
        this.left = null;
        this.right = null;
        this.headside = null;
        this.noheadside = null;
        this.chainid = -1;
        this.assoc = null;
        this.lex = null;
    }

    public Object clone() {
        Word word = (Word)super.clone();
        word.clear(word.name);
        word.parent = this.parent;
        word.left = this.left;
        word.right = this.right;
        word.headside = this.headside;
        word.noheadside = this.noheadside;
        word.chainid = this.chainid;
        word.assoc = this.assoc;
        int n = 0;
        while (n < this.size()) {
            Feature feature = (Feature)this.elementAt(n);
            feature = (Feature)feature.clone();
            feature.w = word;
            word.add(feature);
            ++n;
        }
        word.lex = this.lex;
        return word;
    }

    protected int eval(String string, String[] stringArray) {
        Feature feature = this.get(string);
        if (feature.checked) {
            feature.nohead.wbMain(stringArray);
        }
        return 0;
    }

    protected Word f2w(String string) {
        Feature feature = this.get(string);
        if (feature.checked) {
            return feature.nohead;
        }
        return null;
    }

    public Feature get(String string) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Feature feature = (Feature)enumeration.nextElement();
            if (!feature.id.equals(string)) continue;
            return feature;
        }
        return null;
    }

    public boolean isGoverned() {
        return this.parent != null;
    }

    public boolean isGovernor(Word word) {
        if (word == null) {
            return false;
        }
        if (this == word) {
            return true;
        }
        if (this.noheadside == word) {
            return true;
        }
        if (this.headside != null) {
            return this.headside.isGovernor(word);
        }
        return false;
    }

    public boolean isUpperSide(Word word) {
        if (word == null) {
            return false;
        }
        if (this == word) {
            return false;
        }
        if (this.right == word) {
            return true;
        }
        if (this.left == word) {
            return true;
        }
        if (this.right != null && this.right.isUpperSide(word)) {
            return true;
        }
        return this.left != null && this.left.isUpperSide(word);
    }

    public Word leftmost() {
        if (this.left == null) {
            return this;
        }
        return this.left.leftmost();
    }

    public Word maxproject() {
        Word word = this;
        while (word.parent != null && word.parent.headside == word) {
            word = word.parent;
        }
        return word;
    }

    public boolean rightDownFrom(Word word) {
        while (word != null) {
            if (this == word) {
                return true;
            }
            word = word.right;
        }
        return false;
    }

    public Word rightmost() {
        if (this.right == null) {
            return this;
        }
        return this.right.rightmost();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[" + this.name + "]\n");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(String.valueOf(((Feature)enumeration.nextElement()).toString()) + "\n");
        }
        return stringBuffer.toString();
    }

    public String treeImage(int n, boolean bl) {
        Integer n2 = new Integer(n /= branch_len);
        int n3 = 0;
        while (n3 < 320) {
            Word.mark[n3] = false;
            ++n3;
        }
        return this.treeImage(n2, bl);
    }

    private String treeImage(Integer n, boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = branch_len / 2;
        int n4 = branch_len / 2;
        if (n3 + n4 == branch_len) {
            --n3;
        }
        int n5 = n;
        int n6 = n5 * branch_len + n3;
        if (n5 > 0 && (this.parent == null || this.parent.right == this && this.parent.left != null)) {
            n2 = 0;
            while (n2 < (n5 - 1) * branch_len + n3) {
                if (n2 < 320 && mark[n2]) {
                    stringBuffer.append('|');
                } else {
                    stringBuffer.append(' ');
                }
                ++n2;
            }
            if (this.parent != null) {
                stringBuffer.append('+');
                n2 = 0;
                while (n2 < n4) {
                    if (this.assoc == null) {
                        stringBuffer.append('-');
                    } else {
                        stringBuffer.append('.');
                    }
                    ++n2;
                }
            } else {
                stringBuffer.append(' ');
                n2 = 0;
                while (n2 < n4) {
                    stringBuffer.append(' ');
                    ++n2;
                }
            }
        }
        n = new Integer(++n5);
        if (this.left == null && this.right == null) {
            stringBuffer.append(this.name);
            if (this.chainid >= 0) {
                stringBuffer.append(String.valueOf('_') + String.valueOf(this.chainid));
            }
            if (bl) {
                Word word = this.maxproject();
                boolean bl2 = false;
                n2 = 0;
                while (n2 < word.size()) {
                    Feature feature = (Feature)word.elementAt(n2);
                    if (feature.checked) {
                        if (!bl2) {
                            bl2 = true;
                            stringBuffer.append(";");
                        }
                        stringBuffer.append(String.valueOf(' ') + feature.name + '(' + feature.value + ')');
                    }
                    ++n2;
                }
            }
            stringBuffer.append('\n');
            n = new Integer(--n5);
        } else {
            int n7 = 0;
            stringBuffer.append(this.name);
            if (this.chainid >= 0) {
                stringBuffer.append(String.valueOf('_') + String.valueOf(this.chainid));
                n7 += String.valueOf(this.chainid).length() + 1;
            }
            n7 += this.name.length();
            while (n7 < branch_len) {
                stringBuffer.append('-');
                ++n7;
            }
            if (n6 > 0 && n6 < 320) {
                boolean bl3 = Word.mark[n6] = this.right != null;
            }
            if (this.left != null) {
                stringBuffer.append(this.left.treeImage(n, bl));
            }
            if (n6 > 0 && n6 < 320) {
                Word.mark[n6] = false;
            }
            if (this.right != null) {
                stringBuffer.append(this.right.treeImage(n, bl));
            }
            n = new Integer(--n5);
        }
        return stringBuffer.toString();
    }

    public int wbMain(String[] stringArray) {
        return 0;
    }
}

