package wbeer.core;

import java.lang.* ;

public class Feature {
  public boolean inherent ;
  public boolean headside ;
  public boolean obligatory ;
  public boolean checked ;
  public boolean covered ;
  public boolean eachside ;
  public String name ;
  public String id ;
  public String value ;
  public int chainid ;
  public Word w ;
  public Word nohead ;

  public Feature( String name ) {
    clear( name ) ;
  }

  public Object clone() {
    Feature f    = new Feature( name ) ;
    f.inherent   = inherent ;
    f.headside   = headside ;
    f.obligatory = obligatory ;
    f.checked    = checked ;
    f.covered    = covered ;
    f.eachside   = eachside ;
    f.id         = id ;
    f.value      = value ;
    f.w          = w ;
    f.nohead     = nohead ;
    f.chainid    = chainid ;
    return f ;
  }

  public void clear( String name ) {
    this.name  = name ;
    id         = "undef" ;
    value      = "undef" ;
    inherent   = false ;
    headside   = false ;
    obligatory = false ;
    checked    = false ;
    covered    = false ;
    eachside   = false ;
    w          = null ;
    nohead     = null ;
    chainid    = -1 ;
  }

  public String toString() {
    StringBuffer buf = new StringBuffer( "[" + name + "]\n" ) ;
    buf.append( "id         = " + id         + "\n" +
                "value      = " + value      + "\n" +
                "inherent   = " + inherent   + "\n" +
                "headside   = " + headside   + "\n" +
                "obligatory = " + obligatory + "\n" +
                "checked    = " + checked    + "\n" +
                "covered    = " + covered    + "\n" +
                "eachside   = " + eachside   + "\n" +
                "chainid    = " + chainid    + "\n" ) ;
    return buf.toString() ;
  }
}
