package wbeer.core;

import java.lang.* ;
import java.util.* ;

public class Fstack extends Vector {

  private static final int cell_width = 11 ;

  public boolean legitimate() {
    Feature f ;
    for ( int i = 0 ; i < size() ; i++ ) {
      f = ( Feature )elementAt( i ) ;
      if ( f.checked == false && f.obligatory == true && f.chainid < 0 ) {
        return false ;
      }
    }
    return true ;
  }

  public String toString() {
    StringBuffer buf = new StringBuffer() ;
    Feature f ;
    for ( int i = size() - 1 ; i >= 0 ; i-- ) {
      f = ( Feature )elementAt( i ) ;
      buf.append( f.toString() ) ;
    }
    return buf.toString() ;
  }

  private void appendStringBuffer( StringBuffer buf , String s ) {
    buf.append( s ) ;
    for ( int i = buf.length() ; ( i % cell_width != 0 ) ; i++ ) {
      buf.append( ' ' ) ;
    }
  }

  public String stackImage( int offset ) {
    offset = ( offset / cell_width ) * cell_width ;
    StringBuffer buf = new StringBuffer() ;
    Feature f ;
    int i , j ;

    for ( j = 0 ; j < offset ; j++ ) {
      buf.append( ' ' ) ;
    }
    appendStringBuffer( buf , "name" ) ;
    appendStringBuffer( buf , "inherent" ) ;
    appendStringBuffer( buf , "headside" ) ;
    appendStringBuffer( buf , "obligatory" ) ;
    appendStringBuffer( buf , "value" ) ;
    appendStringBuffer( buf , "word"  ) ;
    buf.append( "chainid" ) ;
    buf.append( "\n==========================================================================\n" ) ;

    for ( i = size() - 1 ; i >= 0 ; i-- ) {
      f = ( Feature )elementAt( i ) ;
      if ( f.checked && f.chainid < 0 ) {
        continue ;
      }
      for ( j = 0 ; j < offset ; j++ ) {
        buf.append( ' ' ) ;
      }
      StringBuffer buf1 = new StringBuffer() ;
      appendStringBuffer( buf1 , f.name ) ;
      appendStringBuffer( buf1 , f.inherent   ? "true" : "false" ) ;
      appendStringBuffer( buf1 , f.headside   ? "true" : "false" ) ;
      appendStringBuffer( buf1 , f.obligatory ? "true" : "false" ) ;
      appendStringBuffer( buf1 , f.value ) ;
      appendStringBuffer( buf1 , f.w.name ) ;
      buf1.append( f.chainid >= 0 ? String.valueOf( f.chainid ) : "" ) ;
      buf.append( buf1 + "\n" ) ;
    }
    buf.append( "\n" ) ;
    return buf.toString() ;
  }
}
