package wbeer.core;

import java.util.* ;

public class Lexicon extends Hashtable {

  public void regist( Word w ) {
    put( w.name , ( Word )w.clone() ) ;
  }

  public Word select( String key ) {
    return select( key , null ) ;
  }

  public Word select( String key , Word owner ) {
    Word w = ( Word )get( key ) ;
    if ( w == null ) {
      return null ;
    }
    w = ( Word )w.clone() ;
    for ( int i = 0 ; i < w.size() ; i++ ) {
      ( ( Feature )w.elementAt( i ) ).w = w ;
    }
    w.lex = this ;
    return w ;
  }

  public String toString() {
    StringBuffer buf = new StringBuffer() ;
    Enumeration elem = elements() ;

    while( elem.hasMoreElements() ) {
      buf.append( ( ( Word )elem.nextElement() ).toString() + "\n" ) ;
    }
    return buf.toString() ;
  }
}
