package wbeer.ui;

import java.applet.* ;
import java.awt.* ;
import wbeer.core.*;

public class WbApp extends Applet {
  public final int wn = 8 ;
  public final int fn = 4 ;

  private String wname[] = new String[wn] ;
  private String fname[][] = new String[wn][fn] ;
  private String fval[][] = new String[wn][fn] ;
  private boolean headside[][] = new boolean[wn][fn] ;
  private boolean inherent[][] = new boolean[wn][fn] ;
  private boolean obligatory[][] = new boolean[wn][fn] ;

  private String mytreeimage ;
  private String mystackimage ;

  public void set_wname( int i , String wn ) {
    wname[i] = wn ;
  }

  public String get_wname( int i ) {
    return wname[i] ;
  }

  public void set_fname( int i , int j , String fname ) {
    this.fname[i][j] = fname ;
  }

  public String get_fname( int i , int j ) {
    return fname[i][j] ;
  }

  public void set_fval( int i , int j , String fval ) {
    this.fval[i][j] = fval ;
  }

  public String get_fval( int i , int j ) {
    return fval[i][j] ;
  }

  public void set_headside( int i , int j , boolean headside ) {
    this.headside[i][j] = headside ;
  }

  public boolean get_headside( int i , int j ) {
    return headside[i][j] ;
  }

  public void set_inherent( int i , int j , boolean inherent ) {
    this.inherent[i][j] = inherent ;
  }

  public boolean get_inherent( int i , int j ) {
    return inherent[i][j] ;
  }

  public void set_obligatory( int i , int j , boolean obligatory ) {
    this.obligatory[i][j] = obligatory ;
  }

  public boolean get_obligatory( int i , int j ) {
    return obligatory[i][j] ;
  }

  private Wbeer mywbeer ;
  private boolean init ;
  private boolean makechain ;
  private boolean makeassoc ;

  public void init() {
    setVisible( false ) ; 
    for ( int i = 0 ; i < wn ; i++ ) {
      wname[i] = "" ;
      for ( int j = 0 ; j < fn ; j++ ) {
        fname[i][j] = "" ;
        headside[i][j] = false ;
        inherent[i][j] = false ;
        obligatory[i][j] = false ;
      }
    }
    mytreeimage = "" ;
    mystackimage = "" ;
    mywbeer = new Wbeer() ;
    init = true ;
  }

  public void parse( String pf ) {
    mywbeer.clear() ;
    for ( int i = 0 ; i < wn ; i++ ) {
      if ( wname[i] != null && !wname[i].equals( "" ) ) {
        Word w = new Word( wname[i] ) ;
        for ( int j = 0 ; j < fn ; j++ ) {
          if ( fname[i][j] != null && !fname[i][j].equals( "" ) ) {
            Feature f = new Feature( fname[i][j] ) ;
            f.value = fval[i][j] ;
            f.headside = headside[i][j] ;
            f.inherent = inherent[i][j] ;
            f.obligatory = obligatory[i][j] ;
            w.add( f ) ;
          }
        } // j
        mywbeer.regist( w ) ;
      }
    } // i

    String str = "" ;
    mywbeer.doParse( pf ) ;
    if ( mywbeer.hasErrMsg() ) {
      str = "-----error-----\n" + mywbeer.errMsg() ;
    } else {
      if ( mywbeer.legitimate() ) {
        str = "-----success-----\n" ;
      } else {
        str = "-----error-----\n" + mywbeer.errMsg() ;
      }
    }
    mytreeimage = mywbeer.treeImage() + str ;
    mystackimage = mywbeer.stackImage() + str ;
    init = true ;
  } // parse()

  public String step( String pf ) {
    String str = "" ;
    boolean ret ;
    if ( init ) {
      init = false ;
      makechain = false ;
      makeassoc = false ;
      mywbeer.clear() ;

      for ( int i = 0 ; i < wn ; i++ ) {
        if ( wname[i] != null && !wname[i].equals( "" ) ) {
          Word w = new Word( wname[i] ) ;
          for ( int j = 0 ; j < fn ; j++ ) {
            if ( fname[i][j] != null && !fname[i][j].equals( "" ) ) {
              Feature f = new Feature( fname[i][j] ) ;
              f.value = fval[i][j] ;
              f.headside = headside[i][j] ;
              f.inherent = inherent[i][j] ;
              f.obligatory = obligatory[i][j] ;
              w.add( f ) ;
            }
          } // j
          mywbeer.regist( w ) ;
        }
      } // i

      ret = mywbeer.startStep( pf ) ;
    } else if ( !makeassoc ) {
      ret = mywbeer.nextStep() ;
    } else if ( !makechain ) {
      ret = mywbeer.makeOneAssoc() ;
    } else {
      ret = mywbeer.makeOneChain() ;
    }

    if ( mywbeer.hasErrMsg() ) {
      str = "-----error-----\n" + mywbeer.errMsg() ;
      init = true ;
    } else {
      if ( !ret ) {
        if ( !makeassoc ) {
          makeassoc = true ;
          ret = mywbeer.makeOneAssoc() ;
          if ( !ret ) {
            makechain = true ;
          }
        }
        if ( !makechain ) {
          makechain = true ;
          ret = mywbeer.makeOneChain() ;
          if ( !ret ) {
            init = true ;
            if ( mywbeer.legitimate() ) {
              str = "-----success-----\n" ;
            } else {
              str = "-----error-----\n" + mywbeer.errMsg() ;
            }
          }
        } else {
          if ( !init ) {
            ret = mywbeer.makeOneChain() ;
            if ( !ret ) {
              init = true ;
              if ( mywbeer.legitimate() ) {
                str = "-----success-----\n" ;
              } else {
                str = "-----error-----\n" + mywbeer.errMsg() ;
              }
            }
          }
        }
      }
    }
    mytreeimage = mywbeer.treeImage() + str ;
    mystackimage = mywbeer.stackImage() + str ;
    return str ;
  }

  public void reset() {
    init = true ;
    mywbeer.clear() ;
    mytreeimage = "" ;
    mystackimage = "" ;
  }

  public String treeImage() {
    return mytreeimage ;
  }

  public String stackImage() {
    return mystackimage ;
  }
}

