//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDDEV_H
#define WSDDEV_H

#include <WScom.h>
#include <WSDEV.h>
#include <WSCroot.h>
#include <WSClistData.h>
#include <WSDcolor.h>

class WSCbase;
class WSDdraw;
class WSDimage;
class WSCstring;

class WSDdev   :public WSCroot{

  public:
    long    _event_mask;
    short   _x;            
    short   _y;
    static  WSCushort _w;
    static  WSCushort _h;
  protected:
static    WSDdraw* _draw;
static    WSDdraw* _native_draw;
    WSCbase* _client;
    double*  _scale_ptr;
    short*   _x_offset_ptr;
    short*   _y_offset_ptr;
    void (*_addr_change_handler)(WSDdev*,void*);
    void*    _handler_data;
    WSDdev*  _parent_dev;
    WSDdev*  _event_parent_dev;
    unsigned _initialized:1;
    unsigned _visible:1;
    unsigned _any_where:1;
    unsigned _registered:1;
    unsigned _absolute_draw:1;
    unsigned _no_child:1;
    unsigned _deleted:1;

    void      setInitialized(WSCbool fl);
    WSCbool   getEventRegistered();
    void      setEventRegistered(WSCbool);

  public:
    WSDdev();
    virtual ~WSDdev();

    virtual long setEventOrder(WSDdev* dev,char top_or_bottom);
    virtual long setEvent(WSDdev* dev,WSCbool on_off);
    virtual long execEvent(long ev_kind,void* data);
    virtual long cancelEvent(WSDdev* dev);
    virtual long detachClient();
    virtual long initialize();

    void setScalePtr(double*);
    void setXOffsetPtr(short*);
    void setYOffsetPtr(short*);
    double getScale();
    short  getXOffset();
    short  getYOffset();
    void getWH(WSCushort*,WSCushort*);

    long     attachClient(WSCbase*);
    WSCbool  getAttached(); 
    WSCbase* getAttachedClient();
    WSCbool  getInitialized();
static    WSDdraw* getNativeDraw();
static    WSDdraw* getDraw();
static    long setNativeDraw(WSDdraw*);
static    long setDraw(WSDdraw*);
    long setForeColor(short cid);
    long setBackColor(short cid);
    long setForeColor(WSDcolor*);
    long setBackColor(WSDcolor*);
    long setLineWidth(short);
    long setLineDashType(char no);
    long setHatchPattern(char no);

    virtual long setValue(long kind,void* value); 
    virtual long getValue(long kind, void* value); 

    virtual void setExposedArea(short x,short y,WSCushort w,WSCushort h); 
    virtual long getExposedArea(short* x,short* y,WSCushort* w,WSCushort* h,WSCbool scaling = True); 
    virtual WSCbool isExposed(short x,short y,WSCushort w,WSCushort h,WSCbool scaling = True);

    virtual long setRegion(short x,short y,WSCushort w,WSCushort h);
    virtual long beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool absolute = False,WSCbool scaling = True);
    virtual long endDraw();

    long drawArc(short x,short y,WSCushort width,WSCushort height,short _a1,short _a2);
    long drawFillArc(short x,short y,WSCushort width,WSCushort height,short _a1,short _a2,char kind);
    long drawLine(short x1,short y1,short x2,short y2);
    long drawLines(WSCpoint*,long num);
    long drawRect(short x,short y,WSCushort w,WSCushort h);
    long drawFillRect(short x,short y,WSCushort w,WSCushort h);
    long drawRects(WSCrect*,long num);
    long drawFillRects(WSCrect*,long num);
    long drawPoly(WSCpoint*,long num);
    long drawFillPoly(WSCpoint*,long num);
    long drawGradation(long type,short col1,short col2,short col3,
              short x,short y,WSCushort w,WSCushort h,WSCuchar grad_margin);

    long drawImage(short x,short y,WSCushort,WSCushort,WSDimage*,char align);
    long drawImage(short x,short y,short sx,short sy,WSCushort,WSCushort,WSDimage*);
    long drawStretchedImage(short x,short y,WSCushort w,WSCushort h,WSDimage*);

    long drawString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                    char font,char align,long cur,WSCbool inter_cur,
                    long spos1=0,long spos2=0);

    long drawString(long x,long y,WSCulong w,WSCulong h,char font,char align,
                            char*,long encoding = WS_EN_DEFAULT);

    long drawUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                     char font,char align,long cur,WSCbool inter_cur,
                     long spos1=0,long spos2=0);

    long drawFillString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                        char font,char align,long cur,WSCbool inter_cur);

    long drawFillString(long x,long y,WSCulong w,WSCulong h,char font,char align,
                        char*,long encoding = WS_EN_DEFAULT);

    long drawFillUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                         char font,char align,long cur,WSCbool inter_cur);

    virtual long exposeArea(long x,long y,WSCulong w,WSCulong h,WSCbool scaling = True);
    virtual long clearArea(long x,long y,WSCulong w,WSCulong h,WSCbool fl,WSCbool scaling = True);

    virtual long setVisible(WSCbool);
    virtual WSCbool isAvailableEvent(long ev_kind);
    virtual long setEnableEvent(long ev_kind);
    virtual long setEnableEventBit(long ev_bit);
    virtual long setDisableEvent(long ev_kind);
    virtual long setAbsoluteAddrChangeHandler(void(*)(WSDdev*,void*),void*);

    virtual long getAvailableEventBit();
    virtual void getAbsoluteAddr(short,short,short*,short*);
    virtual void getDispAddr(short*,short*);

    virtual WSDdev* getParentDev();
    virtual WSDdev* getEventParentDev();
    virtual WSDdev* getVisibleParentDev();

    virtual long getDeviceResource() =0;
    virtual long getWindowResource() =0;
    virtual long getContextResource() =0;
    virtual long getSpecialResource() =0;
    virtual WSCbool getReady();

    virtual long copyArea(long,long,WSCulong,WSCulong,long,long);

    void setEventMaskBit(long);
    long getEventMaskBit();
    void getGeom(short* ox,short* oy,WSCushort* ow,WSCushort* oh);
    long informEventToClient(long ev_kind,void*);
    WSCbool getVisible();
    WSCbool getNoChildDev();
    void deleteInstance();
    void setParentDev(WSDdev*);
    void setEventParentDev(WSDdev*);
    WSMFclassDef(WSDdev,WSCroot);

};
#endif
