#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>
//----------------------------------------------------------
//Function for the event procedure
//----------------------------------------------------------
#include <WSCimageSet.h>
#include <WSDmwindowDev.h>
#include <WSCopenglForm.h>
#include <GL/gl.h>
#ifndef MacOS
#include <GL/glut.h>
#else
#include <GLUT/glut.h>
#endif

static double rot = 0.0;
double rot_direction = 1.0;
GLuint t2id;
GLuint teapotdlist;

void drawep(WSCbase* object){
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  static WSCbool init=False;
  if (init == False){
    init = True;
    glShadeModel(GL_SMOOTH);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_CULL_FACE);
    glEnable(GL_TEXTURE_2D);

    glGenTextures(1,&t2id);
    glBindTexture(GL_TEXTURE_2D,t2id);

    WSDimage* image = WSGIappImageSet()->getImage("texture.jpg");
    WSDmwindowDev* mdev = WSDmwindowDev::getNewInstance();
    long w = image->getImageWidth();
    long h = image->getImageHeight();
    mdev->createPixmap(w,h);
    mdev->beginDraw(0,0,w,h);
    mdev->drawStretchedImage(0,0,w,h,image);
    mdev->endDraw();
    mdev->initBuffer();

    WSCuchar* buf = mdev->getBuffer();

    gluBuild2DMipmaps(GL_TEXTURE_2D,GL_RGB,w,h,GL_RGB,GL_UNSIGNED_BYTE,buf);
    delete buf;

    teapotdlist=glGenLists(1);
    glNewList(teapotdlist,GL_COMPILE);
    glRotatef(90.0,1.0,0.0,0.0);
    glCullFace(GL_FRONT);
    glutSolidTeapot(175);
    glCullFace(GL_BACK);
    glEndList();

  }

  glPushMatrix();               // BEGIN

  glTranslatef (0, 0, -1500.0);
  glRotatef((GLfloat)rot, 1.0, 2.0, 1.0); // rotation
  rot += rot_direction;

  glCallList(teapotdlist);

  glPopMatrix();                // END
}
static WSCfunctionRegister  op("drawep",(void*)drawep);
