//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCOM_H
#define WSCOM_H

///////////////////////////////////////
// definition of directories and files
///////////////////////////////////////
#ifndef WS_DEFAULT_DIR
#define  WS_DEFAULT_DIR   "/usr/local/ws"
#endif

#if 0
#ifdef LINUX
# undef  WS_DEFAULT_DIR
# define  WS_DEFAULT_DIR   "/usr/local/ws"
#endif

#ifdef SUN
# undef  WS_DEFAULT_DIR
# define  WS_DEFAULT_DIR   "/opt/ws"
#endif

#ifdef MSW
# undef  WS_DEFAULT_DIR
# define  WS_DEFAULT_DIR   "C:/ws"
#endif
#endif


//#define WS_NO_DEBUG_TRACE 0
//#define WS_NO_DEBUG_TRACE 1

#ifdef MSW
# define WSDLEX __declspec(dllexport)
#else
# define WSDLEX 
#endif

#include <WSNdef.h>

//#define PDBG
//#define MEMDBG
#ifdef MEMDBG
#include <stddef.h>
extern void* operator new(size_t);
extern void operator delete(void*);
extern void operator delete[](void*);
#endif

#define WS_PROCEDURE_NAME            1
#define WS_OBJECT_NAME               2
#define WS_OBJECT_ARRAY_NAME         3
#define WS_OBJECT_ARRAY_NAME_INVALID 4
#define WS_OTHER_NAME                5

/////////////////////////////////////
// Strings used by  set/getUserData
/////////////////////////////////////

#define WS_BASE_CLASS       "BASE-CLASS"
#define WS_TRG_LIST         "TRG-LIST"
#define WS_WIN_STORE        "WIN-STORE"
#define WS_WIN_CLASS        "WIN-CLASS"
#define WS_WIN_CLASS_BASE   "WIN-CLASS-BASE"
#define WS_CLASS_ICON       "WS-CLASS-ICON"
#define WS_CLASS_COMMENT    "WS-CLASS-COMMENT"
#define WS_EXT_VAR          "EXT-VAR"
#define WS_PROPERTY_CHANGED "PROP-CHANGED"
#define WS_GEOMETRY_UPDATE  "GEOMETRY-UPDATE"
#define WS_DET              "WS-DET"
#define WS_VIS              "WS-VIS"
#define WS_PROP_LIST        "WS-PROP-LIST"
#define WS_UTRG_LIST        "WS-UTRG-LIST"
#define WS_RMETHOD_LIST     "WS-RMETHOD-LIST"
#define WS_REGISTERED       "WS-REG"
#define WS_FILENAME         "WS-FNAME"
#define WS_PM_POPUPED       "WS-PM-POPUPED"
#define WS_RCLASS_GENERATE  "WS-RCLASS-GENERATE"
#define WS_RCLASS_NAME      "WS-RCLASS-NAME"
#define WS_RCLASS_BNAME     "WS-RCLASS-BNAME"

// arc types
#define WS_ARC_NONE     -1
#define WS_ARC_OPEN      0
#define WS_ARC_CLOSE     1
#define WS_ARC_PIE       2

//FILL ARC type
#define WS_PI     0
#define WS_NOPI   1

//object type
#define WS_TYPE_WINDOW   0x0001
#define WS_TYPE_MANAGER  0x0002
#define WS_TYPE_FORM     0x0004
#define WS_TYPE_SCR_FORM 0x0008

#define WS_OOF_SUFFIX   ".oof"
#define WS_OOF_SUFFIX2  "oof"

#define WS_CPP_SUFFIX   ".cpp"
#define WS_CPP_SUFFIX2  "cpp"


#define  WS_INCLUDE_DIR   "$(WSDIR)/usr/include/"
#define  WS_PIXMAP_DIR    "$(WSDIR)/sys/pixmaps/"
#define  WS_DATA_DIR      "$(WSDIR)/sys/data/"
#define  WS_CFG_DIR      "$(WSDIR)/sys/config/"
#define  WS_BIN_DIR       "$(WSDIR)/bin/"

//#define  WS_BTN_PIX       WS_PIXMAP_DIR "tbtn2.xpm"
//#define  WS_BTN2_PIX      WS_PIXMAP_DIR "tbtn3.xpm"
#define  WS_EBTN_PIX      WS_PIXMAP_DIR "endbtn.xpm"
//#define  WS_BG_PIX        WS_PIXMAP_DIR "bg.xpm"
#define  WS_TG1_PIX       WS_PIXMAP_DIR "tbl1.xpm"
#define  WS_TG2_PIX       WS_PIXMAP_DIR "tbl2.xpm"

#define  WS_COLOR_FILE    WS_DATA_DIR "color.data"
#define  WS_TOOLB_FILE    WS_DATA_DIR "toolb.data"
#define  WS_PROPS_FILE    WS_DATA_DIR "prop.def"

//#define  WS_BAR_PIX256    WS_PIXMAP_DIR "bar/bar256.jpg"
//#define  WS_BAR_PIX512    WS_PIXMAP_DIR "bar/bar512.jpg"
//#define  WS_BAR_PIX768    WS_PIXMAP_DIR "bar/bar768.jpg"
//#define  WS_BAR_PIX1024   WS_PIXMAP_DIR "bar/bar1024.jpg"
//#define  WS_BAR_PIX1536   WS_PIXMAP_DIR "bar/bar1536.jpg"
//#define  WS_VBAR_PIX256    WS_PIXMAP_DIR "bar/vbar256.jpg"
//#define  WS_VBAR_PIX512    WS_PIXMAP_DIR "bar/vbar512.jpg"
//#define  WS_VBAR_PIX768    WS_PIXMAP_DIR "bar/vbar768.jpg"
//#define  WS_VBAR_PIX1024   WS_PIXMAP_DIR "bar/vbar1024.jpg"
//#define  WS_VBAR_PIX1536   WS_PIXMAP_DIR "bar/vbar1536.jpg"
/////////////DEVELOP////////////////////////////

///////////////
// Running Mode
#define WS_MODE_NORMAL       0
#define WS_MODE_NS_PLUGIN    1

//ENCODING..
#define WS_EN_DEFAULT    -2
#define WS_EN_LOCALE     -1
#define WS_EN_NONE        0
#define WS_EN_ISO8859_1   1
#define WS_EN_ISO8859_2   2
#define WS_EN_ISO8859_3   3
#define WS_EN_ISO8859_4   4
#define WS_EN_ISO8859_5   5
#define WS_EN_ISO8859_6   6
#define WS_EN_ISO8859_7   7
#define WS_EN_ISO8859_8   8
#define WS_EN_ISO8859_9   9
#define WS_EN_ISO8859_10  10
#define WS_EN_ISO8859_11  11
#define WS_EN_ISO8859_12  12
#define WS_EN_ISO8859_13  13
#define WS_EN_ISO8859_14  14
#define WS_EN_ISO8859_15  15
#define WS_EN_UTF8        16
#define WS_EN_KOI8R       17
#define WS_EN_EUCJP       20
#define WS_EN_SJIS        21
#define WS_EN_EUCKR       30
#define WS_EN_EUCCN       40
#define WS_EN_BIG5        50

#define WS_EN_LANG_NONE    0
#define WS_EN_LANG_JP      1

#define WSN_EN_DEFAULT    "DEFAULT"
#define WSN_EN_LOCALE     "LOCALE"
#define WSN_EN_NONE       "NONE"
#define WSN_EN_ISO8859_1  "C"
#define WSN_EN_ISO8859_2  "ISO8859-2"
#define WSN_EN_ISO8859_3  "ISO8859-3"
#define WSN_EN_ISO8859_4  "ISO8859-4"
#define WSN_EN_ISO8859_5  "ISO8859-5"
#define WSN_EN_ISO8859_6  "ISO8859-6"
#define WSN_EN_ISO8859_7  "ISO8859-7"
#define WSN_EN_ISO8859_8  "ISO8859-8"
#define WSN_EN_ISO8859_9  "ISO8859-9"
#define WSN_EN_ISO8859_10 "ISO8859-10"
#define WSN_EN_ISO8859_11 "ISO8859-11"
#define WSN_EN_ISO8859_12 "ISO8859-12"
#define WSN_EN_ISO8859_13 "ISO8859-13"
#define WSN_EN_ISO8859_14 "ISO8859-14"
#define WSN_EN_ISO8859_15 "ISO8859-15"
#define WSN_EN_UTF8       "UTF8"
#define WSN_EN_KOI8R      "KOI8R"
#define WSN_EN_EUCJP      "EUCJP"
#define WSN_EN_SJIS       "SJIS"
#define WSN_EN_EUCKR      "EUCKR"
#define WSN_EN_EUCCN      "EUCCN"
#define WSN_EN_BIG5       "BIG5"
#define WSN_EN_UTF8_JP    "UTF8_JP"

typedef unsigned char  WSCbool;
typedef void*          WSCptr;
typedef unsigned short WSCushort;
typedef unsigned long  WSCulong;
typedef unsigned char  WSCuchar;
typedef unsigned int   WSCuint;
class WSCbase;
class WSDmwindowDev;
class WSDimage;
typedef void (*WSCeventProc)(WSCbase*);

//kind of mouse button state ,return value of WSDmouse::getMouseStatus()
#define WS_MOUSE_SHIFT     (1<<0)
#define WS_MOUSE_LOCK      (1<<1)
#define WS_MOUSE_CONTROL   (1<<2)
#define WS_MOUSE_MOD       (1<<3)
#define WS_MOUSE_BTN1      (1<<8)
#define WS_MOUSE_BTN2      (1<<9)
#define WS_MOUSE_BTN3      (1<<10)
#define WS_MOUSE_BTN4      (1<<11)
#define WS_MOUSE_BTN5      (1<<12)

//kind of read write mode
#define WS_READ      0
#define WS_WRITE     1
#define WS_RW        2

//kind of indicator type
#define WS_IN_OUT     (unsigned char)0
#define WS_OUT        (unsigned char)1
#define WS_IN         (unsigned char)2
#define WS_NONE       (unsigned char)3

//kind of orientation
#define WS_VERTICAL   (unsigned char)1
#define WS_HORIZONTAL (unsigned char)0

//PIXMAP STYLE
#define WS_DIRECT_WINDOW      (char)(0)
#define WS_DYNAMIC_PIXMAP     (char)(1)

//SHADOW TYPE  //notice. exist in WSRdef
#define WS_SHADOW_NONE     (signed char)(-1)
#define WS_SHADOW_TRANS    (signed char)(-1)
#define WS_SHADOW_OUT      (0)
#define WS_SHADOW_IN       (1)
#define WS_SHADOW_EOUT     (2)
#define WS_SHADOW_EIN      (3)
#define WS_SHADOW_BORDER   (4)

//TITLE BAR  //notice. exist in WSRdef
#define WS_NO_TITLE       (char)0
#define WS_FULL_TITLE     (char)1
#define WS_ONLY_TITLE     (char)2
#define WS_MINI_BTN       (char)3
#define WS_MAX_BTN        (char)4
#define WS_FRAME          (char)5
#define WS_NO_MANAGE      (char)6

//do not change...
#define WS_LEFT           0
#define WS_RIGHT          1
#define WS_CENTER         2
#define WS_UP             3
#define WS_TOP            3
#define WS_DOWN           4
#define WS_BOTTOM         4

#define WS_LEFT_TOP       5
#define WS_LEFT_BOTTOM    6
#define WS_RIGHT_TOP      7
#define WS_RIGHT_BOTTOM   8
#define WS_RET            9
#define WS_TAB           11
#define WS_STAB          12

#define WS_NO_ERR  0
#define WS_OK      0
#define WS_ERR    -1
#define WS_REMOTE_CALL_FAILED    -1

#ifndef TE
#ifndef False
#define False       (WSCbool)0
#endif

#ifndef True
#define True        (WSCbool)1
#endif

#else //TE
extern "C" {
extern char*  getcwd(char*,unsigned int);
extern int  chdir(const char*);
//struct timeval{
//    int tv_sec;        /* Seconds.  */
//    int tv_usec;       /* Microseconds.  */
//};
struct timezone {
    int tz_minuteswest;     /* Minutes west of GMT.  */
    int tz_dsttime;     /* Nonzero if DST is ever in effect.  */
};
extern int gettimeofday(struct timeval *__tv,
                  struct timezone *__tz);
};
#endif //TE

//property type
#define WSTlong         0
#define WSTulong        1
#define WSTshort        2
#define WSTushort       3
#define WSTchar         4
#define WSTuchar        5
#define WSTfloat        6
#define WSTdouble       7
#define WSTvoidptr      8
#define WSTcharptr      9
#define WSTvoid        10
#define WSTbool        11
#define WSTint         12
#define WSTuint        13

//events
#define  WSEV_HASH_MAX_NUM        32
#define  WSEV_NONE                -1
#define  WSEV_INITIALIZE           (long)0
#define  WSEV_DELETE               (long)1
#define  WSEV_ACTIVATE             (long)2
#define  WSEV_VALUE_CH             (long)3
#define  WSEV_FOCUS_CH             (long)4
#define  WSEV_VISIBLE_CH           (long)5
#define  WSEV_SENSITIVE_CH         (long)6
#define  WSEV_PARENT_VISIBLE_CH    (long)7
#define  WSEV_PARENT_SENSITIVE_CH  (long)8
#define  WSEV_EXPOSE               (long)9
#define  WSEV_RESIZE              (long)10
#define  WSEV_MOUSE_IN            (long)11
#define  WSEV_MOUSE_OUT           (long)12
#define  WSEV_MOUSE_PRESS         (long)13
#define  WSEV_MOUSE_RELEASE       (long)14
#define  WSEV_MOUSE_MOVE          (long)15 
#define  WSEV_KEY_PRESS           (long)16
#define  WSEV_KEY_RELEASE         (long)17
#define  WSEV_KEY_HOOK            (long)18
#define  WSEV_MOUSE_DOUBLE_CLICK  (long)19

#define  WSEV_SORT                (long)33
#define  WSEV_GUI_POLICY_CH       (long)34
#define  WSEV_ITEM_SELECTED       (long)35
#define  WSEV_STATUS_CH           (long)36
#define  WSEV_INPUT_FIXED         (long)37
#define  WSEV_BEGIN               (long)38
#define  WSEV_END                 (long)39
#define  WSEV_INCREMENT           (long)40
#define  WSEV_DECREMENT           (long)41
#define  WSEV_PAGE_INCREMENT      (long)42
#define  WSEV_PAGE_DECREMENT      (long)43
#define  WSEV_SCR_MOUSE_PRESS     (long)44
#define  WSEV_SCR_MOUSE_RELEASE   (long)45
#define  WSEV_SCR_MOUSE_MOVE      (long)46 
#define  WSEV_EDIT_MODE_CH        (long)47
#define  WSEV_SPECIAL_FOCUS_CH    (long)48
#define  WSEV_CHILD_ADDED         (long)49
#define  WSEV_SELECTION_CH        (long)50
#define  WSEV_SCR_MOUSE_DOUBLE_CLICK  (long)51
#define  WSEV_ITEM_DOUBLE_CLICKED    (long)52
#define  WSEV_THREAD_STARTED      (long)53

#define  WSEV_NONE_BIT                0x00000000
#define  WSEV_INITIALIZE_BIT          0x00000001
#define  WSEV_DELETE_BIT              0x00000002
#define  WSEV_ACTIVATE_BIT            0x00000004
#define  WSEV_VALUE_CH_BIT            0x00000008
#define  WSEV_FOCUS_CH_BIT            0x00000010
#define  WSEV_VISIBLE_CH_BIT          0x00000020
#define  WSEV_SENSITIVE_CH_BIT        0x00000040
#define  WSEV_PARENT_VISIBLE_CH_BIT   0x00000080
#define  WSEV_PARENT_SENSITIVE_CH_BIT 0x00000100
#define  WSEV_EXPOSE_BIT              0x00000200
#define  WSEV_RESIZE_BIT              0x00000400
#define  WSEV_MOUSE_IN_BIT            0x00000800
#define  WSEV_MOUSE_OUT_BIT           0x00001000
#define  WSEV_MOUSE_PRESS_BIT         0x00002000
#define  WSEV_MOUSE_RELEASE_BIT       0x00004000
#define  WSEV_MOUSE_MOVE_BIT          0x00008000
#define  WSEV_KEY_PRESS_BIT           0x00010000
#define  WSEV_KEY_RELEASE_BIT         0x00020000
#define  WSEV_KEY_HOOK_BIT            0x00040000


//#ifndef MSW //if unix system
#include <assert.h>
//#else
//#define assert
//#endif

#ifdef MSW //if not unix system
#include <windows.h>
#define WS_WINMAIN extern "C" { \
extern int _win_main(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow); \
int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow){ \
return _win_main(hInstance,hPrevInstance,lpCmdLine,nCmdShow); }; };

#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <stdarg.h>

#if defined MSW
extern int _dbprintf_init();
extern int _dbprintf(const char*,...);
#define dbprintf _dbprintf
#else
extern int _dbprintf_init();
extern int _dbprintf(const char*,...);
extern FILE* _ws_debug_fp;
#define dbprintf if (_ws_debug_fp) _dbprintf
#endif

typedef struct {
  long x, y;
  inline void setPoint(long vx,long vy){
    x = vx;
    y = vy;
  }
} WSCpoint;

struct WSCrect {
  long x, y;
  WSCulong width, height;
  inline void setRect(long vx,long vy,WSCulong vw,WSCulong vh){
    x = vx;
    y = vy;
    width = vw;
    height = vh;
  }
  inline void setRect(WSCrect* r){
    x = r->x;
    y = r->y;
    width = r->width;
    height = r->height;
  }
};
struct WSCrectList {
  WSCrect rect;
  WSCrectList* next;
};
class WSCstring;
extern WSDLEX void  WSGFtrace(WSCstring);
extern WSDLEX char* WSGFstrdup(const char*);
extern WSDLEX long  WSGFstricmp(char*,char*);
extern WSDLEX long  WSGFstrnccmp(char*,char*,long);
extern WSDLEX void  WSGFtrimSpace(char*);
extern WSDLEX WSCulong WSGFeventToMaskBit(long);
extern WSDLEX long WSGFmaskBitToEvent(WSCulong);
extern WSDLEX short WSGFindexColor(char*);
extern WSDLEX short WSGFcolor(char*);
extern WSDLEX char* WSGFcolorName(short);
extern WSDLEX short WSGFimage(char*);
extern WSDLEX char* WSGFimageName(short);

extern WSDLEX WSCuchar  WSGFblinkRate(long);
extern WSDLEX WSCbool  WSGFareaInclude(short,short,WSCushort,WSCushort,
                                short,short,WSCushort,WSCushort);
extern WSDLEX long     WSGForArea(long,long,WSCulong,WSCulong,
                           long,long,WSCulong,WSCulong,
                           long*,long*,WSCulong*,WSCulong*);
extern WSDLEX long     WSGFandArea(long,long,WSCulong,WSCulong,
                            long,long,WSCulong,WSCulong,
                            long*,long*,WSCulong*,WSCulong*);
class WSDdev;
extern WSDLEX void WSGFdrawShadow(WSDdev* dev,char shadow_type,
                           WSCushort shadow_thick,
                           short fg_no,short ts_no,short bs_no,short bg_no,
                           short x,short y,WSCushort w,WSCushort h,WSCbool nodark=False);
extern WSDLEX void WSGFdrawBtnShadow(WSDdev* dev,char shadow_type,
                           WSCushort shadow_thick,
                           short fg_no,short ts_no,short bs_no,short bg_no,
                           short x,short y,WSCushort w,WSCushort h,WSCbool nodark=False);
extern WSDLEX void WSGFdrawArrow(WSDdev* dev,WSCbool fill,
                           WSCushort shadow_thick,
                           short bg_no, short ts_no,short bs_no,
                           char direction,
                           short x,short y,WSCushort w,WSCushort h);

//convert jis string to euc-jp string  //return results by static buffer
extern WSDLEX char* WSGFcreateEucStringFromJisStr(char*);
extern WSDLEX char* WSGFcreateJisStringFromEucStr(char*);

class WSCstring;
class WSDfont;
extern WSDLEX long WSGFcalcOneLineStringAddr(WSCstring* str,WSCrect* area,
                               char alignment,WSDfont* font,
                               WSCpoint* out);
extern WSDLEX long WSGFcalcStringAddr(WSCstring* str,WSCrect* area,
                               char alignment,WSDfont* font,
                               WSCpoint** out,long* num);

extern WSDLEX long WSGFcalcStringPosAddr(WSCushort* istr,WSCrect* area,
                                  char alignment,WSDfont* font,
                                  long pos,
                                  long* ox,long *oy);

extern WSDLEX long WSGFcalcStringPosFromAddr(WSCushort* istr,WSCrect* area,
                                  char alignment,WSDfont* font,
                                  long x,long y,
                                  long* pos,WSCbool intercur);
extern WSDLEX long WSGFcalcStringXYPos(WSCushort* istr,long pos,
                                long* xpos,long* ypos);
extern WSDLEX long WSGFcalcStringXYPosToPos(WSCushort* istr,long xpos,
                                     long ypos,long* pos);
extern WSDLEX long WSGFgetLinesUCS2(WSCushort*);
extern WSDLEX long WSGFstrlenUCS2(WSCushort*);
extern WSDLEX void WSGFdelTailSpaceUCS2(WSCushort*);
extern WSDLEX void WSGFdelStringUCS2(WSCushort*,long pos,long chars);
extern WSDLEX WSCushort* WSGFinsertStringUCS2(WSCushort*,long pos,WSCushort* ins);
extern WSDLEX WSCushort* WSGFreplaceStringUCS2(WSCushort*,WSCushort* src,WSCushort* dest,long* num);
extern WSDLEX long WSGFdelLineFeedUCS2(WSCushort*);
extern WSDLEX WSCushort* WSGFstrdupUCS2(WSCushort*);
extern WSDLEX WSCushort* WSGFgetWordUCS2(WSCushort*,long pos,WSCushort*);
extern WSDLEX long WSGFgetWordCharPosUCS2(WSCushort*,long pos,WSCushort*);
extern WSDLEX WSCushort* WSGFgetUCS2(const char* text,long encode);
extern WSDLEX char* WSGFgetString(WSCushort* text,long encode);
extern WSDLEX WSCushort* WSGFaddStringUCS2(WSCushort* str1,WSCushort* str2);
extern WSDLEX WSDmwindowDev* WSGFgetAquaImage(short col,WSCushort,WSCushort,long);
extern WSDLEX WSDmwindowDev* WSGFgetAquaMaskImage(WSCushort,WSCushort,long);


//do not change this size
#define WS_MAX_HASH_VALUE       64
extern WSDLEX long WSGFgetHashValue(char*);

#ifndef WS_DEBUG
#  ifdef __GNUC__
#    define WSMFtrace(x...)   
#  else 
#    define WSMFtrace
#  endif
#else
#  ifdef MSW
#    define WSMFtrace  printf
#  else
#    define WSMFtrace  printf
#  endif
#endif

extern WSDLEX WSCbase* WSGIappPropertyEditor();
extern WSDLEX long      WSGFsetAppPropertyEditor(WSCbase*);
extern WSDLEX WSCbase* WSGIappWindowList();
extern WSDLEX long      WSGFsetAppWindowList(WSCbase*);

extern WSDLEX long WSGFclocktime();
extern WSDLEX void WSGFtimetrace();
extern WSDLEX void WSGFsetTimePoint();
extern WSDLEX long WSGFdiffTimePoint();

extern WSDLEX char* WSGFltoa(long val);
extern WSDLEX char* WSGFltoa(long val,char* buf); 
extern WSDLEX char* WSGFultoa(WSCulong val); 
extern WSDLEX char* WSGFultoa(WSCulong val,char* buf);
extern WSDLEX char* WSGFftoa(float);
extern WSDLEX char* WSGFlftoa(double);

extern WSDLEX void WSGFgettimeofday(long* );

extern WSDLEX WSCbase* WSGFgetNewGripHand(WSCbase* parent);

extern WSDLEX WSCstring* WSGFcreateWindowHeader(WSCbase*);
extern WSDLEX WSCstring* WSGFcreateWindowSrc(WSCbase*);
extern WSDLEX WSCstring* WSGFcreateWindowSrcRb(WSCbase*);
extern WSDLEX WSCstring* WSGFcreateWindowSrcPy(WSCbase*);
extern WSDLEX WSCstring* WSGFcreateWindowSrcPerl(WSCbase*);
extern WSDLEX WSCstring* WSGFcreateWindowSrcPerl_new(WSCbase*);

//extern WSDLEX short  WSGFgetBarPixmap(WSCushort,WSCuchar);
extern WSDLEX void   WSGFmarkChanged(WSCbase*);
extern WSDLEX void   WSGFclearMarkChanged(WSCbase*);
extern WSDLEX WSCbool WSGFcheckMarkChanged(WSCbase*);
class WSCproperty;
extern WSDLEX char*   WSGFconvertPropValueString(WSCproperty*,char*);
extern WSDLEX void    WSGFsetEditMode(WSCbase*,WSCbool edit);
class WSClistData;
extern WSDLEX void    WSGFgetProcedureList(WSCbase*,WSClistData*);
extern WSDLEX long    WSGFadjustNumber(long,long);
extern WSDLEX WSCbool  WSGFreadInitString(WSCstring*,char*,WSCstring*,WSCstring*);
extern WSDLEX void     WSGFopCreate(WSCstring*,char*,char*);
extern WSDLEX void     WSGFopCreateRb(WSCstring*,char*,char*);
extern WSDLEX void     WSGFopCreatePy(WSCstring*,char*,char*);
extern WSDLEX void     WSGFopCreatePerl(WSCstring*,char*,char*);
extern WSDLEX void     WSGFclassProcedureCreate(WSCstring*,char*,char*,char*);
extern WSDLEX WSCbool  WSGFcheckNameString(char*);
extern WSDLEX WSCbool  WSGFcheckPureNameString(char*);
extern WSDLEX WSCbool  WSGFcheckDirNameString(char*);
extern WSDLEX WSCbool  WSGFcheckExistFile(char*);
extern WSDLEX long     WSGFcheckDiffFile(char*,void*,long len);
extern WSDLEX long     WSGFcheckDiffTextFile(char*,char*);
extern WSDLEX long     WSGFreplaceFile(char*,void*,long len,WSCbool same_save);
extern WSDLEX long     WSGFreplaceTextFile(char*,char*,WSCbool same_save);
extern WSDLEX void     WSGFsortCharList(WSClistData* src,WSClistData* dest);
extern WSDLEX void     WSGFsetMargin(WSCbase*,WSCushort);
extern WSDLEX void     WSGFdestroyPixmap(char*);
extern WSDLEX void     WSGFdestroyPixmap(short);
extern WSDLEX void     WSGFdestroyAllPixmap();

extern WSDLEX WSCstring*    WSGFcreateWindowClassHeader(WSCbase*);  //must free
extern WSDLEX WSCstring*    WSGFcreateWindowClassHeaderP(WSCbase*); //must free
extern WSDLEX WSCstring*    WSGFcreateWindowClassSrc(WSCbase*);     //must free
extern WSDLEX WSCstring*    WSGFcreateWindowClassSrcP(WSCbase*);    //must free
extern WSDLEX WSCstring*    WSGFupdateWindowClassHeader(WSCstring*,WSCbase*); //must return value
extern WSDLEX WSCstring*    WSGFreadTextFile(char*,long encoding=WS_EN_DEFAULT); //must free return value
extern WSDLEX WSCbool       WSGFcheckArrayName(char*,long*,char*);
extern WSDLEX long          WSGFexistName(char*,WSCbase*);
extern WSDLEX void          WSGFsetExistNameHandler(long (*)(char*,WSCbase*));
extern WSDLEX void*         WSGFgetExistNameHandler();
extern WSDLEX long          WSGFsendMessage(char*  message_key,char* data);
extern WSDLEX char*         WSGFeventToName(long ev);
extern WSDLEX long          WSGFnameToEvent(char* ev);
extern WSDLEX WSCstring*    WSGFgetMouseCursorSaveData();
extern WSDLEX WSCstring*    WSGFgetFontSaveData();
extern WSDLEX long          WSGFloadMouseCursorFile(char*);
extern WSDLEX long          WSGFloadMouseCursorData(char**);
extern WSDLEX void          WSGFsetFontData(WSCstring* data);
extern WSDLEX void          WSGFloadFontFile(char*);
extern WSDLEX void          WSGFloadFontData(char**);
extern WSDLEX WSCbase*      WSGFgetFontEditor();
extern WSDLEX void          WSGFsetFontEditor(WSCbase*);
extern WSDLEX WSCbase*      WSGFgetClassBase(WSCbase*);
extern WSDLEX void          WSGFresetClassBase(WSCbase*);
extern WSDLEX void          WSGFsetDeleteHandler(void (*)(WSCbase*));
extern WSDLEX void(* WSGFgetDeleteHandler() )(WSCbase*) ;
extern WSDLEX void          WSGFsetCreateHandler(void (*)(WSCbase*));
extern WSDLEX void          WSGFexecCreateHandler(WSCbase*);
extern WSDLEX char*         WSGFtriggerToName(long ev);
extern WSDLEX WSCstring     WSGFgetFileName(char*);
extern WSDLEX WSCstring     WSGFgetDirName(char*);
extern WSDLEX void          WSGFgetAllPropertyList(WSCbase*,WSClistData*);
extern WSDLEX long          WSGFloadWindow(char* field,char* fname,WSCbase** pic,WSCbase*);
extern WSDLEX long          WSGFsaveWindow(char* field,char* fname,WSCbase* pic);
extern WSDLEX long  WSGFdestroyWindow(WSCbase* pic);
extern WSDLEX void  WSGFcreateVerticalString(WSCstring* str);
extern WSDLEX void  WSGFdeviceInitialize();
extern WSDLEX void  WSGFstretchPopup(WSCbase* obj);
extern WSDLEX void  WSGFstretchPopdown(WSCbase* obj);
extern WSDLEX void  WSGFcleanupStretchAction(WSCbase* obj);
extern WSDLEX void  WSGFsetGeometry(WSCbase* obj,short,short,WSCushort,WSCushort);
extern WSDLEX long  WSGFgetLines(char*);

extern WSDLEX char*  WSGFgettext(char*);
extern WSDLEX void WSGFgetShadowColor(short,short*,short*,short*);
extern WSDLEX void WSGFdrawStripes(WSDdev*,WSCushort,WSCushort,short,short,short);

extern WSDLEX long WSGFgetLanguage();
extern WSDLEX void WSGFsetGetLanguageHandler(long(*)());

extern WSDLEX void WSGFwsNsPluginInitialize();
extern WSDLEX void WSGFwsIePluginInitialize();

#ifndef WS_DIALOG_CANCEL
#define WS_DIALOG_CANCEL  0
#endif

#ifndef WS_DIALOG_OK
#define WS_DIALOG_OK      1
#endif

#ifndef WS_DIALOG_NO
#define WS_DIALOG_NO      2
#endif

#ifndef WS_DIALOG_DONE
#define WS_DIALOG_DONE    3
#endif

#define WS_TEXT    0
#define WS_BINARY  1

#define WS_NORMAL  0
#define WS_TREE    1
#define WS_VERBOSE 2

#define WS_LIST_TREE_OPEN "list-tr-open"
#define WS_LIST_TREE_OPEN_CH "list-tr-open-ch"
#define WS_LIST_INDENT_LEVEL "list-indent-level"
#define WS_LIST_INDENT_STATUS "list-indent-status"
#define WS_LIST_LABEL_LIST "list-lb-list"
#define WS_LIST_TOP "list-lb-top"
#define WS_HAVE_CHILD   1
#define WS_HAVE_BROS    2

#define WS_OPEN          0
#define WS_INDENT_LEVEL  1
#define WS_ABSOLUTE_OPEN 2
#define WS_ICON          3

#define WS_SFORM_FIXED          0
#define WS_SFORM_UNDER_RESIZING 1

#define WS_EXEC_NONE      0
#define WS_EXEC_RD        1
#define WS_EXEC_RDWR      2
#define WS_EXEC_WR        3

#define WS_DOUBLE_CLICK_TIME    300

#define WS_POLICY_ORIGINAL   1
#define WS_POLICY_WINDOWS    2
#define WS_POLICY_GRADATION  4
#define WS_POLICY_AQUA       8
#define WS_POLICY_OTHER     16

#define WS_DATA_SOURCE_NONE      0
#define WS_DATA_SOURCE_INSTANCE  1
#define WS_DATA_SOURCE_FILE      2

///////////////////////////////////////////
#define WS_MAX_DF_COLORS        24

#define WS_DF_BACKCOLOR         -1
#define WS_DF_FORECOLOR         -2
#define WS_DF_TOPSHADOWCOLOR    -3
#define WS_DF_BOTTOMSHADOWCOLOR -4
#define WS_DF_MENUBACKCOLOR     -5
#define WS_DF_MENUFORECOLOR     -6
#define WS_DF_MENUSELECTCOLOR   -7
#define WS_DF_MENUTOPSHADOWCOLOR    -8
#define WS_DF_MENUBOTTOMSHADOWCOLOR -9
#define WS_DF_DARKBACKCOLOR         -10
#define WS_DF_WORKBACKCOLOR         -11
#define WS_DF_BARSHADOWCOLOR        -12
#define WS_DF_NWBACKCOLOR           -13
#define WS_DF_NWFORECOLOR           -14
#define WS_DF_NWTOPSHADOWCOLOR      -15
#define WS_DF_NWBOTTOMSHADOWCOLOR   -16
#define WS_DF_DARKBOTTOMSHADOWCOLOR   -17
#define WS_DF_MENUSELECTFORECOLOR     -18
#define WS_DF_AQUAFORECOLOR           -19
#define WS_DF_AQUAHIGHLIGHTCOLOR      -20


#define WS_GR_NONE  0
#define WS_GR_LT_RB 1
#define WS_GR_RT_LB 2
#define WS_GR_LB_RT 3
#define WS_GR_RB_LT 4
#define WS_GR_T_B   5
#define WS_GR_B_T   6
#define WS_GR_L_R   7
#define WS_GR_R_L   8


extern WSDLEX char* WSGFgetLocaleName(long);
extern WSDLEX long WSGFgetLocaleValue(char*);

#define WS250MS   (WSCuchar)1
#define WS500MS   (WSCuchar)2
#define WS750MS   (WSCuchar)3
#define WS1000MS  (WSCuchar)4
#define WS1250MS  (WSCuchar)5
#define WS1500MS  (WSCuchar)6
#define WS1750MS  (WSCuchar)7
#define WS2000MS  (WSCuchar)8
#define WS2250MS  (WSCuchar)9
#define WS2500MS  (WSCuchar)10
#define WS2750MS  (WSCuchar)11
#define WS3000MS  (WSCuchar)12
#define WS3250MS  (WSCuchar)13
#define WS3500MS  (WSCuchar)14
#define WS3750MS  (WSCuchar)15
#define WS4000MS  (WSCuchar)16
#define WS4250MS  (WSCuchar)17
#define WS4500MS  (WSCuchar)18
#define WS4750MS  (WSCuchar)19
#define WS5000MS  (WSCuchar)20
#define WS5250MS  (WSCuchar)21
#define WS5500MS  (WSCuchar)22
#define WS5750MS  (WSCuchar)23
#define WS6000MS  (WSCuchar)24
#define WS6250MS  (WSCuchar)25
#define WS6500MS  (WSCuchar)26
#define WS6750MS  (WSCuchar)27
#define WS7000MS  (WSCuchar)28
#define WS7250MS  (WSCuchar)29
#define WS7500MS  (WSCuchar)30
#define WS7750MS  (WSCuchar)31
#define WS8000MS  (WSCuchar)32
#define WS8250MS  (WSCuchar)33
#define WS8500MS  (WSCuchar)34
#define WS8750MS  (WSCuchar)35
#define WS9000MS  (WSCuchar)36
#define WS9250MS  (WSCuchar)37
#define WS9500MS  (WSCuchar)38
#define WS9750MS  (WSCuchar)39
#define WS10000MS (WSCuchar)40
#define WS10250MS (WSCuchar)41
#define WS10500MS (WSCuchar)42
#define WS10750MS (WSCuchar)43
#define WS11000MS (WSCuchar)44
#define WS11250MS (WSCuchar)45
#define WS11500MS (WSCuchar)46
#define WS11750MS (WSCuchar)47
#define WS12000MS (WSCuchar)48
#define WS12250MS (WSCuchar)49
#define WS12500MS (WSCuchar)50
#define WS12750MS (WSCuchar)51
#define WS13000MS (WSCuchar)52
#define WS13250MS (WSCuchar)53
#define WS13500MS (WSCuchar)54
#define WS13750MS (WSCuchar)55
#define WS14000MS (WSCuchar)56
#define WS14250MS (WSCuchar)57
#define WS14500MS (WSCuchar)58
#define WS14750MS (WSCuchar)59
#define WS15000MS (WSCuchar)60
#define WS15250MS (WSCuchar)61
#define WS15500MS (WSCuchar)62
#define WS15750MS (WSCuchar)63
#define WS16000MS (WSCuchar)64
#define WS16250MS (WSCuchar)65
#define WS16500MS (WSCuchar)66
#define WS16750MS (WSCuchar)67
#define WS17000MS (WSCuchar)68
#define WS17250MS (WSCuchar)69
#define WS17500MS (WSCuchar)70
#define WS17750MS (WSCuchar)71
#define WS18000MS (WSCuchar)72
#define WS18250MS (WSCuchar)73
#define WS18500MS (WSCuchar)74
#define WS18750MS (WSCuchar)75
#define WS19000MS (WSCuchar)76
#define WS19250MS (WSCuchar)77
#define WS19500MS (WSCuchar)78
#define WS19750MS (WSCuchar)79
#define WS20000MS (WSCuchar)80

#define WS_PR_A4         0
#define WS_PR_A5         1
#define WS_PR_A3         2
#define WS_PR_B4         3
#define WS_PR_B5         4
#define WS_PR_LETTER     5
#define WS_PR_LEGAL      6
#define WS_PR_STATEMENT  7
#define WS_PR_TABLOID    8
#define WS_PR_LEDGER     9
#define WS_PR_FOLIO      10
#define WS_PR_QUARTO     11
#define WS_PR_10X14      12
#define WS_PR_EXECUTIVE  13
#define WS_PR_FREE       14

#define WS_PR_PS  0
#define WS_PR_EPS 1
#define WS_PR_PRINTER 2


#define WS_DEFAULT_AGENT_PORT 9105
#define WS_DEFAULT_AGENT_UDP_PORT 9106
#define WS_DEFAULT_SERVER_PORT 0
#define WS_DEFAULT_SERVER_PORT_BASE 9200

#define WS_WINDOW_NORMAL         0
#define WS_WINDOW_MINIMIZE       1
#define WS_WINDOW_MAXIMIZE       2

#define WS_DB_ODBC     0
#define WS_DB_POSTGRES 1

//LANG
#define WS_LANG_CPP    0
#define WS_LANG_RUBY   1
#define WS_LANG_PYTHON 2
#define WS_LANG_PERL   3


//MOUSE
#define WS_DEFAULT_MOUSE_ID "0   132        0          black      white"

#ifdef WIN32
#ifdef WS_DEFAULT_MOUSE_ID
#undef WS_DEFAULT_MOUSE_ID
#endif
#define WS_DEFAULT_MOUSE_ID "0   IDC_ARROW"
#endif


#ifdef BTRON
#ifdef WS_DEFAULT_MOUSE_ID
#undef WS_DEFAULT_MOUSE_ID
#endif
#define WS_DEFAULT_MOUSE_ID "0   PS_SELECT black white"
#endif

#ifdef TE
#ifdef WS_DEFAULT_MOUSE_ID
#undef WS_DEFAULT_MOUSE_ID
#endif
#define WS_DEFAULT_MOUSE_ID "0   PS_SELECT black white"
#endif

#define WS_IMAGE_DEFAULT  (0)
#define WS_IMAGE_XPM      (1)
#define WS_IMAGE_BMP      (2)
#define WS_IMAGE_PNG      (3)
#define WS_IMAGE_JPG      (4)

#endif //WSCOMH
