//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDNXDRAW_H
#define WSDNXDRAW_H

#include <WScom.h>
#include <WSDdraw.h>
#include <WSClistData.h>
#include <WSDdev.h>
#include <nx/WSDnxFormDev.h>

class WSCbase;

class WSDnxDraw :public WSDdraw{

  protected:
    WSDcolor* _fg_col;
    WSDcolor* _bg_col;
    WSDdev*  _dev;
    WSDnxFormDev*  _fdev;
    WSDnxFormDev*  _parent_fdev;
    void* _window;
    void* _context;
    void* _fg_value;
    void* _bg_value;
    WSCulong _line_type_val;
    short _x;
    short _y;
    long _w;
    long _h;
    short _clip_x;
    short _clip_y;
    WSCushort _clip_w;
    WSCushort _clip_h;
    short _fg_cno;
    short _bg_cno;
    short    _line_width;
    signed char     _line_type;
    signed char     _fill_type;
    WSCbool  _clipping;
    void* _fill_mask;

  public:
    WSDnxDraw();
    virtual ~WSDnxDraw();

    virtual long setForeColor(short cid);
    virtual long setBackColor(short cid);
    virtual long setForeColor(WSDcolor*);
    virtual long setBackColor(WSDcolor*);
    virtual long setLineWidth(short);
    virtual long setLineDashType(char no);
    virtual long setHatchPattern(char no);
    virtual long setRegion(short x,short y,WSCushort w,WSCushort h);
    virtual long beginDraw(WSDdev*,long prm1,long prm2,long prm3);
    virtual long endDraw();
    virtual long drawArc(short x,short y,WSCushort width,WSCushort height,short a1,short a2);
    virtual long drawFillArc(short x,short y,WSCushort width,WSCushort height,short a1,short a2,char kind);
    virtual long drawLine(short x1,short y1,short x2,short y2);
    virtual long drawLines(WSCpoint*,long num);
    virtual long drawRect(short x,short y,WSCushort w,WSCushort h);
    virtual long drawFillRect(short x,short y,WSCushort w,WSCushort h);
    virtual long drawRects(WSCrect*,long num);
    virtual long drawGradation(long type,short col1,short col2,short col3,
                         short x,short y,WSCushort w,WSCushort h,WSCuchar);
    virtual long drawFillRects(WSCrect*,long num);
    virtual long drawPoly(WSCpoint*,long num);
    virtual long drawFillPoly(WSCpoint*,long num);
    virtual long drawImage(short x,short y,WSCushort,WSCushort,WSDimage*,char align);
    virtual long drawImage(short x,short y,short sx,short sy,WSCushort,WSCushort,WSDimage*);
    virtual long drawStretchedImage(short x,short y,WSCushort w,WSCushort h,
                                    WSDimage*);

    virtual long drawString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                            char font,char align,long cur,WSCbool inter_cur,
                            long scur1 = 0,long scur2 = 0);

    virtual long drawUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                             char font,char align,long cur,WSCbool inter_cur,
                             long scur1 = 0,long scur2 = 0);

    virtual long drawFillString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                                char font,char align,short cur,WSCbool inter_cur);

    virtual long drawFillUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                                 char font,char align,short cur,WSCbool inter_cur);

     WSMFclassDef(WSDnxDraw,WSDdraw);
};
#endif
