//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCstring.h>
#include <WSCbase.h>
#include <WSCmessageDialog.h>
#include <advance/WSadcom.h>
#include <WSCclassInformation.h>
#include <WSCbaseList.h>
#include <WSCvariant.h>

static WSCbase*  _get_parent_base(WSCbase* win,char* pname){
  if (!strcmp(pname,win->getInstanceName())){
    return win;
  }
  WSClistData children = win->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];

    if ( !strcmp(pname,child->getInstanceName()) ){
      return child;
    }else{
      WSCbase* ret = _get_parent_base(child,pname);
      if (ret != NULL){
        return ret;
      }
    }
  }
  return NULL;
}
static WSCbase*  _get_parent_base2(WSCbase* win,char* pname){
  char* tname = (char*)win->getUserData("tname-");
  if (tname != NULL && !strcmp(pname,tname)){
    return win;
  }
  WSClistData children = win->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];

    char* tname = (char*)child->getUserData("tname-");
    if ( tname != NULL && !strcmp(pname,tname) ){
      return child;
    }else{
      WSCbase* ret = _get_parent_base2(child,pname);
      if (ret != NULL){
        return ret;
      }
    }
  }
  return NULL;
}
extern void _get_2_words(char* src,char* word1,char* word2);
#if 0
void _get_2_words(char* src,char* word1,char* word2){
   word1[0] = 0;
   word2[0] = 0;
   long ptr=0;
   while(1){
     if (src[ptr] == 0){
       return;
     }
     if (src[ptr] == ' ' || src[ptr] == '\t'){
       ptr++;
     }else{
       break;
     }
   }

   long i=0;
   while(1){
     if (src[ptr] == 0){
       word1[i] = 0;
       return;
     }
     if (src[ptr] == ' ' || src[ptr] == '\t'){
       word1[i] = 0;
       break;
     }
     word1[i] = src[ptr];
     i++;
     ptr++;
   }

   while(1){
     if (src[ptr] == 0){
       return;
     }
     if (src[ptr] == ' ' || src[ptr] == '\t'){
       ptr++;
     }else{
       break;
     }

   }

   i=0;
   while(1){
     if (src[ptr] == 0){
       word2[i] = 0;
       return;
     }
     if (src[ptr] == ' ' || src[ptr] == '\t'){
       word2[i] = 0;
       return;
     }
     word2[i] = src[ptr];
     i++;
     ptr++;
   }
}
#endif
static void _op_dummy(WSCbase*){
}
void _clean_tname_(WSCbase* base){
  if (base != NULL){
    char* tname = (char*)base->getUserData("tname-");
    if (tname != NULL){
      delete tname;
      base->setUserData("tname-",NULL);
    }
    WSClistData children = base->getChildren();
    long num = children.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)children[i];
      _clean_tname_(child);
    }
  }
}
WSCbase* _WSGFreadWinSrc(WSCstring& src,WSCbool edit,WSCbool spec_name,char* topname);

WSCbase* WSGFreadWinSrc(WSCstring& src,WSCbool edit){
  WSCbase* ret = _WSGFreadWinSrc(src,edit,False,NULL);
  _clean_tname_(ret);
  return ret;
}
WSCbase* WSGFreadWinSrc2(WSCstring& src,WSCbool edit,char* topname){
  return _WSGFreadWinSrc(src,edit,True,topname);
}
long (*_create_proc_handler)(char*,char*) = NULL;
void WSGFreadWinSrcSetCreateProcHandler(long(*hd)(char*,char*)){
  _create_proc_handler = hd;
}

char* get_type_name(long num){
extern char* WSGFvalueToType(long);
  return WSGFvalueToType(num);
#if 0
  switch(num){
    case 0: return "long";
    case 1: return "WSCulong";
    case 2: return "short";
    case 3: return "WSCushort";
    case 4: return "char";
    case 5: return "WSCuchar";
    case 6: return "float";
    case 7: return "double";
    case 9: return "char*";
    case 11: return "WSCbool";
    case 12: return "int";
    case 13: return "WSCuint";
    case 14: return "void";
  }
  return "long";
#endif
}
long get_type_value(char* typen){
extern long WSGFtypeToValue(char*);
  return WSGFtypeToValue(typen);
#if 0
  if (!strcmp(typen,"long")){
    return 0;
  }else
  if (!strcmp(typen,"WSCulong")){
    return 1;
  }else
  if (!strcmp(typen,"short")){
    return 2;
  }else
  if (!strcmp(typen,"WSCushort")){
    return 3;
  }else
  if (!strcmp(typen,"char")){
    return 4;
  }else
  if (!strcmp(typen,"WSCuchar")){
    return 5;
  }else
  if (!strcmp(typen,"float")){
    return 6;
  }else
  if (!strcmp(typen,"double")){
    return 7;
  }else
  if (!strcmp(typen,"char*")){
    return 9;
  }else
  if (!strcmp(typen,"void")){
    return 10;
  }else
  if (!strcmp(typen,"WSCbool")){
    return 11;
  }else
  if (!strcmp(typen,"int")){
    return 12;
  }else
  if (!strcmp(typen,"WSCuint")){
    return 13;
  }
  return 0;
#endif
}
char* get_type_name2(char* typen){
  if (!strcmp(typen,"long")){
    return "Long";
  }else
  if (!strcmp(typen,"WSCulong")){
    return "ULong";
  }else
  if (!strcmp(typen,"short")){
    return "Short";
  }else
  if (!strcmp(typen,"WSCushort")){
    return "UShort";
  }else
  if (!strcmp(typen,"char")){
    return "Char";
  }else
  if (!strcmp(typen,"WSCuchar")){
    return "UChar";
  }else
  if (!strcmp(typen,"float")){
    return "Float";
  }else
  if (!strcmp(typen,"double")){
    return "Double";
  }else
  if (!strcmp(typen,"char*")){
    return "String";
  }else
  if (!strcmp(typen,"void")){
    return "void";
  }else
  if (!strcmp(typen,"WSCbool")){
    return "Char";
  }else
  if (!strcmp(typen,"int")){
    return "Int";
  }else
  if (!strcmp(typen,"WSCuint")){
    return "UInt";
  }
  return "Long";
}




WSCbase* _WSGFreadWinSrc(WSCstring& src,WSCbool edit,WSCbool spec_name,char* topname){
   WSCbase* ret = NULL;
   WSCbase* obj = NULL;
   WSCbase* obj2 = NULL;
   WSCbool top = True;
//   char buffer[1024];
   char buf1[1024];
   char buf2[1024];
   char buf3[1024];
   char buf4[1024];
   WSCstring classname;

   src.seek(0);
   WSCstring str = src.gets();
   while(src.eof() == False){
     buf1[0] = 0;
     buf2[0] = 0;
     _get_2_words((char*)str,buf1,buf2);
    if(strcmp("#OBJ", buf1) && strcmp("#obj", buf1) &&
        strcmp("#cobj",buf1) && strcmp("#sobj",buf1) &&
        strcmp("#cobjr",buf1) ){
      break;
    }
    WSCbool ext = False;
    WSCbool classwin = False;
    WSCbool storewin = False;
    WSCbool rclass = False;
    if (!strcmp("#OBJ",buf1)){
      ext = True;
    }
    if (!strcmp("#cobj",buf1)){
      classwin = True;
      rclass = False;
    }
    if (!strcmp("#cobjr",buf1)){
      classwin = True;
      rclass = True;
    }
    if (!strcmp("#sobj",buf1)){
      storewin = True;
    }
    char dummy[2048];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(buf2,&ano,dummy);
    if (is_array != False){
      ext = True;
    }

    if (src.eof() != False){
      break;
    }
    str = src.gets();

    buf1[0] = 0;
    buf3[0] = 0;

    _get_2_words(str,buf1,buf3);
    if (classwin != False){
      classname = buf3;
    }
    if (strcmp("#TYPE",buf1)){
      break;
    }
    if (src.eof() != False){
      break;
    }
    str = src.gets();

    buf1[0] = 0;
    buf4[0] = 0;

    _get_2_words(str,buf1,buf4);

    if (strcmp("#PARENT",buf1)){
      break;
    }

    WSCbase* parent = NULL;
    if ( strcmp(buf4,"NULL") && buf4[0] != 0 ){
      if (spec_name == False){
        if (obj != NULL && !strcmp(obj->getInstanceName(),buf4)){
          parent = obj;
        }else
        if (obj2 != NULL && !strcmp(obj2->getInstanceName(),buf4)){
          parent = obj2;
        }else if (ret != NULL){
          parent = _get_parent_base(ret,buf4);
        }
        obj2 = parent; //ƤˤʤäΤ򥭥å夹
      }else{
        if (obj != NULL){
          char* tname = (char*)obj->getUserData("tname-");
          if (tname != NULL && !strcmp(tname,buf4)){
            parent = obj;
          }
        }
        if (parent == NULL && obj2 != NULL){
          char* tname2 = (char*)obj2->getUserData("tname-");
          if (tname2 != NULL && !strcmp(tname2,buf4)){
            parent = obj2;
          }
        }
        if (parent == NULL && ret != NULL){
          parent = _get_parent_base2(ret,buf4);
        }
        obj2 = parent; //ƤˤʤäΤ򥭥å夹
      }
    }

    obj = WSCbase::getNewInstance(buf3,parent,"--NO NAME--");
    if (obj == NULL){
      WSCmessageDialog* msg = WSGIappMessageDialog();
      msg->setPropertyV(WSNdefaultPosition,(WSCbool)True);
      msg->setPropertyV(WSNwidth,(WSCushort)450);
      msg->setPropertyV(WSNheight,(WSCushort)120);
      char buffer[1024];
      sprintf(buffer,WSGFgettext("A3:WSSTR Can not create class: %s.\nPlease check the import library is right."),buf3);
      msg->setPropertyV(WSNlabelString,buffer);
      msg->popup();
      if (ret != NULL){
        delete ret;
      }
      return NULL;
    }
//printf("WSadcom::readWinSrc cname=%s name=%s\n",buf3,buf2);
    long st_name = 0;
    if (spec_name == False){
      st_name = WSGFexistName(buf2,obj);
    }else if (top != False){
      st_name = WSGFexistName(topname,obj);
    }
    if (ext == True && ((st_name != 0 && is_array == False) ||
                       ((st_name == WS_PROCEDURE_NAME ||
                         st_name == WS_OBJECT_NAME ) && is_array != False ))){
      if (spec_name == False){
        WSCmessageDialog* msg = WSGIappMessageDialog();
        msg->setPropertyV(WSNwidth,(WSCushort)450);
        msg->setPropertyV(WSNheight,(WSCushort)120);
        char buffer[1024];
        sprintf(buffer,
           WSGFgettext("B3:WSSTR The name %s is already used by another instance."),
           buf2);
        msg->setPropertyV(WSNlabelString,buffer);
        msg->popup();
      }
    }
    if (spec_name == False){
      obj->setInstanceName(buf2);
    }else{
      obj->setUserData("tname-",WSGFstrdup(buf2));
      if (ret != NULL){
        obj->setInstanceName(WSGFcreateName(ret->getInstanceName(),
                             obj->getClassName()));
      }else{
        obj->setInstanceName(topname);
      }
    }

    obj->initialize();
    obj->setPropertyEditMode(edit);

    WSGFexecCreateHandler(obj);

    void (*delete_handler)(WSCbase*) = WSGFgetDeleteHandler();
    if (delete_handler != NULL){
      WSCprocedure* ac = new WSCprocedure("delete-handler",WSEV_DELETE);
      ac->setFunction(delete_handler,"delete_handler");
      ac->setInternal(True);
      obj->addProcedure(ac);
    }

    if (ext == True){
      obj->setUserData(WS_EXT_VAR,(void*)1);
    }
    if (classwin == True){
      obj->setUserData(WS_WIN_CLASS,(void*)1);
    }
    if (rclass == True){
      obj->setUserData(WS_RCLASS_GENERATE,(void*)1);
    }
    if (storewin == True){
      obj->setUserData(WS_WIN_STORE,(void*)1);
    }
    if (src.eof() != False){
      break;
    }
    str = src.gets();

    while(1){
      buf1[0]=0;
      buf2[0]=0;
      _get_2_words(str,buf1,buf2);

      if (strcmp("#PROC",buf1)){
        break;
      }

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();

      long trig;
      buf1[0]=0;
      buf3[0]=0;
      sscanf(str,"%s %d",buf1,&trig);

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();

      _get_2_words(str,buf1,buf3);

      WSCstring prog(buf3);

      WSCprocedure* ac = new WSCprocedure(buf2,trig);
      if (prog.isExist(".cpp") == -1 && prog.isExist(".C") == -1){
        ac->setUseFile(False);
      }else{
        ac->setUseFile(True);
        if (spec_name != False && _create_proc_handler != NULL){
          if (classwin == False){
            _create_proc_handler((char*)prog,NULL);
          }else{
            _create_proc_handler((char*)prog,(char*)classname);
          }
        }
      }

      prog.replaceString(".cpp","",0);
      prog.replaceString(".C","",0);
      ac->setFunction(_op_dummy,prog.getString());
      obj->addProcedure(ac);

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;
      _get_2_words(str,buf1,buf2);

      if (strcmp("#RES",buf1)){
        break;
      }
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
      obj->setProperty(buf2,(char*)str);

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;
      char tbuf1[1024];
      char bbuf1[1024];
      tbuf1[0] = 0;
      bbuf1[0] = 0;
      long att = 0;
      long type;
      long use_file;

      sscanf(str,"%s %s %s %d %d %d %s",buf1,buf2,tbuf1,&type,&use_file,&att,bbuf1);
      if (strncmp("#res",buf1,4)){
        break;
      }
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();

      WSClistData* prprc_list = (WSClistData*)obj->getUserData(WS_PROP_LIST);
      if (prprc_list == NULL){
        prprc_list = new WSClistData();
        obj->setUserData(WS_PROP_LIST,(void*)prprc_list);
      }
      char values[1024];
      values[0] = 0;
      if (buf1[4] == '#'){
        strcpy(values,&(buf1[5]));
      }
      prop_data* propdata = new prop_data;
      propdata->name.setString(buf2);
      propdata->vname.setString(tbuf1);
      propdata->value.setString(str);
      propdata->bname.setString(bbuf1);
      propdata->type = type;
      propdata->att = att;
      propdata->use_file = use_file;
      propdata->values.setString(values);
      propdata->values.replaceString("\\S"," ",0);
      prprc_list->add((void*)propdata);
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;
      char bbuf1[1024];
      long value;
      long value2;

      sscanf(str,"%s %s %s %d",buf1,buf2,bbuf1,&value2);
      if (strncmp("#utrg",buf1,4)){
        break;
      }
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
      value = atoi(str);

      WSClistData* prprc_list = (WSClistData*)obj->getUserData(WS_UTRG_LIST);
      if (prprc_list == NULL){
        prprc_list = new WSClistData();
        obj->setUserData(WS_UTRG_LIST,(void*)prprc_list);
      }
      utrg_data* utrgdata = new utrg_data;
      utrgdata->name.setString(buf2);
      utrgdata->vname.setString(bbuf1);
      utrgdata->value = value;
      utrgdata->type = value2;
      prprc_list->add((void*)utrgdata);
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }


    while(1){
      buf1[0]=0;
      long trg;

      sscanf(str,"%s %d",buf1,&trg);
      if (strcmp("#trg",buf1)){
        break; //
      }

      WSClistData* tlist = (WSClistData*)obj->getUserData(WS_TRG_LIST);
      if (tlist == NULL){
        tlist = new WSClistData();
        obj->setUserData(WS_TRG_LIST,(void*)tlist);
      }
      tlist->add((void*)trg);

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;
      _get_2_words(str,buf1,buf2);

      if (strcmp("#icon",buf1)){
        break; //
      }

      char* icon = (char*)obj->getUserData(WS_CLASS_ICON);
      if (icon != NULL){
        delete icon;
      }

      obj->setUserData(WS_CLASS_ICON,(void*)WSGFstrdup(buf2));
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;

//      sscanf(str,"%s %s",buf1,buf2);
      _get_2_words(str,buf1,buf2);

      if (strcmp("#com",buf1)){
        break; //
      }

      char* ccom = (char*)obj->getUserData(WS_CLASS_COMMENT);
      if (ccom != NULL){
        delete ccom;
      }
      obj->setUserData(WS_CLASS_COMMENT,(void*)WSGFstrdup(buf2));
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
 
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;

      _get_2_words(str,buf1,buf2);

      if (strcmp("#cbase",buf1)){
        break;
      }

      char* cbase = (char*)obj->getUserData(WS_WIN_CLASS_BASE);
      if (cbase != NULL){
        delete cbase;
      }

      obj->setUserData(WS_WIN_CLASS_BASE,(void*)WSGFstrdup(buf2));
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;

      _get_2_words(str,buf1,buf2);

      if (strcmp("#rmethod",buf1)){
        break;
      }

      WSClistData* rmlist = (WSClistData*)obj->getUserData(WS_RMETHOD_LIST);
      if (rmlist == NULL){
        rmlist = new WSClistData();
        obj->setUserData(WS_RMETHOD_LIST,(void*)rmlist);
      }
      WSCstring rstr(buf2);

      rmethod_data* rmdata = new rmethod_data;
      rmdata->name = rstr.getWord(1,",");
//      rmdata->type =  get_type_value(rstr.getWord(0,","));
      rmdata->type_name =  rstr.getWord(0,",");

      if (src.eof() != False){
        return ret;
      }
      rstr = src.gets();
      rmdata->params = rstr;
      rmlist->add((void*)rmdata);

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;

      _get_2_words(str,buf1,buf2);

      if (strcmp("#rcname",buf1)){
        break;
      }
      obj->setUserData(WS_RCLASS_NAME,WSGFstrdup(buf2));

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;

      _get_2_words(str,buf1,buf2);

      if (strcmp("#brcname",buf1)){
        break;
      }
      obj->setUserData(WS_RCLASS_BNAME,WSGFstrdup(buf2));

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    if (top != False){
      ret = obj;
      obj->setUserData(WS_EXT_VAR,(void*)1);
      top = False;
    }
    str = src.gets();
  }
  return ret;
}
static void  _append(WSClistData* list,WSCstring* str){
  long num = list->getNum();
  long i;
  if (num > 2){
    WSClistData list1;
    WSClistData list2;
    for(i=0; i<num; i++){
      if (i < num/2){
        list1.add( (*list)[i]);
      }else{
        list2.add( (*list)[i]);
      }
    }
    WSCstring str1;
    WSCstring str2;
    _append(&list1,&str1);
    _append(&list2,&str2);
    str->addString(str1.getString());;
    str->addString(str2.getString());;
    return;
  }else{
    if (num == 2){
      WSCstring* str1 = (WSCstring*)(*list)[0];
      WSCstring* str2 = (WSCstring*)(*list)[1];
      str->addString(str1->getString());
      str->addString(str2->getString());
    }else if (num == 1){
      WSCstring* str1 = (WSCstring*)(*list)[0];
      str->addString(str1->getString());
    }
    return;
  }
}
//high speed strcmp
inline long WSGFstrcmp(char* x,char* y){
  register WSCuchar* s1 = (WSCuchar*)x;
  register WSCuchar* s2 = (WSCuchar*)y;
  register WSCuchar p1 = 0;
  register WSCuchar p2 = 0;
  do{
      p1 = (WSCuchar)*s1++;
      p2 = (WSCuchar)*s2++;
      if (p1 == 0){
         return p1 -p2;
      }
  } while (p1 == p2);
  return p1 -p2;
}

void _add_default_changed_property(WSCbase* btarget,char* pn,char tp,char* pdata,WSClistData* plist);
char* _value_to_type(long val){
static char* buf[17];
static char fl = False;
  if (fl == False){
    fl = True;
    buf[WSTlong] = "long";
    buf[WSTulong] = "WSCulong";
    buf[WSTshort] = "short";
    buf[WSTushort] = "WSCushort";
    buf[WSTchar] = "char";
    buf[WSTuchar] = "WSCuchar";
    buf[WSTfloat] = "float";
    buf[WSTdouble] = "double";
    buf[WSTvoidptr] = "void*";
    buf[WSTcharptr] = "char*";
    buf[WSTvoid] = "void";
    buf[WSTbool] = "WSCbool";
    buf[WSTint] = "int";
    buf[WSTuint] = "WSCuint";
  }
  if (-1 < val && val < WSTuint + 1){
    return buf[val];
  }
  return "long";
}
char* WSGFvalueToType(long val){
  return _value_to_type(val);
}
static WSCbool _is_color_property(char* pn){
  WSCstring tmp(pn);
  tmp.replaceString("WSN","",0);
  char* pname = tmp.getString();

  long len = strlen(pname);
  if (len < 5){
    return False;
  }
  if (!WSGFstrcmp(&pname[len -5],"Color")||
      !WSGFstrcmp(&pname[len -5],"color")){
    return True;
  }
  if (len < 6){
    return False;
  }
  if (!strncmp(&pname[len -6],"Color",5) ||
      !strncmp(&pname[len -6],"color",5)){
    if ( '0' <= pname[len-1] && '9' >= pname[len-1] ){
      return True;
    }else{
      return False;
    }
  }
  if (len < 7){
    return False;
  }
  if (!strncmp(&pname[len -7],"Color",5) ||
      !strncmp(&pname[len -7],"color",5)){
    if ( '0' <= pname[len-2] && '9' >= pname[len-2] &&
         '0' <= pname[len-1] && '9' >= pname[len-1] ){
      return True;
    }else{
      return False;
    }
  }
  return False;
}

static WSCbool _is_pixmap_property(char* pn){
  WSCstring tmp(pn);
  tmp.replaceString("WSN","",0);
  char* pname = tmp.getString();

  long len = strlen(pname);
  if (len < 6){
    return False;
  }
  if (!WSGFstrcmp(&pname[len -6],"Pixmap") ||
      !WSGFstrcmp(&pname[len -6],"pixmap")){
    return True;
  }
  if (len < 7){
    return False;
  }
  if (!strncmp(&pname[len -7],"Pixmap",6) ||
      !strncmp(&pname[len -7],"pixmap",6)){
    if ( '0' <= pname[len-1] &&
         '9' >= pname[len-1] ){
      return True;
    }else{
      return False;
    }
  }
  if (len < 8){
    return False;
  }
  if (!strncmp(&pname[len -8],"Pixmap",6) ||
      !strncmp(&pname[len -8],"pixmap",6)){
    if ( '0' <= pname[len-2] && '9' >= pname[len-2] &&
         '0' <= pname[len-1] && '9' >= pname[len-1] ){
      return True;
    }else{
      return False;
    }
  }
  return False;
}

void WSGFcreateWinData(WSCstring* str,WSCbase* parent,WSCbase* base){
   WSClistData children = base->getChildren();
   char buffer[2048];
   WSCstring str2;
   if ((long)base->getUserData(WS_WIN_STORE) == 1){
     sprintf(buffer,"#sobj      %s\n",base->getInstanceName());
   }else if ((long)base->getUserData(WS_WIN_CLASS) == 1){
     if ((long)base->getUserData(WS_RCLASS_GENERATE) == 1){
       sprintf(buffer,"#cobjr      %s\n",base->getInstanceName());
     }else{
       sprintf(buffer,"#cobj      %s\n",base->getInstanceName());
     }
   }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
     sprintf(buffer,"#OBJ       %s\n",base->getInstanceName());
   }else{
     sprintf(buffer,"#obj       %s\n",base->getInstanceName());
   }
   str2.addString(buffer);
   sprintf(buffer," #TYPE       %s\n",base->getClassName());
   str2.addString(buffer);

   if (parent == NULL){
     sprintf(buffer," #PARENT   NULL\n");
   }else{
     sprintf(buffer," #PARENT   %s\n",parent->getInstanceName());
   }
   str2.addString(buffer);


   WSClistData* prc_list = base->getProcedureList();
   long num = prc_list->getNum();
   long i;
   for(i=0; i< num; i++){
     WSCprocedure* ac = (WSCprocedure*)(*prc_list)[i];
     if (ac->getInternal() != False){
       continue;
     }
     sprintf(buffer," #PROC  %s\n",ac->getProcName());
     str2.addString(buffer);
     sprintf(buffer,"  #TRIG    %d\n",ac->getTrigger());
     str2.addString(buffer);
     if (ac->getUseFile() == False){
       sprintf(buffer,"  #PRO   %s\n\n",ac->getFunctionName());
     }else{
       sprintf(buffer,"  #PRO   %s.cpp\n\n",ac->getFunctionName());
     }
     str2.addString(buffer);

   }

   WSClistData props;
   WSGFgetAllPropertyList(base,&props);
//   WSClistData* props = base->getClassInformation()->getAllPropertyList();
   WSCproperty* prop;
   num = props.getNum();
   for(i=0; i< num; i++){
     prop = (WSCproperty*)props[i];
//     WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);
     if (def != False){
       continue;
     }
     if (!strcmp("name",prop->getPropObjName())){
       continue;
     }
     if (base->getDataSourceType() != WS_DATA_SOURCE_NONE &&
        !strcmp(prop->getPropObjName(),base->getDataSourcePropertyName())){
       continue;
     }

     sprintf(buffer," #RES      %s\n",prop->getPropObjName());
     str2.addString(buffer);

     sprintf(buffer,"%s",(char*)base->getProperty(prop->getPropObjName()));
     WSCstring sdata;
     sdata.setString(buffer);
     sdata.replaceString("\n","\\n",0);
     str2.addString(sdata.getString());
     str2.addString("\n");
   }

   WSClistData* prprc_list = (WSClistData*)base->getUserData(WS_PROP_LIST);
   if (prprc_list != NULL){
     num = prprc_list->getNum();
     for(i=0; i<num; i++){
       prop_data* propdata = (prop_data*)(*prprc_list)[i];
       if( !strcmp(propdata->vname.getString(),"")){
          propdata->vname.setString("dummy");
       }
       if (!strcmp(propdata->values.getString(),"")){
         sprintf(buffer," #res\t%s\t%s\t%d\t%d\t%d\t%s\n",propdata->name.getString(),
                       propdata->vname.getString(),
                       propdata->type,
                       propdata->use_file,
                       propdata->att,
                       propdata->bname.getString());
       }else{
         sprintf(buffer," #res#%s\t%s\t%s\t%d\t%d\t%d\t%s\n",propdata->values.getString(),
                       propdata->name.getString(),
                       propdata->vname.getString(),
                       propdata->type,
                       propdata->use_file,
                       propdata->att,
                       propdata->bname.getString());
       }
       str2.addString(buffer);
       sprintf(buffer,"%s",propdata->value.getString());
       WSCstring sdata;
       sdata.setString(buffer);
       sdata.replaceString("\n","\\n",0);
       str2.addString(sdata.getString());
       str2.addString("\n");
     }
   }
   WSClistData* prut_list = (WSClistData*)base->getUserData(WS_UTRG_LIST);
   if (prut_list != NULL){
     num = prut_list->getNum();
     for(i=0; i<num; i++){
       utrg_data* utrgdata = (utrg_data*)(*prut_list)[i];
       sprintf(buffer," #utrg\t%s\t%s\t%d\n",utrgdata->name.getString(),
                       utrgdata->vname.getString(),utrgdata->type);
       str2.addString(buffer);
       sprintf(buffer,"%d",utrgdata->value);
       WSCstring sdata;
       sdata.setString(buffer);
       sdata.replaceString("\n","\\n",0);
       str2.addString(sdata.getString());
       str2.addString("\n");
     }
   }
   WSClistData* tlist = (WSClistData*)base->getUserData(WS_TRG_LIST);
   if (tlist != NULL){
     num = tlist->getNum();
     for(i=0; i<num; i++){
       long trg = (long)(*tlist)[i];
       sprintf(buffer," #trg\t%d\n",trg);
       str2.addString(buffer);
     }
   }

   if ((char*)base->getUserData(WS_CLASS_ICON) != NULL){
       sprintf(buffer," #icon\t%s\n",(char*)base->getUserData(WS_CLASS_ICON));
       str2.addString(buffer);
   }

   if ((char*)base->getUserData(WS_CLASS_COMMENT) != NULL){
       sprintf(buffer," #com\t%s\n",(char*)base->getUserData(WS_CLASS_COMMENT));
       str2.addString(buffer);
   }

   if ((char*)base->getUserData(WS_WIN_CLASS_BASE) != NULL){
       sprintf(buffer," #cbase\t%s\n",(char*)base->getUserData(WS_WIN_CLASS_BASE));
       str2.addString(buffer);
   }

   WSClistData* rmlist = (WSClistData*)base->getUserData(WS_RMETHOD_LIST);
   if (rmlist != NULL){
     num = rmlist->getNum();
     for(i=0; i<num; i++){
       rmethod_data* rmdata = (rmethod_data*)(*rmlist)[i];
       sprintf(buffer," #rmethod\t%s,%s\n%s\n",
           (char*)rmdata->type_name,(char*)rmdata->name,
           (char*)rmdata->params);
       str2.addString(buffer);
     }
   }
   char* rcname = (char*)base->getUserData(WS_RCLASS_NAME);
   if (rcname != NULL){
     WSCstring tmp;
     tmp << " #rcname " << rcname <<"\n";
     str2 << tmp;
   }
   char* brcname = (char*)base->getUserData(WS_RCLASS_BNAME);
   if (brcname != NULL){
     WSCstring tmp;
     tmp << " #brcname " << brcname <<"\n";
     str2 << tmp;
   }



   str2.addString("\n");

   str->addString(str2.getString());

   num = children.getNum();
   WSClistData clist;
   for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring* cdata = new WSCstring;
        WSGFcreateWinData(cdata,base,child);
        clist.add((void*)cdata);
      }
   }

   WSCstring str3;
   _append(&clist,&str3);
   str->addString(str3.getString());

   num = clist.getNum();
   for(i=0; i<num; i++){
     WSCstring* cdata = (WSCstring*)clist[i];
     delete cdata;
   }
}

WSCstring WSGFcreateWinSrc(WSCbase* win){
  WSCstring str;
  WSGFcreateWinData(&str,NULL,win);
  return str;
}

char* WSGFcreateName(char* winname,char* classname){
static char buffer[32];
static int  num=0;
char tmp[16];
   strcpy(buffer,"___________");
   if (!strncmp(winname,"WSC",3) || !strncmp(winname,"WSD",3)){
     strncpy(tmp,&winname[3],3);
   }else{
     strncpy(tmp,winname,3);
   }
   tmp[3]=0;
   memcpy(buffer,tmp,strlen(tmp));
   if (strlen(classname) < 4){
     strcpy(tmp,"AAAAA");
   }else{
     strncpy(tmp,&(classname[3]),5);
   }
   tmp[4]=0;
   memcpy(&(buffer[3]),tmp,strlen(tmp));
   sprintf(tmp,"%03d",num);
   tmp[3]=0;
   memcpy(&(buffer[11-strlen(tmp)]),tmp,strlen(tmp));
   buffer[11]=0;
   num++;
   WSCbase* base = WSGIappObjectList()->getInstance("WSCbase",buffer);
   if ( base != NULL){
     return WSGFcreateName(winname,classname);
   }
//printf("WSGFcreateName ret=%s\n",buffer);
   return buffer;
}

WSCbool WSGFneedGenerateRemoteClass(WSCbase* inst){
  WSCbase* cbase = (WSCbase*)inst->getUserData(WS_WIN_CLASS_BASE);
  if (cbase != NULL){
    if (cbase->getUserData(WS_RCLASS_GENERATE)){
      return True;
    }else{
      return False;
    }
  }else{
    if (inst->getUserData(WS_RCLASS_GENERATE)){
      return True;
    }else{
      return False;
    }
  }
  return False;
}

WSCstring WSGFcreateVirtualRemoteClassHeader(WSCbase* inst){
  WSClistData* rdata = (WSClistData*)inst->getUserData(WS_RMETHOD_LIST);
  WSCstring cname = inst->getInstanceName();
  WSCstring ret;
  char* rcname = (char*)inst->getUserData(WS_RCLASS_NAME);
  if (rcname == NULL){
    WSCstring tmp;
    tmp = inst->getInstanceName();
    if (!strncmp((char*)tmp,"WSC",3)){
      tmp.replaceString("WSC","WSCR",1);
    }else{
      WSCstring tmp2;
      tmp2 << "WSCR" << tmp;
      tmp = tmp2;
    }
    rcname = WSGFstrdup((char*)tmp);
  }

  char* rbcname = (char*)inst->getUserData(WS_RCLASS_BNAME);
  if (rcname == NULL){
    WSCstring tmp;
    tmp = inst->getClassName();
    if (!strncmp((char*)tmp,"WSC",3)){
      tmp.replaceString("WSC","WSCR",1);
    }else{
      WSCstring tmp2;
      tmp2 << "WSCR" << tmp;
      tmp = tmp2;
    }
    rbcname = WSGFstrdup((char*)tmp);
  }

  ret =  "//----------------------------------------------------//\n";
  ret << "// Wide Studio Application C++ Source File            //\n";
  ret << "//            created by Wide Studio source generator //\n";
  ret << "//----------------------------------------------------//\n";
  ret << "#ifndef " << rcname << "_H\n";
  ret << "#define " << rcname << "_H\n\n";
  ret << "#include <WScom.h>\n";
  ret << "#include <" << rbcname << ".h>\n";

  ret << "class ";
  ret << rcname << " :public ";
  ret << rbcname << " {\n\n";
  ret << " public:\n";
  ret << "  " << rcname << "();\n";
  ret << "  ~" << rcname << "();\n\n";

  if (rdata != NULL){

    long i;
    long num = rdata->getNum();

    for(i=0; i<num; i++){
      rmethod_data* rmdata =(rmethod_data*)(*rdata)[i];
      if (rmdata != NULL){
        ret << "  " << rmdata->type_name << " "
            << rmdata->name << "(";
        WSCstring params;
        params = rmdata->params;
        long j;
        long pnum = params.getWords(",");
        for(j=0; j<pnum; j++){
          WSCstring tname;
          WSCstring pname;
          tname = params.getWord(j,",");
          j++;
          pname = params.getWord(j,",");
          ret << tname << " " << pname;
          if (j+1 < pnum){
            ret << ",";
          }
        }
        ret << ");\n";
      }
    }

  }
  ret << "  WSMFclassDef(" << rcname << "," <<
          rbcname << ");\n";
  ret << "};\n";
  ret << "#endif\n";
  return ret;
}

WSCstring WSGFcreateVirtualRemoteClassSrc(WSCbase* inst){
  WSClistData* rdata = (WSClistData*)inst->getUserData(WS_RMETHOD_LIST);
  WSCstring cname = inst->getInstanceName();
  WSCstring ret;
  char* rcname = (char*)inst->getUserData(WS_RCLASS_NAME);
  if (rcname == NULL){
    WSCstring tmp;
    tmp = inst->getInstanceName();
    if (!strncmp((char*)tmp,"WSC",3)){
      tmp.replaceString("WSC","WSCR",1);
    }else{
      WSCstring tmp2;
      tmp2 << "WSCR" << tmp;
      tmp = tmp2;
    }
    rcname = WSGFstrdup((char*)tmp);
  }

  char* rbcname = (char*)inst->getUserData(WS_RCLASS_BNAME);
  if (rcname == NULL){
    WSCstring tmp;
    tmp = inst->getClassName();
    if (!strncmp((char*)tmp,"WSC",3)){
      tmp.replaceString("WSC","WSCR",1);
    }else{
      WSCstring tmp2;
      tmp2 << "WSCR" << tmp;
      tmp = tmp2;
    }
    rbcname = WSGFstrdup((char*)tmp);
  }

  ret =  "//----------------------------------------------------//\n";
  ret << "// Wide Studio Application C++ Source File            //\n";
  ret << "//            created by Wide Studio source generator //\n";
  ret << "//----------------------------------------------------//\n";

  ret << "#include <WScom.h>\n";
  ret << "#include <" << rcname << ".h>\n";
  ret << "#include <" << inst->getInstanceName() << ".h>\n";
  ret << "#include <WSCbase.h>\n";
  ret << "#include <WSCbaseList.h>\n\n";
  ret << "WSMFclassInit(" << rcname << "," << rbcname << ");\n";
  ret << "WSMFremoteClassInit(" << rcname << "," << inst->getInstanceName() << ");\n\n";

  ret << rcname << "::" << rcname << "(){\n}\n\n";
  ret << rcname << "::~" << rcname << "(){\n}\n\n";

  if (rdata != NULL){

    long i;
    long num = rdata->getNum();

    for(i=0; i<num; i++){
      rmethod_data* rmdata =(rmethod_data*)(*rdata)[i];
      if (rmdata != NULL){
        ret << rmdata->type_name << " " << rcname << "::"
            << rmdata->name << "(";
        WSCstring params;
        params = rmdata->params;
        long j;
        long pnum = params.getWords(",");
        for(j=0; j<pnum; j++){
          WSCstring tname;
          WSCstring pname;
          if (!strcmp(pname,"")){
            pname << "p"<< j;
          }
          tname = params.getWord(j,","); j++;
          pname = params.getWord(j,",");
          ret << tname << " " << pname;
          if (j+1 < pnum){
            ret << ",";
          }
        }
        ret << "){\n";
        ret << "  if (_local != NULL){\n";
        ret << "    " << inst->getInstanceName() << "* item = (";
        ret << inst->getInstanceName() << "*)_local->cast(\"";
        ret << inst->getInstanceName() << "\");\n";
        ret << "    if (item != NULL){\n";
        if (strcmp((char*)rmdata->type_name,"void")){
          ret << "      return item->" << rmdata->name << "(";
        }else{
          ret << "      item->" << rmdata->name << "(";
        }
        for(j=0; j<pnum; j++){
          WSCstring pname;
          j++;
          pname = params.getWord(j,",");
          if (!strcmp(pname,"")){
            pname << "p"<< j;
          }
          ret << pname;

          if (j+1 < pnum){
            ret << ",";
          }
        }
        ret << ");\n";
        if (!strcmp((char*)rmdata->type_name,"void")){
          ret << "      return;\n";
        }
        ret << "    }\n";
        ret << "  }\n";
        ret << "  WSCremoteCall rc;\n";
        ret << "  rc.setClassName(\"" << inst->getInstanceName() << "\");\n";
        ret << "  rc.setOperationName(\"" << rmdata->name << "\");\n";
        ret << "  beginRemoteCall(&rc);\n";
        ret << "  if (_db == NULL){\n";
        if (!strcmp((char*)rmdata->type_name,"void")){
          ret << "    return;\n";
        }else
        if (!strcmp((char*)rmdata->type_name,"char*")){
          ret << "    return "";\n";
        }else{
          ret << "    return 0;\n";
        }
        ret << "  }\n";

        for(j=0; j<pnum; j++){
          WSCstring tname;
          WSCstring pname;
          if (!strcmp(pname,"")){
            pname << "p"<< j;
          }

          tname = params.getWord(j,",");
          j++;
          pname = params.getWord(j,",");
          if (!strcmp( get_type_name2((char*)tname) ,"String")){
            ret << "  _db->save(WS_DcRString,\""
                << pname << "\",(void*)" << pname << ");\n";
          }else{
            ret << "  _db->save(WS_DcR" << get_type_name2((char*)tname) 
                << ",\"" << pname << "\",(void*)&" << pname << ");\n";
          }

        }
        if (!strcmp((char*)rmdata->type_name,"void")){
        }else
        if (!strcmp((char*)rmdata->type_name,"char*")){
          ret << " char* ret;";
          ret << " _db->loadAlloc(WS_DcRString,\"ret\",(void**)&ret,NULL);\n";
        }else{
          ret << "  " << rmdata->type_name << " ret;\n";
          ret << " _db->load(WS_DcR"
                << get_type_name2((char*)rmdata->type_name) 
                << ",\"ret\",(void**)&ret);\n";
        }
        ret << "  endRemoteCall();\n";
        if (!strcmp((char*)rmdata->type_name,"void")){
          ret << "  return;\n";
        }else{
          ret << "  return ret;\n";
        }
      }
      ret << "}\n";
    }
  }
  ret << "void _" << inst->getInstanceName()
      << "_remote_call(WSDserialize* db,WSCremoteCall* rc){\n";
  long i;
  long num = rdata->getNum();
  for(i=0; i<num; i++){
    rmethod_data* rmdata =(rmethod_data*)(*rdata)[i];
    if (rmdata != NULL){
      ret << "  if (!strcmp(rc->_op,\"" << rmdata->name << "\")){\n";
      ret << "    WSCbase* inst ="
          << " WSGIappObjectList()->getInstance(rc->_class,rc->_instance);\n";

      if (!strcmp((char*)rmdata->type_name,"void")){
      }else
      if (!strcmp( (char*)rmdata->type_name ,"char*")){
        ret << "    WSCstring ret;\n";
      }else{
        ret << "    " << rmdata->type_name << " ret = 0;\n";
      }

      ret << "    if (inst != NULL){\n";
      ret << "      " << inst->getInstanceName() << "* target = ("
          << inst->getInstanceName() << "*)inst->cast(\""
          << inst->getInstanceName() << "\");\n";
      WSCstring params;
      params = rmdata->params;
      long j;
      long pnum = params.getWords(",");
      for(j=0; j<pnum; j++){
        WSCstring tname;
        WSCstring pname;
        if (!strcmp(pname,"")){
          pname << "p"<< j;
        }
        tname = params.getWord(j,","); j++;
        pname = params.getWord(j,",");

        if (!strcmp( get_type_name2((char*)tname) ,"String")){
          ret << "      char* " << pname << ";\n";
          ret << "      db->loadAlloc(WS_DcRString,\""
              << pname << "\",(void**)&" << pname << ",NULL);\n";
          ret << "      WSCstring " << pname << "_tmp;\n";
          ret << "      " << pname << "_tmp.setString(" << pname
              << ",WS_EN_UTF8);\n";
        }else{
          ret << "      " << tname << " " << pname << ";\n";
          ret << "      db->load(WS_DcR" << get_type_name2((char*)tname) 
              << ",\"" << pname << "\",(void*)&" << pname << ");\n";
        }
      }
      ret << "      if (target != NULL){\n";
      if (!strcmp(rmdata->type_name,"void")){
        ret << "        target->" << rmdata->name << "(";
      }else
      if (!strcmp( (char*)rmdata->type_name ,"char*")){
        ret << "        ret.setString( target->" << rmdata->name << "(";
      }else{
        ret << "        ret = target->" << rmdata->name << "(";
      }
      for(j=0; j<pnum; j++){
        WSCstring tname;
        WSCstring pname;
        if (!strcmp(pname,"")){
          pname << "p"<< j;
        }
        tname = params.getWord(j,","); j++;
        pname = params.getWord(j,",");

        if (!strcmp( get_type_name2((char*)tname) ,"String")){
          ret << pname << "_tmp";
        }else{
          ret << pname;
        }
        if (j+1 < pnum){
          ret << ",";
        }
      }
      ret << ")";
      if (!strcmp((char*)rmdata->type_name,"void")){
        ret << ";\n";
        ret << "        return;\n";
        ret << "      }\n";
        ret << "    }\n";
        ret << "    return;\n";
      }else
      if (!strcmp( (char*)rmdata->type_name ,"char*")){
        ret << ",WSGIappLocaleSet()->getDefaultEncoding());\n";
        ret << "      }\n";
        ret << "    }\n";
        ret << "    db->save(WS_DcR"
            << get_type_name2((char*)rmdata->type_name)
            << ",\"ret\",(void*)ret.getString(WS_EN_UTF8));\n";
        ret << "    return;\n";
      }else{
        ret << ";\n";
        ret << "      }\n";
        ret << "    }\n";
        ret << "    db->save(WS_DcR"
            << get_type_name2((char*)rmdata->type_name)
            << ",\"ret\",(void*)&ret);\n";
        ret << "    return;\n";
      }
      if (i+1<num){
        ret << "  }else\n";
      }else{
        ret << "  }\n";
      }
    }
  }
//XXZZ
  ret << "extern void _" << inst->getClassName()
      << "_remote_call(WSDserialize* db,WSCremoteCall* rc);\n";
  ret << "  _" << inst->getClassName() << "_remote_call(db,rc);\n}\n\n";

  ret << "WSMFdefineDrNetServer(" << inst->getInstanceName()
      << ",_" << inst->getInstanceName() << "_remote_call);\n\n";
  return ret;
}

void WSGFcreateWindowIncludeList(WSClistData* list,WSCbase* base){
  long i;
  long num = list->getNum();
  WSCbool fl = False;
  for(i=0; i< num; i++){
    WSCbase* lb = (WSCbase*)(*list)[i];
    if (!WSGFstrcmp(lb->getClassName(),base->getClassName())){
      fl = True;
      break;
    }
  }
  if (fl == False){
    list->add(base);
  }

  WSClistData children = base->getChildren();
  num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowIncludeList(list,child);
    }
  }
}

void WSGFcreateWindowInstanceList(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array == True){
      sprintf(buffer,"%s** %s;\n",base->getClassName(),arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
    }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"%s* %s;\n",base->getClassName(),base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceList(str,child);
    }
  }
}

void WSGFcreateWindowInstanceListRb(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array == True){
//      sprintf(buffer,"$%s = []\n",arrayn);
      sprintf(buffer,"  attr_reader :%s\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
    }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
//      sprintf(buffer,"$%s\n",base->getInstanceName());
      sprintf(buffer,"  attr_reader :%s\n",base->getInstanceName());
      *str += buffer;
    }else{
//      sprintf(buffer,"$%s\n",base->getInstanceName());
      sprintf(buffer,"  attr_reader :%s\n",base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceListRb(str,child);
    }
  }
}

void WSGFcreateWindowInstanceListPy(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array == True){
      sprintf(buffer,"%s = {}\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
    }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"%s = None\n",base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"%s = None\n",base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceListPy(str,child);
    }
  }
}

void WSGFcreateWindowInstanceList2Py(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array == True){
      sprintf(buffer,"\tglobal %s\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceList2Py(str,child);
    }
  }
}

void WSGFcreateWindowInstanceExternList(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array == True){
      sprintf(buffer,"extern %s** %s;\n",base->getClassName(),arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
    }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"extern %s* %s;\n",base->getClassName(),base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceExternList(str,child);
    }
  }
}

void WSGFcreateWindowInstanceInitList(WSCstring* str,WSCbase* base){
  char buffer[1024];
  if (base->getInternalObject() == False){
    if ((long)base->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"  %s = NULL;\n",base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long num = children.getNum();
  if (num != 0){
    long i;
    WSCstring tmp1;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSGFcreateWindowInstanceInitList(&tmp1,child);
      }
    }
    *str += tmp1;
  }
}

void _create_array_data(WSCbase* base,WSClistData* aname,WSClistData* anos,WSClistData* atype){
  char arrayn[1024];
  long ano;
  long i;
  long num;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (array != False){
    num = aname->getNum();
    WSCbool fl = False;
    for(i=0; i<num; i++){
      char* an = (char*)(*aname)[i];
      if (!WSGFstrcmp(an,arrayn)){
        fl = True;
        long no = (long)(*anos)[i];
        if (no < ano){
          anos->setData(i,(void*)ano);
        }
        break;
      }
    }
    if (fl == False){
      aname->add((void*)WSGFstrdup(arrayn));
      anos->add((void*)ano);
      atype->add((void*)WSGFstrdup(base->getClassName()));
    }
  }
  WSClistData children = base->getChildren();
  num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      _create_array_data(child,aname,anos,atype);
    }
  }
}

void WSGFcreateWindowArrayInstanceSetup(WSCstring* str,WSCbase* base){
  WSClistData atype;
  WSClistData aname;
  WSClistData anos;
  _create_array_data(base,&aname,&anos,&atype);
  *str += "\n";
  long i;
  long num = aname.getNum();
  for(i=0; i<num; i++){
    char buffer[1024];
    sprintf(buffer,"\t%s = new %s*[%d];\n",(char*)aname[i],(char*)atype[i],(long)anos[i]+1);
    *str += buffer;
    delete (char*)aname[i];
    delete (char*)atype[i];
  }
  *str += "\n";
}

void WSGFcreateWindowInstanceSrc(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    sprintf(buffer,"    %s = new  %s(%s,\"%s\");\n",base->getInstanceName(),
      base->getClassName(),parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"  %s = new  %s(NULL,\"%s\");\n",base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  %s = new  %s(%s,\"%s\");\n",base->getInstanceName(),
        base->getClassName(),parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
    }
  }else{
    if (parent == NULL){
      sprintf(buffer,"  %s*     %s = new  %s(NULL,\"%s\");\n",base->getClassName(),
        base->getInstanceName(),base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  %s* %s = new  %s(%s,\"%s\");\n",base->getClassName(),
        base->getInstanceName(),base->getClassName(),parent->getInstanceName(),
              base->getInstanceName());
      *str += buffer;
    }
  }
  sprintf(buffer,"      %s->initialize();\n",base->getInstanceName());
  *str += buffer;

  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      sprintf(buffer,"  %s->setPropertyV(WSN%s,\"%s\");\n",
        base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      *str += buffer;
    }else{
      sprintf(buffer,"  %s->setPropertyV(WSN%s,(%s)%s);\n",
        base->getInstanceName(),
        prop->getPropObjName(),prop->getPropObjTypeName(),
        (char*)base->getProperty(prop->getPropObjName()));
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    char objname[1024];
    if (is_array != False){
      sprintf(objname,"%sARY%d",arrayn,ano);
    }else{
      sprintf(objname,"%s",base->getInstanceName());
    }
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    sprintf(buffer,"    WSCprocedure* op_%s_%d = new WSCprocedure(\"%s\",%d);\n",
       objname,i,ac->getProcName(),ac->getTrigger());
    *str += buffer;
    sprintf(buffer,"    extern void %s(WSCbase*);\n",ac->getFunctionName());
    *str += buffer;
    sprintf(buffer,"    op_%s_%d->setFunction(%s,\"%s\");\n",objname,i,
      ac->getFunctionName(),ac->getFunctionName());
    *str += buffer;
    sprintf(buffer,"    %s->addProcedure(op_%s_%d);\n",base->getInstanceName(),
      objname,i);
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrc(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}

void WSGFcreateWindowInstanceSrcRb(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
//      sprintf(buffer,"  $%s = Mpfc::%s.new($%s,\"%s\")\n",
//             base->getInstanceName(),
//             base->getClassName(),
//             parent->getInstanceName(),base->getInstanceName());
      sprintf(buffer,"    @%s ||= []\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
      sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
             base->getInstanceName(),base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }else{
//      sprintf(buffer,"  $%s = Mpfc::%s.new(%s,\"%s\")\n",
//             base->getInstanceName(),
//             base->getClassName(),
//             parent->getInstanceName(),base->getInstanceName());
      sprintf(buffer,"    @%s ||= []\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
      sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
             base->getInstanceName(),base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }

    *str += buffer;
//    sprintf(buffer,"    $%s.init\n",base->getInstanceName());
    sprintf(buffer,"    @%s.init\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
//      sprintf(buffer,"  $%s = Mpfc::%s.new(nil,\"%s\")\n",base->getInstanceName(),
//              base->getClassName(),base->getInstanceName());
      sprintf(buffer, "  def initialize(arg1 = nil, arg2 = \"%s\")\n",
              base->getInstanceName());
      *str += buffer;
      sprintf(buffer, "    super(arg1,arg2)\n    @%s = self\n",
              base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s = Mpfc::%s.new($%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }else{
//        sprintf(buffer,"        $%s = Mpfc::%s.new(%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }
      *str += buffer;
    }
//    sprintf(buffer,"    $%s.init\n",base->getInstanceName());
    sprintf(buffer,"    @%s.init\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
//      sprintf(buffer,"  $%s = Mpfc::%s.new(nil,\"%s\")\n",base->getInstanceName(),
//              base->getClassName(),base->getInstanceName());
      sprintf(buffer, "  def initialize(arg1 = nil, arg2 = \"%s\")\n",
              base->getInstanceName());
      *str += buffer;
      sprintf(buffer, "    super(arg1,arg2)\n    @%s = self\n",
              base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s = Mpfc::%s.new($%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }else{
//        sprintf(buffer,"        $%s = Mpfc::%s.new(%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }
      *str += buffer;
    }
//    sprintf(buffer,"    $%s.init\n",base->getInstanceName());
    sprintf(buffer,"    @%s.init\n",base->getInstanceName());
    *str += buffer;
  }

  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s.setProperty(\"%s\",\"%s\")\n",
//          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
        sprintf(buffer,"    @%s.setProperty(\"%s\",\"%s\")\n",
              base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
//        sprintf(buffer,"        %s.setProperty(\"%s\",\"%s\")\n",
//          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
        sprintf(buffer,"    @%s.setProperty(\"%s\",\"%s\")\n",
              base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s.setProperty(\"%s\",%s);\n",
//          base->getInstanceName(),
//          prop->getPropObjName(),
//          (char*)base->getProperty(prop->getPropObjName()));
        sprintf(buffer,"    @%s.setProperty(\"%s\",%s)\n",
              base->getInstanceName(), prop->getPropObjName(),
              (char*)base->getProperty(prop->getPropObjName()));
      }else{
//        sprintf(buffer,"        %s.setProperty(\"%s\",%s);\n",
//          base->getInstanceName(),
//          prop->getPropObjName(),
//          (char*)base->getProperty(prop->getPropObjName()));
        sprintf(buffer,"    @%s.setProperty(\"%s\",%s)\n",
              base->getInstanceName(), prop->getPropObjName(),
              (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
//                               arrayn,ano,ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
              arrayn,ano,ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }else{
//        sprintf(buffer,"        %s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
//                               arrayn,ano,ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
              arrayn,ano,ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s.addProcedure(\"%s\",\"%s\",%d)\n",
//                               base->getInstanceName(),
//                               ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s.addProcedure(\"%s\",\"%s\",%d)\n",
              base->getInstanceName(),ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }else{
//        sprintf(buffer,"        %s.addProcedure(\"%s\",\"%s\",%d)\n",
//                               base->getInstanceName(),
//                               ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s.addProcedure(\"%s\",\"%s\",%d)\n",
              base->getInstanceName(),ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
//    WSCstring  tmpbuf;
//    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
//        WSCstring tmp1;
//        WSGFcreateWindowInstanceSrcRb(&tmp1,base,child);
//        tmpbuf += tmp1;
//        cnt++;
//        if (cnt > 20){
//          cnt=0;
//          *str += tmpbuf;
//          tmpbuf = "";
//        }
        WSGFcreateWindowInstanceSrcRb(str,base,child);
      }
    }
//    if (cnt > 0){
//      *str += tmpbuf;
//    }
  }
}

void WSGFcreateWindowInstanceSrc2Rb(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    sprintf(buffer,"$%s = []\n",arrayn);
    //if array,and noexisting, add into...
    if (str->isExist(buffer) == -1){
      *str += buffer;
    }
    if ( (long)base->getParentWindow()->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"$%s = $%s.%s\n",
              base->getInstanceName(),
              base->getParentWindow()->getInstanceName(),base->getInstanceName());
    }else{
      sprintf(buffer,"$%s = %s.%s\n",
              base->getInstanceName(),
              base->getParentWindow()->getInstanceName(),base->getInstanceName());
    }
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer, "$%s = Newwin_%s.new\n",
              base->getInstanceName(), base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)base->getParentWindow()->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"$%s = $%s.%s\n",
                       base->getInstanceName(),
                       base->getParentWindow()->getInstanceName(),
                       base->getInstanceName());
      }else{
        sprintf(buffer,"$%s = %s.%s\n",
                       base->getInstanceName(),
                       base->getParentWindow()->getInstanceName(),
                       base->getInstanceName());
      }
      *str += buffer;
    }
  }else{
    if (parent == NULL){
      sprintf(buffer, "%s = Newwin_%s.new\n",
              base->getInstanceName(), base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)base->getParentWindow()->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"%s = $%s.%s\n",
                       base->getInstanceName(),
                       base->getParentWindow()->getInstanceName(),
                       base->getInstanceName());
      }else{
        sprintf(buffer,"%s = %s.%s\n",
                       base->getInstanceName(),
                       base->getParentWindow()->getInstanceName(),
                       base->getInstanceName());
      }
      *str += buffer;
    }
  }

  //*str += "\n";

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  if (num != 0){
//    WSCstring  tmpbuf;
//    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
//        WSCstring tmp1;
//        WSGFcreateWindowInstanceSrc2Rb(&tmp1,base,child);
//        tmpbuf += tmp1;
//        cnt++;
//        if (cnt > 20){
//          cnt=0;
//          *str += tmpbuf;
//          tmpbuf = "";
//        }
        WSGFcreateWindowInstanceSrc2Rb(str,base,child);
      }
    }
//    if (cnt > 0){
//      *str += tmpbuf;
//    }
  }
}


void WSGFcreateWindowInstanceSrcPy(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"\t%s = mpfc.%s(%s,\"%s\")\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }else{
      sprintf(buffer,"\t%s = mpfc.%s(%s,\"%s\")\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }
    *str += buffer;
    sprintf(buffer,"\t%s.initialize()\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(None,\"%s\")\n",
              base->getInstanceName(),
              base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(%s,\"%s\")\n",
                       base->getInstanceName(),
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }else{
        sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(%s,\"%s\")\n",
                       base->getInstanceName(),
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }
      *str += buffer;
    }
    sprintf(buffer,"\t%s.initialize()\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
      sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(None,\"%s\")\n",
        base->getInstanceName(),
        base->getInstanceName(),
        base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(%s,\"%s\")\n",
              base->getInstanceName(),
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      }else{
        sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(%s,\"%s\")\n",
              base->getInstanceName(),
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      }
      *str += buffer;
    }
    sprintf(buffer,"\t%s.initialize()\n",base->getInstanceName());
    *str += buffer;
  }

  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s.setProperty(\"%s\",\"%s\")\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
        sprintf(buffer,"\t%s.setProperty(\"%s\",\"%s\")\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s.setProperty(\"%s\",%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }else{
        sprintf(buffer,"\t%s.setProperty(\"%s\",%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"\t%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s.addProcedure(\"%s\",\"%s\",%d)\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"\t%s.addProcedure(\"%s\",\"%s\",%d)\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrcPy(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}


void WSGFcreateWindowInstanceSrcPerl(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    sprintf(buffer,"    $%s = mpfc::new_%s($%s,\"%s\");\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    *str += buffer;
    sprintf(buffer,"    mpfc::WSCbase_init($%s);\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"  $%s = mpfc::new_%s($void,\"%s\");\n",base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  $%s = mpfc::new_%s($%s,\"%s\");\n",
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    mpfc::WSCbase_init($%s);\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
      sprintf(buffer,"  $%s = mpfc::new_%s($void,\"%s\");\n",
        base->getInstanceName(),base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  local($%s) = mpfc::new_%s($%s,\"%s\");\n",
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    mpfc::WSCbase_init($%s);\n",base->getInstanceName());
    *str += buffer;
  }


  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        mpfc::WSCbase_setProperty($%s,'%s','%s');\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
        sprintf(buffer,"        mpfc::WSCbase_setProperty($%s,'%s','%s');\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        mpfc::WSCbase_setProperty($%s,'%s',%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }else{
        sprintf(buffer,"        mpfc::WSCbase_setProperty($%s,'%s',%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        mpfc::WSCbase_addProcedure($%s[%d],'%s','%s',%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"        mpfc::WSCbase_addProcedure($%s[%d],'%s','%s',%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        mpfc::WSCbase_addProcedure($%s,'%s','%s',%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"        mpfc::WSCbase_addProcedure($%s,'%s','%s',%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrcPerl(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}
void WSGFcreateWindowInstanceSrcPerl_new(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    sprintf(buffer,"    $%s = new mpfc::%s($%s,\"%s\");\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    *str += buffer;
    sprintf(buffer,"    $%s->init();\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"  $%s = new mpfc::%s($void,\"%s\");\n",base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  $%s = new mpfc::%s($%s,\"%s\");\n",
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    $%s->init();\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
      sprintf(buffer,"  $%s = new mpfc::%s($void,\"%s\");\n",
        base->getInstanceName(),base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  local($%s) = new mpfc::%s($%s,\"%s\");\n",
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    $%s->init();\n",base->getInstanceName());
    *str += buffer;
  }


  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s->setProperty('%s','%s');\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
        sprintf(buffer,"        $%s->setProperty('%s','%s');\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s->setProperty('%s',%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }else{
        sprintf(buffer,"        $%s->setProperty('%s',%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s[%d]->addProcedure('%s','%s',%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"        $%s[%d]->addProcedure('%s','%s',%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s->addProcedure('%s','%s',%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"        $%s->addProcedure('%s','%s',%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrcPerl_new(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}
void WSGFcreateWindowInstanceClassSrc(WSCstring* str,WSCbase* parent,WSCbase* base){
  if (parent == NULL){ //at first time...
    WSClistData children = base->getChildren();
    long num = children.getNum();
    long i;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceClassSrc(&tmp1,base,child);
        *str += tmp1;
      }
    }
  }
  char buffer[2048];
  if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent != NULL){
      sprintf(buffer,"  %s = new  %s(%s,\"%s\");\n",base->getInstanceName(),
        base->getClassName(),parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
      sprintf(buffer,"  %s->initialize();\n",base->getInstanceName());
      *str += buffer;
      sprintf(buffer,"  %s->setInternalObject(True);\n",base->getInstanceName());
      *str += buffer;
    }
  }else{
    if (parent != NULL){
      sprintf(buffer,"  %s* %s = new  %s(%s,\"%s\");\n",base->getClassName(),
        base->getInstanceName(),base->getClassName(),parent->getInstanceName(),
        base->getInstanceName());
      *str += buffer;
      sprintf(buffer,"  %s->initialize();\n",base->getInstanceName());
      *str += buffer;
      sprintf(buffer,"  %s->setInternalObject(True);\n",base->getInstanceName());
      *str += buffer;
    }
  }
  sprintf(buffer,"      %s->setUserData(WS_BASE_CLASS,(void*)this);\n",base->getInstanceName());
  *str += buffer;

  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (!strcmp(prop->getPropObjName(),"name")){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      sprintf(buffer,"  %s->setPropertyV(WSN%s,\"%s\");\n",base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      *str += buffer;
    }else{
      sprintf(buffer,"  %s->setPropertyV(WSN%s,(%s)%s);\n",base->getInstanceName(),prop->getPropObjName(),prop->getPropObjTypeName(),(char*)base->getProperty(prop->getPropObjName()));
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    char objname[1024];
    if (is_array != False){
      sprintf(objname,"%sARY%d",arrayn,ano);
    }else{
      sprintf(objname,"%s",base->getInstanceName());
    }
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    sprintf(buffer,"    WSCprocedure* op_%s_%d = new WSCprocedure(\"%s\",%d);\n",
      objname,i,ac->getProcName(),ac->getTrigger());
    *str += buffer;
    sprintf(buffer,"    op_%s_%d->setFunction(%s,\"%s\");\n",objname,i,ac->getFunctionName(),
      ac->getFunctionName());
    *str += buffer;
    sprintf(buffer,"    op_%s_%d->setInternal(True);\n",objname,i);
    *str += buffer;
    sprintf(buffer,"    %s->addProcedure(op_%s_%d);\n",base->getInstanceName(),objname,i);
    *str += buffer;
  }

  *str += "\n";

  if (parent != NULL){
    WSClistData children = base->getChildren();
    num = children.getNum();
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceClassSrc(&tmp1,base,child);
        *str += tmp1;
      }
    }
  }
}

WSCstring* WSGFcreateWindowHeader(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "//----------------------------------------------------//\n";
  *str << "// Wide Studio Application C++ Source File            //\n";
  *str << "//            created by Wide Studio source generator //\n";
  *str << "//----------------------------------------------------//\n";
  *str << "#ifndef _" << btarget->getInstanceName() << "_H\n";
  *str << "#define _" << btarget->getInstanceName() << "_H\n";
  *str << "#include <WScom.h>\n#include <WSDappDev.h>\n";
  *str << "\n";
  *str << "//--- OBJECT includes ---//\n";

  WSCstring tmp1;
  long i;
  long num = ilist.getNum();
  for(i=0; i< num; i++){
    WSCbase* base = (WSCbase*)ilist[i];
    char buffer[1024];
    sprintf(buffer,"#include <%s.h>\n",base->getClassName());
    tmp1 += buffer;
  }
  *str << tmp1 << "\n";
  *str << "//--- OBJECT instance variable ---//\n";

  WSGFcreateWindowInstanceExternList(str,btarget);

  *str << "\n";
  *str << "#endif /* _"<< btarget->getInstanceName() << "_H */\n";
  return str;
}

WSCstring* WSGFcreateWindowSrc(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "//----------------------------------------------------//\n";
  *str << "// Wide Studio Application C++ Source File            //\n";
  *str << "//            created by Wide Studio source generator //\n";
  *str << "//----------------------------------------------------//\n";
  *str << "#include <WScom.h>\n#include <WSDappDev.h>\n";
  *str << "\n";
  *str << "//--- OBJECT includes ---//\n";

  WSCstring tmp1;
  long i;
  long num = ilist.getNum();
  for(i=0; i< num; i++){
    WSCbase* base = (WSCbase*)ilist[i];
    char buffer[1024];
    sprintf(buffer,"#include <%s.h>\n",base->getClassName());
    tmp1 += buffer;
  }
  *str << tmp1 << "\n";
  *str << "//--- OBJECT instance variable ---//\n";

  WSGFcreateWindowInstanceList(str,btarget);

  *str << "\n";
  *str << "//--- OBJECT src ---//\n";
  *str << "\n";
  *str << "WSCbase* _create_win_";
  *str << btarget->getInstanceName();
  *str << "(){\n";

  WSGFcreateWindowArrayInstanceSetup(str,btarget);
  WSGFcreateWindowInstanceSrc(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    *str << "   " << btarget->getInstanceName() << "->setVisible(True);\n";
  }
  *str << "   return " << btarget->getInstanceName() << ";\n";
  *str << "}\n\n";
  *str << "//--- end of src ---//\n";
  return str;

}

WSCstring* WSGFcreateWindowSrcRb(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "#----------------------------------------------------\n";
  *str << "# Wide Studio Application Ruby Lang Source File      \n";
  *str << "#            created by Wide Studio source generator \n";
  *str << "#----------------------------------------------------\n";
  *str << "\n";
  *str << "#--- OBJECT src ---\n";
  *str << "\n";
  *str << "class Newwin_";
  *str << btarget->getInstanceName();
  *str << " < Mpfc::";
  *str << btarget->getClassName();
  *str << "\n";

  WSGFcreateWindowInstanceListRb(str,btarget);
  WSGFcreateWindowInstanceSrcRb(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    if ((long)btarget->getUserData(WS_EXT_VAR) == 1){
      *str << "    @" << btarget->getInstanceName() << ".setVisible(1)\n";
    }else{
      *str << "    @" << btarget->getInstanceName() << ".setVisible(1)\n";
    }
  }
  *str << "  end\n";
  *str << "end\n\n";

  WSGFcreateWindowInstanceSrc2Rb(str,NULL,btarget);
  *str << "#--- end of src ---\n";
  return str;
}

WSCstring* WSGFcreateWindowSrcPy(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "#----------------------------------------------------\n";
  *str << "# Wide Studio Application Python Lang Source File    \n";
  *str << "#            created by Wide Studio source generator \n";
  *str << "#----------------------------------------------------\n";
  *str << "import mpfc\n\n";
  *str << "#--- OBJECT instance variable ---\n";

  WSGFcreateWindowInstanceListPy(str,btarget);

  *str << "\n";
  *str << "#--- OBJECT src ---\n";
  *str << "\n";
  *str << "def _create_win_";
  *str << btarget->getInstanceName();
  *str << "():\n";

  WSGFcreateWindowInstanceList2Py(str,btarget);
  WSGFcreateWindowInstanceSrcPy(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    if ((long)btarget->getUserData(WS_EXT_VAR) == 1){
      *str << "\t" << btarget->getInstanceName() << ".setVisible(1)\n";
    }else{
      *str << "\t" << btarget->getInstanceName() << ".setVisible(1)\n";
    }
  }
  *str << "\n\n";
  *str << "_create_win_";
  *str << btarget->getInstanceName();
  *str << "()\n";
  *str << "#--- end of src ---\n";
  return str;
}

WSCstring* WSGFcreateWindowSrcPerl(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "#----------------------------------------------------\n";
  *str << "# Wide Studio Application Perl Lang Source File      \n";
  *str << "#            created by Wide Studio source generator \n";
  *str << "#----------------------------------------------------\n";
  *str << "\n";
  *str << "use mpfc;\n";
  *str << "\n";
  *str << "#--- OBJECT src ---\n";
  *str << "\n";

  WSGFcreateWindowInstanceSrcPerl(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    *str << "   mpfc::WSCbase_setVisible($" << btarget->getInstanceName()
                                            << ",1);\n";
  }
  *str << "1;\n";
  *str << "#--- end of src ---\n";
  return str;
}
WSCstring* WSGFcreateWindowSrcPerl_new(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "#----------------------------------------------------\n";
  *str << "# Wide Studio Application Perl Lang Source File      \n";
  *str << "#            created by Wide Studio source generator \n";
  *str << "#----------------------------------------------------\n";
  *str << "\n";
  *str << "use mpfc;\n";
  *str << "\n";
  *str << "#--- OBJECT src ---\n";
  *str << "\n";

  WSGFcreateWindowInstanceSrcPerl_new(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    *str << "   $" << btarget->getInstanceName() << "->setVisible(1);\n";
  }
  *str << "1;\n";
  *str << "#--- end of src ---\n";
  return str;
}




void  _create_procedure_list(WSClistData* prclist ,WSCbase* base){
  WSClistData* ops = base->getProcedureList();
  long num = ops->getNum();
  long i;
  for(i=0; i < num; i++){
    WSCprocedure* ac = (WSCprocedure*)(*ops)[i];
    long onum = prclist->getNum();
    long j;
    WSCbool fl = True;
    for(j=0; j < onum; j++){
      WSCprocedure* item = (WSCprocedure*)(*prclist)[j];
      if ( !WSGFstrcmp(item->getFunctionName(),ac->getFunctionName())){
         fl = False;
      }
    }
    if (fl == True){
      prclist->add((void*)ac);
    }
  }

  WSClistData children = base->getChildren();
  num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
       _create_procedure_list(prclist ,child);
    }
  }
}

void  WSGFcreateWindowClassProcedureList(WSCstring* out ,WSCbase* btarget){
  WSClistData prclist;
  _create_procedure_list(&prclist,btarget);

  long num = prclist.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCprocedure* ac = (WSCprocedure*)prclist[i];
    *out << "   static void " << ac->getFunctionName() << "(WSCbase*);\n";
  }
}


void _get_class_list2(WSCbase* base,WSClistData* list){
  long num = list->getNum();
  long i;
  long fl = True;
  for(i=0; i< num; i++){
    WSCbase* item = (WSCbase*)(*list)[i];
    if (!WSGFstrcmp(item->getClassName(),base->getClassName())){
      fl = False;
      break;
    }
  }
  if (fl == True){
    list->add((void*)base);
  }

  WSClistData children = base->getChildren();
  num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      _get_class_list2(child,list);
    }
  }
}

WSClistData* _get_class_list(WSCbase* btarget){
static   WSClistData  tmp;
  tmp.clear();
  tmp.add((void*)btarget);
  WSClistData children = btarget->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      _get_class_list2(child,&tmp);
    }
  }
  return &tmp;
}

WSCstring* WSGFcreateWindowClassSrc(WSCbase* btarget){
  WSCstring* str = new WSCstring;
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  *str =  "//----------------------------------------------------//\n";
  *str << "// Wide Studio Application C++ Source File            //\n";
  *str << "//            created by Wide Studio source generator //\n";
  *str << "//----------------------------------------------------//\n";
  *str << "#include <WScom.h>\n#include <WSDappDev.h>\n\n";
  *str << "//--- OBJECT includes ---//\n";
  *str << "#include <" << btarget->getInstanceName() << ".h>\n";

  WSCstring tmp1;
  long i;
  long num = ilist.getNum();
  for(i=0; i< num; i++){
    WSCbase* base = (WSCbase*)ilist[i];
    char buffer[1024];
    sprintf(buffer,"#include <%s.h>\n",base->getClassName());
    tmp1 << buffer;
  }
  *str << tmp1 << "\n";
  *str << btarget->getInstanceName() << "::" << btarget->getInstanceName();
  *str << "(WSCbase* base,char* objName):\n";
  *str << btarget->getInstanceName() << "BASETYPE(base,objName){\n\n";
  *str << "  _property_initialize();\n";
//  *str << WSGFgettext("A:WSSTR  //please edit here...\n");
  *str << "  //please edit here...\n";
  *str << "\n\n}\n\n";

  *str << btarget->getInstanceName()<< "::~" << btarget->getInstanceName()<< "(){\n\n";
  *str << "  _property_delete();\n";
//  *str << WSGFgettext("A:WSSTR  //please edit here...\n");
  *str << "  //please edit here...\n";
  *str << "\n\n}\n\n";
  *str << "long " << btarget->getInstanceName() << "::initialize(){\n  ";
  *str << btarget->getInstanceName() << "BASETYPE" << "::initialize();\n";
  *str << "  objectInitialize();\n\n";
//  *str << WSGFgettext("A:WSSTR  //please edit here...\n");
  *str << "  //please edit here...\n";
  *str << "  return WS_NO_ERR;\n}\n";

  return str;
}

WSCstring* WSGFcreateWindowClassSrcP(WSCbase* btarget){
  WSCstring* str = new WSCstring;
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  *str =  "//----------------------------------------------------//\n";
  *str << "// Wide Studio Application C++ Source File            //\n";
  *str << "//            created by Wide Studio source generator //\n";
  *str << "//----------------------------------------------------//\n";
  *str << "#include <WScom.h>\n#include <WSDappDev.h>\n";
  *str << "#include <WSCclassInformation.h>\n";
  *str << "//--- OBJECT includes ---//\n";
  *str << "#include <" << btarget->getInstanceName() << ".h>\n\n";

  WSCstring tmp1;
  long i;
  long num = ilist.getNum();
  for(i=0; i< num; i++){
    WSCbase* base = (WSCbase*)ilist[i];
    char buffer[1024];
    sprintf(buffer,"#include <%s.h>\n",base->getClassName());
    tmp1 << buffer;
  }
  *str << tmp1;
//  *str << WSGFgettext("B:WSSTR\n\n//Initializing of class...\n");
  *str << "\n\n//Initializing of class...\n";
  *str << "WSMFguiClassInitialize(" << btarget->getInstanceName() << ",";
  *str << btarget->getClassName() << ");\n\n";
  *str << "WSMFversion(" << btarget->getInstanceName() << ",";
  *str << btarget->getClassName() << ");\n\n";

  WSClistData  def_prop_list;
  WSClistData* props = btarget->getClassInformation()->getAllPropertyList();
  WSCproperty* prop;
  num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
    WSCbool def = prop->isDefaultValue(btarget);
    if (def != False){
      continue;
    }
    if (!strcmp(prop->getPropObjName(),WSNname)){
      continue;
    }
    if (!strcmp(prop->getPropObjName(),WSNvis)){
      continue;
    }
    _add_default_changed_property(btarget,prop->getPropObjName(),
      prop->getPropObjType(), btarget->getProperty(prop->getPropObjName()),
      &def_prop_list);
  }

  WSClistData* own_prop_list = (WSClistData*)btarget->getUserData(WS_PROP_LIST);
  WSClistData  prop_list_ins;
  WSClistData* prop_list = &prop_list_ins;
  if (own_prop_list != NULL){
    num = own_prop_list->getNum();
    for(i=0; i<num; i++){
      prop_list->add( (*own_prop_list)[i] );
    }
  }
  num = def_prop_list.getNum();
  for(i=0; i<num; i++){
    prop_list->add( def_prop_list[i] );
  }

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){ //Normal definition...
        if (WSGFstrcmp(propdata->values.getString(),"")){
          long num = propdata->values.getWords(",");
          if (num > 1){
            WSCstring vsname;
            vsname = propdata->values.getWord(0,",");
            vsname.replaceString("\\S","_",0);
            *str << "char* " << vsname << "[]={\n";

            long i;
            for(i=1; i<num; i++){
              WSCstring valuen;
              valuen = propdata->values.getWord(i,",");
              valuen.replaceString("\\S"," ",0);
              i++;
              *str << "\"" << valuen << "\",\n";
            }
            *str << "NULL\n";
            *str << "};\n";

            *str << "char* " << vsname << "D[]={\n";

            for(i=2; i<num; i++){
              WSCstring valuen;
              valuen = propdata->values.getWord(i,",");
              valuen.replaceString("\\S"," ",0);
              i++;
              *str << "\"" << valuen << "\",\n";
            }
            *str << "NULL\n";
            *str << "};\n";
          }
        }
      }
    }
  }

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 2){  //default value change
        *str << "WSMFpropertyValueChange(";
        *str << btarget->getInstanceName() << ",";
        *str << propdata->name.getString() << ",";
        *str <<  _value_to_type(propdata->type) << ",";
        if (propdata->type == WSTcharptr){  //string
           *str << "WSGFstrdup(\"" << propdata->value.getString() << "\")";
        }else{
           if (propdata->type == WSTshort && //2=short
               _is_color_property(propdata->name.getString()) != False){
             *str << "WSGFcolor(\"" << propdata->value.getString() << "\")";
           }else
           if (propdata->type == WSTshort &&  //2=short
               _is_pixmap_property(propdata->name.getString()) != False){
             *str << "WSGFimage(\"" << propdata->value.getString() << "\")";
           }else{
             *str << propdata->value.getString();
           }
        }
        *str << ");\n";
      }
    }
  }

  *str << "void " << btarget->getInstanceName() << "::_property_initialize(){\n";

  //󥹥ѿν //initialize of the instance variable
  WSCstring tmpInit;
  WSGFcreateWindowInstanceInitList(&tmpInit,btarget);
  char buffer[128];
  //ܤ饹Υ󥹥󥹤ǤСʤΤǺ
  //Delete first line,if it is instance of own class...
  sprintf(buffer,"  %s = NULL;\n",btarget->getInstanceName());
  tmpInit.replaceString(buffer,"",1);

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){
        *str << "  " << propdata->vname.getString() << " = (";
        *str <<  _value_to_type(propdata->type) << ")";
        if (propdata->type == WSTcharptr){ //string
           *str << "WSGFstrdup(\"" << propdata->value.getString() << "\")";
        }else{
           if (propdata->type == WSTshort && //2=short
               _is_color_property(propdata->name.getString()) != False){
             if (WSGFstrcmp(propdata->value.getString(),"")){
               *str << "WSGFcolor(\"" << propdata->value.getString() << "\")";
             }else{
               *str << "WSGFcolor(\"#000000\")";
             }
           }else
           if (propdata->type == WSTshort &&  //2=short
               _is_pixmap_property(propdata->name.getString()) != False){
             *str << "WSGFimage(\"" << propdata->value.getString() << "\")";
           }else{
             if (WSGFstrcmp(propdata->value.getString(),"")){
               *str << propdata->value.getString();
             }else{
               *str << "0";
             }
           }
        }
        *str << ";\n";
      }
    }
  }

  *str << tmpInit.getString();
  *str << "\n  WSMFpropertyCreateStart\n";
  *str << "    //Check Version...\n";
  *str << "    WSMFparentCheckVerSrc(" << btarget->getInstanceName() << ");\n\n";

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){ //̾ץѥƥ
        *str << "  WSMFpropertyCreate(";
        *str << propdata->name.getString() << ",";
        *str <<  _value_to_type(propdata->type) << ",";
        *str << propdata->vname.getString() << ",\"";
        *str << propdata->bname.getString() << "\");\n";
        if (WSGFstrcmp(propdata->values.getString(),"")){
            WSCstring vsname;
            vsname = propdata->values.getWord(0,",");
            vsname.replaceString("\\S","_",0);
            *str << "  WSMFpropertySetSelection(";
            *str << vsname << ",";
            *str << vsname << "D);\n\n";
        }else{
          if (WSGFstrcmp(propdata->bname.getString(),"")){
            if (propdata->type == WSTbool){ //WSCbool ʤ
              *str << "  WSMFpropertySetSelection(WSRbool, WSRboolD);\n\n";
            }
          }else{
            *str << "\n";
          }
        }
                if (propdata->att == 4){
          *str << "  WSMFpropertyVisible(False);\n\n";
                }
      }else if (propdata->att == 1){ //delete prop
        *str << "  WSMFpropertyDelete(";
        *str << propdata->name.getString();
        *str << ");\n";
      }else if (propdata->att == 2){ //change default
        *str << "  WSMFpropertyValueChangeDef(";
        *str << btarget->getInstanceName() << ",";
        *str << propdata->name.getString() << ",";
        *str <<  _value_to_type(propdata->type) << ");\n";
      }else if (propdata->att == 3){ //builder unvis
        *str << "  WSMFpropertyVisibleOff(";
        *str << propdata->name.getString() << ");\n";
      }
    }
  }
  WSClistData* tlist = (WSClistData*)btarget->getUserData(WS_TRG_LIST);
  if (tlist != NULL){
    long num = tlist->getNum();
    long i;
    for(i=0; i<num; i++){
      long trg = (long)(*tlist)[i];
      *str << "  WSMFaddTrigger(" << WSGFltoa(trg) << ");\n";
    }

  }

  WSClistData* utlist = (WSClistData*)btarget->getUserData(WS_UTRG_LIST);
  if (utlist != NULL){
    long num = utlist->getNum();
    long i;
    for(i=0; i<num; i++){
      utrg_data* utrgdata  = (utrg_data*)(*utlist)[i];
      if (utrgdata->type == 0){
        *str << "  WSMFaddExtTrigger(" << utrgdata->vname.getString()
           << ",\"" << utrgdata->name.getString() << "\");\n";
      }else{
        *str << "  WSMFdelExtTrigger(" << utrgdata->vname.getString() << ");\n";
      }
    }
  }

  //setup of properties

  *str << "  WSMFpropertyCreateEnd\n" << "}\n";
  *str << "void " << btarget->getInstanceName() << "::_property_delete(){\n";
//  *str << "  delAllProcedure();\n";

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      //̾ޤԲĻ  char* ʤ
      //if charptr
      if ( (propdata->att == 0 || propdata->att == 4 ) && propdata->type == WSTcharptr){
        *str << "  delete " << propdata->vname.getString() << ";\n";
      }
    }
  }
  *str << "}\n";

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){
        *str << "WSMFproperty(";
        *str << btarget->getInstanceName() << ",";
        *str << propdata->name.getString() << ",";
        *str <<  _value_to_type(propdata->type) << ",";
        *str << propdata->vname.getString() << ",";
        if (propdata->type == WSTcharptr){ //string
           *str << "WSGFstrdup(\"" << propdata->value.getString() << "\")";
        }else
        if (propdata->type == WSTvoidptr){
           *str << "(void*)" << propdata->value.getString();
        }else{
           if (propdata->type == WSTshort && //2=short
               _is_color_property(propdata->name.getString()) != False){
             if (WSGFstrcmp(propdata->value.getString(),"")){
               *str << "WSGFcolor(\"" << propdata->value.getString() << "\")";
             }else{
               *str << "WSGFcolor(\"#000000\")";
             }
           }else
           if (propdata->type == WSTshort &&  //2=short
               _is_pixmap_property(propdata->name.getString()) != False){
             *str << "WSGFimage(\"" << propdata->value.getString() << "\")";
           }else{
             if (WSGFstrcmp(propdata->value.getString(),"")){
               *str << propdata->value.getString();
             }else{
               *str << "0";
             }
           }
        }
        *str << ");\n";
        if (propdata->use_file == False){
          *str << "void " << btarget->getInstanceName() << "::setWork";
          *str << propdata->name.getString() << "(";
          *str <<  _value_to_type(propdata->type) << "){}\n";
          *str << "void " << btarget->getInstanceName() << "::getWork";
          *str << propdata->name.getString() << "(";
          *str <<  _value_to_type(propdata->type) << "*){}\n";
        }
      }
    }
  }

  *str << "long " << btarget->getInstanceName() << "::objectInitialize(){\n  ";

  WSCstring str2;
  WSGFcreateWindowInstanceClassSrc(&str2,NULL,btarget);
  // class->  ʬΤä
  WSCstring tmp(btarget->getInstanceName());
  tmp << "->";
  str2.replaceString(tmp.getString(),"",0);

  // change [ new WSCxxx(class,"xxx") ] to [ new WSCxxx(this,"xxx") ]
  tmp = "(";
  tmp << btarget->getInstanceName() << ",";
  str2.replaceString(tmp.getString(),"(this,",0);
  if (btarget != btarget->getParentWindow()){
    str2.replaceString("\tsetPropertyV(","//\tsetPropertyV(",0);
  }

  *str << str2;
  *str << "    return WS_NO_ERR;\n";
  *str << "}\n//end of src\n";
  num = def_prop_list.getNum();
  for(i=0; i<num; i++){
    prop_data* pdata = (prop_data*)def_prop_list[i];
    delete pdata;
  }
  return str;
}

WSCstring* WSGFcreateWindowClassHeaderP(WSCbase* btarget){
  WSCstring* str = new WSCstring;

  //output of properties
  *str << "  private:////////////////////////\n";
  *str << "  //valiables for properties\n\n";
  WSClistData* prop_list = (WSClistData*)btarget->getUserData(WS_PROP_LIST);
  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){
        *str << "  " <<  _value_to_type(propdata->type) << " ";
        *str << propdata->vname.getString() << ";\n";
      }
    }
  }

  *str << "  protected:////////////////////////\n";
  *str << "     //definition of properties\n\n";

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){
        *str << "  WSMFpropertyDef(";
        *str <<  propdata->name.getString() << ",";
        *str <<  _value_to_type(propdata->type) << ",";
        *str << propdata->vname.getString() << ");\n";
      }
    }
  }
  *str << "\n     //valiables for instances\n";

  WSCstring tmp1;
  WSGFcreateWindowInstanceList(&tmp1,btarget);

  //ܤ饹Υ󥹥󥹤ǤСʤΤǺ
  char buffer[128];
  sprintf(buffer,"%s* %s;\n",btarget->getClassName(),btarget->getInstanceName());
  WSCstring tmp2(buffer);
  tmp1.replaceString(tmp2.getString(),"",1);

  *str << tmp1;

  //define properties...
  *str << "     void _property_initialize();\n\n";
  *str << "     void _property_delete();\n\n";
  *str << "  public:////////////////////////\n";
  *str << "virtual     long initialize();\n\n";
  *str << "            long objectInitialize();\n\n";
  *str << "\n   // definitions for event procedures\n\n";

  WSCstring tmp3;
  WSGFcreateWindowClassProcedureList(&tmp3,btarget);
  *str << tmp3;
  *str << "\n\n";
  return str;
}

WSCstring* WSGFupdateWindowClassHeader(WSCstring* in,WSCbase* btarget){
  WSClistData* clist = _get_class_list(btarget);
  long i;
  long num = clist->getNum();
  for(i=0; i<num; i++){
    WSCbase* base = (WSCbase*)(*clist)[i];
    if (base == btarget){
      continue;
    }
    WSCstring tmp("class ");
    tmp << base->getClassName() << ";\n";
    if (in->isExist(tmp.getString()) == -1){ // if not exist
       WSCstring tmp2("//USE CLASS\n");
       tmp2 += tmp;
       in->replaceString("//USE CLASS\n",tmp2.getString(),1);
    }
  }

  WSClistData* prop_list = (WSClistData*)btarget->getUserData(WS_PROP_LIST);
  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      in->seek(0);
      char* str = 0;
      WSCbool exist = False;
      while(!in->eof()){
        WSCstring tmp = in->gets();
        if (tmp.isExist(propdata->name.getString()) != -1 &&
            tmp.isExist("#define") != -1 ){
           exist = True;
           delete str;
           break;
        }
      }

      if (exist == True){
        continue;
      }
      if (propdata->att == 0 || propdata->att == 4 ){
        WSCstring st("//USE PROPERTY\n#ifndef ");
        st << propdata->name.getString() << "\n";
        st << "#define " << propdata->name.getString();
        WSCstring tmp(propdata->name.getString());
        tmp.replaceString("WSN","\t\"",1);
        st << tmp.getString();
        st << "\"\n#endif\n";
        in->replaceString("//USE PROPERTY\n",st.getString(),1);
      }
    }
  }
  in->seek(0);
  WSClistData* utrg_list = (WSClistData*)btarget->getUserData(WS_UTRG_LIST);
  if (utrg_list != NULL){
    long num = utrg_list->getNum();
    long i;
    for(i=0; i<num; i++){
      utrg_data* utrgdata = (utrg_data*)(*utrg_list)[i];
      in->seek(0);
      char* str = 0;
      WSCbool exist = False;
      while(!in->eof()){
        WSCstring tmp = in->gets();
        if (tmp.isExist(utrgdata->name.getString()) != -1 &&
            tmp.isExist("#define") != -1 ){
           exist = True;
           delete str;
           break;
        }
      }

      if (exist == True){
        continue;
      }
      WSCstring st("//USE TRIGGER\n#ifndef ");
      st << utrgdata->vname.getString() << "\n";
      st << "#define " << utrgdata->vname.getString() << " ";
      st << utrgdata->value << "\n#endif\n";
      in->replaceString("//USE TRIGGER\n",st.getString(),1);
    }
  }


  in->seek(0);
  while(!in->eof()){
    WSCstring tmp = in->gets();

    if (tmp.isExist("//BASE CLASS HEADER") != -1){
      tmp = in->gets();
      WSCstring tmp2("<");
      tmp2 << btarget->getClassName();
      tmp2 << ".h>";
      if (tmp.isExist( tmp2.getString() ) == -1){
        tmp << "\n";
        in->replaceString(tmp.getString(),"",1);
        tmp2 = "//BASE CLASS HEADER\n";
        tmp2 << "#include <";
        tmp2 << btarget->getClassName();
        tmp2 << ".h>\n";
        in->replaceString("//BASE CLASS HEADER\n",tmp2.getString(),1);
      }
    }else if (tmp.isExist("BASETYPE") != -1 && tmp.isExist("#define") != -1){
      if (tmp.isExist(btarget->getClassName()) != -1 ){
        break;
      }else{
        tmp << "\n";
        in->replaceString(tmp.getString(),"",1);
        WSCstring tmp2("//BASE CLASS SETTING\n#define ");
        tmp2 << btarget->getInstanceName();
        tmp2 << "BASETYPE " << btarget->getClassName() << "\n";
        in->replaceString("//BASE CLASS SETTING\n",tmp2.getString(),1);
        break;
      }
    }
  }
  return in;
}


WSCstring* WSGFcreateWindowClassHeader(WSCbase* btarget){
  WSCstring* str = new WSCstring;
  *str =  "//----------------------------------------------------//\n";
  *str << "// Wide Studio Application C++ Source File            //\n";
  *str << "//            created by Wide Studio source generator //\n";
  *str << "//----------------------------------------------------//\n";
  *str << "#ifndef " << btarget->getInstanceName() << "_H\n";
  *str << "#define " << btarget->getInstanceName() << "_H\n";
  *str << "#include <WScom.h>\n#include <WSDappDev.h>\n";
  *str << "//define version...\n";
  *str << "#define " << btarget->getInstanceName() << "_VER 1000\n";
//  *str << WSGFgettext("C:WSSTR//##### IMPORTANT: Do not edit from here  #######\n\n");
  *str << "//##### IMPORTANT: Do not edit from here  #######\n\n";

  *str << "//BASE CLASS HEADER\n";
  *str << "#include <" << btarget->getClassName() << ".h>\n\n";

  //class list...
  WSClistData* clist = _get_class_list(btarget);
  long i;
  long num = clist->getNum();
  *str << "//USE CLASS\n";
  for(i=0; i<num; i++){
    WSCbase* base = (WSCbase*)(*clist)[i];
    if (base == btarget){
      continue;
    }
    *str << "class ";
    *str << base->getClassName();
    *str << ";\n";
  }

  *str << "\n//USE PROPERTY\n";
  WSClistData* prop_list = (WSClistData*)btarget->getUserData(WS_PROP_LIST);
  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){
        *str << "#ifndef " << propdata->name.getString() << "\n";
        *str << "#define " << propdata->name.getString();
        WSCstring tmp(propdata->name.getString());
        tmp.replaceString("WSN","\t\"",1);
        *str << tmp.getString() << "\"\n";
        *str << "#endif\n";
      }
    }
  }
   *str << "\n//USE TRIGGER\n";
  WSClistData* utrg_list = (WSClistData*)btarget->getUserData(WS_UTRG_LIST);
  if (utrg_list != NULL){
    long num = utrg_list->getNum();
    long i;
    for(i=0; i<num; i++){
      utrg_data* utrgdata = (utrg_data*)(*utrg_list)[i];
      *str << "#ifndef " << utrgdata->vname.getString() << "\n";
      *str << "#define " << utrgdata->vname.getString() << " " ;
      *str << utrgdata->value << "\n";
      *str << "#endif\n";
    }
  }


  *str << "\n//BASE CLASS SETTING\n";
  *str << "#define " << btarget->getInstanceName() << "BASETYPE ";
  *str << btarget->getClassName() << "\n\n";
//  *str << WSGFgettext("D:WSSTR//##### IMPORTANT: Do not edit to here  #######\n\n");
  *str << "//##### IMPORTANT: Do not edit to here  #######\n\n";
  //define class...
  *str << "class ";
  *str << btarget->getInstanceName() << " :public ";
  *str << btarget->getInstanceName() << "BASETYPE " << " {\n\n";

  // private include...
  *str << "#include <" << btarget->getInstanceName() << "P.h>\n\n";

  *str << "  public://///////////////////\n     ";
  *str << btarget->getInstanceName();
  *str << "(WSCbase* base,char* name);\n    virtual ~";
  *str << btarget->getInstanceName();
//  *str << WSGFgettext("E:WSSTR();\n\n    // class definitions/////////////////////////////////\n")
;
  *str << "();\n\n    // class definitions/////////////////////////////////\n";
  *str << "    WSMFguiClassDef("<< btarget->getInstanceName() << ",";
  *str << btarget->getInstanceName() << "BASETYPE " << ");\n";
  *str << "    WSMFversionDef(" << btarget->getInstanceName() << ");\n};\n";
  *str << "#endif\n";
  return str;
}



