//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCscrForm.h>
#include <WSCclassInformation.h>
#include <WSCvbscrBar.h>
#include <WSCscrFrame.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCbaseList.h>
#include <WSDappDev.h>
#include <WSDmouse.h>

#define NO_PIX

WSMFguiClassInitialize(WSCscrForm,WSCform);
WSMFversion(WSCscrForm,WSCform);

WSMFpropertyValueChange( WSCscrForm, WSNshadowType , char,WS_SHADOW_IN);

WSCscrForm::WSCscrForm(WSCbase* base,char* objname):
                WSCform(base,objname){
  _scr_area = NULL;
  _v_scr = NULL;
  _h_scr = NULL;

  _v_scr_slider_sz = 0;
  _h_scr_slider_sz = 0;
  _v_scr_max_sz = 0;
  _h_scr_max_sz = 0;

  _v_scr_x_bk = -1;
  _h_scr_y_bk = -1;
//  _scr_shadowthick_bk = 0xffff;

  _v_scr_w_bk = 0xffff;
  _h_scr_w_bk = 0xffff;
  _v_scr_h_bk = 0xffff;
  _h_scr_h_bk = 0xffff;

  _bar_thick = 16;
  _work_width   = 1000;
  _work_height  = 1000;
  _wx_pos  = 0;
  _wy_pos  = 0;
  _increment = 10;
  _page_increment = 100;
  _hbar_visible = True;
  _vbar_visible = True;
  _scroll_width  = 30;
  _scroll_height = 30;
//  _work_back_color = WSGFcolor("gray80");
//  _bar_back_color    = WSGFcolor("gray75");
  _work_back_color = WS_DF_WORKBACKCOLOR;
  _bar_back_color    = WS_DF_BARSHADOWCOLOR;
  _dev_is_public_dev = True;
  _shadow_type = WS_SHADOW_IN;
  _marginw = 4;
  _padding = 0;
  _virtual_scr = 0;
  _scr_offset_x = 0;
  _scr_offset_y = 0;
  _frame = True;
  _no_scroll = False;
  _update_work_area = False;

  WSGIappObjectList()->addEvent(this,WSEV_GUI_POLICY_CH);

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCscrForm);

    WSMFpropertyCreate(WSNbarThickness, WSCushort, _bar_thick,WSSbarThickness );
    WSMFpropertyCreate(WSNworkWidth,  WSCushort, _work_width,WSSworkWidth   );
    WSMFpropertyCreate(WSNworkHeight, WSCushort, _work_height,WSSworkHeight  );
    WSMFpropertyCreate(WSNhbarValue,  WSCushort, _wx_pos,WSShbarValue  );
    WSMFpropertyCreate(WSNvbarValue,  WSCushort, _wy_pos,WSSvbarValue  );
    WSMFpropertyCreate(WSNincrement,    WSCushort, _increment,WSSincrement );
    WSMFpropertyCreate(WSNpageIncrement,WSCushort, _page_increment,WSSpageIncrement );
    WSMFpropertyCreate(WSNhbarVisible,WSCbool,_hbar_visible,WSShbarVisible );
      WSMFpropertySetSelection(WSRbool2,WSRbool2D);
    WSMFpropertyCreate(WSNvbarVisible,WSCbool, _vbar_visible,WSSvbarVisible );
      WSMFpropertySetSelection(WSRbool2,WSRbool2D);
    WSMFpropertyCreate(WSNworkBackColor,short,_work_back_color,WSSworkBackColor );
    WSMFpropertyCreate(WSNbarShadowColor, short,_bar_back_color, WSSbarShadowColor  );
    WSMFpropertyCreate(WSNscrollWidth,WSCushort,_scroll_width,WSSscrollWidth );
      WSMFpropertyVisibleOff(WSNscrollWidth);

    WSMFpropertyCreate(WSNscrollHeight,WSCushort,_scroll_height,WSSscrollHeight );
      WSMFpropertyVisibleOff(WSNscrollHeight);

    WSMFpropertyCreate(WSNmargin,WSCuchar,_marginw,WSSmargin );
    WSMFpropertyCreate(WSNvirtualScroll,WSCbool,_virtual_scr,WSSvirtualScroll );
      WSMFpropertySetSelection(WSRbool1,WSRbool1D);
    WSMFpropertyCreate(WSNframe,WSCbool,_frame,WSSframe );
      WSMFpropertySetSelection(WSRbool1,WSRbool1D);

    WSMFpropertyValueChangeDef( WSCscrForm,WSNshadowType ,char);

    WSMFpropertyVisibleOff(WSNshadowType);
    WSMFpropertyDelete(WSNgradation);
    WSMFpropertyDelete(WSNgradationMargin);

    WSMFaddTrigger(WSEV_VALUE_CH    );
    WSMFaddTrigger(WSEV_ACTIVATE    );
    WSMFaddExtTrigger(WSEV_SCR_MOUSE_PRESS,"SCR-MOUSE-PRESS"  );
    WSMFaddExtTrigger(WSEV_SCR_MOUSE_RELEASE,"SCR-MOUSE-RELEASE"  );
    WSMFaddExtTrigger(WSEV_SCR_MOUSE_MOVE,"SCR-MOUSE-MOVE"  );
    WSMFaddExtTrigger(WSEV_SCR_MOUSE_DOUBLE_CLICK,"SCR-MOUSE-DCLICK"  );

  WSMFpropertyCreateEnd
}

WSCscrForm::~WSCscrForm(){
  WSCbase* fclient = WSGIappMouse()->getMouseFocusClient();
  if (fclient == this){
    WSGIappMouse()->setMouseFocusClient(NULL);
  }
  WSGIappObjectList()->delEvent(this,WSEV_GUI_POLICY_CH);
}

WSMFproperty( WSCscrForm, WSNbarThickness,  WSCushort, _bar_thick, 16);
WSMFproperty( WSCscrForm, WSNworkWidth,     WSCushort, _work_width, 1000);
WSMFproperty( WSCscrForm, WSNworkHeight,    WSCushort, _work_height, 1000);
WSMFproperty( WSCscrForm, WSNhbarValue,     WSCushort, _wx_pos,   0);
WSMFproperty( WSCscrForm, WSNvbarValue,     WSCushort, _wy_pos,   0);
WSMFproperty( WSCscrForm, WSNincrement,     WSCushort, _increment,  10);
WSMFproperty( WSCscrForm, WSNpageIncrement, WSCushort, _page_increment, 100);
WSMFproperty( WSCscrForm, WSNvbarVisible,   WSCbool, _vbar_visible, True);
WSMFproperty( WSCscrForm, WSNhbarVisible,   WSCbool, _hbar_visible, True);
//WSMFproperty( WSCscrForm, WSNworkBackColor, short, _work_back_color, WSGFcolor("gray80"));
WSMFproperty( WSCscrForm, WSNworkBackColor, short, _work_back_color, WS_DF_WORKBACKCOLOR);
//WSMFproperty( WSCscrForm, WSNbarShadowColor,short, _bar_back_color,WSGFcolor("gray75"));
WSMFproperty( WSCscrForm, WSNbarShadowColor,short, _bar_back_color,WS_DF_BARSHADOWCOLOR);
WSMFproperty( WSCscrForm, WSNscrollWidth,  WSCushort,_scroll_width,30);
WSMFproperty( WSCscrForm, WSNscrollHeight, WSCushort,_scroll_height,30);
WSMFproperty( WSCscrForm, WSNmargin, WSCuchar,_marginw,4);
WSMFproperty( WSCscrForm, WSNvirtualScroll, WSCbool,_virtual_scr,0);
WSMFproperty( WSCscrForm, WSNframe, WSCbool,_frame,True);

void WSCscrForm::setWorkWSNpixmapStyle(WSCuchar data){
  if (_scr_area != NULL){
    _scr_area->setPropertyV(WSNpixmapStyle,data);
  }
#ifndef NO_PIX
  WSCform::setWorkWSNpixmapStyle(data);
#endif //NO_PIX
}

void WSCscrForm::setWorkWSNbarThickness(WSCushort){
  if (_scr_area != NULL){
    _adjust();
  }
}
void WSCscrForm::getWorkWSNbarThickness(WSCushort*){}

void WSCscrForm::setWorkWSNmargin(WSCuchar){
  if (_scr_area != NULL){
    _adjust();
  }
}
void WSCscrForm::getWorkWSNmargin(WSCuchar*){}

void WSCscrForm::setWorkWSNworkWidth(WSCushort data){
  if (data & 0x8000){
    data = 0x7fff;
    _work_width = 0x7fff;
  }
  if (_scr_area != NULL){
    _update_work_area = True;
    WSCulong slsize;
    _h_scr->getPropertyV(WSNsliderSize,&slsize);
    WSCulong pos;
    _h_scr->getPropertyV(WSNvalue,&pos);
    if (data < pos + slsize){
      if ((long)data - (long)slsize -1 > 0){
        setPropertyV(WSNhbarValue,(WSCushort)(data -slsize-1));
      }else{
        setPropertyV(WSNhbarValue,(WSCushort)0);
      }
    }
    if (_virtual_scr == 0){
      _scr_area->setPropertyV(WSNworkWidth,data);
    }else{
      WSCushort ww_org;
      _scr_area->getPropertyV(WSNworkWidth,&ww_org);
      if (ww_org > _w){
        if (ww_org > _w + 256){
          _scr_area->setPropertyV(WSNworkWidth,_w);
        }
      }else if (ww_org < _w){
        _scr_area->setProperty(WSNworkWidth,(_w+256));
      }
    }
    if (data <_h_scr_slider_sz){
      _h_scr->setPropertyV(WSNsliderSize,(WSCulong)_h_scr_slider_sz);
    }
    _h_scr->setPropertyV(WSNmaximum,(WSCulong)data);
    _adjust();
  }
}

void WSCscrForm::getWorkWSNworkWidth(WSCushort* ){
}

void WSCscrForm::setWorkWSNworkHeight(WSCushort data){
  if (data & 0x8000){
    data = 0x7fff;
    _work_height = 0x7fff;
  }
  if (_scr_area != NULL){
    _update_work_area = True;
    WSCulong slsize;
    _v_scr->getPropertyV(WSNsliderSize,&slsize);
    WSCulong pos;
    _v_scr->getPropertyV(WSNvalue,&pos);

    if (data < pos + slsize){
      if ((long)data - (long)slsize-1 > 0){
        setPropertyV(WSNvbarValue,(WSCushort)(data -slsize-1));
      }else{
        setPropertyV(WSNvbarValue,(WSCushort)0);
      }
    }

    if (_virtual_scr == 0){
      _scr_area->setPropertyV(WSNworkHeight,data);
      _scr_area->setAbsoluteDraw(False); //set work height clear bug fix
    }else{
      WSCushort wh_org;
      _scr_area->getPropertyV(WSNworkHeight,&wh_org);
      if (wh_org > _h){
        if (wh_org > _h + 256){
          _scr_area->setPropertyV(WSNworkHeight,_h);
        }
      }else if (wh_org < _h){
        if (wh_org > _h + 256){
          _scr_area->setProperty(WSNworkHeight,(_h+256));
        }

      }
    }
    if (data <_v_scr_slider_sz){
      _v_scr->setPropertyV(WSNsliderSize,(WSCulong)_v_scr_slider_sz);
    }
    _v_scr->setPropertyV(WSNmaximum,(WSCulong)data);
    _adjust();
  }
}

void WSCscrForm::getWorkWSNworkHeight(WSCushort* ){
}

void WSCscrForm::setWorkWSNhbarValue(WSCushort data){
  if (_scr_area != NULL){
    _scr_offset_x = -data;
    if (_virtual_scr == False){
      _scr_area->setHbarValue(data);
    }else{
//      _scr_area->redraw();
      _redraw_scr();
    }
    _h_scr->setPropertyV(WSNvalue,(WSCulong)data);
    _h_scr->setAbsoluteDraw(True);
    _h_scr->draw();
  }
}

void WSCscrForm::getWorkWSNhbarValue(WSCushort*){
}

void WSCscrForm::setWorkWSNvbarValue(WSCushort data){
  if (_scr_area != NULL){
    _scr_offset_y = -data;
    if (_virtual_scr == False){
      _scr_area->setVbarValue(data);
    }else{
//      _scr_area->redraw();
      _redraw_scr();
    }
    _v_scr->setPropertyV(WSNvalue,(WSCulong)data);
    _v_scr->setAbsoluteDraw(True);
    _v_scr->draw();
  }
}

void WSCscrForm::getWorkWSNvbarValue(WSCushort*){
}

void WSCscrForm::setWorkWSNtopShadowColor(short data){
  if (_scr_area != NULL){
    _h_scr->setPropertyV(WSNtopShadowColor,data);
    _v_scr->setPropertyV(WSNtopShadowColor,data);
  }
}
void WSCscrForm::setWorkWSNbottomShadowColor(short data){
  if (_scr_area != NULL){
    _h_scr->setPropertyV(WSNbottomShadowColor,data);
    _v_scr->setPropertyV(WSNbottomShadowColor,data);
  }
}
void WSCscrForm::setWorkWSNshadowThickness(WSCuchar data){
  if (_scr_area != NULL){
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      _h_scr->setPropertyV(WSNshadowThickness,data);
      _v_scr->setPropertyV(WSNshadowThickness,data);
    }else
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      _h_scr->setProperty(WSNshadowThickness,2);
      _v_scr->setProperty(WSNshadowThickness,2);
    }
    _scr_area->setPropertyV(WSNx,(short)data);
    _scr_area->setPropertyV(WSNy,(short)(data + _padding));
    _scr_area->setAbsoluteDraw(False);
  }
}
void WSCscrForm::setWorkWSNbackColor(short data){
  if (_scr_area != NULL){
    _h_scr->setPropertyV(WSNbackColor,data);
    _v_scr->setPropertyV(WSNbackColor,data);
  }
  if (_dev != NULL){
    _dev->setValue(WSDEV_BACKCOLOR,(void*)&data);
  }
}

void WSCscrForm::setWorkWSNforeColor(short data){
  if (_scr_area != NULL){
    _h_scr->setPropertyV(WSNforeColor,data);
    _v_scr->setPropertyV(WSNforeColor,data);
  }
}

void WSCscrForm::setWorkWSNbarShadowColor(short data){
  if (_scr_area != NULL){
    _h_scr->setPropertyV(WSNbarShadowColor,data);
    _v_scr->setPropertyV(WSNbarShadowColor,data);
  }
}

void WSCscrForm::getWorkWSNbarShadowColor(short*){ }
void WSCscrForm::setWorkWSNscrollWidth(WSCushort){ }
void WSCscrForm::getWorkWSNscrollWidth(WSCushort*){ }
void WSCscrForm::setWorkWSNscrollHeight(WSCushort){ }
void WSCscrForm::getWorkWSNscrollHeight(WSCushort*){ }

void WSCscrForm::setWorkWSNpageIncrement(WSCushort data){
  if (data == 0){
    data = 1;
    _page_increment = 1;
  }
  if (_scr_area != NULL){
    _v_scr->setPropertyV(WSNpageIncrement,data);
    _h_scr->setPropertyV(WSNpageIncrement,data);
  }
}
void WSCscrForm::getWorkWSNpageIncrement(WSCushort*){ }

void WSCscrForm::setWorkWSNincrement(WSCushort data){
  if (data == 0){
    data = 1;
    _increment = 1;
  }
  if (_scr_area != NULL){
    _v_scr->setPropertyV(WSNincrement,data);
    _h_scr->setPropertyV(WSNincrement,data);
  }
}
void WSCscrForm::getWorkWSNincrement(WSCushort*){ }

void WSCscrForm::setWorkWSNhbarVisible(WSCbool){
  if (_scr_area != NULL){
    _adjust();
  }
}
void WSCscrForm::getWorkWSNhbarVisible(WSCbool*){ }

void WSCscrForm::setWorkWSNvbarVisible(WSCbool){
  if (_scr_area != NULL){
    _adjust();
  }
}
void WSCscrForm::getWorkWSNvbarVisible(WSCbool*){ }

void WSCscrForm::setWorkWSNworkBackColor(short data){
  if (_scr_area != NULL){
    _scr_area->setPropertyV(WSNbackColor,data);
//    _scr_area->setPropertyV(WSNbackColor,WSGFcolor("red"));
  }
}
void WSCscrForm::getWorkWSNworkBackColor(short*){ }

void WSCscrForm::setWorkWSNvirtualScroll(WSCbool fl){
  setWorkWSNworkWidth(_work_width);
  setWorkWSNworkHeight(_work_height);
  WSClistData children = getChildren();
  long i,num = children.getNum();
  if (fl == 0){
    _scr_area->setPropertyV(WSNvbarValue,(WSCushort)_wx_pos);
    _scr_area->setPropertyV(WSNhbarValue,(WSCushort)_wy_pos);
  }else{
    _scr_area->setPropertyV(WSNvbarValue,(WSCushort)0);
    _scr_area->setPropertyV(WSNhbarValue,(WSCushort)0);
  }
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getUseParentBaseDev() != False){
      continue;
    }
    if (fl == 0){
      child->setXOffsetPtr(NULL);
      child->setYOffsetPtr(NULL);
    }else{
//printf("WSCscrForm:: child=%s \n",child->getInstanceName());
      child->setXOffsetPtr(&_scr_offset_x);
      child->setYOffsetPtr(&_scr_offset_y);
    }
  }
}
void WSCscrForm::getWorkWSNvirtualScroll(WSCbool* fl){
}
void WSCscrForm::setWorkWSNwidth(WSCushort w){
  WSCform::setWorkWSNwidth(w);
//printf("WSCscfForm::setWorkWSNwidth %s\n",getInstanceName());
//  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
//    setAbsoluteDraw(False);
//    WSCbase::update();
//    update();
//  }
}
void WSCscrForm::setWorkWSNheight(WSCushort h){
  WSCform::setWorkWSNheight(h);
//  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
//    setAbsoluteDraw(False);
//    WSCbase::update();
//    update();
//  }
}
void WSCscrForm::setWorkWSNframe(WSCbool fl){ };
void WSCscrForm::getWorkWSNframe(WSCbool* fl){ };


long WSCscrForm::initialize(){
  WSCform::initialize();

  WSCstring scrname(getInstanceName());
  WSCstring addstr("-scr");
  scrname.addString(addstr);
  _scr_area = new WSCscrFrame(this,scrname.getString());
  _scr_area->setInternalObject(True);
  _scr_area->setUseParentBaseDev(True);
  _scr_area->initialize();
  _scr_area_w = 0;
  _scr_area_h = 0;
  _dev_public = _scr_area;
  _scr_area->setPropertyV(WSNx,(short)_shadow_thick);
  _scr_area->setPropertyV(WSNy,(short)(_shadow_thick + _padding));
  _scr_area->setPropertyV(WSNbackColor,(short)_work_back_color);
  _scr_area->setVisible(True);
  WSCprocedure* op_p = new WSCprocedure("scrmp",WSEV_MOUSE_PRESS);
  op_p->setInternal(True);
  op_p->setFunction(_scr_mouse_press,"_scr_mouse_press");
  _scr_area->addProcedure(op_p);
  WSCprocedure* op_r = new WSCprocedure("scrmr",WSEV_MOUSE_RELEASE);
  op_r->setInternal(True);
  op_r->setFunction(_scr_mouse_release,"_scr_mouse_release");
  _scr_area->addProcedure(op_r);
  WSCprocedure* op_m = new WSCprocedure("scrmm",WSEV_MOUSE_MOVE);
  op_m->setInternal(True);
  op_m->setFunction(_scr_mouse_move,"_scr_mouse_move");
  _scr_area->addProcedure(op_m);
  WSCprocedure* op_dc = new WSCprocedure("scrmm",WSEV_MOUSE_DOUBLE_CLICK);
  op_dc->setInternal(True);
  op_dc->setFunction(_scr_mouse_dclick,"_scr_mouse_dclick");
  _scr_area->addProcedure(op_dc);

  scrname.setString(getInstanceName());
  addstr.setString("-hscr");
  scrname.addString(addstr);

  WSCbase* htmp = WSCbase::getNewInstance(getUseScrBarClass(),this,scrname.getString());
  _h_scr = (WSCvscrBar*)htmp->cast("WSCvscrBar");
  if (_h_scr == NULL){
WSMFtrace("Error: WSCscrForm cannot create ScrBarClass:%s.\n",getUseScrBarClass());
    _h_scr = new WSCvscrBar(this,scrname.getString());
  }
  _h_scr->setInternalObject(True);
  _h_scr->setUseParentBaseDev(True);
  _h_scr->initialize();
  WSCprocedure* op1 = new WSCprocedure("value-ch",WSEV_VALUE_CH);
  op1->setInternal(True);
  op1->setFunction(_h_scr_work_op,"_h_scr_work_op");
  _h_scr->addProcedure(op1);
  WSCprocedure* op3 = new WSCprocedure("activate",WSEV_ACTIVATE);
  op3->setInternal(True);
  op3->setFunction(_ha_scr_work_op,"_ha_scr_work_op");
  _h_scr->addProcedure(op3);
  _h_scr->setPropertyV(WSNshadowThickness,(WSCuchar)_shadow_thick);
  _h_scr->setPropertyV(WSNbackColor,_back_color);
  _h_scr->setPropertyV(WSNforeColor,_fore_color);
  _h_scr->setPropertyV(WSNtopShadowColor,_ts_color);
  _h_scr->setPropertyV(WSNbottomShadowColor,_bs_color);
  _h_scr->setPropertyV(WSNbarShadowColor,_bar_back_color);

  scrname.setString(getInstanceName());
  addstr.setString("-vscr");
  scrname.addString(addstr);
  WSCbase* vtmp = WSCbase::getNewInstance(getUseScrBarClass(),this,scrname.getString());
  _v_scr = (WSCvscrBar*)vtmp->cast("WSCvscrBar");
  if (_v_scr == NULL){
WSMFtrace("Error: WSCscrForm cannot create ScrBarClass:%s.\n",getUseScrBarClass());
    _v_scr = new WSCvscrBar(this,scrname.getString());
  }
  _v_scr->setInternalObject(True);
  _v_scr->setUseParentBaseDev(True);
  _v_scr->initialize();
  _v_scr->setPropertyV(WSNorientation,(WSCuchar)WS_VERTICAL);
  WSCprocedure* op2 = new WSCprocedure("value-ch",WSEV_VALUE_CH);
  op2->setInternal(True);
  op2->setFunction(_v_scr_work_op,"_v_scr_work_op");
  _v_scr->addProcedure(op2);
  WSCprocedure* op4 = new WSCprocedure("activate",WSEV_ACTIVATE);
  op4->setInternal(True);
  op4->setFunction(_va_scr_work_op,"_va_scr_work_op");
  _v_scr->addProcedure(op4);
  _v_scr->setPropertyV(WSNshadowThickness,(WSCuchar)_shadow_thick);
  _v_scr->setPropertyV(WSNbackColor,_back_color);
  _v_scr->setPropertyV(WSNforeColor,_fore_color);
  _v_scr->setPropertyV(WSNtopShadowColor,_ts_color);
  _v_scr->setPropertyV(WSNbottomShadowColor,_bs_color);
  _v_scr->setPropertyV(WSNbarShadowColor,_bar_back_color);
  if (_virtual_scr != 0){
    setWorkWSNvirtualScroll(1);
  }
  _adjust();

  return WS_NO_ERR;
}

//WSDdev* WSCscrForm::getPublicDev(){
//  return _scr_area->getDev();
//}

long WSCscrForm::_device_initialize(){
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  _adjust();

  dev->setEnableEventBit( WSEV_MOUSE_MOVE_BIT | WSEV_MOUSE_OUT_BIT |
                              WSEV_MOUSE_PRESS_BIT  | WSEV_MOUSE_RELEASE_BIT );

  if (_scr_area != NULL){
    _scr_area->setPropertyV(WSNworkWidth, _work_width);
    _scr_area->setPropertyV(WSNworkHeight,_work_height);
    _scr_area->setPropertyV(WSNhbarValue, _wx_pos);
    _scr_area->setPropertyV(WSNvbarValue, _wy_pos);
  }

  WSCform::_device_initialize();
#ifndef NO_PIX
  char fl = False;
  _dev->setValue(WSDEV_PIXMAP_STYLE,(void*)&fl);
#endif //NO_PIX
  return WS_NO_ERR;
}



long WSCscrForm::execEventProc(long ev,void* data){
  if (ev == WSEV_MOUSE_MOVE){
    WSCpoint* point = (WSCpoint*)data;
    _btn_x = point->x;
    _btn_y = point->y;
  }else if (ev == WSEV_MOUSE_PRESS){
    WSCpoint* point = (WSCpoint*)data;
    _btn_x = point->x;
    _btn_y = point->y;
    _btn_x_pressed = point->x;
    _btn_y_pressed = point->y;
  }else if (ev == WSEV_MOUSE_RELEASE){
    WSCpoint* point = (WSCpoint*)data;
    _btn_x = point->x;
    _btn_y = point->y;
  }
  return WSCform::execEventProc(ev,data);
}


short WSCscrForm::_btn_x = 0;
short WSCscrForm::_btn_y = 0;
short WSCscrForm::_btn_x_pressed = 0;
short WSCscrForm::_btn_y_pressed = 0;
WSCushort WSCscrForm::_value_pressed = 0;

void WSCscrForm::_redraw_scr(){
  if (_scr_area != NULL){
    if (_virtual_scr == False){
      _scr_area->redraw();
    }else{
      if (_pixmap_style == WS_DIRECT_WINDOW){
        _scr_area->redraw();
      }else{
        if (_scr_area->getdev() != NULL){
          _scr_area->getdev()->exposeArea(0,0,_work_width,_work_height);
        }
      }
    }
  }
}

long WSCscrForm::redraw(){
//  _redraw_scr();
#ifndef NO_PIX
  WSCform::redraw();
#else //NO_PIX
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  if (getVisible() == False){
    return WS_ERR;
  }
  long er = dev->beginDraw(0,0,_w,_h,True);
  if (er != WS_NO_ERR){
    return WS_NO_ERR;
  }
  dev->clearArea(_shadow_thick,_shadow_thick,
                 _w - _shadow_thick *2,_h - _shadow_thick *2,True);
  dev->endDraw();
#endif //NO_PIX
  return WS_NO_ERR;
}

long WSCscrForm::clear(){
//  if (_scr_area != NULL){
//    _scr_area->clear();
//  }
  WSCform::clear();
  return WS_NO_ERR;
}

void WSCscrForm::_adjust(){
  long _margin = _marginw;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    _margin = 0;
  }
  WSCushort sh = _h - _bar_thick -_shadow_thick*2 - _padding;
  if (_get_hbar_visible() == False){
    sh = _h  - _shadow_thick*2 - _padding;
  }
//printf("scrform::_adjust sh=%d vssz=%d ws=%d\n",sh,_v_scr_slider_sz,_work_height);
//  if (_v_scr_slider_sz != sh){
//    _v_scr->setPropertyV(WSNsliderSize,(WSCulong)sh);
//    _v_scr_slider_sz = sh;
//  }

  if (_v_scr_max_sz != _work_height ||
      _v_scr_slider_sz != sh){
    _v_scr->setPropertyV(WSNmaximum,(WSCulong)_work_height);
    _v_scr_max_sz = _work_height;
    _v_scr->setPropertyV(WSNsliderSize,(WSCulong)sh);
    _v_scr_slider_sz = sh;
  }

  WSCushort sw = _w - _bar_thick - _shadow_thick*2;
  if (_get_vbar_visible() == False){
    sw = _w  - _shadow_thick*2;
  }

//  if (_h_scr_slider_sz != sw){
//    _h_scr->setPropertyV(WSNsliderSize,(WSCulong)sw);
//    _h_scr_slider_sz = sw;
//  }

  if (_h_scr_max_sz != _work_width ||
      _h_scr_slider_sz != sw){
    _h_scr->setPropertyV(WSNmaximum,(WSCulong)_work_width);
    _h_scr_max_sz = _work_width;
    _h_scr->setPropertyV(WSNsliderSize,(WSCulong)sw);
    _h_scr_slider_sz = sw;
  }

  WSCushort w = _w;
  WSCushort h = _h;

  if (_scr_area == NULL){
    return;
  }
  WSCushort st = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    st = _shadow_thick;
  }
  short bw = 0,bh = 0;
  if (_get_hbar_visible() != False){
    bw = w - _bar_thick -_margin;
    if (_get_vbar_visible() == False){
      bw = w;
    }
    if (bw < 1){
      bw =1;
    }
    bh = _bar_thick;
    if (bh < 1){
      bh =1;
    }

    if (h - _bar_thick -st != _h_scr_y_bk){
      _h_scr->setPropertyV(WSNx,(short)st);
      _h_scr->setPropertyV(WSNy,(short)(h - _bar_thick-st));
      _h_scr_y_bk = h - _bar_thick -st;
    }

    if (bw -st*2 != _h_scr_w_bk){
      _h_scr->setPropertyV(WSNwidth,(WSCushort)(bw -st*2));
      _h_scr_w_bk = bw -st*2;
    }

    if (bh != _h_scr_h_bk){
      _h_scr->setPropertyV(WSNheight,(WSCushort)bh);
      _h_scr_h_bk = bh;
    }
    if (_h_scr->getVisible() == False){
      _h_scr->setVisible(True);
    }
  }else{ 
    if (_h_scr->getVisible() != False){
      _h_scr->setVisible(False);
    }
  }

  if (_get_vbar_visible() != False){
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      bh = h - _bar_thick -_margin - _padding;
      if (_get_hbar_visible() == False){
        bh = h - _padding;
      }
    }else
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      bh = h - _bar_thick -_margin;
      if (_get_hbar_visible() == False){
        bh = h;
      }
    }
    if (bh < 1){
      bh =1;
    }
    bw = _bar_thick;
    if (bw < 1){
      bw =1;
    }

    if (w - _bar_thick-st != _v_scr_x_bk){
      _v_scr->setPropertyV(WSNx,(short)(w - _bar_thick -st));
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
        _v_scr->setPropertyV(WSNy,(short)(_padding +st));
      }else
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        _v_scr->setPropertyV(WSNy,(short)st);
      }
      _v_scr_x_bk = w - _bar_thick -st;
    }

    if (bw != _v_scr_w_bk){
      _v_scr->setPropertyV(WSNwidth,(WSCushort)bw);
      _v_scr_w_bk = bw;
    }

    if (bh -st*2!= _v_scr_h_bk){
      _v_scr->setPropertyV(WSNheight,(WSCushort)(bh -st*2));
      _v_scr_h_bk = bh-st*2;
    }
    if (_v_scr->getVisible() == False){
      _v_scr->setVisible(True);
    }
  }else{
    if (_v_scr->getVisible() != False){
      _v_scr->setVisible(False);
    }
  }

}

void WSCscrForm::update(){
  _adjust();
  _adjust_scr_area();
  if (isNeedUpdate() != False){
    if (_pixmap_style != WS_DIRECT_WINDOW){
      WSCform::redraw();
    }else{
      setAbsoluteDraw(True);
      draw();
    }
    WSCbase::update();
  }
}
void WSCscrForm::_adjust_scr_area(){
  long _margin = _marginw;
  long st = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    _margin = 0;
    st = _shadow_thick;
  }
  unsigned v_bar_thick = _bar_thick + _margin+st; 
  unsigned h_bar_thick = _bar_thick + _margin+st; 
  long st2 = _shadow_thick;
  if (_get_hbar_visible() == False &&
      _get_vbar_visible() == False && _frame == False){
    st2 = 0;
    _scr_area->setProperty(WSNx,0);
    _scr_area->setProperty(WSNy,_padding);
  }else{
    _scr_area->setProperty(WSNx,st2);
    _scr_area->setProperty(WSNy,st2 + _padding);
  }
  if (_get_vbar_visible() != False){
    if (_scr_area_w != _w - st2*2 - _bar_thick -_margin){
      _scr_area_w = _w - st2*2 - _bar_thick -_margin;
      _scr_area->setPropertyV(WSNwidth,_scr_area_w);
      if (_virtual_scr != False){
        _scr_area->setPropertyV(WSNworkWidth,_scr_area_w);
      }
      _scr_area->setAbsoluteDraw(False); //resize clear bug fix
    }
  }else{
    if (_scr_area_w != _w - st2*2){
      _scr_area_w = _w - st2*2 ;
      _scr_area->setPropertyV(WSNwidth,_scr_area_w);
      if (_virtual_scr != False){
        _scr_area->setPropertyV(WSNworkWidth,_scr_area_w);
      }
      _scr_area->setAbsoluteDraw(False); //resize clear bug fix
    }
    v_bar_thick = 0;
  }
  if (_get_hbar_visible() != False){
    if (_scr_area_h != _h - st2*2 - _bar_thick -_margin - _padding){
      _scr_area_h = _h - st2*2 - _bar_thick -_margin - _padding;
      _scr_area->setPropertyV(WSNheight,_scr_area_h);
      if (_virtual_scr != False){
        _scr_area->setPropertyV(WSNworkHeight,_scr_area_h);
      }
      _scr_area->setAbsoluteDraw(False); //resize clear bug fix
    }
  }else{
    if (_scr_area_h != _h - st2*2 - _padding){
      _scr_area_h = _h - st2*2 - _padding;
      _scr_area->setPropertyV(WSNheight,_scr_area_h);
      if (_virtual_scr != False){
        _scr_area->setPropertyV(WSNworkHeight,_scr_area_h);
      }
      _scr_area->setAbsoluteDraw(False); //resize clear bug fix
    }
    h_bar_thick = 0;
  }
  
}
long WSCscrForm::cdraw(){
  _scr_area->cdraw();
  return WSCform::cdraw();
}

long WSCscrForm::draw(){
  long _margin = _marginw;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    _margin = 0;
  }

  //ɽ°򸫤Ƥߤ
  if (getVisible() == False){
    return WS_NO_ERR;
  }

  if (_scr_area == NULL){
    //֥ȤνƤʤ
    return WS_NO_ERR;
  }

  //ץѥƥѹƤСߤ˳ƥѡĤοι
  if (isNeedUpdate() != False){
    _adjust();
  }
  if (_virtual_scr != False){
    WSClistData children = getChildren();
    long i;
    long num = children.getNum();
    for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getUseParentBaseDev() != False){
        continue;
      }
      if (child->getXOffsetPtr() == NULL){
        child->setXOffsetPtr(&_scr_offset_x);
        child->setYOffsetPtr(&_scr_offset_y);
        child->setAbsoluteDraw(True);
        child->needUpdate();
      }
    }
  }

  _adjust_scr_area();
  unsigned v_bar_thick = _bar_thick + _margin; 
  unsigned h_bar_thick = _bar_thick + _margin; 
  if (_get_vbar_visible() == False){
    v_bar_thick = 0;
  }
  if (_get_hbar_visible() == False){
    h_bar_thick = 0;
  }

  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  WSCushort w = _w;
  WSCushort h = _h;
  WSCushort shadow_thick = _shadow_thick;

  WSCbool absolute = getAbsoluteDraw(); 
  if (absolute == False  ){
#if 0
    if (getDotMode() == False){
      if ( dev->isExposed(0,0,w -v_bar_thick,shadow_thick) == False &&
           dev->isExposed(0,0,shadow_thick,h -h_bar_thick) == False &&
           dev->isExposed(w -v_bar_thick -shadow_thick,0,shadow_thick,h) == False &&
           dev->isExposed(0,h -h_bar_thick -shadow_thick,w,shadow_thick) == False ){
        return WS_NO_ERR;
      }
    }else{
#endif
      if ( dev->isExposed(0,0,w,h) == False ){
        return WS_NO_ERR;
      }
#if 0
    }
#endif
  }
  if (_geometry_changed != False || _update_work_area != False){
    _exec_child_adjust_for_anchors();
  }

  if (WSGIappDev()->getExtGuiPolicySelected() != False){
    if (_ext_draw_proc == NULL){
      _ext_draw_proc = (void(*)(void*))WSGIappDev()->
                               getExtGuiPolicyProc("WSCscrForm::draw");
    }
    if (_ext_draw_proc != NULL){
      WSCscrForm_draw_struct st;
      st._this = this;
      st.dev = dev;
      st.x = _x;
      st.y = _y;
      st.width = _w;
      st.height = _h;
      st.shadow_thickness = _shadow_thick;
      st.shadow_type = _shadow_type;
      st.fore_color = _fore_color;
      st.back_color = _back_color;
      st.top_shadow_color = _ts_color;
      st.bottom_shadow_color = _bs_color;
      st.work_back_color = _work_back_color;
      st.back_pixmap = _bp_color;
      st.gradation = _grad_no;
      st.gradation_margin = _grad_margin;
      st.bar_thickness = _bar_thick;
      st.margin_width = _marginw;
      st.padding = _padding;
      st.frame = _frame;
      st.vbar_visible = _get_vbar_visible();
      st.hbar_visible = _get_hbar_visible();
      _ext_draw_proc(&st);
      return WS_NO_ERR;
    }
  }

  long err = dev->beginDraw(0,0,w,h,True);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }
  if ( shadow_thick > 0){
#if 0
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      WSGFdrawShadow(dev,_shadow_type, shadow_thick, _fore_color,
                   _ts_color,_bs_color,_back_color,
                   0,0,w - v_bar_thick,h - h_bar_thick);
    }else
#endif
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      WSGFdrawShadow(dev,_shadow_type, shadow_thick, _fore_color,
                   _ts_color,_bs_color,_back_color,
                   0,0,w,h);
    }
  }
  dev->endDraw();

  long err2 = dev->beginDraw(0,0,w,h,absolute);
  if (err2 != WS_NO_ERR){
    return WS_NO_ERR;
  }

  WSCbase::update();
  setAbsoluteDraw(False);
  if (_bp_color == -1){
    dev->setForeColor(_back_color);
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      dev->drawFillRect(_w - _shadow_thick - v_bar_thick,
                        _h - _shadow_thick - h_bar_thick,
                        v_bar_thick,
                        h_bar_thick);
    }else{
      dev->drawFillRect(0,0,_w,_h);
    }
  }
  if ( shadow_thick > 0){
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      WSGFdrawShadow(dev,_shadow_type, shadow_thick, _fore_color,
                   _ts_color,_bs_color,_back_color,
                   0,0,w - v_bar_thick,h - h_bar_thick);
#if 0
    }else
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      WSGFdrawShadow(dev,_shadow_type, shadow_thick, _fore_color,
                   _ts_color,_bs_color,_back_color,
                   0,0,w,h);
#endif
    }
  }

  dev->setForeColor(_work_back_color);
  dev->drawFillRect(_shadow_thick,_shadow_thick,
         w - v_bar_thick - _shadow_thick*2,
         h - h_bar_thick - _shadow_thick*2);
  dev->endDraw();
  return WS_NO_ERR;

}

WSCushort WSCscrForm::_get_shift_width(){
  long _margin = _marginw;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    _margin = 0;
  }
  return _work_width + _shadow_thick*2 + _bar_thick -_margin - _w;
}

WSCushort WSCscrForm::_get_shift_height(){
  long _margin = _marginw;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    _margin = 0;
  }
  return _work_height + _shadow_thick*2 + _bar_thick -_margin - _h;
}

void WSCscrForm::onParentVisibleChange(WSCbool fl){
  WSCform::onParentVisibleChange(fl);
  setPropertyV(WSNhbarValue,_wx_pos);
  setPropertyV(WSNvbarValue,_wy_pos);
}


WSCbool WSCscrForm::_get_hbar_visible(){
  if (_hbar_visible == False){
    return False;
  }

  if (_work_width > _w - _shadow_thick*2){
    return True;
  }

  WSCbool vvis = False;
  long _margin = _marginw;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    _margin = 0;
  }


  if (_vbar_visible == True && _work_height > _h - _shadow_thick*2 - _padding){
    vvis = True;
  }

  if (vvis == True){
    if (_work_width > _w - _shadow_thick*2 - _bar_thick -_margin){
      return True;
    }
  }
  return False;
}

WSCbool WSCscrForm::_get_vbar_visible(){
  if (_vbar_visible == False){
    return False;
  }

  if (_work_height > _h - _shadow_thick*2 - _padding){
    return True;
  }

  WSCbool hvis = False;

  long _margin = _marginw;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    _margin = 0;
  }

  if (_hbar_visible == True && _work_width > _w - _shadow_thick*2){
    hvis = True;
  }
  if (hvis == True){
    if (_work_height > _h - _shadow_thick*2 - _bar_thick -_margin){
      return True;
    }
  }

  return False;
}

long WSCscrForm::setPropertyEditMode(WSCbool fl){
  long ret = WSCbase::setPropertyEditMode(fl);
  if (_scr_area != NULL){
//    _scr_area->setDotMode(fl);
    _scr_area->setPropertyEditMode(fl);
  }
  return ret;
}

long WSCscrForm::getVisibleWidth(){
      return _scr_area_w;
}

long WSCscrForm::getVisibleHeight(){
      return _scr_area_h;
}

void WSCscrForm::_ha_scr_work_op(WSCbase* obj){
  WSCbase* parent = obj->getParent();
  WSCscrForm* scr = (WSCscrForm*)parent->cast("WSCscrForm");
//  scr->execEventProc(WSEV_ACTIVATE,NULL);
  scr->onActivate();
} 
void WSCscrForm::onActivate(){
  execProcedure(WSEV_ACTIVATE);
}
void WSCscrForm::_adjust_children(){
  WSClistData children = getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getObjectType() & WS_TYPE_MANAGER){
      if (child != _scr_area){
        child->setAbsoluteDraw(True);
        child->needUpdate();
      }
    }
  }
}
void WSCscrForm::_h_scr_work_op(WSCbase* obj){
  WSCbase* parent = obj->getParent();
  WSCscrForm* scr = (WSCscrForm*)parent->cast("WSCscrForm");
  WSCvscrBar* bar = (WSCvscrBar*)obj->cast("WSCvscrBar");
  WSCulong val;
  WSCushort sld_width;
  WSCushort current;
  sld_width = scr->getProperty(WSNscrollWidth);
  scr->_scr_area->getPropertyV(WSNhbarValue,&current);

  obj->getPropertyV(WSNvalue,&val);
 
  if (val == 0 || current - val > sld_width ||
                  val - current > sld_width ||
                  bar->getMaxSlideValue() <= val){
    if ( bar->getMaxSlideValue() <= val){
      val = bar->getMaxSlideValue();
    }else{
      val -= val % sld_width;
    }
    if ( scr->_wx_pos != val){
      scr->_wx_pos = val;
      scr->_scr_offset_x = -val;
      if (scr->_no_scroll == False){
        if (scr->_virtual_scr == False){
          scr->_scr_area->setHbarValue(val); 
        }else{
          scr->_adjust_children();
//        scr->_scr_area->redraw();
          scr->_redraw_scr();
        }
      }else{
        scr->_adjust_no_scroll();
      }
//      scr->execEventProc(WSEV_VALUE_CH,NULL);
      scr->onValueChange();
    }
  }
}
void WSCscrForm::onValueChange(){
  execProcedure(WSEV_VALUE_CH);
}
void WSCscrForm::_va_scr_work_op(WSCbase* obj){
  WSCbase* parent = obj->getParent();
  WSCscrForm* scr = (WSCscrForm*)parent->cast("WSCscrForm");
//  scr->execEventProc(WSEV_ACTIVATE,NULL);
  scr->onActivate();
}

void WSCscrForm::_v_scr_work_op(WSCbase* obj){
  WSCbase* parent = obj->getParent();
  WSCscrForm* scr = (WSCscrForm*)parent->cast("WSCscrForm");
  WSCvscrBar* bar = (WSCvscrBar*)obj->cast("WSCvscrBar");
  WSCulong val;
  WSCushort sld_width;
  WSCushort current;
  sld_width = scr->getProperty(WSNscrollHeight);
  scr->_scr_area->getPropertyV(WSNvbarValue,&current);
  obj->getPropertyV(WSNvalue,&val);
  if (val == 0 || (long)((long)current - (long)val) > (long)sld_width ||
                  (long)((long)val - (long)current) > sld_width ||
                  bar->getMaxSlideValue() <= val){
    if ( bar->getMaxSlideValue() <= val){
      val = bar->getMaxSlideValue();
    }else{
      val -= val % sld_width;
    }
    if ( scr->_wy_pos != val){
      scr->_wy_pos = val;
      scr->_scr_offset_y = -val;
      if (scr->_no_scroll == False){
        if (scr->_virtual_scr == False){
          scr->_scr_area->setVbarValue(val); 
        }else{
          scr->_adjust_children();
//        scr->_scr_area->redraw();
          scr->_redraw_scr();
        }
      }else{
        scr->_adjust_no_scroll();
      }
//      scr->execEventProc(WSEV_VALUE_CH,NULL);
      scr->onValueChange();
    }
  }
}

WSCbase* WSCscrForm::getScrFrame(){
  return _scr_area;
}
void WSCscrForm::onChildAdded(WSCbase* child){
  if (_virtual_scr != False){
    if (child->getUseParentBaseDev() == False){
      child->setXOffsetPtr(&_scr_offset_x);
      child->setYOffsetPtr(&_scr_offset_y);
      child->update();
    }
  }
}
static char* _scr_bar_cname = NULL;
void WSCscrForm::setUseScrBarClass(char* cname){
  if (_scr_bar_cname != NULL){
    delete _scr_bar_cname;
    _scr_bar_cname = NULL;
  }
  if (cname != NULL){
    _scr_bar_cname = WSGFstrdup(cname);
  }
}
char* WSCscrForm::getUseScrBarClass(){
  if (_scr_bar_cname == NULL){
    return "WSCvbscrBar";
  }
  return _scr_bar_cname;
}

void(*WSCscrForm::_ext_draw_proc)(void*) = NULL;
WSCstring WSCscrForm::_policy_name;

void WSCscrForm::onGuiPolicyChange(long policy){
  WSCbase::onGuiPolicyChange(policy);
  if (WSGIappDev()->getExtGuiPolicySelected() == False){
    _ext_draw_proc = NULL;
  }else{
    if (!strcmp((char*)_policy_name,(char*)WSGIappDev()->getExtGuiPolicyName())){
    }else{
      _ext_draw_proc = (void(*)(void*))WSGIappDev()->getExtGuiPolicyProc("WSCscrForm::draw");
    }
  }
  setAbsoluteDraw(True);
  draw();
}
void WSCscrForm::onMousePress(WSCpoint* pt){
  if (WSGIappMouse()->getTargetBtn() == WS_MOUSE_BTN4){
    if (getVisible() == False){
      return;
    }
    long val = _wy_pos - _page_increment;
    if (val < 0){
      setProperty(WSNvbarValue,0);
    }else{
      setProperty(WSNvbarValue,val);
    }
    return;
  }else
  if (WSGIappMouse()->getTargetBtn() == WS_MOUSE_BTN5){
    if (getVisible() == False){
      return;
    }
    long val = _wy_pos + _page_increment;
    long slidersize = _v_scr->getProperty(WSNsliderSize);
    long max = _v_scr->getProperty(WSNmaximum);
    if (val > max - slidersize){
      val = max - slidersize;
    }
    setProperty(WSNvbarValue,val);
    return;
  }

  WSGIappMouse()->setMouseFocusClient(this);
  WSCbase::onMousePress(pt);
}
void WSCscrForm::_scr_mouse_press(WSCbase* obj){
  WSCbase* parent = obj->getParent();
  WSCscrForm* scr = (WSCscrForm*)parent->cast("WSCscrForm");
  short x=0,y=0;
  obj->getMouseAddr(&x,&y);
  WSCpoint pt;
  pt.x = x;
  pt.y = y;
  scr->onScrMousePress(&pt);
}
void WSCscrForm::_scr_mouse_dclick(WSCbase* obj){
  WSCbase* parent = obj->getParent();
  WSCscrForm* scr = (WSCscrForm*)parent->cast("WSCscrForm");
  short x=0,y=0;
  obj->getMouseAddr(&x,&y);
  WSCpoint pt;
  pt.x = x;
  pt.y = y;
//printf("WSCscrForm::_scr_mouse_double_click %d,%d\n",x,y);
  scr->onScrMouseDoubleClick(&pt);
}



void WSCscrForm::_scr_mouse_release(WSCbase* obj){
  WSCbase* parent = obj->getParent();
  WSCscrForm* scr = (WSCscrForm*)parent->cast("WSCscrForm");
  short x=0,y=0;
  obj->getMouseAddr(&x,&y);
  WSCpoint pt;
  pt.x = x;
  pt.y = y;
  scr->onScrMouseRelease(&pt);
}
void WSCscrForm::_scr_mouse_move(WSCbase* obj){
  WSCbase* parent = obj->getParent();
  WSCscrForm* scr = (WSCscrForm*)parent->cast("WSCscrForm");
  short x=0,y=0;
  obj->getMouseAddr(&x,&y);
  WSCpoint pt;
  pt.x = x;
  pt.y = y;
  scr->onScrMouseMove(&pt);
}

void WSCscrForm::onScrMousePress(WSCpoint* pt){
  execProcedure(WSEV_SCR_MOUSE_PRESS);
}
void WSCscrForm::onScrMouseRelease(WSCpoint* pt){
  execProcedure(WSEV_SCR_MOUSE_RELEASE);
}
void WSCscrForm::onScrMouseMove(WSCpoint* pt){
  execProcedure(WSEV_SCR_MOUSE_MOVE);
}
void WSCscrForm::onScrMouseDoubleClick(WSCpoint* pt){
//printf("WSCscrForm::onScrMouseDoubleClick %s\n",getInstanceName());
  execProcedure(WSEV_SCR_MOUSE_DOUBLE_CLICK);
}
void WSCscrForm::_set_no_scroll(WSCbool fl){
  _no_scroll = fl;
  if (_scr_area != NULL){
    _scr_area->_set_no_scroll(fl);
  }
}
void WSCscrForm::_adjust_no_scroll(){
}
void WSCscrForm::_exec_child_adjust_for_anchors(){
  if (adjustAnchor() != False){
    if (_geometry_changed != False || _update_work_area != False){
      _update_work_area = False;
      WSClistData children = getChildren();
      long num = children.getNum();
      long i;
      for(i=0; i<num; i++){
        WSCbase* child = (WSCbase*)children[i];
//        if (child == _scr_area || child == _v_scr || child == _h_scr){
//          continue;
//        }
        child->_adjust_for_anchors(_work_width,_work_height);
        if (_pixmap_style == WS_DYNAMIC_PIXMAP){
          if (child->isNeedUpdate() != False){
            if ((long)child->getUserData("anchor update..") == 0){
              child->setUserData("anchor update..",(void*)1);
              child->update();
              child->setUserData("anchor update..",(void*)0);
            }
          }
        }
      }
    }
  }
}
long WSCscrForm::getObjectType(){
  return (WS_TYPE_MANAGER | WS_TYPE_FORM | WS_TYPE_SCR_FORM);
}   

