//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <windows.h>
#include <WScom.h>
#include <win/WSDwinfont.h>
#include <WSCfontSet.h>
#include <win/WSDwinappDev.h>

//#ifdef WS_EE
#define DEFAULT_FONT_SET  "15,0,0,0,400,0,0,0,1,3,2,1,1,Courier New"

char* dfnames[] = { 
"0,13,0,0,0,400,0,0,0,1,3,2,1,1,Courier New",
"1,15,0,0,0,400,0,0,0,1,3,2,1,1,Courier New",
"2,17,0,0,0,400,0,0,0,1,3,2,1,1,Courier New",
"3,19,0,0,0,400,0,0,0,1,3,2,1,1,Courier New",
"4,22,0,0,0,400,0,0,0,1,3,2,1,1,Courier New",
"5,24,0,0,0,400,0,0,0,1,3,2,1,1,Courier New",
"6,26,0,0,0,400,0,0,0,1,3,2,1,1,Courier New",
"7,34,0,0,0,400,0,0,0,1,3,2,1,1,Courier New",
"8,15,0,0,0,400,0,0,0,1,3,2,1,1,Courier New",
NULL
};
//#else
//#define DEFAULT_FONT_SET  "13,0,0,0,400,0,0,0,1,0,0,0,1,NULL"
////#define DEFAULT_FONT_SET  "13,0,0,0,400,0,0,0,1,3,2,1,1,NULL"
//char* dfnames[] = { 
//"0,13,0,0,0,400,0,0,0,1,0,0,0,1,NULL",
//"1,15,0,0,0,400,0,0,0,1,0,0,0,1,NULL",
//"2,17,0,0,0,400,0,0,0,1,0,0,0,1,NULL",
//"3,19,0,0,0,400,0,0,0,1,0,0,0,1,NULL",
//"4,22,0,0,0,400,0,0,0,1,0,0,0,1,NULL",
//"5,24,0,0,0,400,0,0,0,1,0,0,0,1,NULL",
//"6,26,0,0,0,400,0,0,0,1,0,0,0,1,NULL",
//"7,34,0,0,0,400,0,0,0,1,0,0,0,1,NULL",
//"8,13,0,0,0,400,0,0,0,1,0,0,0,1,NULL",
//NULL
//};
#define DEFAULT_FONT_SET_JP  "13,0,0,0,400,0,0,0,128,3,2,1,1,lr SVbN"

char* dfnames_jp[] = { 
"0,13,0,0,0,400,0,0,0,128,3,2,1,1,lr SVbN",
"1,15,0,0,0,400,0,0,0,128,3,2,1,1,lr SVbN",
"2,17,0,0,0,400,0,0,0,128,3,2,1,1,lr SVbN",
"3,19,0,0,0,400,0,0,0,128,3,2,1,1,lr SVbN",
"4,22,0,0,0,400,0,0,0,128,3,2,1,1,lr SVbN",
"5,24,0,0,0,400,0,0,0,128,3,2,1,1,lr SVbN",
"6,26,0,0,0,400,0,0,0,128,3,2,1,1,lr SVbN",
"7,34,0,0,0,400,0,0,0,128,3,2,1,1,lr SVbN",
"8,12,0,0,0,400,0,0,0,128,3,2,1,1,lr SVbN",
NULL
};
#define DEFAULT_FONT_SET_KR  "12,0,0,0,400,0,0,0,129,3,2,1,49,ü"

char* dfnames_kr[] = { 
"0,13,0,0,0,400,0,0,0,129,3,2,1,49,ü",
"1,15,0,0,0,400,0,0,0,129,3,2,1,49,ü",
"2,17,0,0,0,400,0,0,0,129,3,2,1,49,ü",
"3,19,0,0,0,400,0,0,0,129,3,2,1,49,ü",
"4,22,0,0,0,400,0,0,0,129,3,2,1,49,ü",
"5,24,0,0,0,400,0,0,0,129,3,2,1,49,ü",
"6,26,0,0,0,400,0,0,0,129,3,2,1,49,ü",
"7,34,0,0,0,400,0,0,0,129,3,2,1,49,ü",
"8,13,0,0,0,400,0,0,0,129,3,2,1,49,ü",
NULL
};

#define DEFAULT_FONT_SET_CN  "12,0,0,0,400,0,0,0,134,3,2,1,49,NSimSun"
char* dfnames_cn[] = { 
"0,13,0,0,0,400,0,0,0,134,3,2,1,49,NSimSun",
"1,15,0,0,0,400,0,0,0,134,3,2,1,49,NSimSun",
"2,17,0,0,0,400,0,0,0,134,3,2,1,49,NSimSun",
"3,19,0,0,0,400,0,0,0,134,3,2,1,49,NSimSun",
"4,22,0,0,0,400,0,0,0,134,3,2,1,49,NSimSun",
"5,24,0,0,0,400,0,0,0,134,3,2,1,49,NSimSun",
"6,26,0,0,0,400,0,0,0,134,3,2,1,49,NSimSun",
"7,34,0,0,0,400,0,0,0,134,3,2,1,49,NSimSun",
"8,13,0,0,0,400,0,0,0,134,3,2,1,49,NSimSun",
NULL
};



//#endif
WSMFclassInit(WSDwinfont,WSDfont);
WSDfont* _winfont_chandler(){
  WSDfont* font = new WSDwinfont();
  return font;
};
long _winfont_setup_handler(WSDfont* font,char* str){
  char tmp[2];
  tmp[0] = str[0];
  tmp[1] = 0;
  long no = atoi(tmp);
  font->setId(no);
  font->setFontName(&str[2]);
WSMFtrace("fontname%d=#%s# here1\n",no,font->getSrc());
  return WS_NO_ERR;
};

long _winfont_default_init_handler(WSCfontSet* fontset){
  long i=0;
  long lid = GetSystemDefaultLCID();
  if (getenv("LANG")!= NULL){
    if (!strcmp(getenv("LANG"),"ko")){
      lid = LANG_KOREAN;
    }
    if (!strcmp(getenv("LANG"),"zh")){
      lid = LANG_CHINESE | (SUBLANG_CHINESE_SIMPLIFIED << 10);
    }
  }
  while(dfnames[i]){
    WSDfont* font = new WSDwinfont();
    if ((lid & 0x3ff) == LANG_JAPANESE){
      _winfont_setup_handler(font,dfnames_jp[i]);
    }else if ((lid & 0x3ff) == LANG_KOREAN){
      _winfont_setup_handler(font,dfnames_kr[i]);
    }else if ((lid & 0x3ff) == LANG_CHINESE){
      if (SUBLANGID(lid) == SUBLANG_CHINESE_SIMPLIFIED){
        _winfont_setup_handler(font,dfnames_cn[i]);
      }
    }else{
      _winfont_setup_handler(font,dfnames[i]);
    }
    fontset->addFont(font);
    i++;
  }
  return WS_NO_ERR;
};

void _win_font_init(){
     WSGIappFontSet()->setCreateHandler(_winfont_chandler);
     WSGIappFontSet()->setSetupHandler(_winfont_setup_handler);
     WSGIappFontSet()->setDefaultInitializeHandler(_winfont_default_init_handler);
     WSGIappFontSet()->initializeDefault();
};

WSDwinfont::WSDwinfont(){
  _hfont = 0;
}

WSDwinfont::~WSDwinfont(){
  destroy();
}

long WSDwinfont::initialize(){
  char* fname = getSrc();
extern int XUGetLocale();
  long encode = XUGetLocale();
  if (fname == NULL || !strcmp(fname,"") ){
    fname = DEFAULT_FONT_SET;
//    long lid = GetSystemDefaultLCID();
//    if ((lid & 0x3ff) == LANG_JAPANESE){
//      fname = DEFAULT_FONT_SET_JP;
//    }
    if (encode = WS_EN_EUCJP){
      fname = DEFAULT_FONT_SET_JP;
    }else
    if (encode = WS_EN_SJIS){
      fname = DEFAULT_FONT_SET_JP;
    }else
    if (encode = WS_EN_EUCKR){
      fname = DEFAULT_FONT_SET_KR;
    }else
    if (encode = WS_EN_EUCCN){
      fname = DEFAULT_FONT_SET_CN;
    }
  }

  long e1,e2,e3,e4,e5,e6,e7,e8,e9,e10,e11,e12,e13;
  char fname1[LF_FACESIZE+1024];
  fname1[0] = 0;
  sscanf(fname,"%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%s",
       &e1, &e2, &e3, &e4, &e5, &e6, &e7, &e8, &e9, &e10, &e11,
       &e12, &e13, fname1);

  char dust[1024];
  if (_virtual_flag != False){
    char* fname2 = getFontName();
    sscanf(fname2,"%d %s",&e1,dust);
  }

WSMFtrace("font=#%s#\n",fname1);

  _lgfont.lfHeight = e1;
  _lgfont.lfWidth = e2;
  _lgfont.lfEscapement = e3;
  _lgfont.lfOrientation = e4;
  _lgfont.lfWeight = e5;
  _lgfont.lfItalic = e6;
  _lgfont.lfUnderline = e7;
  _lgfont.lfStrikeOut = e8;
  _lgfont.lfCharSet = e9;
  _lgfont.lfOutPrecision = e10;
  _lgfont.lfClipPrecision = e11;
  _lgfont.lfQuality = e12;
  _lgfont.lfPitchAndFamily = e13;
  if (!strcmp(fname1,"NULL")){
    fname1[0] = 0;
  }
  strcpy(_lgfont.lfFaceName,fname1);
  memcpy(&_lgfont2,&_lgfont,sizeof(LOGFONT));
#if 0
  if (getId() == 8){
    OSVERSIONINFO osvi;
    osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
    GetVersionEx(&osvi);
    if (osvi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS){
      long lid = GetSystemDefaultLCID();
      if ((lid & 0x3ff) == LANG_JAPANESE){
        _lgfont.lfCharSet = 128;
      }
    }
  }
#endif
  _hfont = CreateFontIndirect(&_lgfont);
  _hfont2 = 0;
  setValue1((long)_hfont);
  return WS_NO_ERR;
}


long WSDwinfont::destroy(){
  if (_hfont != 0){
    DeleteObject((void*)_hfont);
  }
  setValue1(-1);
  if (_hfont2 != 0){
    DeleteObject((void*)_hfont2);
  }
  return WS_NO_ERR;
}
long WSDwinfont::getStringWidthUCS2(WSCushort* str){
  if (_hfont == 0){
    initialize();
  }
  long len = WSGFstrlenUCS2(str);
  HWND wnd = WSGIwinAppDev()->getHWND();
  HDC hdc = GetDC(wnd);
  HFONT fbk = (HFONT)SelectObject(hdc,(void*)_hfont);
  SIZE size;
  GetTextExtentPoint32W(hdc,(WCHAR*)str,len,&size);
  SelectObject(hdc,(void*)fbk);
  ReleaseDC(wnd,hdc);
  return size.cx;
}
long WSDwinfont::getStringWidth(WSCstring* str){
  if (_hfont == 0){
    initialize();
  }
  HWND wnd = WSGIwinAppDev()->getHWND();
  HDC hdc = GetDC(wnd);
  HFONT fbk = (HFONT)SelectObject(hdc,(void*)_hfont);
  SIZE size;
  WCHAR* str2 = (WCHAR*)WSGFgetUCS2(str->getString(WS_EN_UTF8),WS_EN_UTF8);
  long len = WSGFstrlenUCS2((WSCushort*)str2);
  GetTextExtentPoint32W(hdc,str2,len,&size);
  delete str2;
  SelectObject(hdc,(void*)fbk);
  ReleaseDC(wnd,hdc);
  return size.cx;
}
long WSDwinfont::getStringHeightUCS2(WSCushort*){
  if (_hfont == 0){
    initialize();
  }
  return  _lgfont.lfHeight;
}
long WSDwinfont::getStringHeight(WSCstring*){
  if (_hfont == 0){
    initialize();
  }
  return  _lgfont.lfHeight;
}
LOGFONT* WSDwinfont::getLogFont(){
  return &_lgfont;
}
HFONT WSDwinfont::getScaledFont(double sx,double sy){
  if (_lgfont.lfWidth * sx != _lgfont2.lfWidth ||
      _lgfont.lfHeight * sy != _lgfont2.lfHeight){
    if (_hfont2 != 0){
      DeleteObject((void*)_hfont2);
      _hfont2 = 0;
    }
  }else{
    if (_hfont2 != 0){
      return _hfont2;
    }
  }
  _lgfont2.lfHeight = (DWORD)((double)_lgfont.lfHeight * sy);
  _lgfont2.lfWidth = (DWORD)((double)_lgfont.lfWidth * sx);
  _hfont2 = CreateFontIndirect(&_lgfont2);
  return _hfont2;
}

