//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCwizardDialog.h>
#include <WSCvifield.h>
#include <WSCform.h>
#include <WSCvtoggle.h>
#include <WSCvbtn.h>
#include <WSCoption.h>
#include <WSCfileSelect.h>
#include <WSDfileSystem.h>
#include <WSCmessageDialog.h>
#include <WSClocaleSet.h>
#include <advance/WSCprojectEditor.h>

extern WSCprojectEditor* pe;
extern WSCmessageDialog* message;
extern WSCwizardDialog* newprj;
WSCvifield* npif1;
WSCvifield* npif2;
//WSCvtoggle* nptgl21;
//WSCvtoggle* nptgl22;
WSCoption* npopt1;
WSCoption* opt31;
WSCoption* opt32;

static void opbtn1(WSCbase*){
  newprj->setPropertyV(WSNmodal,(WSCbool)False);
  WSCfileSelect* fs = WSGIappFileSelect();
  fs->setProperty(WSNselectDir,True);
  fs->setProperty(WSNmodal,True);
  long ret = fs->popup();
  fs->setProperty(WSNmodal,False);
  fs->setProperty(WSNselectDir,False);
  if (ret == WS_DIALOG_OK){
    WSCstring str;
    str = fs->getProperty(WSNdirName);
    npif2->setProperty(WSNlabelString,str);
  }
  newprj->setPropertyV(WSNmodal,(WSCbool)True);
}

static void visop(WSCbase*){
  if (newprj->getVisible() != False){
    newprj->setPropertyV(WSNvalue,(WSCuchar)0);
    npif1->setPropertyV(WSNlabelString,"newproject");
#ifdef MSW
    npif2->setPropertyV(WSNlabelString,
                        WSGIappFileSystem()->adjustFileName("$(WSDIR)"));
#else
    npif2->setPropertyV(WSNlabelString,".");
#endif
//    nptgl21->setStatus(1);
    npopt1->setProperty(WSNvalue,0);
  }else{
    if (newprj->getStatus() == WS_DIALOG_DONE){
//    do something...
    }
  }
}

void create_newprj_dialog(){

  newprj = new WSCwizardDialog(NULL,"newprj");
  newprj->initialize();
  WSGFsetGeometry(newprj,300,300,500,120);
  newprj->setPropertyV(WSNtitleString,WSGFgettext("T4:WSSTR New project"));
  newprj->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi39.xpm");
  newprj->setPropertyV(WSNlabelString,WSGFgettext("U4:WSSTR < Back,Next >,Finish"));
  newprj->setPropertyV(WSNmenuItems,(WSCuchar)3);
  newprj->setPropertyV(WSNmodal,(WSCbool)True);
  WSCprocedure* op1 = new WSCprocedure("visop",WSEV_VISIBLE_CH);
  op1->setFunction(visop,"visop");
  newprj->addProcedure(op1);

  WSCvlabel* sp1 = new WSCvlabel(newprj,"sp1");
  sp1->initialize();
  WSGFsetGeometry(sp1,0,5,1280,2);
  sp1->setPropertyV(WSNuserValue,(long)1);
  sp1->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  sp1->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  sp1->setVisible(True);

  WSCvlabel* lb11 = new WSCvlabel(newprj,"lb11");
  lb11->initialize();
  WSGFsetGeometry(lb11,5,12,120,20);
  lb11->setPropertyV(WSNlabelString,WSGFgettext("V4:WSSTR Project name"));
  lb11->setPropertyV(WSNuserValue,(long)1);
  WSGFsetMargin(lb11,0);
  lb11->setVisible(True); 

  npif1 = new  WSCvifield(newprj,"nmif1");
  npif1->initialize();
  npif1->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  npif1->setPropertyV(WSNshadowType,(char)1);
  npif1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  npif1->setPropertyV(WSNmaxLength,(WSCushort)16);
  npif1->setPropertyV(WSNuserValue,(long)1);
  WSGFsetGeometry(npif1,130,12,360,20);

  WSCvlabel* lb12 = new WSCvlabel(newprj,"lb12");
  lb12->initialize();
  WSGFsetGeometry(lb12,5,37,120,20);
  lb12->setPropertyV(WSNlabelString,WSGFgettext("W4:WSSTR Working dir"));
  lb12->setPropertyV(WSNuserValue,(long)1);
  WSGFsetMargin(lb12,0);
  lb12->setVisible(True); 

  npif2 = new  WSCvifield(newprj,"nmif2");
  npif2->initialize();
  npif2->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  npif2->setPropertyV(WSNshadowType,(char)1);
  npif2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  npif2->setPropertyV(WSNmaxLength,(WSCushort)0);
  npif2->setPropertyV(WSNuserValue,(long)1);
  WSGFsetGeometry(npif2,130,37,335,20);

  WSCvbtn* npbtn1 = new  WSCvbtn(newprj,"nmbtn1");
  npbtn1->initialize();
  npbtn1->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  npbtn1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  npbtn1->setPropertyV(WSNuserValue,(long)1);
  npbtn1->setPropertyV(WSNlabelString,"..");
  WSGFsetGeometry(npbtn1,470,37,20,20);
  WSCprocedure* opbt1 = new WSCprocedure("opbtn1",WSEV_ACTIVATE);
  opbt1->setFunction(opbtn1,"opbtn1");
  npbtn1->addProcedure(opbt1);

  //page2
  WSCvlabel* sp2 = new WSCvlabel(newprj,"sp2");
  sp2->initialize();
  WSGFsetGeometry(sp2,0,5,1280,2);
  sp2->setPropertyV(WSNuserValue,(long)2);
  sp2->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  sp2->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  sp2->setVisible(True);

  WSCvlabel* lb21 = new WSCvlabel(newprj,"lb21");
  lb21->initialize();
  WSGFsetGeometry(lb21,5,12,120,20);
  lb21->setPropertyV(WSNlabelString,WSGFgettext("X4:WSSTR Project type"));
  lb21->setPropertyV(WSNuserValue,(long)2);
  WSGFsetMargin(lb21,0);
  lb21->setVisible(True);

#if 0
  nptgl21 = new  WSCvtoggle(newprj,"tgl21");
  nptgl21->initialize();
  nptgl21->setPropertyV(WSNindicatorSize,(WSCuchar)16);
  nptgl21->setPropertyV(WSNindicatorShadow,(WSCuchar)0);
  nptgl21->setPropertyV(WSNindicatorPixmap,"$(WSDIR)/sys/pixmaps/tbl1.xpm");
  nptgl21->setPropertyV(WSNselectPixmap,"$(WSDIR)/sys/pixmaps/tbl2.xpm");
  nptgl21->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  nptgl21->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  nptgl21->setPropertyV(WSNlabelString,WSGFgettext("Y4:WSSTR  Normal application"));
  nptgl21->setPropertyV(WSNalignmentH,(WSCuchar)0);
  nptgl21->setPropertyV(WSNunique,(WSCbool)True);
  nptgl21->setPropertyV(WSNgroup,"nptgl");
  nptgl21->setPropertyV(WSNuserValue,(long)2);
  WSGFsetGeometry(nptgl21,130,10,260,26);
  nptgl21->setVisible(True);

  nptgl22 = new  WSCvtoggle(newprj,"nptgl22");
  nptgl22->initialize();
  nptgl22->setPropertyV(WSNindicatorSize,(WSCuchar)16);
  nptgl22->setPropertyV(WSNindicatorShadow,(WSCuchar)0);
  nptgl22->setPropertyV(WSNindicatorPixmap,"$(WSDIR)/sys/pixmaps/tbl1.xpm");
  nptgl22->setPropertyV(WSNselectPixmap,"$(WSDIR)/sys/pixmaps/tbl2.xpm");
  nptgl22->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  nptgl22->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  nptgl22->setPropertyV(WSNlabelString,WSGFgettext("Z4:WSSTR  Class library component"));
  nptgl22->setPropertyV(WSNalignmentH,(WSCuchar)0);
  nptgl22->setPropertyV(WSNunique,(WSCbool)True);
  nptgl22->setPropertyV(WSNgroup,"nptgl");
  nptgl22->setPropertyV(WSNuserValue,(long)2);
  WSGFsetGeometry(nptgl22,130,37,260,26);
  nptgl22->setVisible(True);
#endif

  npopt1 = new WSCoption(newprj,"opt31");
  npopt1->initialize();
  WSGFsetGeometry(npopt1,130,12,360,20);
  npopt1->setPropertyV(WSNuserValue,(long)2);
  npopt1->setProperty(WSNshadowThickness,1);

  WSCstring ltype_file;
  ltype_file << "$(WSDIR)/sys/data/linkoptions";

  WSCstring* ltype = WSGFreadTextFile(ltype_file,
      WSGIappLocaleSet()->getSystemLocaleEncoding());
  WSCstring ltype_menu;
  if (ltype != NULL){
    WSCstring line = ltype->gets();
    WSCstring lname = line.getWord(0,":");
    WSCstring lval = line.getWord(1,":");
    ltype_menu << lname << ":" << lval << ":";
    while(!ltype->eof()){
      ltype_menu << ",";
      WSCstring line = ltype->gets();
      WSCstring lname = line.getWord(0,":");
      WSCstring lval = line.getWord(1,":");
      ltype_menu << lname << ":" << lval << ":";
    }
    delete ltype;
    npopt1->setProperty(WSNmenuItems,ltype_menu);
    npopt1->setProperty(WSNvalue,0);
//    pe->setEncodingMenu(locale_menu,default_val);
  }else{
    WSCstring msg;
    msg << WSGFgettext("Z4:WSSTR Can not read file:")
        << ltype_file
        << WSGFgettext("a4:WSSTR .");
       
    message->setProperty(WSNwidth,550);
    message->setProperty(WSNlabelString,msg);
    message->popup();
  }
  npopt1->setVisible(True);


  WSCvlabel* lb31 = new WSCvlabel(newprj,"lb21");
  lb31->initialize();
  WSGFsetGeometry(lb31,5,12,120,20);

  lb31->setPropertyV(WSNlabelString,WSGFgettext("Y4:WSSTR Locale type"));

  lb31->setPropertyV(WSNuserValue,(long)3);
  WSGFsetMargin(lb31,0);
  lb31->setVisible(True);

  opt31 = new WSCoption(newprj,"opt31");
  opt31->initialize();
  WSGFsetGeometry(opt31,130,12,360,20);
  opt31->setPropertyV(WSNuserValue,(long)3);
  opt31->setProperty(WSNshadowThickness,1);

  WSCstring locales_file;
  locales_file << "$(WSDIR)/sys/data/"
               << WSGIappLocaleSet()->getDefaultLocaleName()
               << "/locales";

  WSCstring* locales = WSGFreadTextFile(locales_file,
      WSGIappLocaleSet()->getSystemLocaleEncoding());
  WSCstring locale_menu;
  if (locales != NULL){
    WSCstring line = locales->gets();
    WSCstring line2 = locales->gets();
    long default_val = (long)WSGFstrdup((char*)line2);
    locale_menu << line << ":" << WSGFltoa(default_val) << ":";
    while(!locales->eof()){
      locale_menu << ",";
      WSCstring line = locales->gets();
      WSCstring line2 = locales->gets();
      locale_menu << line << ":" << WSGFltoa((long)WSGFstrdup(line2)) << ":";
    }
    delete locales;
    opt31->setProperty(WSNmenuItems,locale_menu);
    opt31->setProperty(WSNvalue,default_val);
    pe->setEncodingMenu(locale_menu,default_val);
  }else{
    WSCstring msg;
    msg << WSGFgettext("Z4:WSSTR Can not read file:")
        << locales_file
        << WSGFgettext("a4:WSSTR .");
       
    message->setProperty(WSNwidth,550);
    message->setProperty(WSNlabelString,msg);
    message->popup();
  }
  opt31->setVisible(True);

  WSCvlabel* lb32 = new WSCvlabel(newprj,"lb32");
  lb32->initialize();
  WSGFsetGeometry(lb32,5,42,120,20);

  lb32->setPropertyV(WSNlabelString,WSGFgettext("Y4:WSSTR Language"));

  lb32->setPropertyV(WSNuserValue,(long)3);
  WSGFsetMargin(lb32,0);
  lb32->setVisible(True);

  opt32 = new WSCoption(newprj,"opt32");
  opt32->initialize();
  WSGFsetGeometry(opt32,130,42,360,20);
  opt32->setPropertyV(WSNuserValue,(long)3);
  opt32->setProperty(WSNshadowThickness,1);
  opt32->setProperty(WSNmenuItems,"C/C++:0,Ruby:1,Python:2,Perl:3");

  opt32->setVisible(True);


}
