//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCWINDOW_H
#define WSCWINDOW_H

#include <WScom.h>
#include <WSCbase.h>
#include <WSClistData.h>

#define WSCwindow_VER  1000
#define WSEV_EXIT      32

class WSCwindow  :public WSCbase{

  protected:
    char*      _title_string;
    char*      _user_string;
    char*      _group_name;
    WSClistData _children;
    long       _user_value;
    short      _x;
    short      _y;
    WSCushort  _w;
    WSCushort  _h;
    short      _fg_no;
    short      _bg_no;
    short      _ts_no;
    short      _bs_no;
    short      _bp_no;
    short      _a1_color;
    short      _a2_color;
    short      _a3_color;
    WSCushort  _mouse_no;
    WSCushort  _margin_left;
    WSCuchar   _grad_no;
    WSCuchar   _grad_margin;
    WSCuchar   _bar_thick;
    unsigned   _shadow_thick:4;
    signed      _title_bar:4;
    signed     _shadow_type:4;
    unsigned   _unique:1;
    unsigned   _pixmap_style:2;
    unsigned   _exit:1;
    unsigned   _margin:4;
    unsigned   _update_resize:1;
    unsigned   _indicator:1;
    unsigned   _emboss:1;
    unsigned   _vis_ch_sequence:1;

    WSMFpropertyDef(WSNname,char*,     _instance_name); 
    WSMFpropertyDef(WSNtitleString,char*,     _title_string); 
    WSMFpropertyDef(WSNuserString, char*,     _user_string ); 
    WSMFpropertyDef(WSNuserValue,  long,      _user_value  ); 
    WSMFpropertyDef(WSNx,      short,     _x           );
    WSMFpropertyDef(WSNy,        short,     _y           );
    WSMFpropertyDef(WSNwidth,     WSCushort, _w           );
    WSMFpropertyDef(WSNheight,       WSCushort, _h           );
    WSMFpropertyDef(WSNshadowThickness, WSCuchar, _shadow_thick);
    WSMFpropertyDef(WSNforeColor,  short,      _fg_no );
    WSMFpropertyDef(WSNbackColor,   short,     _bg_no );
    WSMFpropertyDef(WSNtopShadowColor,  short, _ts_no );
    WSMFpropertyDef(WSNbottomShadowColor,short,_bs_no );
    WSMFpropertyDef(WSNbackPixmap,  short,     _bp_no       );
    WSMFpropertyDef(WSNtitleBar,   char,      _title_bar   );
    WSMFpropertyDef(WSNshadowType, char,      _shadow_type );
    WSMFpropertyDef(WSNvis,        WSCbool,   _vis     );
    WSMFpropertyDef(WSNdet,        WSCbool,   _sensitive      );
    WSMFpropertyDef(WSNpixmapStyle,WSCuchar,  _pixmap_style);
    WSMFpropertyDef(WSNgroup,   char*,     _group_name  ); 
    WSMFpropertyDef(WSNunique,  WSCbool,   _unique      ); 
    WSMFpropertyDef(WSNmouse,   WSCushort,  _mouse_no    ); 
    WSMFpropertyDef(WSNgradation,   WSCuchar,  _grad_no    );
    WSMFpropertyDef(WSNgradationMargin,   WSCuchar,  _grad_margin    );
    WSMFpropertyDef(WSNexit,   WSCbool,  _exit    );
    WSMFpropertyDef(WSNindicatorOn,   WSCbool,  _indicator    );
    WSMFpropertyDef(WSNmargin,   WSCuchar,  _margin    );
    WSMFpropertyDef(WSNmarginLeft,   WSCushort,  _margin_left    );
    WSMFpropertyDef(WSNbarThickness,   WSCuchar,  _bar_thick    );
    WSMFpropertyDef(WSNemboss,   WSCbool,  _emboss    );
    WSMFpropertyDef(WSNexport,   WSCbool,  _export_    );

    void _exec_child_adjust_for_anchors();

    virtual long _device_initialize();

    static WSClistData*  _workwindow_list;
    static WSClistData*  getWorkWindowList();
    static void (*_exit_handler)();
    static void _delay_visible(unsigned char,void*);
  public:
    WSCwindow(WSCbase*,char*);
    virtual ~WSCwindow();
    virtual long initialize();
    virtual long execEventProc(long ev,void*);

    virtual void onVisibleChange(WSCbool);
    virtual void onResize(WSCrect*);
    virtual void onParentVisibleChange(WSCbool);
    virtual void onFocusChange(WSCbool);
    virtual void onEditModeChange(WSCbool);
    virtual void onDefaultColorChange();

    virtual long draw();
    virtual long clear();
    virtual long redraw();
    virtual long cdraw();
    virtual void update();

    long setMapStatus(long);

    virtual long getObjectType();
    virtual WSClistData& getChildren();
    virtual void setChildren(WSClistData&);
    virtual void adjustForm();
    virtual void setVisible(WSCbool);
    virtual void internalUpdate();

    void execResizeEvent();

static void setGlobalExitHandler(void(*)());

    long setWindowStatus(long status);
    long getWindowStatus();
    long getPixmapStyle();
    WSMFguiClassDef(WSCwindow,WSCbase);
    WSMFsetUseDevice(windowDev);
    WSMFversionDef(WSCwindow);
};
extern WSDLEX long          WSGFsetActiveWindow(WSCbase*);
extern WSDLEX WSCbase*      WSGFgetActiveWindow();
extern WSDLEX WSCbase*      WSGFgetPreActiveWindow();
#endif
