//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSKEYSYM_H
#define WSKEYSYM_H

//-----------------------------------------------------------------------------
#if !defined MSW  && !defined BTRON //UNIX - Xwindow System
//-----------------------------------------------------------------------------
#include <X11/keysym.h>
#define WSK_BackSpace   XK_BackSpace
#define WSK_Tab         XK_Tab
#define WSK_Linefeed    XK_Linefeed
#define WSK_Clear       XK_Clear
#define WSK_Return      XK_Return
#define WSK_Pause       XK_Pause
#define WSK_Scroll_Lock XK_Scroll_Lock
#define WSK_Sys_Req     XK_Sys_Req
#define WSK_Escape      XK_Escape
#define WSK_Delete      XK_Delete

#define WSK_Kanji             XK_Kanji
#define WSK_Muhenkan          XK_Muhenkan
#define WSK_Henkan_Mode       XK_Henkan_Mode
#define WSK_Henkan            XK_Henkan
#define WSK_Romaji            XK_Romaji
#define WSK_Hiragana          XK_Hiragana
#define WSK_Katakana          XK_Katakana
#define WSK_Hiragana_Katakana XK_Hiragana_Katakana
#define WSK_Zenkaku           XK_Zenkaku
#define WSK_Hankaku           XK_Hankaku
#define WSK_Zenkaku_Hankaku   XK_Zenkaku_Hankaku
#define WSK_Touroku           XK_Touroku
#define WSK_Massyo            XK_Massyo
#define WSK_Kana_Lock         XK_Kana_Lock
#define WSK_Kana_Shift        XK_Kana_Shift
#define WSK_Eisu_Shift        XK_Eisu_Shift
#define WSK_Eisu_toggle       XK_Eisu_toggle

#define WSK_Home              XK_Home
#define WSK_Left              XK_Left
#define WSK_Up                XK_Up
#define WSK_Right             XK_Right
#define WSK_Down              XK_Down
#define WSK_Prior             XK_Prior
#define WSK_Page_Up           XK_Page_Up
//#define WSK_Next              0xFF56
#define WSK_Page_Down         XK_Page_Down
#define WSK_End               XK_End
//#define WSK_Begin             0xFF58 //


//#define WSK_Select        0xFF60
#define WSK_Print         XK_Print
#define WSK_Execute       XK_Execute
#define WSK_Insert        XK_Insert
//#define WSK_Undo          0xFF65 /* Undo, oops */
//#define WSK_Redo          0xFF66 /* redo, again */
//#define WSK_Menu          0xFF67 //
//#define WSK_Find          0xFF68 //
#define WSK_Cancel        XK_Cancel
#define WSK_Help          XK_Help
#define WSK_Break         XK_Break
//#define WSK_Mode_switch   0xFF7E //
//#define WSK_script_switch 0xFF7E //
#define WSK_Num_Lock      XK_Num_Lock

/* Keypad Functions, keypad numbers cleverly chosen to map to ascii */
#define WSK_KP_Space     XK_KP_Space
#define WSK_KP_Tab       XK_KP_Tab
#define WSK_KP_Enter     XK_KP_Enter
#define WSK_KP_F1        XK_KP_F1
#define WSK_KP_F2        XK_KP_F2
#define WSK_KP_F3        XK_KP_F3
#define WSK_KP_F4        XK_KP_F4
#define WSK_KP_Home      XK_KP_Home
#define WSK_KP_Left      XK_KP_Left
#define WSK_KP_Up        XK_KP_Up
#define WSK_KP_Right     XK_KP_Right
#define WSK_KP_Down      XK_KP_Down
#define WSK_KP_Prior     XK_KP_Prior
#define WSK_KP_Page_Up   XK_KP_Page_Up
#define WSK_KP_Next      XK_KP_Next
#define WSK_KP_Page_Down XK_KP_Page_Down
#define WSK_KP_End       XK_KP_End
#define WSK_KP_Begin     XK_KP_Begin
#define WSK_KP_Insert    XK_KP_Insert
#define WSK_KP_Delete    XK_KP_Delete
#define WSK_KP_Equal     XK_KP_Equal
#define WSK_KP_Multiply  XK_KP_Multiply
#define WSK_KP_Add       XK_KP_Add
#define WSK_KP_Separator XK_KP_Separator
#define WSK_KP_Subtract  XK_KP_Subtract
#define WSK_KP_Decimal   XK_KP_Decimal
#define WSK_KP_Divide    XK_KP_Divide

#define WSK_KP_0   XK_KP_0
#define WSK_KP_1   XK_KP_1
#define WSK_KP_2   XK_KP_2
#define WSK_KP_3   XK_KP_3
#define WSK_KP_4   XK_KP_4
#define WSK_KP_5   XK_KP_5
#define WSK_KP_6   XK_KP_6
#define WSK_KP_7   XK_KP_7
#define WSK_KP_8   XK_KP_8
#define WSK_KP_9   XK_KP_9

#define WSK_F1   XK_F1
#define WSK_F2   XK_F2
#define WSK_F3   XK_F3
#define WSK_F4   XK_F4
#define WSK_F5   XK_F5
#define WSK_F6   XK_F6
#define WSK_F7   XK_F7
#define WSK_F8   XK_F8
#define WSK_F9   XK_F9
#define WSK_F10  XK_F10
#define WSK_F11  XK_F11
#define WSK_L1   XK_L1
#define WSK_F12  XK_F12
#define WSK_L2   XK_L2
#define WSK_F13  XK_F13
#define WSK_L3   XK_L3
#define WSK_F14  XK_F14
#define WSK_L4   XK_L4
#define WSK_F15  XK_F15
#define WSK_L5   XK_L5
#define WSK_F16  XK_F16
#define WSK_L6   XK_L6
#define WSK_F17  XK_F17
#define WSK_L7   XK_L7
#define WSK_F18  XK_F18
#define WSK_L8   XK_L8
#define WSK_F19  XK_F19
#define WSK_L9   XK_L9
#define WSK_F20  XK_F20
#define WSK_L10  XK_L10
#define WSK_F21  XK_F21
#define WSK_R1   XK_R1
#define WSK_F22  XK_F22
#define WSK_R2   XK_R2
#define WSK_F23  XK_F23
#define WSK_R3   XK_R3
#define WSK_F24  XK_F24
#define WSK_R4   XK_R4
#define WSK_F25  XK_F25
#define WSK_R5   XK_R5
#define WSK_F26  XK_F26
#define WSK_R6   XK_R6
#define WSK_F27  XK_F27
#define WSK_R7   XK_R7
#define WSK_F28  XK_F28
#define WSK_R8   XK_R8
#define WSK_F29  XK_F29
#define WSK_R9   XK_R9
#define WSK_F30  XK_F30
#define WSK_R10  XK_R10
#define WSK_F31  XK_F31
#define WSK_R11  XK_R11
#define WSK_F32  XK_F32
#define WSK_R12  XK_R12
#define WSK_F33  XK_F33
#define WSK_R13  XK_R13
#define WSK_F34  XK_F34
#define WSK_R14  XK_R14
#define WSK_F35  XK_F35
#define WSK_R15  XK_R15

#define WSK_Shift_L    XK_Shift_L
#define WSK_Shift_R    XK_Shift_R
#define WSK_Control_L  XK_Control_L
#define WSK_Control_R  XK_Control_R
#define WSK_Caps_Lock  XK_Caps_Lock
#define WSK_Shift_Lock XK_Shift_Lock

#define WSK_Meta_L   XK_Meta_L
#define WSK_Meta_R   XK_Meta_R
#define WSK_Alt_L    XK_Alt_L
#define WSK_Alt_R    XK_Alt_R
#define WSK_Super_L  XK_Super_L
#define WSK_Super_R  XK_Super_R
#define WSK_Hyper_L  XK_Hyper_L
#define WSK_Hyper_R  XK_Hyper_R

#define WSK_space               XK_space
#define WSK_exclam              XK_exclam
#define WSK_quotedbl            XK_quotedbl
#define WSK_numbersign          XK_numbersign
#define WSK_dollar              XK_dollar
#define WSK_percent             XK_percent
#define WSK_ampersand           XK_ampersand
#define WSK_apostrophe          XK_apostrophe
#define WSK_quoteright          XK_quoteright
#define WSK_parenleft           XK_parenleft
#define WSK_parenright          XK_parenright
#define WSK_asterisk            XK_asterisk
#define WSK_plus                XK_plus
#define WSK_comma               XK_comma
#define WSK_minus               XK_minus
#define WSK_period              XK_period
#define WSK_slash               XK_slash
#define WSK_0                   XK_0
#define WSK_1                   XK_1
#define WSK_2                   XK_2
#define WSK_3                   XK_3
#define WSK_4                   XK_4
#define WSK_5                   XK_5
#define WSK_6                   XK_6
#define WSK_7                   XK_7
#define WSK_8                   XK_8
#define WSK_9                   XK_9
#define WSK_colon               XK_colon
#define WSK_semicolon           XK_semicolon
#define WSK_less                XK_less
#define WSK_equal               XK_equal
#define WSK_greater             XK_greater
#define WSK_question            XK_question
#define WSK_at                  XK_at
#define WSK_A                   XK_A
#define WSK_B                   XK_B
#define WSK_C                   XK_C
#define WSK_D                   XK_D
#define WSK_E                   XK_E
#define WSK_F                   XK_F
#define WSK_G                   XK_G
#define WSK_H                   XK_H
#define WSK_I                   XK_I
#define WSK_J                   XK_J
#define WSK_K                   XK_K
#define WSK_L                   XK_L
#define WSK_M                   XK_M
#define WSK_N                   XK_N
#define WSK_O                   XK_O
#define WSK_P                   XK_P
#define WSK_Q                   XK_Q
#define WSK_R                   XK_R
#define WSK_S                   XK_S
#define WSK_T                   XK_T
#define WSK_U                   XK_U
#define WSK_V                   XK_V
#define WSK_W                   XK_W
#define WSK_X                   XK_X
#define WSK_Y                   XK_Y
#define WSK_Z                   XK_Z
#define WSK_bracketleft         XK_bracketleft
#define WSK_backslash           XK_backslash
#define WSK_bracketright        XK_bracketright
#define WSK_asciicircum         XK_asciicircum
#define WSK_underscore          XK_underscore
#define WSK_grave               XK_grave
#define WSK_quoteleft           XK_quoteleft
#define WSK_a                   XK_a
#define WSK_b                   XK_b
#define WSK_c                   XK_c
#define WSK_d                   XK_d
#define WSK_e                   XK_e
#define WSK_f                   XK_f
#define WSK_g                   XK_g
#define WSK_h                   XK_h
#define WSK_i                   XK_i
#define WSK_j                   XK_j
#define WSK_k                   XK_k
#define WSK_l                   XK_l
#define WSK_m                   XK_m
#define WSK_n                   XK_n
#define WSK_o                   XK_o
#define WSK_p                   XK_p
#define WSK_q                   XK_q
#define WSK_r                   XK_r
#define WSK_s                   XK_s
#define WSK_t                   XK_t
#define WSK_u                   XK_u
#define WSK_v                   XK_v
#define WSK_w                   XK_w
#define WSK_x                   XK_x
#define WSK_y                   XK_y
#define WSK_z                   XK_z
#define WSK_braceleft           XK_braceleft
#define WSK_bar                 XK_bar
#define WSK_braceright          XK_braceright
#define WSK_asciitilde          XK_asciitilde

#endif //UNIX - Xwindow System

//-----------------------------------------------------------------------------
#ifdef MSW //MS Windows System
//-----------------------------------------------------------------------------
#define WSK_BackSpace			VK_BACK
#define WSK_Tab					VK_TAB
#define WSK_Linefeed			-1
#define WSK_Clear				VK_CLEAR
#define WSK_Return				VK_RETURN
#define WSK_Pause				VK_PAUSE
#define WSK_Scroll_Lock			VK_SCROLL
#define WSK_Sys_Req				VK_SNAPSHOT
#define WSK_Escape				VK_ESCAPE
#define WSK_Delete				VK_DELETE

//#define WSK_Kanji				VK_KANJI
#define WSK_Kanji				0x19
//#define WSK_Muhenkan			VK_NONCONVERT
#define WSK_Muhenkan			0x1d
//#define WSK_Henkan_Mode			VK_CONVERT
#define WSK_Henkan_Mode			0x1c
//#define WSK_Henkan				VK_CONVERT
#define WSK_Henkan				0x1c
#define WSK_Romaji				0xF2
#define WSK_Hiragana			0xF2
#define WSK_Katakana			0xF2
#define WSK_Hiragana_Katakana	0xF2
#define WSK_Zenkaku				0xF4
#define WSK_Hankaku				0xF3
#define WSK_Zenkaku_Hankaku		0xF4
#define WSK_Touroku				-1
#define WSK_Massyo				-1
#define WSK_Kana_Lock			-1
#define WSK_Kana_Shift			-1
#define WSK_Eisu_Shift			-1
#define WSK_Eisu_toggle			0xF0

#define WSK_Home				VK_HOME
#define WSK_Left				VK_LEFT
#define WSK_Up					VK_UP
#define WSK_Right				VK_RIGHT
#define WSK_Down				VK_DOWN
#define WSK_Prior				VK_PRIOR
#define WSK_Page_Up				VK_PRIOR
//#define WSK_Next				0xFF56
#define WSK_Page_Down			VK_NEXT
#define WSK_End					VK_END
//#define WSK_Begin				0xFF58


//#define WSK_Select			0xFF60
#define WSK_Print				VK_SNAPSHOT
#define WSK_Execute				VK_EXECUTE
#define WSK_Insert				VK_INSERT
//#define WSK_Undo				0xFF65
//#define WSK_Redo				0xFF66
//#define WSK_Menu				0xFF67
//#define WSK_Find				0xFF68
#define WSK_Cancel				VK_CANCEL
#define WSK_Help				VK_HELP
#define WSK_Break				VK_CANCEL
//#define WSK_Mode_switch		0xFF7E
//#define WSK_script_switch		0xFF7E
#define WSK_Num_Lock			VK_NUMLOCK

#define WSK_KP_Space			-1
#define WSK_KP_Tab				-1
#define WSK_KP_Enter			VK_RETURN
#define WSK_KP_F1				-1
#define WSK_KP_F2				-1
#define WSK_KP_F3				-1
#define WSK_KP_F4				-1
#define WSK_KP_Home				VK_HOME
#define WSK_KP_Left				VK_LEFT
#define WSK_KP_Up				VK_UP
#define WSK_KP_Right			VK_RIGHT
#define WSK_KP_Down				VK_DOWN
#define WSK_KP_Prior			-1
#define WSK_KP_Page_Up			VK_PRIOR
#define WSK_KP_Next				-1
#define WSK_KP_Page_Down		VK_NEXT
#define WSK_KP_End				VK_END
#define WSK_KP_Begin			-1
#define WSK_KP_Insert			VK_INSERT
#define WSK_KP_Delete			VK_DELETE
#define WSK_KP_Equal			-1
#define WSK_KP_Multiply			VK_MULTIPLY
#define WSK_KP_Add				VK_ADD
#define WSK_KP_Separator		VK_SEPARATOR
#define WSK_KP_Subtract			VK_SUBTRACT	
#define WSK_KP_Decimal			VK_DECIMAL
#define WSK_KP_Divide			VK_DIVIDE

#define WSK_KP_0				VK_NUMPAD0
#define WSK_KP_1				VK_NUMPAD1
#define WSK_KP_2				VK_NUMPAD2
#define WSK_KP_3				VK_NUMPAD3
#define WSK_KP_4				VK_NUMPAD4
#define WSK_KP_5				VK_NUMPAD5
#define WSK_KP_6				VK_NUMPAD6
#define WSK_KP_7				VK_NUMPAD7
#define WSK_KP_8				VK_NUMPAD8
#define WSK_KP_9				VK_NUMPAD9

#define WSK_F1					VK_F1
#define WSK_F2					VK_F2
#define WSK_F3					VK_F3
#define WSK_F4					VK_F4
#define WSK_F5					VK_F5
#define WSK_F6					VK_F6
#define WSK_F7					VK_F7
#define WSK_F8					VK_F8
#define WSK_F9					VK_F9
#define WSK_F10					VK_F10
#define WSK_F11					VK_F11
#define WSK_L1					VK_F11
#define WSK_F12					VK_F12
#define WSK_L2					VK_F12
#define WSK_F13					VK_F13
#define WSK_L3					VK_F13
#define WSK_F14					VK_F14
#define WSK_L4					VK_F14
#define WSK_F15					VK_F15
#define WSK_L5					VK_F15
#define WSK_F16					VK_F16
#define WSK_L6					VK_F16
#define WSK_F17					VK_F17
#define WSK_L7					VK_F17
#define WSK_F18					VK_F18
#define WSK_L8					VK_F18
#define WSK_F19					VK_F19
#define WSK_L9					VK_F19
#define WSK_F20					VK_F20
#define WSK_L10					VK_F20
#define WSK_F21					VK_F21
#define WSK_R1					VK_F21
#define WSK_F22					VK_F22
#define WSK_R2					VK_F22
#define WSK_F23					VK_F23
#define WSK_R3					VK_F23
#define WSK_F24					VK_F24
#define WSK_R4					VK_F24
#define WSK_F25					-1
#define WSK_R5					-1
#define WSK_F26					-1
#define WSK_R6					-1
#define WSK_F27					-1
#define WSK_R7					-1
#define WSK_F28					-1
#define WSK_R8					-1
#define WSK_F29					-1
#define WSK_R9					-1
#define WSK_F30					-1
#define WSK_R10					-1
#define WSK_F31					-1
#define WSK_R11					-1
#define WSK_F32					-1
#define WSK_R12					-1
#define WSK_F33					-1
#define WSK_R13					-1
#define WSK_F34					-1
#define WSK_R14					-1
#define WSK_F35					-1
#define WSK_R15					-1

/* Modifiers */

#define WSK_Shift_L				VK_SHIFT
#define WSK_Shift_R				VK_SHIFT
#define WSK_Control_L			VK_CONTROL
#define WSK_Control_R			VK_CONTROL
#define WSK_Caps_Lock			VK_CAPITAL
#define WSK_Shift_Lock			-1

#define WSK_Meta_L				-1
#define WSK_Meta_R				-1
#define WSK_Alt_L				VK_MENU
#define WSK_Alt_R				VK_MENU
#define WSK_Super_L				-1
#define WSK_Super_R				-1
#define WSK_Hyper_L				-1
#define WSK_Hyper_R				-1

#define WSK_space				VK_SPACE
#define WSK_exclam				0x121
#define WSK_quotedbl			0x122
#define WSK_numbersign			0x123
#define WSK_dollar				0x124
#define WSK_percent				0x125
#define WSK_ampersand			0x126
#define WSK_apostrophe			0x127
#define WSK_quoteright			0x127
#define WSK_parenleft			0x128
#define WSK_parenright			0x129
#define WSK_asterisk			0x12a
#define WSK_plus				0x12b
#define WSK_comma				0x12c
#define WSK_minus				0x12d
#define WSK_period				0x12e
#define WSK_slash				0x12f
#define WSK_0					0x130
#define WSK_1					0x131
#define WSK_2					0x132
#define WSK_3					0x133
#define WSK_4					0x134
#define WSK_5					0x135
#define WSK_6					0x136
#define WSK_7					0x137
#define WSK_8					0x138
#define WSK_9					0x139
#define WSK_colon				0x13a
#define WSK_semicolon			0x13b
#define WSK_less				0x13c
#define WSK_equal				0x13d
#define WSK_greater				0x13e
#define WSK_question			0x13f
#define WSK_at					0x140
#define WSK_A					0x141
#define WSK_B					0x142
#define WSK_C					0x143
#define WSK_D					0x144
#define WSK_E					0x145
#define WSK_F					0x146
#define WSK_G					0x147
#define WSK_H					0x148
#define WSK_I					0x149
#define WSK_J					0x14a
#define WSK_K					0x14b
#define WSK_L					0x14c
#define WSK_M					0x14d
#define WSK_N					0x14e
#define WSK_O					0x14f
#define WSK_P					0x150
#define WSK_Q					0x151
#define WSK_R					0x152
#define WSK_S					0x153
#define WSK_T					0x154
#define WSK_U					0x155
#define WSK_V					0x156
#define WSK_W					0x157
#define WSK_X					0x158
#define WSK_Y					0x159
#define WSK_Z					0x15a
#define WSK_bracketleft			0x15b
#define WSK_backslash			0x15c
#define WSK_bracketright		0x15d
#define WSK_asciicircum			0x15e
#define WSK_underscore			0x15f
#define WSK_grave				0x160
#define WSK_quoteleft			0x160
#define WSK_a					0x161
#define WSK_b					0x162
#define WSK_c					0x163
#define WSK_d					0x164
#define WSK_e					0x165
#define WSK_f					0x166
#define WSK_g					0x167
#define WSK_h					0x168
#define WSK_i					0x169
#define WSK_j					0x16a
#define WSK_k					0x16b
#define WSK_l					0x16c
#define WSK_m					0x16d
#define WSK_n					0x16e
#define WSK_o					0x16f
#define WSK_p					0x170
#define WSK_q					0x171
#define WSK_r					0x172
#define WSK_s					0x173
#define WSK_t					0x174
#define WSK_u					0x175
#define WSK_v					0x176
#define WSK_w					0x177
#define WSK_x					0x178
#define WSK_y					0x179
#define WSK_z					0x17a
#define WSK_braceleft			0x17b
#define WSK_bar					0x17c
#define WSK_braceright			0x17d
#define WSK_asciitilde			0x17e

#endif //MS Windows System

#ifdef BTRON //BTRON

#define KC_EIJI 	0x1000
#define KC_CAPN 	0x1001
#define KC_SHT_R	0x1002
#define KC_SHT_L	0x1003
#define KC_EXP		0x1004
#define KC_CMD		0x1005
#define KC_JPN0 	0x1006
#define KC_JPN1 	0x1007
#define KC_ENG0 	0x1008
#define KC_ENG1 	0x1009
#define	KC_KBSEL	0x100a
#define	KC_ENGALT	0x100b
#define	KC_JPNALT	0x100c
#define	KC_HAN		0x1150
#define KC_JPN0_Z 	0x1016
#define KC_JPN1_Z 	0x1017
#define KC_ENG0_H 	0x1018
#define KC_ENG1_H 	0x1019

#define KC_HOME		0x1245
#define KC_PGUP		0x1246
#define KC_PGDN		0x1247
#define KC_END		0x125e

#define KC_CC_U 	0x0100
#define KC_CC_D 	0x0101
#define KC_CC_R 	0x0102
#define KC_CC_L 	0x0103

#define KC_SC_U 	0x0104
#define KC_SC_D 	0x0105
#define KC_SC_R 	0x0106
#define KC_SC_L 	0x0107

#define KC_SS_U 	0x0108
#define KC_SS_D 	0x0109
#define KC_SS_R 	0x010a
#define KC_SS_L 	0x010b

#define KC_PG_U 	0x010c
#define KC_PG_D 	0x010d
#define KC_PG_R 	0x010e
#define KC_PG_L 	0x010f

#define	BREAK_CODE	0x1140
#define	INS_CODE	0x114c

#define	KC_NUL		0x0000
#define	KC_IEND		0x0004
#define	KC_BS		0x0008
#define	KC_TAB		0x0009
#define	KC_NL		0x000a
#define	KC_CR		0x000d
#define	KC_CAN		0x0018
#define	KC_ASSIST	0x001b
#define	KC_CNV		0x001e
#define	KC_RCNV		0x001f
#define	KC_DEL		0x007f
#define KC_CNV0		0x1151
#define KC_CNV1		0x1152
#define KC_SPACE	0x2121
#define	KC_PRSCRN	0x1148

#define	KC_PF1		0x1161
#define	KC_PF2		0x1162
#define	KC_PF3		0x1163
#define	KC_PF4		0x1164
#define	KC_PF5		0x1165
#define	KC_PF6		0x1166
#define	KC_PF7		0x1167
#define	KC_PF8		0x1168
#define	KC_PF9		0x1169
#define	KC_PF10		0x116a
#define	KC_PF11		0x116b
#define	KC_PF12		0x116c


#define		TK_DEL		0x007f
#define		TK_SP0		0x0020
#define		TK_SP1		0x00a0
#define		TK_NULL		0x0000
#define		TK_TAB		0x0009
#define		TK_NL		0x000a

#define		TK_BS		0x0008
#define 	TK_END		0x0004
#define		TK_CAN		0x0018
#define		TK_CNV		0x001e
#define		TK_RCNV 	0x001f
#define		TK_DICT 	0x0083

#define		TK_KSP		0x2121		/*	*/
#define		TK_EXCL		0x212a		/* !	*/
#define		TK_RQOT		0x212e		/* `	*/
#define		TK_DQOT		0x2149		/* " 	*/
#define		TK_SHRP		0x2174		/* #	*/
#define		TK_DLLR		0x2170		/* $	*/
#define		TK_PCNT		0x2173		/* %	*/
#define		TK_AND		0x2175		/* &	*/
#define		TK_SQOT		0x2147		/* '	*/
#define		TK_LPAR		0x214a		/* (	*/
#define		TK_RPAR		0x214b		/* )	*/
#define		TK_ASTR		0x2176		/* *	*/
#define		TK_PLUS		0x215c		/* +	*/
#define		TK_CMMA		0x2124		/* ,	*/
#define		TK_MINS		0x215d		/* -	*/
#define		TK_PROD		0x2125		/* .	*/
#define		TK_SLSH		0x213f		/* /	*/
#define		TK_COLN		0x2127		/* :	*/
#define		TK_SCLN		0x2128		/* ;	*/
#define		TK_LSTN		0x2163		/* <	*/
#define		TK_EQAL		0x2161		/* =	*/
#define		TK_GTTN		0x2164		/* >	*/
#define		TK_QSTN		0x2129		/* ?	*/
#define		TK_ATMK		0x2177		/* @	*/
#define		TK_LABR		0x214e		/* [	*/
#define		TK_BSLH		0x216f		/* \	*/
#define		TK_RABR		0x214f		/* ]	*/
#define		TK_EXOR		0x2130		/* ^	*/
#define		TK_USCR		0x2132		/* _	*/
#define		TK_LCBR		0x2150		/* {	*/
#define		TK_OR		0x2143		/* |	*/
#define		TK_RCBR		0x2151		/* }	*/
#define		TK_TILD		0x2131		/* ~	*/

#define		TK_AL_A		0x2341		/* 'A'	*/
#define		TK_AL_X		0x2358		/* 'X'	*/
#define		TK_AL_Z		0x235a		/* 'Z'	*/

#define		TK_AL_a		0x2361		/* 'a'	*/
#define		TK_AL_x		0x2378		/* 'x'	*/
#define		TK_AL_z		0x237a		/* 'z'	*/

#define		TK_NU_0		0x2330		/* '0'	*/
#define		TK_NU_9		0x2339		/* '9'	*/

#define		TK_KK_S		0x2521		/* ʥƬ */
#define		TK_KK_E 	0x2576		/* ʥʺǸ */
#define		TK_HK_S 	0x2421		/* Ҥ餬Ƭ */
#define		TK_HK_E 	0x2473		/* Ҥ餬ʺǸ */

#define		TK_DKON		0x212b		/* 		*/
#define		TK_HNDK		0x212c		/* Ⱦ	*/

#define		TK_0		(TK_NU_0+0)
#define		TK_1		(TK_NU_0+1)
#define		TK_2		(TK_NU_0+2)
#define		TK_3		(TK_NU_0+3)
#define		TK_4		(TK_NU_0+4)
#define		TK_5		(TK_NU_0+5)
#define		TK_6		(TK_NU_0+6)
#define		TK_7		(TK_NU_0+7)
#define		TK_8		(TK_NU_0+8)
#define		TK_9		(TK_NU_0+9)

#define		TK_A		(TK_AL_A+0)
#define		TK_B		(TK_AL_A+1)
#define		TK_C		(TK_AL_A+2)
#define		TK_D		(TK_AL_A+3)
#define		TK_E		(TK_AL_A+4)
#define		TK_F		(TK_AL_A+5)
#define		TK_G		(TK_AL_A+6)
#define		TK_H		(TK_AL_A+7)
#define		TK_I		(TK_AL_A+8)
#define		TK_J		(TK_AL_A+9)
#define		TK_K		(TK_AL_A+10)
#define		TK_L		(TK_AL_A+11)
#define		TK_M		(TK_AL_A+12)
#define		TK_N		(TK_AL_A+13)
#define		TK_O		(TK_AL_A+14)
#define		TK_P		(TK_AL_A+15)
#define		TK_Q		(TK_AL_A+16)
#define		TK_R		(TK_AL_A+17)
#define		TK_S		(TK_AL_A+18)
#define		TK_T		(TK_AL_A+19)
#define		TK_U		(TK_AL_A+20)
#define		TK_V		(TK_AL_A+21)
#define		TK_W		(TK_AL_A+22)
#define		TK_X		(TK_AL_A+23)
#define		TK_Y		(TK_AL_A+24)
#define		TK_Z		(TK_AL_A+25)

#define		TK_a		(TK_AL_a+0)
#define		TK_b		(TK_AL_a+1)
#define		TK_c		(TK_AL_a+2)
#define		TK_d		(TK_AL_a+3)
#define		TK_e		(TK_AL_a+4)
#define		TK_f		(TK_AL_a+5)
#define		TK_g		(TK_AL_a+6)
#define		TK_h		(TK_AL_a+7)
#define		TK_i		(TK_AL_a+8)
#define		TK_j		(TK_AL_a+9)
#define		TK_k		(TK_AL_a+10)
#define		TK_l		(TK_AL_a+11)
#define		TK_m		(TK_AL_a+12)
#define		TK_n		(TK_AL_a+13)
#define		TK_o		(TK_AL_a+14)
#define		TK_p		(TK_AL_a+15)
#define		TK_q		(TK_AL_a+16)
#define		TK_r		(TK_AL_a+17)
#define		TK_s		(TK_AL_a+18)
#define		TK_t		(TK_AL_a+19)
#define		TK_u		(TK_AL_a+20)
#define		TK_v		(TK_AL_a+21)
#define		TK_w		(TK_AL_a+22)
#define		TK_x		(TK_AL_a+23)
#define		TK_y		(TK_AL_a+24)
#define		TK_z		(TK_AL_a+25)


#define WSK_BackSpace   KC_BS
#define WSK_Tab         KC_TAB
#define WSK_Linefeed    KC_NL
#define WSK_Clear       -1
#define WSK_Return      KC_NL
#define WSK_Pause       -1
#define WSK_Scroll_Lock -1
#define WSK_Sys_Req     -1
#define WSK_Escape      KC_CAN
#define WSK_Delete      KC_DEL

#define WSK_Kanji             -1
#define WSK_Muhenkan          -1
#define WSK_Henkan_Mode       -1
#define WSK_Henkan            TK_CNV
#define WSK_Romaji            -1
#define WSK_Hiragana          -1
#define WSK_Katakana          -1
#define WSK_Hiragana_Katakana -1
#define WSK_Zenkaku           -1
#define WSK_Hankaku           -1
#define WSK_Zenkaku_Hankaku   -1
#define WSK_Touroku           -1
#define WSK_Massyo            -1
#define WSK_Kana_Lock         -1
#define WSK_Kana_Shift        -1
#define WSK_Eisu_Shift        -1
#define WSK_Eisu_toggle       -1

#define WSK_Home              KC_HOME
#define WSK_Left              KC_CC_L
#define WSK_Up                KC_CC_U
#define WSK_Right             KC_CC_R
#define WSK_Down              KC_CC_D
#define WSK_Prior             -1
#define WSK_Page_Up           KC_PGUP
//#define WSK_Next              0xFF56
#define WSK_Page_Down         KC_PGDN
#define WSK_End               KC_END
//#define WSK_Begin             0xFF58 //


//#define WSK_Select        0xFF60
#define WSK_Print         KC_PRSCRN
#define WSK_Execute       -1
#define WSK_Insert        -1
//#define WSK_Undo          0xFF65 /* Undo, oops */
//#define WSK_Redo          0xFF66 /* redo, again */
//#define WSK_Menu          0xFF67 //
//#define WSK_Find          0xFF68 //
#define WSK_Cancel        KC_CAN
#define WSK_Help          -1
#define WSK_Break         -1
//#define WSK_Mode_switch   0xFF7E //
//#define WSK_script_switch 0xFF7E //
#define WSK_Num_Lock      -1

/* Keypad Functions, keypad numbers cleverly chosen to map to ascii */
#define WSK_KP_Space     -1
#define WSK_KP_Tab       -1
#define WSK_KP_Enter     KC_NL
#define WSK_KP_F1        -1
#define WSK_KP_F2        -1
#define WSK_KP_F3        -1
#define WSK_KP_F4        -1
#define WSK_KP_Home      KC_HOME
#define WSK_KP_Left      KC_CC_L
#define WSK_KP_Up        KC_CC_U
#define WSK_KP_Right     KC_CC_R
#define WSK_KP_Down      KC_CC_D
#define WSK_KP_Prior     -1
#define WSK_KP_Page_Up   KC_PGUP
#define WSK_KP_Next      -1
#define WSK_KP_Page_Down KC_PGDN
#define WSK_KP_End       KC_END
#define WSK_KP_Begin     -1
#define WSK_KP_Insert    -1
#define WSK_KP_Delete    -1
#define WSK_KP_Equal     TK_EQAL
#define WSK_KP_Multiply  TK_ASTR
#define WSK_KP_Add       TK_PLUS
#define WSK_KP_Separator TK_CMMA
#define WSK_KP_Subtract  TK_MINS
#define WSK_KP_Decimal   TK_PROD
#define WSK_KP_Divide    TK_SLSH

#define WSK_KP_0   TK_0
#define WSK_KP_1   TK_1
#define WSK_KP_2   TK_2
#define WSK_KP_3   TK_3
#define WSK_KP_4   TK_4
#define WSK_KP_5   TK_5
#define WSK_KP_6   TK_6
#define WSK_KP_7   TK_7
#define WSK_KP_8   TK_8
#define WSK_KP_9   TK_9

#define WSK_F1   KC_PF1
#define WSK_F2   KC_PF2
#define WSK_F3   KC_PF3
#define WSK_F4   KC_PF4
#define WSK_F5   KC_PF5
#define WSK_F6   KC_PF6
#define WSK_F7   KC_PF7
#define WSK_F8   KC_PF8
#define WSK_F9   KC_PF9
#define WSK_F10  KC_PF10
#define WSK_F11  KC_PF11
#define WSK_L1   KC_PF11
#define WSK_F12  KC_PF12
#define WSK_L2   KC_PF12
#define WSK_F13  -1
#define WSK_L3   -1
#define WSK_F14  -1
#define WSK_L4   -1
#define WSK_F15  -1
#define WSK_L5   -1
#define WSK_F16  -1
#define WSK_L6   -1
#define WSK_F17  -1
#define WSK_L7   -1
#define WSK_F18  -1 
#define WSK_L8   -1
#define WSK_F19  -1
#define WSK_L9   -1
#define WSK_F20  -1
#define WSK_L10  -1
#define WSK_F21  -1
#define WSK_R1   -1
#define WSK_F22  -1
#define WSK_R2   -1
#define WSK_F23  -1
#define WSK_R3   -1
#define WSK_F24  -1
#define WSK_R4   -1
#define WSK_F25  -1
#define WSK_R5   -1
#define WSK_F26  -1
#define WSK_R6   -1
#define WSK_F27  -1
#define WSK_R7   -1
#define WSK_F28  -1
#define WSK_R8   -1
#define WSK_F29  -1
#define WSK_R9   -1
#define WSK_F30  -1
#define WSK_R10  -1
#define WSK_F31  -1
#define WSK_R11  -1
#define WSK_F32  -1
#define WSK_R12  -1
#define WSK_F33  -1
#define WSK_R13  -1
#define WSK_F34  -1
#define WSK_R14  -1
#define WSK_F35  -1
#define WSK_R15  -1

#define WSK_Shift_L    KC_SHT_L
#define WSK_Shift_R    KC_SHT_R
#define WSK_Control_L  -1
#define WSK_Control_R  -1
#define WSK_Caps_Lock  -1
#define WSK_Shift_Lock -1

#define WSK_Meta_L   -1
#define WSK_Meta_R   -1
#define WSK_Alt_L    -1
#define WSK_Alt_R    -1
#define WSK_Super_L  -1
#define WSK_Super_R  -1
#define WSK_Hyper_L  -1
#define WSK_Hyper_R  -1

#define WSK_space               TK_KSP
#define WSK_exclam              TK_EXCL
#define WSK_quotedbl            TK_DQOT
#define WSK_numbersign          TK_SHRP
#define WSK_dollar              TK_DLLR
#define WSK_percent             TK_PCNT
#define WSK_ampersand           TK_AND
#define WSK_apostrophe          TK_SQOT
#define WSK_quoteright          TK_RQOT
#define WSK_parenleft           TK_LPAR
#define WSK_parenright          TK_RPAR
#define WSK_asterisk            TK_ASTR
#define WSK_plus                TK_PLUS
#define WSK_comma               TK_CMMA
#define WSK_minus               TK_MINS
#define WSK_period              TK_PROD
#define WSK_slash               TK_SLSH
#define WSK_0                   TK_0
#define WSK_1                   TK_1
#define WSK_2                   TK_2
#define WSK_3                   TK_3
#define WSK_4                   TK_4
#define WSK_5                   TK_5
#define WSK_6                   TK_6
#define WSK_7                   TK_7
#define WSK_8                   TK_8
#define WSK_9                   TK_9
#define WSK_colon               TK_COLN
#define WSK_semicolon           TK_SCLN
#define WSK_less                TK_LSTN
#define WSK_equal               TK_EQAL
#define WSK_greater             TK_GTTN
#define WSK_question            TK_QSTN
#define WSK_at                  TK_ATMK
#define WSK_A                   TK_A
#define WSK_B                   TK_B
#define WSK_C                   TK_C
#define WSK_D                   TK_D
#define WSK_E                   TK_E
#define WSK_F                   TK_F
#define WSK_G                   TK_G
#define WSK_H                   TK_H
#define WSK_I                   TK_I
#define WSK_J                   TK_J
#define WSK_K                   TK_K
#define WSK_L                   TK_L
#define WSK_M                   TK_M
#define WSK_N                   TK_N
#define WSK_O                   TK_O
#define WSK_P                   TK_P
#define WSK_Q                   TK_Q
#define WSK_R                   TK_R
#define WSK_S                   TK_S
#define WSK_T                   TK_T
#define WSK_U                   TK_U
#define WSK_V                   TK_V
#define WSK_W                   TK_W
#define WSK_X                   TK_X
#define WSK_Y                   TK_Y
#define WSK_Z                   TK_Z
#define WSK_bracketleft         TK_LABR
#define WSK_backslash           TK_BSLH
#define WSK_bracketright        TK_RABR
#define WSK_asciicircum         TK_EXOR
#define WSK_underscore          TK_USCR
#define WSK_grave               TK_RQUT
#define WSK_quoteleft           TK_RQUT
#define WSK_a                   TK_a
#define WSK_b                   TK_b
#define WSK_c                   TK_c
#define WSK_d                   TK_d
#define WSK_e                   TK_e
#define WSK_f                   TK_f
#define WSK_g                   TK_g
#define WSK_h                   TK_h
#define WSK_i                   TK_i
#define WSK_j                   TK_j
#define WSK_k                   TK_k
#define WSK_l                   TK_l
#define WSK_m                   TK_m
#define WSK_n                   TK_n
#define WSK_o                   TK_o
#define WSK_p                   TK_p
#define WSK_q                   TK_q
#define WSK_r                   TK_r
#define WSK_s                   TK_s
#define WSK_t                   TK_t
#define WSK_u                   TK_u
#define WSK_v                   TK_v
#define WSK_w                   TK_w
#define WSK_x                   TK_x
#define WSK_y                   TK_y
#define WSK_z                   TK_z
#define WSK_braceleft           TK_LCBR
#define WSK_bar                 TK_OR
#define WSK_braceright          TK_RCBR
#define WSK_asciitilde          TK_TILD


#endif //BTRON

#endif //WSKEYSYM_H
